package com.ejie.y40a.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;

/**
 * * PlanificacionSolicitanteBusqueda  
 * 
 *  
 */

public class PlanificacionSolicitanteBusqueda implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// Categoria
	private String idCat;
	private String nombreCategoriaEs;
	private String nombreCategoriaEu;
	private List<Categoria> categorias = new ArrayList<Categoria>();

	// Solicitante
	private String entidadId;
	private String nombreEs;
	private String nombreEu;
	private String noraMunicipioId;
	private String nombreMunicipio;

	private String numFormaciones;
	private String aceptadas;

	private Date fechaSolicitud;

	private String intervaloImparticion;

	private String sinPlanificarTodas;
	private String sinPlanificar;
	private String planificados;
	private Date fechaImparticionDesde;
	private Date fechaImparticionHasta;

	private Date fechaSolicitudDesde;
	private Date fechaSolicitudHasta;

	private List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();
	private String idsEtiquetas;

	private String radioEtiquetas;

	private String telEntidad;
	private String emailEntidad;
	private String nombapecontacto;
	private String emailcontacto;
	private String telcontacto;

	/**
	 * Method 'Solicitud'.
	 * 
	 */
	public PlanificacionSolicitanteBusqueda() {
	}

	/**
	 * @param idCat
	 * @param nombreCategoriaEs
	 * @param nombreCategoriaEu
	 * @param entidadId
	 * @param nombreEs
	 * @param nombreEu
	 * @param noraMunicipioId
	 * @param nombreMunicipio
	 * @param numFormaciones
	 * @param aceptadas
	 * @param fechaSolicitud
	 * @param intervaloImparticion
	 * @param fechaImparticionDesde
	 * @param fechaImparticionHasta
	 * @param telEntidad
	 * @param emailEntidad
	 * @param nombapecontacto
	 * @param emailcontacto
	 * @param telcontacto
	 */
	public PlanificacionSolicitanteBusqueda(String idCat,
			String nombreCategoriaEs, String nombreCategoriaEu,
			String entidadId, String nombreEs, String nombreEu,
			String noraMunicipioId, String nombreMunicipio,
			String numFormaciones, String aceptadas, Date fechaSolicitud,
			String intervaloImparticion, Date fechaImparticionDesde,
			Date fechaImparticionHasta, String telEntidad, String emailEntidad,
			String nombapecontacto, String emailcontacto, String telcontacto) {
		this.idCat = idCat;
		this.nombreCategoriaEs = nombreCategoriaEs;
		this.nombreCategoriaEu = nombreCategoriaEu;
		this.entidadId = entidadId;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
		this.noraMunicipioId = noraMunicipioId;
		this.nombreMunicipio = nombreMunicipio;
		this.numFormaciones = numFormaciones;
		this.aceptadas = aceptadas;
		this.fechaSolicitud = fechaSolicitud;
		this.intervaloImparticion = intervaloImparticion;
		this.fechaImparticionDesde = fechaImparticionDesde;
		this.fechaImparticionHasta = fechaImparticionHasta;
		this.telEntidad = telEntidad;
		this.emailEntidad = emailEntidad;
		this.nombapecontacto = nombapecontacto;
		this.emailcontacto = emailcontacto;
		this.telcontacto = telcontacto;
	}

	/**
	 * @return the idCat
	 */
	public String getIdCat() {
		return idCat;
	}

	/**
	 * @param idCat
	 *            the idCat to set
	 */
	public void setIdCat(String idCat) {
		this.idCat = idCat;
	}

	/**
	 * @return the nombreCategoriaEs
	 */
	public String getNombreCategoriaEs() {
		return nombreCategoriaEs;
	}

	/**
	 * @param nombreCategoriaEs
	 *            the nombreCategoriaEs to set
	 */
	public void setNombreCategoriaEs(String nombreCategoriaEs) {
		this.nombreCategoriaEs = nombreCategoriaEs;
	}

	/**
	 * @return the nombreCategoriaEu
	 */
	public String getNombreCategoriaEu() {
		return nombreCategoriaEu;
	}

	/**
	 * @param nombreCategoriaEu
	 *            the nombreCategoriaEu to set
	 */
	public void setNombreCategoriaEu(String nombreCategoriaEu) {
		this.nombreCategoriaEu = nombreCategoriaEu;
	}

	/**
	 * @return the entidadId
	 */
	public String getEntidadId() {
		return entidadId;
	}

	/**
	 * @param entidadId
	 *            the entidadId to set
	 */
	public void setEntidadId(String entidadId) {
		this.entidadId = entidadId;
	}

	/**
	 * @return the nombreEs
	 */
	public String getNombreEs() {
		return nombreEs;
	}

	/**
	 * @param nombreEs
	 *            the nombreEs to set
	 */
	public void setNombreEs(String nombreEs) {
		this.nombreEs = nombreEs;
	}

	/**
	 * @return the nombreEu
	 */
	public String getNombreEu() {
		return nombreEu;
	}

	/**
	 * @param nombreEu
	 *            the nombreEu to set
	 */
	public void setNombreEu(String nombreEu) {
		this.nombreEu = nombreEu;
	}

	/**
	 * @return the noraMunicipioId
	 */
	public String getNoraMunicipioId() {
		return noraMunicipioId;
	}

	/**
	 * @param noraMunicipioId
	 *            the noraMunicipioId to set
	 */
	public void setNoraMunicipioId(String noraMunicipioId) {
		this.noraMunicipioId = noraMunicipioId;
	}

	/**
	 * @return the nombreMunicipio
	 */
	public String getNombreMunicipio() {
		return nombreMunicipio;
	}

	/**
	 * @param nombreMunicipio
	 *            the nombreMunicipio to set
	 */
	public void setNombreMunicipio(String nombreMunicipio) {
		this.nombreMunicipio = nombreMunicipio;
	}

	/**
	 * @return the numFormaciones
	 */
	public String getNumFormaciones() {
		return numFormaciones;
	}

	/**
	 * @param numFormaciones
	 *            the numFormaciones to set
	 */
	public void setNumFormaciones(String numFormaciones) {
		this.numFormaciones = numFormaciones;
	}

	/**
	 * @return the aceptadas
	 */
	public String getAceptadas() {
		return aceptadas;
	}

	/**
	 * @param aceptadas
	 *            the aceptadas to set
	 */
	public void setAceptadas(String aceptadas) {
		this.aceptadas = aceptadas;
	}

	/**
	 * @return the fechaSolicitud
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaSolicitud() {
		return fechaSolicitud;
	}

	/**
	 * @param fechaSolicitud
	 *            the fechaSolicitud to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaSolicitud(Date fechaSolicitud) {
		this.fechaSolicitud = fechaSolicitud;
	}

	/**
	 * @return the intervaloImparticion
	 */
	public String getIntervaloImparticion() {
		return intervaloImparticion;
	}

	/**
	 * @param intervaloImparticion
	 *            the intervaloImparticion to set
	 */
	public void setIntervaloImparticion(String intervaloImparticion) {
		this.intervaloImparticion = intervaloImparticion;
	}

	/**
	 * @return the sinPlanificarTodas
	 */
	public String getSinPlanificarTodas() {
		return sinPlanificarTodas;
	}

	/**
	 * @param sinPlanificarTodas
	 *            the sinPlanificarTodas to set
	 */
	public void setSinPlanificarTodas(String sinPlanificarTodas) {
		this.sinPlanificarTodas = sinPlanificarTodas;
	}

	/**
	 * @return the sinPlanificar
	 */
	public String getSinPlanificar() {
		return sinPlanificar;
	}

	/**
	 * @param sinPlanificar
	 *            the sinPlanificar to set
	 */
	public void setSinPlanificar(String sinPlanificar) {
		this.sinPlanificar = sinPlanificar;
	}

	/**
	 * @return the planificados
	 */
	public String getPlanificados() {
		return planificados;
	}

	/**
	 * @param planificados
	 *            the planificados to set
	 */
	public void setPlanificados(String planificados) {
		this.planificados = planificados;
	}

	/**
	 * @return the fechaImparticionDesde
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaImparticionDesde() {
		return fechaImparticionDesde;
	}

	/**
	 * @param fechaImparticionDesde
	 *            the fechaImparticionDesde to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaImparticionDesde(Date fechaImparticionDesde) {
		this.fechaImparticionDesde = fechaImparticionDesde;
	}

	/**
	 * @return the fechaImparticionHasta
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaImparticionHasta() {
		return fechaImparticionHasta;
	}

	/**
	 * @param fechaImparticionHasta
	 *            the fechaImparticionHasta to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaImparticionHasta(Date fechaImparticionHasta) {
		this.fechaImparticionHasta = fechaImparticionHasta;
	}

	/**
	 * @return the etiquetas
	 */
	@JsonIgnore
	public List<Etiqueta> getEtiquetas() {
		return etiquetas;
	}

	/**
	 * @param etiquetas
	 *            the etiquetas to set
	 */
	public void setEtiquetas(List<Etiqueta> etiquetas) {
		this.etiquetas = etiquetas;
	}

	/**
	 * @return the idsEtiquetas
	 */
	public String getIdsEtiquetas() {
		return idsEtiquetas;
	}

	/**
	 * @param idsEtiquetas
	 *            the idsEtiquetas to set
	 */
	public void setIdsEtiquetas(String idsEtiquetas) {
		this.idsEtiquetas = idsEtiquetas;
	}

	/**
	 * @return the categorias
	 */
	@JsonIgnore
	public List<Categoria> getCategorias() {
		return categorias;
	}

	/**
	 * @param categorias
	 *            the categorias to set
	 */
	public void setCategorias(List<Categoria> categorias) {
		this.categorias = categorias;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "PlanificacionSolicitanteBusqueda [idCat=" + idCat
				+ ", nombreCategoriaEs=" + nombreCategoriaEs
				+ ", nombreCategoriaEu=" + nombreCategoriaEu + ", categorias="
				+ categorias + ", entidadId=" + entidadId + ", nombreEs="
				+ nombreEs + ", nombreEu=" + nombreEu + ", noraMunicipioId="
				+ noraMunicipioId + ", nombreMunicipio=" + nombreMunicipio
				+ ", numFormaciones=" + numFormaciones + ", aceptadas="
				+ aceptadas + ", fechaSolicitud=" + fechaSolicitud
				+ ", intervaloImparticion=" + intervaloImparticion
				+ ", sinPlanificarTodas=" + sinPlanificarTodas
				+ ", sinPlanificar=" + sinPlanificar + ", planificados="
				+ planificados + ", fechaImparticionDesde="
				+ fechaImparticionDesde + ", fechaImparticionHasta="
				+ fechaImparticionHasta + ", fechaSolicitudDesde="
				+ fechaSolicitudDesde + ", fechaSolicitudHasta="
				+ fechaSolicitudHasta + ", etiquetas=" + etiquetas
				+ ", idsEtiquetas=" + idsEtiquetas + ", radioEtiquetas="
				+ radioEtiquetas + ", telEntidad=" + telEntidad
				+ ", emailEntidad=" + emailEntidad + ", nombapecontacto="
				+ nombapecontacto + ", emailcontacto=" + emailcontacto
				+ ", telcontacto=" + telcontacto + "]";
	}

	/**
	 * @param fechaSolicitudDesde
	 *            the fechaSolicitudDesde to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaSolicitudDesde(Date fechaSolicitudDesde) {
		this.fechaSolicitudDesde = fechaSolicitudDesde;
	}

	/**
	 * @return the fechaSolicitudDesde
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaSolicitudDesde() {
		return fechaSolicitudDesde;
	}

	/**
	 * @param fechaSolicitudHasta
	 *            the fechaSolicitudHasta to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaSolicitudHasta(Date fechaSolicitudHasta) {
		this.fechaSolicitudHasta = fechaSolicitudHasta;
	}

	/**
	 * @return the fechaSolicitudHasta
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaSolicitudHasta() {
		return fechaSolicitudHasta;
	}

	/**
	 * @return the radioEtiquetas
	 */
	public String getRadioEtiquetas() {
		return radioEtiquetas;
	}

	/**
	 * @param radioEtiquetas
	 *            the radioEtiquetas to set
	 */
	public void setRadioEtiquetas(String radioEtiquetas) {
		this.radioEtiquetas = radioEtiquetas;
	}

	/**
	 * @return the telEntidad
	 */
	public String getTelEntidad() {
		return telEntidad;
	}

	/**
	 * @param telEntidad
	 *            the telEntidad to set
	 */
	public void setTelEntidad(String telEntidad) {
		this.telEntidad = telEntidad;
	}

	/**
	 * @return the emailEntidad
	 */
	public String getEmailEntidad() {
		return emailEntidad;
	}

	/**
	 * @param emailEntidad
	 *            the emailEntidad to set
	 */
	public void setEmailEntidad(String emailEntidad) {
		this.emailEntidad = emailEntidad;
	}

	/**
	 * @return the nombapecontacto
	 */
	public String getNombapecontacto() {
		return nombapecontacto;
	}

	/**
	 * @param nombapecontacto
	 *            the nombapecontacto to set
	 */
	public void setNombapecontacto(String nombapecontacto) {
		this.nombapecontacto = nombapecontacto;
	}

	/**
	 * @return the emailcontacto
	 */
	public String getEmailcontacto() {
		return emailcontacto;
	}

	/**
	 * @param emailcontacto
	 *            the emailcontacto to set
	 */
	public void setEmailcontacto(String emailcontacto) {
		this.emailcontacto = emailcontacto;
	}

	/**
	 * @return the telcontacto
	 */
	public String getTelcontacto() {
		return telcontacto;
	}

	/**
	 * @param telcontacto
	 *            the telcontacto to set
	 */
	public void setTelcontacto(String telcontacto) {
		this.telcontacto = telcontacto;
	}

}
