package com.ejie.y40a.model;

import java.sql.Blob;
import java.util.Date;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;

/**
 * * Historico  
 * 
 *  
 */

public class Historico implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String idHist;
	private Blob archivo;
	private String nombre;
	private String tipo;
	private Long tamanio;
	private Date fecha;

	/**
	 * Method 'Historico'.
	 * 
	 */
	public Historico() {
	}

	/**
	 * Method 'Historico'.
	 * 
	 * @param idHist
	 *            String
	 * @param archivo
	 *            Blob
	 * @param nombre
	 *            String
	 * @param tipo
	 *            String
	 * @param tamanio
	 *            Long
	 * @param fecha
	 *            Date
	 */
	public Historico(String idHist, Blob archivo, String nombre, String tipo,
			Long tamanio, Date fecha) {

		this.idHist = idHist;
		this.archivo = archivo;
		this.nombre = nombre;
		this.tipo = tipo;
		this.tamanio = tamanio;
		this.fecha = fecha;
	}

	/**
	 * Method 'getIdHist'.
	 * 
	 * @return String
	 */

	public String getIdHist() {
		return this.idHist;
	}

	/**
	 * Method 'setIdHist'.
	 * 
	 * @param idHist
	 *            String
	 * @return
	 */

	public void setIdHist(String idHist) {
		this.idHist = idHist;
	}

	/**
	 * Method 'getArchivo'.
	 * 
	 * @return Blob
	 */
	@JsonIgnore
	public Blob getArchivo() {
		return this.archivo;
	}

	/**
	 * Method 'setArchivo'.
	 * 
	 * @param archivo
	 *            Blob
	 * @return
	 */

	public void setArchivo(Blob archivo) {
		this.archivo = archivo;
	}

	/**
	 * Method 'getNombre'.
	 * 
	 * @return String
	 */

	public String getNombre() {
		return this.nombre;
	}

	/**
	 * Method 'setNombre'.
	 * 
	 * @param nombre
	 *            String
	 * @return
	 */

	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Method 'getTipo'.
	 * 
	 * @return String
	 */

	public String getTipo() {
		return this.tipo;
	}

	/**
	 * Method 'setTipo'.
	 * 
	 * @param tipo
	 *            String
	 * @return
	 */

	public void setTipo(String tipo) {
		this.tipo = tipo;
	}

	/**
	 * Method 'getTamanio'.
	 * 
	 * @return Long
	 */

	public Long getTamanio() {
		return this.tamanio;
	}

	/**
	 * Method 'setTamanio'.
	 * 
	 * @param tamanio
	 *            Long
	 * @return
	 */

	public void setTamanio(Long tamanio) {
		this.tamanio = tamanio;
	}

	/**
	 * @return the fecha
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecha() {
		return fecha;
	}

	/**
	 * @param fecha
	 *            the fecha to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecha(Date fecha) {
		this.fecha = fecha;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Historico [idHist=" + idHist + ", archivo=" + archivo
				+ ", nombre=" + nombre + ", tipo=" + tipo + ", tamanio="
				+ tamanio + ", fecha=" + fecha + "]";
	}

}
