package com.ejie.y40a.model;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * * Formacion  
 * 
 *  
 */

public class Formacion implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String idFor;
	private Categoria categoria;
	@Length(max = 150, message = "lenght.nombreEs")
	@NotEmpty(message = "required.nombreEs")
	private String nombreEs;
	@Length(max = 150, message = "lenght.nombreEu")
	@NotEmpty(message = "required.nombreEu")
	private String nombreEu;
	private String nombreCortoEs;
	private String nombreCortoEu;
	private String descripcionEs;
	private String descripcionEu;
	private String visibleWeb;
	private String jerarquiaFormacion;
	private List<Etiqueta> etiquetas = new ArrayList<Etiqueta>();
	private List<Solicitud> solicituds = new ArrayList<Solicitud>();

	private String visibleContactoCat;

	private String nueva;

	/**
	 * Method 'Formacion'.
	 * 
	 */
	public Formacion() {
	}

	/**
	 * Method 'Formacion'.
	 * 
	 * @param idFor
	 *            String
	 * @param nombreEs
	 *            String
	 * @param nombreEu
	 *            String
	 * @param nombreCortoEs
	 *            String
	 * @param nombreCortoEu
	 *            String
	 * @param descripcionEs
	 *            String
	 * @param descripcionEu
	 *            String
	 * @param visibleWeb
	 *            String
	 * @param categoria
	 *            Categoria
	 */
	public Formacion(String idFor, String nombreEs, String nombreEu,
			String nombreCortoEs, String nombreCortoEu, String descripcionEs,
			String descripcionEu, String visibleWeb, String nueva,
			Categoria categoria) {
		this.idFor = idFor;
		this.categoria = categoria;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
		this.nombreCortoEs = nombreCortoEs;
		this.nombreCortoEu = nombreCortoEu;
		this.descripcionEs = descripcionEs;
		this.descripcionEu = descripcionEu;
		this.visibleWeb = visibleWeb;
		this.nueva = nueva;
	}

	/**
	 * Method 'Formacion'.
	 * 
	 * @param idFor
	 *            String
	 * @param nombreEs
	 *            String
	 * @param nombreEu
	 *            String
	 * @param nombreCortoEs
	 *            String
	 * @param nombreCortoEu
	 *            String
	 * @param descripcionEs
	 *            String
	 * @param descripcionEu
	 *            String
	 * @param visibleWeb
	 *            String
	 * @param categoria
	 *            Categoria
	 * @param etiquetas
	 *            List<Etiqueta>
	 * @param solicituds
	 *            List<Solicitud>
	 */
	public Formacion(String idFor, String nombreEs, String nombreEu,
			String nombreCortoEs, String nombreCortoEu, String descripcionEs,
			String descripcionEu, String visibleWeb, Categoria categoria,
			List<Etiqueta> etiquetas, List<Solicitud> solicituds) {

		this.idFor = idFor;
		this.categoria = categoria;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
		this.nombreCortoEs = nombreCortoEs;
		this.nombreCortoEu = nombreCortoEu;
		this.descripcionEs = descripcionEs;
		this.descripcionEu = descripcionEu;
		this.visibleWeb = visibleWeb;
		this.etiquetas = etiquetas;
		this.solicituds = solicituds;
	}

	/**
	 * Method 'getIdFor'.
	 * 
	 * @return String
	 */

	public String getIdFor() {
		return this.idFor;
	}

	/**
	 * Method 'setIdFor'.
	 * 
	 * @param idFor
	 *            String
	 * @return
	 */

	public void setIdFor(String idFor) {
		this.idFor = idFor;
	}

	/**
	 * Method 'getCategoria'.
	 * 
	 * @return Categoria
	 */
	@JsonIgnore
	public Categoria getCategoria() {
		return this.categoria;
	}

	/**
	 * Method 'setCategoria'.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return
	 */

	public void setCategoria(Categoria categoria) {
		this.categoria = categoria;
	}

	/**
	 * Method 'getNombreEs'.
	 * 
	 * @return String
	 */

	public String getNombreEs() {
		return this.nombreEs;
	}

	/**
	 * Method 'setNombreEs'.
	 * 
	 * @param nombreEs
	 *            String
	 * @return
	 */

	public void setNombreEs(String nombreEs) {
		this.nombreEs = nombreEs;
	}

	/**
	 * Method 'getNombreEu'.
	 * 
	 * @return String
	 */

	public String getNombreEu() {
		return this.nombreEu;
	}

	/**
	 * Method 'setNombreEu'.
	 * 
	 * @param nombreEu
	 *            String
	 * @return
	 */

	public void setNombreEu(String nombreEu) {
		this.nombreEu = nombreEu;
	}

	/**
	 * @return the nombreCortoEs
	 */
	public String getNombreCortoEs() {
		return nombreCortoEs;
	}

	/**
	 * @param nombreCortoEs
	 *            the nombreCortoEs to set
	 */
	public void setNombreCortoEs(String nombreCortoEs) {
		this.nombreCortoEs = nombreCortoEs;
	}

	/**
	 * @return the nombreCortoEu
	 */
	public String getNombreCortoEu() {
		return nombreCortoEu;
	}

	/**
	 * @param nombreCortoEu
	 *            the nombreCortoEu to set
	 */
	public void setNombreCortoEu(String nombreCortoEu) {
		this.nombreCortoEu = nombreCortoEu;
	}

	/**
	 * Method 'getDescripcionEs'.
	 * 
	 * @return String
	 */

	public String getDescripcionEs() {
		return this.descripcionEs;
	}

	/**
	 * Method 'setDescripcionEs'.
	 * 
	 * @param descripcionEs
	 *            String
	 * @return
	 */

	public void setDescripcionEs(String descripcionEs) {
		this.descripcionEs = descripcionEs;
	}

	/**
	 * Method 'getDescripcionEu'.
	 * 
	 * @return String
	 */

	public String getDescripcionEu() {
		return this.descripcionEu;
	}

	/**
	 * Method 'setDescripcionEu'.
	 * 
	 * @param descripcionEu
	 *            String
	 * @return
	 */

	public void setDescripcionEu(String descripcionEu) {
		this.descripcionEu = descripcionEu;
	}

	/**
	 * Method 'getVisibleWeb'.
	 * 
	 * @return String
	 */

	public String getVisibleWeb() {
		return this.visibleWeb;
	}

	/**
	 * Method 'setVisibleWeb'.
	 * 
	 * @param visibleWeb
	 *            String
	 * @return
	 */

	public void setVisibleWeb(String visibleWeb) {
		this.visibleWeb = visibleWeb;
	}

	/**
	 * Method 'getEtiquetas'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Etiqueta> getEtiquetas() {
		return this.etiquetas;
	}

	/**
	 * Method 'setEtiquetas'.
	 * 
	 * @param etiquetas
	 *            List
	 * @return
	 */
	public void setEtiquetas(List<Etiqueta> etiquetas) {
		this.etiquetas = etiquetas;
	}

	/**
	 * Method 'getSolicituds'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Solicitud> getSolicituds() {
		return this.solicituds;
	}

	/**
	 * Method 'setSolicituds'.
	 * 
	 * @param solicituds
	 *            List
	 * @return
	 */
	public void setSolicituds(List<Solicitud> solicituds) {
		this.solicituds = solicituds;
	}

	/**
	 * @return the jerarquiaFormacion
	 */
	public String getJerarquiaFormacion() {
		return jerarquiaFormacion;
	}

	/**
	 * @param jerarquiaFormacion
	 *            the jerarquiaFormacion to set
	 */
	public void setJerarquiaFormacion(String jerarquiaFormacion) {
		this.jerarquiaFormacion = jerarquiaFormacion;
	}

	/**
	 * Method 'setNueva'.
	 * 
	 * @param nueva
	 *            String
	 * @return
	 */

	public void setNueva(String nueva) {
		this.nueva = nueva;
	}

	/**
	 * Method 'getNueva'.
	 * 
	 * @return String
	 */

	public String getNueva() {
		return this.nueva;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Formacion [idFor=" + idFor + ", categoria=" + categoria
				+ ", nombreEs=" + nombreEs + ", nombreEu=" + nombreEu
				+ ", nombreCortoEs=" + nombreCortoEs + ", nombreCortoEu="
				+ nombreCortoEu + ", descripcionEs=" + descripcionEs
				+ ", descripcionEu=" + descripcionEu + ", visibleWeb="
				+ visibleWeb + ", jerarquiaFormacion=" + jerarquiaFormacion
				+ ", etiquetas=" + etiquetas + ", solicituds=" + solicituds
				+ ", nueva=" + nueva + "]";
	}

	/**
	 * @param visibleContactoCat
	 *            the visibleContactoCat to set
	 */
	public void setVisibleContactoCat(String visibleContactoCat) {
		this.visibleContactoCat = visibleContactoCat;
	}

	/**
	 * @return the visibleContactoCat
	 */
	public String getVisibleContactoCat() {
		return visibleContactoCat;
	}

}
