package com.ejie.y40a.model;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

/**
 * * Etiqueta  
 * 
 *  
 */

public class Etiqueta implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String idEtiqueta;
	@Length(max = 50, message = "lenght.nombre")
	@NotEmpty(message = "required.nombre")
	private String nombre;
	private List<Formacion> formacions = new ArrayList<Formacion>();
	private List<Solicitud> solicituds = new ArrayList<Solicitud>();

	/**
	 * Method 'Etiqueta'.
	 * 
	 */
	public Etiqueta() {
	}

	/**
	 * Method 'Etiqueta'.
	 * 
	 * @param idEtiqueta
	 *            String
	 * @param nombre
	 *            String
	 */
	public Etiqueta(String idEtiqueta, String nombre) {
		this.idEtiqueta = idEtiqueta;
		this.nombre = nombre;
	}

	/**
	 * Method 'Etiqueta'.
	 * 
	 * @param idEtiqueta
	 *            String
	 * @param nombre
	 *            String
	 * @param formacions
	 *            List<Formacion>
	 * @param solicituds
	 *            List<Solicitud>
	 */
	public Etiqueta(String idEtiqueta, String nombre,
			List<Formacion> formacions, List<Solicitud> solicituds) {

		this.idEtiqueta = idEtiqueta;
		this.nombre = nombre;
		this.formacions = formacions;
		this.solicituds = solicituds;
	}

	/**
	 * Method 'getIdEtiqueta'.
	 * 
	 * @return String
	 */

	public String getIdEtiqueta() {
		return this.idEtiqueta;
	}

	/**
	 * Method 'setIdEtiqueta'.
	 * 
	 * @param idEtiqueta
	 *            String
	 * @return
	 */

	public void setIdEtiqueta(String idEtiqueta) {
		this.idEtiqueta = idEtiqueta;
	}

	/**
	 * Method 'getNombre'.
	 * 
	 * @return String
	 */

	public String getNombre() {
		return this.nombre;
	}

	/**
	 * Method 'setNombre'.
	 * 
	 * @param nombre
	 *            String
	 * @return
	 */

	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Method 'getFormacions'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Formacion> getFormacions() {
		return this.formacions;
	}

	/**
	 * Method 'setFormacions'.
	 * 
	 * @param formacions
	 *            List
	 * @return
	 */
	public void setFormacions(List<Formacion> formacions) {
		this.formacions = formacions;
	}

	/**
	 * Method 'getSolicituds'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Solicitud> getSolicituds() {
		return this.solicituds;
	}

	/**
	 * Method 'setSolicituds'.
	 * 
	 * @param solicituds
	 *            List
	 * @return
	 */
	public void setSolicituds(List<Solicitud> solicituds) {
		this.solicituds = solicituds;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ idEtiqueta: ").append(this.idEtiqueta).append(" ]");
		result.append(", [ nombre: ").append(this.nombre).append(" ]");
		result.append("}");
		return result.toString();
	}

}
