package com.ejie.y40a.model;

import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;
import com.ejie.y40a.constantes.Y40aConstantes;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.context.i18n.LocaleContextHolder;

/**
 * * Entidad  
 * 
 *  
 */

public class Entidad implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String entidadId;
	private String nombreEs;
	private String nombreEu;
	private String activa;
	private String iskontsumogest;
	private String iskontsumonet;
	private String isofertaform;
	private String isconsultasweb;
	private String codOrg;
	private String observaciones;
	private String telefono;
	private String fax;
	private String email;
	private String url;
	private String usuario;
	private String password;
	private String isnacional;
	private String noraPaisId;
	private String nombrePais;
	private String noraProvinciaId;
	private String nombreProvincia;
	private String noraMunicipioId;
	private String nombreMunicipio;
	private String noraLocalidadId;
	private String nombreLocalidad;
	private String noraCalleId;
	private String nombreCalle;
	private String noraCpId;
	private String nombreCp;
	private String noraPortalId;
	private String nombrePortal;
	private String usuultmod;
	private Date fecultmod;
	private String compleDirec;
	private String orinbdco;
	private ObservacionesEntidad observacionesEntidad;
	private List<Solicitud> solicituds = new ArrayList<Solicitud>();

	// Grupos entidades
	private List<Grupo> grupos = new ArrayList<Grupo>();
	private String gruposArr;

	private Long numHistObserv;
	@SuppressWarnings("unused")
	private String nombre;

	/**
	 * Method 'Entidad'.
	 * 
	 */
	public Entidad() {
	}

	/**
	 * Method 'Entidad'.
	 * 
	 * @param entidadId
	 *            String
	 * @param nombreEs
	 *            String
	 * @param nombreEu
	 *            String
	 * @param activa
	 *            String
	 * @param iskontsumogest
	 *            String
	 * @param iskontsumonet
	 *            String
	 * @param isofertaform
	 *            String
	 * @param isconsultasweb
	 *            String
	 * @param codOrg
	 *            String
	 * @param observaciones
	 *            String
	 * @param telefono
	 *            String
	 * @param fax
	 *            String
	 * @param email
	 *            String
	 * @param url
	 *            String
	 * @param usuario
	 *            String
	 * @param password
	 *            String
	 * @param isnacional
	 *            String
	 * @param noraPaisId
	 *            String
	 * @param nombrePais
	 *            String
	 * @param noraProvinciaId
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param noraMunicipioId
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param noraLocalidadId
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param usuultmod
	 *            String
	 * @param fecultmod
	 *            Date
	 * @param compleDirec
	 *            String
	 * @param orinbdco
	 *            String
	 * @param observacionesEntidad
	 *            ObservacionesEntidad
	 */
	public Entidad(String entidadId, String nombreEs, String nombreEu,
			String activa, String iskontsumogest, String iskontsumonet,
			String isofertaform, String isconsultasweb, String codOrg,
			String observaciones, String telefono, String fax, String email,
			String url, String usuario, String password, String isnacional,
			String noraPaisId, String nombrePais, String noraProvinciaId,
			String nombreProvincia, String noraMunicipioId,
			String nombreMunicipio, String noraLocalidadId,
			String nombreLocalidad, String noraCalleId, String nombreCalle,
			String noraCpId, String nombreCp, String noraPortalId,
			String nombrePortal, String usuultmod, Date fecultmod,
			String compleDirec, String orinbdco,
			ObservacionesEntidad observacionesEntidad) {
		this.entidadId = entidadId;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
		this.activa = activa;
		this.iskontsumogest = iskontsumogest;
		this.iskontsumonet = iskontsumonet;
		this.isofertaform = isofertaform;
		this.isconsultasweb = isconsultasweb;
		this.codOrg = codOrg;
		this.observaciones = observaciones;
		this.telefono = telefono;
		this.fax = fax;
		this.email = email;
		this.url = url;
		this.usuario = usuario;
		this.password = password;
		this.isnacional = isnacional;
		this.noraPaisId = noraPaisId;
		this.nombrePais = nombrePais;
		this.noraProvinciaId = noraProvinciaId;
		this.nombreProvincia = nombreProvincia;
		this.noraMunicipioId = noraMunicipioId;
		this.nombreMunicipio = nombreMunicipio;
		this.noraLocalidadId = noraLocalidadId;
		this.nombreLocalidad = nombreLocalidad;
		this.noraCalleId = noraCalleId;
		this.nombreCalle = nombreCalle;
		this.noraCpId = noraCpId;
		this.nombreCp = nombreCp;
		this.noraPortalId = noraPortalId;
		this.nombrePortal = nombrePortal;
		this.usuultmod = usuultmod;
		this.fecultmod = fecultmod;
		this.compleDirec = compleDirec;
		this.orinbdco = orinbdco;
		this.observacionesEntidad = observacionesEntidad;
	}

	/**
	 * Method 'Entidad'.
	 * 
	 * @param entidadId
	 *            String
	 * @param nombreEs
	 *            String
	 * @param nombreEu
	 *            String
	 * @param activa
	 *            String
	 * @param iskontsumogest
	 *            String
	 * @param iskontsumonet
	 *            String
	 * @param isofertaform
	 *            String
	 * @param isconsultasweb
	 *            String
	 * @param codOrg
	 *            String
	 * @param observaciones
	 *            String
	 * @param telefono
	 *            String
	 * @param fax
	 *            String
	 * @param email
	 *            String
	 * @param url
	 *            String
	 * @param usuario
	 *            String
	 * @param password
	 *            String
	 * @param isnacional
	 *            String
	 * @param noraPaisId
	 *            String
	 * @param nombrePais
	 *            String
	 * @param noraProvinciaId
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param noraMunicipioId
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param noraLocalidadId
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param usuultmod
	 *            String
	 * @param fecultmod
	 *            Date
	 * @param compleDirec
	 *            String
	 * @param orinbdco
	 *            String
	 * @param observacionesEntidad
	 *            ObservacionesEntidad
	 * @param solicituds
	 *            List<Solicitud>
	 */
	public Entidad(String entidadId, String nombreEs, String nombreEu,
			String activa, String iskontsumogest, String iskontsumonet,
			String isofertaform, String isconsultasweb, String codOrg,
			String observaciones, String telefono, String fax, String email,
			String url, String usuario, String password, String isnacional,
			String noraPaisId, String nombrePais, String noraProvinciaId,
			String nombreProvincia, String noraMunicipioId,
			String nombreMunicipio, String noraLocalidadId,
			String nombreLocalidad, String noraCalleId, String nombreCalle,
			String noraCpId, String nombreCp, String noraPortalId,
			String nombrePortal, String usuultmod, Date fecultmod,
			String compleDirec, String orinbdco,
			ObservacionesEntidad observacionesEntidad,
			List<Solicitud> solicituds) {

		this.entidadId = entidadId;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
		this.activa = activa;
		this.iskontsumogest = iskontsumogest;
		this.iskontsumonet = iskontsumonet;
		this.isofertaform = isofertaform;
		this.isconsultasweb = isconsultasweb;
		this.codOrg = codOrg;
		this.observaciones = observaciones;
		this.telefono = telefono;
		this.fax = fax;
		this.email = email;
		this.url = url;
		this.usuario = usuario;
		this.password = password;
		this.isnacional = isnacional;
		this.noraPaisId = noraPaisId;
		this.nombrePais = nombrePais;
		this.noraProvinciaId = noraProvinciaId;
		this.nombreProvincia = nombreProvincia;
		this.noraMunicipioId = noraMunicipioId;
		this.nombreMunicipio = nombreMunicipio;
		this.noraLocalidadId = noraLocalidadId;
		this.nombreLocalidad = nombreLocalidad;
		this.noraCalleId = noraCalleId;
		this.nombreCalle = nombreCalle;
		this.noraCpId = noraCpId;
		this.nombreCp = nombreCp;
		this.noraPortalId = noraPortalId;
		this.nombrePortal = nombrePortal;
		this.usuultmod = usuultmod;
		this.fecultmod = fecultmod;
		this.compleDirec = compleDirec;
		this.orinbdco = orinbdco;
		this.observacionesEntidad = observacionesEntidad;
		this.solicituds = solicituds;
	}

	/**
	 * Method 'getEntidadId'.
	 * 
	 * @return String
	 */

	public String getEntidadId() {
		return this.entidadId;
	}

	/**
	 * Method 'setEntidadId'.
	 * 
	 * @param entidadId
	 *            String
	 * @return
	 */

	public void setEntidadId(String entidadId) {
		this.entidadId = entidadId;
	}

	/**
	 * Method 'getNombreEs'.
	 * 
	 * @return String
	 */

	public String getNombreEs() {
		return this.nombreEs;
	}

	/**
	 * Method 'setNombreEs'.
	 * 
	 * @param nombreEs
	 *            String
	 * @return
	 */

	public void setNombreEs(String nombreEs) {
		this.nombreEs = nombreEs;
	}

	/**
	 * Method 'getNombreEu'.
	 * 
	 * @return String
	 */

	public String getNombreEu() {
		return this.nombreEu;
	}

	/**
	 * Method 'setNombreEu'.
	 * 
	 * @param nombreEu
	 *            String
	 * @return
	 */

	public void setNombreEu(String nombreEu) {
		this.nombreEu = nombreEu;
	}

	/**
	 * Method 'getActiva'.
	 * 
	 * @return String
	 */

	public String getActiva() {
		return this.activa;
	}

	/**
	 * Method 'setActiva'.
	 * 
	 * @param activa
	 *            String
	 * @return
	 */

	public void setActiva(String activa) {
		this.activa = activa;
	}

	/**
	 * Method 'getIskontsumogest'.
	 * 
	 * @return String
	 */

	public String getIskontsumogest() {
		return this.iskontsumogest;
	}

	/**
	 * Method 'setIskontsumogest'.
	 * 
	 * @param iskontsumogest
	 *            String
	 * @return
	 */

	public void setIskontsumogest(String iskontsumogest) {
		this.iskontsumogest = iskontsumogest;
	}

	/**
	 * Method 'getIskontsumonet'.
	 * 
	 * @return String
	 */

	public String getIskontsumonet() {
		return this.iskontsumonet;
	}

	/**
	 * Method 'setIskontsumonet'.
	 * 
	 * @param iskontsumonet
	 *            String
	 * @return
	 */

	public void setIskontsumonet(String iskontsumonet) {
		this.iskontsumonet = iskontsumonet;
	}

	/**
	 * Method 'getIsofertaform'.
	 * 
	 * @return String
	 */

	public String getIsofertaform() {
		return this.isofertaform;
	}

	/**
	 * Method 'setIsofertaform'.
	 * 
	 * @param isofertaform
	 *            String
	 * @return
	 */

	public void setIsofertaform(String isofertaform) {
		this.isofertaform = isofertaform;
	}

	/**
	 * Method 'getIsconsultasweb'.
	 * 
	 * @return String
	 */

	public String getIsconsultasweb() {
		return this.isconsultasweb;
	}

	/**
	 * Method 'setIsconsultasweb'.
	 * 
	 * @param isconsultasweb
	 *            String
	 * @return
	 */

	public void setIsconsultasweb(String isconsultasweb) {
		this.isconsultasweb = isconsultasweb;
	}

	/**
	 * Method 'getCodOrg'.
	 * 
	 * @return String
	 */

	public String getCodOrg() {
		return this.codOrg;
	}

	/**
	 * Method 'setCodOrg'.
	 * 
	 * @param codOrg
	 *            String
	 * @return
	 */

	public void setCodOrg(String codOrg) {
		this.codOrg = codOrg;
	}

	/**
	 * Method 'getObservaciones'.
	 * 
	 * @return String
	 */

	public String getObservaciones() {
		return this.observaciones;
	}

	/**
	 * Method 'setObservaciones'.
	 * 
	 * @param observaciones
	 *            String
	 * @return
	 */

	public void setObservaciones(String observaciones) {
		this.observaciones = observaciones;
	}

	/**
	 * Method 'getTelefono'.
	 * 
	 * @return String
	 */

	public String getTelefono() {
		return this.telefono;
	}

	/**
	 * Method 'setTelefono'.
	 * 
	 * @param telefono
	 *            String
	 * @return
	 */

	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}

	/**
	 * Method 'getFax'.
	 * 
	 * @return String
	 */

	public String getFax() {
		return this.fax;
	}

	/**
	 * Method 'setFax'.
	 * 
	 * @param fax
	 *            String
	 * @return
	 */

	public void setFax(String fax) {
		this.fax = fax;
	}

	/**
	 * Method 'getEmail'.
	 * 
	 * @return String
	 */

	public String getEmail() {
		return this.email;
	}

	/**
	 * Method 'setEmail'.
	 * 
	 * @param email
	 *            String
	 * @return
	 */

	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * Method 'getUrl'.
	 * 
	 * @return String
	 */

	public String getUrl() {
		return this.url;
	}

	/**
	 * Method 'setUrl'.
	 * 
	 * @param url
	 *            String
	 * @return
	 */

	public void setUrl(String url) {
		this.url = url;
	}

	/**
	 * Method 'getUsuario'.
	 * 
	 * @return String
	 */

	public String getUsuario() {
		return this.usuario;
	}

	/**
	 * Method 'setUsuario'.
	 * 
	 * @param usuario
	 *            String
	 * @return
	 */

	public void setUsuario(String usuario) {
		this.usuario = usuario;
	}

	/**
	 * Method 'getPassword'.
	 * 
	 * @return String
	 */

	public String getPassword() {
		return this.password;
	}

	/**
	 * Method 'setPassword'.
	 * 
	 * @param password
	 *            String
	 * @return
	 */

	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * Method 'getIsnacional'.
	 * 
	 * @return String
	 */

	public String getIsnacional() {
		return this.isnacional;
	}

	/**
	 * Method 'setIsnacional'.
	 * 
	 * @param isnacional
	 *            String
	 * @return
	 */

	public void setIsnacional(String isnacional) {
		this.isnacional = isnacional;
	}

	/**
	 * Method 'getNoraPaisId'.
	 * 
	 * @return String
	 */

	public String getNoraPaisId() {
		return this.noraPaisId;
	}

	/**
	 * Method 'setNoraPaisId'.
	 * 
	 * @param noraPaisId
	 *            String
	 * @return
	 */

	public void setNoraPaisId(String noraPaisId) {
		this.noraPaisId = noraPaisId;
	}

	/**
	 * Method 'getNombrePais'.
	 * 
	 * @return String
	 */

	public String getNombrePais() {
		return this.nombrePais;
	}

	/**
	 * Method 'setNombrePais'.
	 * 
	 * @param nombrePais
	 *            String
	 * @return
	 */

	public void setNombrePais(String nombrePais) {
		this.nombrePais = nombrePais;
	}

	/**
	 * Method 'getNoraProvinciaId'.
	 * 
	 * @return String
	 */

	public String getNoraProvinciaId() {
		return this.noraProvinciaId;
	}

	/**
	 * Method 'setNoraProvinciaId'.
	 * 
	 * @param noraProvinciaId
	 *            String
	 * @return
	 */

	public void setNoraProvinciaId(String noraProvinciaId) {
		this.noraProvinciaId = noraProvinciaId;
	}

	/**
	 * Method 'getNombreProvincia'.
	 * 
	 * @return String
	 */

	public String getNombreProvincia() {
		return this.nombreProvincia;
	}

	/**
	 * Method 'setNombreProvincia'.
	 * 
	 * @param nombreProvincia
	 *            String
	 * @return
	 */

	public void setNombreProvincia(String nombreProvincia) {
		this.nombreProvincia = nombreProvincia;
	}

	/**
	 * Method 'getNoraMunicipioId'.
	 * 
	 * @return String
	 */

	public String getNoraMunicipioId() {
		return this.noraMunicipioId;
	}

	/**
	 * Method 'setNoraMunicipioId'.
	 * 
	 * @param noraMunicipioId
	 *            String
	 * @return
	 */

	public void setNoraMunicipioId(String noraMunicipioId) {
		this.noraMunicipioId = noraMunicipioId;
	}

	/**
	 * Method 'getNombreMunicipio'.
	 * 
	 * @return String
	 */

	public String getNombreMunicipio() {
		return this.nombreMunicipio;
	}

	/**
	 * Method 'setNombreMunicipio'.
	 * 
	 * @param nombreMunicipio
	 *            String
	 * @return
	 */

	public void setNombreMunicipio(String nombreMunicipio) {
		this.nombreMunicipio = nombreMunicipio;
	}

	/**
	 * Method 'getNoraLocalidadId'.
	 * 
	 * @return String
	 */

	public String getNoraLocalidadId() {
		return this.noraLocalidadId;
	}

	/**
	 * Method 'setNoraLocalidadId'.
	 * 
	 * @param noraLocalidadId
	 *            String
	 * @return
	 */

	public void setNoraLocalidadId(String noraLocalidadId) {
		this.noraLocalidadId = noraLocalidadId;
	}

	/**
	 * Method 'getNombreLocalidad'.
	 * 
	 * @return String
	 */

	public String getNombreLocalidad() {
		return this.nombreLocalidad;
	}

	/**
	 * Method 'setNombreLocalidad'.
	 * 
	 * @param nombreLocalidad
	 *            String
	 * @return
	 */

	public void setNombreLocalidad(String nombreLocalidad) {
		this.nombreLocalidad = nombreLocalidad;
	}

	/**
	 * Method 'getNoraCalleId'.
	 * 
	 * @return String
	 */

	public String getNoraCalleId() {
		return this.noraCalleId;
	}

	/**
	 * Method 'setNoraCalleId'.
	 * 
	 * @param noraCalleId
	 *            String
	 * @return
	 */

	public void setNoraCalleId(String noraCalleId) {
		this.noraCalleId = noraCalleId;
	}

	/**
	 * Method 'getNombreCalle'.
	 * 
	 * @return String
	 */

	public String getNombreCalle() {
		return this.nombreCalle;
	}

	/**
	 * Method 'setNombreCalle'.
	 * 
	 * @param nombreCalle
	 *            String
	 * @return
	 */

	public void setNombreCalle(String nombreCalle) {
		this.nombreCalle = nombreCalle;
	}

	/**
	 * Method 'getNoraCpId'.
	 * 
	 * @return String
	 */

	public String getNoraCpId() {
		return this.noraCpId;
	}

	/**
	 * Method 'setNoraCpId'.
	 * 
	 * @param noraCpId
	 *            String
	 * @return
	 */

	public void setNoraCpId(String noraCpId) {
		this.noraCpId = noraCpId;
	}

	/**
	 * Method 'getNombreCp'.
	 * 
	 * @return String
	 */

	public String getNombreCp() {
		return this.nombreCp;
	}

	/**
	 * Method 'setNombreCp'.
	 * 
	 * @param nombreCp
	 *            String
	 * @return
	 */

	public void setNombreCp(String nombreCp) {
		this.nombreCp = nombreCp;
	}

	/**
	 * Method 'getNoraPortalId'.
	 * 
	 * @return String
	 */

	public String getNoraPortalId() {
		return this.noraPortalId;
	}

	/**
	 * Method 'setNoraPortalId'.
	 * 
	 * @param noraPortalId
	 *            String
	 * @return
	 */

	public void setNoraPortalId(String noraPortalId) {
		this.noraPortalId = noraPortalId;
	}

	/**
	 * Method 'getNombrePortal'.
	 * 
	 * @return String
	 */

	public String getNombrePortal() {
		return this.nombrePortal;
	}

	/**
	 * Method 'setNombrePortal'.
	 * 
	 * @param nombrePortal
	 *            String
	 * @return
	 */

	public void setNombrePortal(String nombrePortal) {
		this.nombrePortal = nombrePortal;
	}

	/**
	 * Method 'getUsuultmod'.
	 * 
	 * @return String
	 */

	public String getUsuultmod() {
		return this.usuultmod;
	}

	/**
	 * Method 'setUsuultmod'.
	 * 
	 * @param usuultmod
	 *            String
	 * @return
	 */

	public void setUsuultmod(String usuultmod) {
		this.usuultmod = usuultmod;
	}

	/**
	 * Method 'getFecultmod'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecultmod() {
		return this.fecultmod;
	}

	/**
	 * Method 'setFecultmod'.
	 * 
	 * @param fecultmod
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecultmod(Date fecultmod) {
		this.fecultmod = fecultmod;
	}

	/**
	 * Method 'getCompleDirec'.
	 * 
	 * @return String
	 */

	public String getCompleDirec() {
		return this.compleDirec;
	}

	/**
	 * Method 'setCompleDirec'.
	 * 
	 * @param compleDirec
	 *            String
	 * @return
	 */

	public void setCompleDirec(String compleDirec) {
		this.compleDirec = compleDirec;
	}

	/**
	 * Method 'getOrinbdco'.
	 * 
	 * @return String
	 */

	public String getOrinbdco() {
		return this.orinbdco;
	}

	/**
	 * Method 'setOrinbdco'.
	 * 
	 * @param orinbdco
	 *            String
	 * @return
	 */

	public void setOrinbdco(String orinbdco) {
		this.orinbdco = orinbdco;
	}

	/**
	 * Method 'getObservacionesEntidad'.
	 * 
	 * @return ObservacionesEntidad
	 */
	@JsonIgnore
	public ObservacionesEntidad getObservacionesEntidad() {
		return this.observacionesEntidad;
	}

	/**
	 * Method 'setObservacionesEntidad'.
	 * 
	 * @param observacionesEntidad
	 *            ObservacionesEntidad
	 * @return
	 */

	public void setObservacionesEntidad(
			ObservacionesEntidad observacionesEntidad) {
		this.observacionesEntidad = observacionesEntidad;
	}

	/**
	 * Method 'getSolicituds'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Solicitud> getSolicituds() {
		return this.solicituds;
	}

	/**
	 * Method 'setSolicituds'.
	 * 
	 * @param solicituds
	 *            List
	 * @return
	 */
	public void setSolicituds(List<Solicitud> solicituds) {
		this.solicituds = solicituds;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ entidadId: ").append(this.entidadId).append(" ]");
		result.append(", [ nombreEs: ").append(this.nombreEs).append(" ]");
		result.append(", [ nombreEu: ").append(this.nombreEu).append(" ]");
		result.append(", [ activa: ").append(this.activa).append(" ]");
		result.append(", [ iskontsumogest: ").append(this.iskontsumogest)
				.append(" ]");
		result.append(", [ iskontsumonet: ").append(this.iskontsumonet)
				.append(" ]");
		result.append(", [ isofertaform: ").append(this.isofertaform)
				.append(" ]");
		result.append(", [ isconsultasweb: ").append(this.isconsultasweb)
				.append(" ]");
		result.append(", [ codOrg: ").append(this.codOrg).append(" ]");
		result.append(", [ observaciones: ").append(this.observaciones)
				.append(" ]");
		result.append(", [ telefono: ").append(this.telefono).append(" ]");
		result.append(", [ fax: ").append(this.fax).append(" ]");
		result.append(", [ email: ").append(this.email).append(" ]");
		result.append(", [ url: ").append(this.url).append(" ]");
		result.append(", [ usuario: ").append(this.usuario).append(" ]");
		result.append(", [ password: ").append(this.password).append(" ]");
		result.append(", [ isnacional: ").append(this.isnacional).append(" ]");
		result.append(", [ noraPaisId: ").append(this.noraPaisId).append(" ]");
		result.append(", [ nombrePais: ").append(this.nombrePais).append(" ]");
		result.append(", [ noraProvinciaId: ").append(this.noraProvinciaId)
				.append(" ]");
		result.append(", [ nombreProvincia: ").append(this.nombreProvincia)
				.append(" ]");
		result.append(", [ noraMunicipioId: ").append(this.noraMunicipioId)
				.append(" ]");
		result.append(", [ nombreMunicipio: ").append(this.nombreMunicipio)
				.append(" ]");
		result.append(", [ noraLocalidadId: ").append(this.noraLocalidadId)
				.append(" ]");
		result.append(", [ nombreLocalidad: ").append(this.nombreLocalidad)
				.append(" ]");
		result.append(", [ noraCalleId: ").append(this.noraCalleId)
				.append(" ]");
		result.append(", [ nombreCalle: ").append(this.nombreCalle)
				.append(" ]");
		result.append(", [ noraCpId: ").append(this.noraCpId).append(" ]");
		result.append(", [ nombreCp: ").append(this.nombreCp).append(" ]");
		result.append(", [ noraPortalId: ").append(this.noraPortalId)
				.append(" ]");
		result.append(", [ nombrePortal: ").append(this.nombrePortal)
				.append(" ]");
		result.append(", [ usuultmod: ").append(this.usuultmod).append(" ]");
		result.append(", [ fecultmod: ").append(this.fecultmod).append(" ]");
		result.append(", [ compleDirec: ").append(this.compleDirec)
				.append(" ]");
		result.append(", [ orinbdco: ").append(this.orinbdco).append(" ]");
		result.append("}");
		return result.toString();
	}

	/**
	 * @param grupos
	 *            the grupos to set
	 */
	public void setGrupos(List<Grupo> grupos) {
		this.grupos = grupos;
	}

	/**
	 * @return the grupos
	 */
	public List<Grupo> getGrupos() {
		return grupos;
	}

	/**
	 * @param gruposArr
	 *            the gruposArr to set
	 */
	public void setGruposArr(String gruposArr) {
		this.gruposArr = gruposArr;
	}

	/**
	 * @return the gruposArr
	 */
	public String getGruposArr() {
		return gruposArr;
	}

	/**
	 * @param numHistObserv
	 *            the numHistObserv to set
	 */
	public void setNumHistObserv(Long numHistObserv) {
		this.numHistObserv = numHistObserv;
	}

	/**
	 * @return the numHistObserv
	 */
	public Long getNumHistObserv() {
		return numHistObserv;
	}

	public String getNombre() {
		String language = LocaleContextHolder.getLocale().getLanguage();
		if (language.equalsIgnoreCase(Y40aConstantes.CASTELLANO)) {
			return this.nombreEs;
		}
		if (language.equalsIgnoreCase(Y40aConstantes.EUSKERA)) {
			return this.nombreEu;
		}
		return this.nombreEs;
	}

}
