package com.ejie.y40a.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.x38.control.JsonDateDeserializer;
import com.ejie.x38.control.JsonDateSerializer;

/**
 * * ConsultaDinamicaBusqueda  
 * 
 *  
 */

public class ConsultaDinamicaBusqueda implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	// Categorias y formaciones
	private List<Categoria> categorias = new ArrayList<Categoria>();
	private List<Formacion> formaciones = new ArrayList<Formacion>();
	private String categoriasFormacionArr;

	// Grupos entidades
	private List<Grupo> grupos = new ArrayList<Grupo>();
	private String gruposArr;

	// TH
	private String thSolicitanteImparticion;
	private String thAraba;
	private String thBizkaia;
	private String thGipuzkoa;

	// Etiquetas formacion
	private List<Etiqueta> etiquetasFormacion = new ArrayList<Etiqueta>();
	private String etiquetasFormacionSeleccionadas;

	// Etiquetas solicitud
	private List<Etiqueta> etiquetasSolicitud = new ArrayList<Etiqueta>();
	private String etiquetasSolicitudSeleccionadas;

	// Fecha imparticion
	private Date fechaImparticionDesde;
	private Date fechaImparticionHasta;

	// Fecha solicitud
	private Date fechaSolicitudDesde;
	private Date fechaSolicitudHasta;

	// Ordenar resultado
	private String agruparResultado;

	// centros y formaciones
	private String centrosFormaciones;

	/**
	 * Method 'Formacion'.
	 * 
	 */
	public ConsultaDinamicaBusqueda() {
	}

	/**
	 * @param categorias
	 * @param formaciones
	 * @param grupos
	 * @param thSolicitanteImparticion
	 * @param thAraba
	 * @param thBizkaia
	 * @param thGipuzkoa
	 * @param etiquetasFormacion
	 * @param etiquetasFormacionSeleccionadas
	 * @param etiquetasSolicitud
	 * @param etiquetasSolicitudSeleccionadas
	 * @param fechaImparticionDesde
	 * @param fechaImparticionHasta
	 * @param agruparResultado
	 * @param centrosFormaciones
	 */

	public ConsultaDinamicaBusqueda(List<Categoria> categorias,
			List<Formacion> formaciones, List<Grupo> grupos,
			String thSolicitanteImparticion, String thAraba, String thBizkaia,
			String thGipuzkoa, List<Etiqueta> etiquetasFormacion,
			String etiquetasFormacionSeleccionadas,
			List<Etiqueta> etiquetasSolicitud,
			String etiquetasSolicitudSeleccionadas, Date fechaImparticionDesde,
			Date fechaImparticionHasta, String agruparResultado,
			String centrosFormaciones) {
		this.categorias = categorias;
		this.formaciones = formaciones;
		this.grupos = grupos;
		this.thSolicitanteImparticion = thSolicitanteImparticion;
		this.thAraba = thAraba;
		this.thBizkaia = thBizkaia;
		this.thGipuzkoa = thGipuzkoa;
		this.etiquetasFormacion = etiquetasFormacion;
		this.etiquetasFormacionSeleccionadas = etiquetasFormacionSeleccionadas;
		this.etiquetasSolicitud = etiquetasSolicitud;
		this.etiquetasSolicitudSeleccionadas = etiquetasSolicitudSeleccionadas;
		this.fechaImparticionDesde = fechaImparticionDesde;
		this.fechaImparticionHasta = fechaImparticionHasta;
		this.agruparResultado = agruparResultado;
		this.centrosFormaciones = centrosFormaciones;

	}

	/**
	 * @return the categorias
	 */
	public List<Categoria> getCategorias() {
		return categorias;
	}

	/**
	 * @param categorias
	 *            the categorias to set
	 */
	public void setCategorias(List<Categoria> categorias) {
		this.categorias = categorias;
	}

	/**
	 * @return the formaciones
	 */
	public List<Formacion> getFormaciones() {
		return formaciones;
	}

	/**
	 * @param formaciones
	 *            the formaciones to set
	 */
	public void setFormaciones(List<Formacion> formaciones) {
		this.formaciones = formaciones;
	}

	/**
	 * @return the grupos
	 */
	public List<Grupo> getGrupos() {
		return grupos;
	}

	/**
	 * @param grupos
	 *            the grupos to set
	 */
	public void setGrupos(List<Grupo> grupos) {
		this.grupos = grupos;
	}

	/**
	 * @return the thSolicitanteImparticion
	 */
	public String getThSolicitanteImparticion() {
		return thSolicitanteImparticion;
	}

	/**
	 * @param thSolicitanteImparticion
	 *            the thSolicitanteImparticion to set
	 */
	public void setThSolicitanteImparticion(String thSolicitanteImparticion) {
		this.thSolicitanteImparticion = thSolicitanteImparticion;
	}

	/**
	 * @return the thAraba
	 */
	public String getThAraba() {
		return thAraba;
	}

	/**
	 * @param thAraba
	 *            the thAraba to set
	 */
	public void setThAraba(String thAraba) {
		this.thAraba = thAraba;
	}

	/**
	 * @return the thBizkaia
	 */
	public String getThBizkaia() {
		return thBizkaia;
	}

	/**
	 * @param thBizkaia
	 *            the thBizkaia to set
	 */
	public void setThBizkaia(String thBizkaia) {
		this.thBizkaia = thBizkaia;
	}

	/**
	 * @return the thGipuzkoa
	 */
	public String getThGipuzkoa() {
		return thGipuzkoa;
	}

	/**
	 * @param thGipuzkoa
	 *            the thGipuzkoa to set
	 */
	public void setThGipuzkoa(String thGipuzkoa) {
		this.thGipuzkoa = thGipuzkoa;
	}

	/**
	 * @return the etiquetasFormacion
	 */
	public List<Etiqueta> getEtiquetasFormacion() {
		return etiquetasFormacion;
	}

	/**
	 * @param etiquetasFormacion
	 *            the etiquetasFormacion to set
	 */
	public void setEtiquetasFormacion(List<Etiqueta> etiquetasFormacion) {
		this.etiquetasFormacion = etiquetasFormacion;
	}

	/**
	 * @return the etiquetasFormacionSeleccionadas
	 */
	public String getEtiquetasFormacionSeleccionadas() {
		return etiquetasFormacionSeleccionadas;
	}

	/**
	 * @param etiquetasFormacionSeleccionadas
	 *            the etiquetasFormacionSeleccionadas to set
	 */
	public void setEtiquetasFormacionSeleccionadas(
			String etiquetasFormacionSeleccionadas) {
		this.etiquetasFormacionSeleccionadas = etiquetasFormacionSeleccionadas;
	}

	/**
	 * @return the etiquetasSolicitud
	 */
	public List<Etiqueta> getEtiquetasSolicitud() {
		return etiquetasSolicitud;
	}

	/**
	 * @param etiquetasSolicitud
	 *            the etiquetasSolicitud to set
	 */
	public void setEtiquetasSolicitud(List<Etiqueta> etiquetasSolicitud) {
		this.etiquetasSolicitud = etiquetasSolicitud;
	}

	/**
	 * @return the etiquetasSolicitudSeleccionadas
	 */
	public String getEtiquetasSolicitudSeleccionadas() {
		return etiquetasSolicitudSeleccionadas;
	}

	/**
	 * @param etiquetasSolicitudSeleccionadas
	 *            the etiquetasSolicitudSeleccionadas to set
	 */
	public void setEtiquetasSolicitudSeleccionadas(
			String etiquetasSolicitudSeleccionadas) {
		this.etiquetasSolicitudSeleccionadas = etiquetasSolicitudSeleccionadas;
	}

	/**
	 * @return the fechaImparticionDesde
	 */
	public Date getFechaImparticionDesde() {
		return fechaImparticionDesde;
	}

	/**
	 * @param fechaImparticionDesde
	 *            the fechaImparticionDesde to set
	 */
	public void setFechaImparticionDesde(Date fechaImparticionDesde) {
		this.fechaImparticionDesde = fechaImparticionDesde;
	}

	/**
	 * @return the fechaImparticionHasta
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public Date getFechaImparticionHasta() {
		return fechaImparticionHasta;
	}

	/**
	 * @param fechaImparticionHasta
	 *            the fechaImparticionHasta to set
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public void setFechaImparticionHasta(Date fechaImparticionHasta) {
		this.fechaImparticionHasta = fechaImparticionHasta;
	}

	/**
	 * @return the centrosFormaciones
	 */
	public String getCentrosFormaciones() {
		return centrosFormaciones;
	}

	/**
	 * @param centrosFormaciones
	 *            the centrosFormaciones to set
	 */
	public void setCentrosFormaciones(String centrosFormaciones) {
		this.centrosFormaciones = centrosFormaciones;
	}

	/**
	 * @return the agruparResultado
	 */
	public String getAgruparResultado() {
		return agruparResultado;
	}

	/**
	 * @param agruparResultado
	 *            the agruparResultado to set
	 */
	public void setAgruparResultado(String agruparResultado) {
		this.agruparResultado = agruparResultado;
	}

	/**
	 * @return the categoriasFormacionArr
	 */
	public String getCategoriasFormacionArr() {
		return categoriasFormacionArr;
	}

	/**
	 * @param categoriasFormacionArr
	 *            the categoriasFormacionArr to set
	 */
	public void setCategoriasFormacionArr(String categoriasFormacionArr) {
		this.categoriasFormacionArr = categoriasFormacionArr;
	}

	/**
	 * @return the gruposArr
	 */
	public String getGruposArr() {
		return gruposArr;
	}

	/**
	 * @param gruposArr
	 *            the gruposArr to set
	 */
	public void setGruposArr(String gruposArr) {
		this.gruposArr = gruposArr;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "ConsultaDinamicaBusqueda [categorias=" + categorias
				+ ", formaciones=" + formaciones + ", grupos=" + grupos
				+ ", thSolicitanteImparticion=" + thSolicitanteImparticion
				+ ", thAraba=" + thAraba + ", thBizkaia=" + thBizkaia
				+ ", thGipuzkoa=" + thGipuzkoa + ", etiquetasFormacion="
				+ etiquetasFormacion + ", etiquetasFormacionSeleccionadas="
				+ etiquetasFormacionSeleccionadas + ", etiquetasSolicitud="
				+ etiquetasSolicitud + ", etiquetasSolicitudSeleccionadas="
				+ etiquetasSolicitudSeleccionadas + ", fechaImparticionDesde="
				+ fechaImparticionDesde + ", fechaImparticionHasta="
				+ fechaImparticionHasta + ", agruparResultado="
				+ agruparResultado + "]";
	}

	/**
	 * @param fechaSolicitudDesde
	 *            the fechaSolicitudDesde to set
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public void setFechaSolicitudDesde(Date fechaSolicitudDesde) {
		this.fechaSolicitudDesde = fechaSolicitudDesde;
	}

	/**
	 * @return the fechaSolicitudDesde
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public Date getFechaSolicitudDesde() {
		return fechaSolicitudDesde;
	}

	/**
	 * @param fechaSolicitudHasta
	 *            the fechaSolicitudHasta to set
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public void setFechaSolicitudHasta(Date fechaSolicitudHasta) {
		this.fechaSolicitudHasta = fechaSolicitudHasta;
	}

	/**
	 * @return the fechaSolicitudHasta
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public Date getFechaSolicitudHasta() {
		return fechaSolicitudHasta;
	}
}
