/**
 * 
 */
package com.ejie.y40a.model;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

/**
 * Class que representa un campo dentro de los XML de carga de códigos.
 * 
 *  
 * 
 */
@XmlType(name = "CodesField", propOrder = { "name", "value" })
public class CodesField {

	private String name;
	private String value;

	/**
	 * Constructor.
	 */
	public CodesField() {
	}

	/**
	 * Constructor.
	 * 
	 * @param name
	 *            Nombre
	 * @param value
	 *            valor
	 */
	public CodesField(String name, String value) {

		this.name = name;
		this.value = value;
	}

	/**
	 * 
	 * @return Nombre
	 */
	@XmlAttribute()
	public String getName() {
		return this.name;
	}

	/**
	 * 
	 * @param name
	 *            Nombre
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * 
	 * @return Valor
	 */
	@XmlValue()
	public String getValue() {
		return this.value;
	}

	/**
	 * 
	 * @param value
	 *            Valor
	 */
	public void setValue(String value) {
		this.value = value;
	}

}
