package com.ejie.y40a.model;

import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

import com.ejie.y40a.control.Y40aJsonDateDeserializer;
import com.ejie.y40a.control.Y40aJsonDateSerializer;

/**
 * * Categoria  
 * 
 *  
 */

public class CategoriaDetalle implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String idCat;
	private String jerarquiaCategoria;

	// Categoria Padre
	private String idCatPadre;
	private String nombreCatPadreEs;
	private String nombreCatPadreEu;
	@Length(max = 100, message = "length.nombreEsCategoria")
	@NotEmpty(message = "required.nombreEsCategoria")
	private String nombreEs;
	@Length(max = 100, message = "length.nombreEuCategoria")
	@NotEmpty(message = "required.nombreEuCategoria")
	private String nombreEu;
	private Date fechaIniSol;
	private Date fechaFinSol;
	private Long numAsistentes;
	private Long numFormaciones;
	private String visibleWeb;
	private String gruposarr;
	private String perfilesarr;

	@Length(max = 4000, message = "length.observacionescategoria")
	private String observacionesEs;
	@Length(max = 4000, message = "length.observacionesEucategoria")
	private String observacionesEu;

	private String visiblecontacto;
	private String campania;

	/**
	 * Method 'CategoriaDetalle'.
	 * 
	 */
	public CategoriaDetalle() {
	}

	/**
	 * @param idCat
	 * @param jerarquiaCategoria
	 * @param idCatPadre
	 * @param nombreCatPadreEs
	 * @param nombreCatPadreEu
	 * @param nombreEs
	 * @param nombreEu
	 * @param fechaIniSol
	 * @param fechaFinSol
	 * @param numAsistentes
	 * @param numFormaciones
	 * @param visibleWeb
	 * @param gruposarr
	 * @param perfilesarr
	 */
	public CategoriaDetalle(String idCat, String jerarquiaCategoria,
			String idCatPadre, String nombreCatPadreEs,
			String nombreCatPadreEu, String nombreEs, String nombreEu,
			Date fechaIniSol, Date fechaFinSol, Long numAsistentes,
			Long numFormaciones, String visibleWeb, String gruposarr,
			String perfilesarr) {
		this.idCat = idCat;
		this.jerarquiaCategoria = jerarquiaCategoria;
		this.idCatPadre = idCatPadre;
		this.nombreCatPadreEs = nombreCatPadreEs;
		this.nombreCatPadreEu = nombreCatPadreEu;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
		this.fechaIniSol = fechaIniSol;
		this.fechaFinSol = fechaFinSol;
		this.numAsistentes = numAsistentes;
		this.numFormaciones = numFormaciones;
		this.visibleWeb = visibleWeb;
		this.gruposarr = gruposarr;
		this.perfilesarr = perfilesarr;
	}

	/**
	 * Method 'getIdCat'.
	 * 
	 * @return String
	 */

	public String getIdCat() {
		return this.idCat;
	}

	/**
	 * Method 'setIdCat'.
	 * 
	 * @param idCat
	 *            String
	 * @return
	 */

	public void setIdCat(String idCat) {
		this.idCat = idCat;
	}

	/**
	 * Method 'getNombreEs'.
	 * 
	 * @return String
	 */

	public String getNombreEs() {
		return this.nombreEs;
	}

	/**
	 * Method 'setNombreEs'.
	 * 
	 * @param nombreEs
	 *            String
	 * @return
	 */

	public void setNombreEs(String nombreEs) {
		this.nombreEs = nombreEs;
	}

	/**
	 * Method 'getNombreEu'.
	 * 
	 * @return String
	 */

	public String getNombreEu() {
		return this.nombreEu;
	}

	/**
	 * Method 'setNombreEu'.
	 * 
	 * @param nombreEu
	 *            String
	 * @return
	 */

	public void setNombreEu(String nombreEu) {
		this.nombreEu = nombreEu;
	}

	/**
	 * Method 'getFechaIniSol'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y40aJsonDateSerializer.class)
	public Date getFechaIniSol() {
		return this.fechaIniSol;
	}

	/**
	 * Method 'setFechaIniSol'.
	 * 
	 * @param fechaIniSol
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y40aJsonDateDeserializer.class)
	public void setFechaIniSol(Date fechaIniSol) {
		this.fechaIniSol = fechaIniSol;
	}

	/**
	 * Method 'getFechaFinSol'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y40aJsonDateSerializer.class)
	public Date getFechaFinSol() {
		return this.fechaFinSol;
	}

	/**
	 * Method 'setFechaFinSol'.
	 * 
	 * @param fechaFinSol
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y40aJsonDateDeserializer.class)
	public void setFechaFinSol(Date fechaFinSol) {
		this.fechaFinSol = fechaFinSol;
	}

	/**
	 * Method 'getNumAsistentes'.
	 * 
	 * @return Long
	 */

	public Long getNumAsistentes() {
		return this.numAsistentes;
	}

	/**
	 * Method 'setNumAsistentes'.
	 * 
	 * @param numAsistentes
	 *            Long
	 * @return
	 */

	public void setNumAsistentes(Long numAsistentes) {
		this.numAsistentes = numAsistentes;
	}

	/**
	 * Method 'getNumFormaciones'.
	 * 
	 * @return Long
	 */

	public Long getNumFormaciones() {
		return this.numFormaciones;
	}

	/**
	 * Method 'setNumFormaciones'.
	 * 
	 * @param numFormaciones
	 *            Long
	 * @return
	 */

	public void setNumFormaciones(Long numFormaciones) {
		this.numFormaciones = numFormaciones;
	}

	/**
	 * Method 'getVisibleWeb'.
	 * 
	 * @return String
	 */

	public String getVisibleWeb() {
		return this.visibleWeb;
	}

	/**
	 * Method 'setVisibleWeb'.
	 * 
	 * @param visibleWeb
	 *            String
	 * @return
	 */

	public void setVisibleWeb(String visibleWeb) {
		this.visibleWeb = visibleWeb;
	}

	/**
	 * @return the jerarquiaCategoria
	 */
	public String getJerarquiaCategoria() {
		return jerarquiaCategoria;
	}

	/**
	 * @param jerarquiaCategoria
	 *            the jerarquiaCategoria to set
	 */
	public void setJerarquiaCategoria(String jerarquiaCategoria) {
		this.jerarquiaCategoria = jerarquiaCategoria;
	}

	/**
	 * @return the idCatPadre
	 */
	public String getIdCatPadre() {
		return idCatPadre;
	}

	/**
	 * @param idCatPadre
	 *            the idCatPadre to set
	 */
	public void setIdCatPadre(String idCatPadre) {
		this.idCatPadre = idCatPadre;
	}

	/**
	 * @return the nombreCatPadreEs
	 */
	public String getNombreCatPadreEs() {
		return nombreCatPadreEs;
	}

	/**
	 * @param nombreCatPadreEs
	 *            the nombreCatPadreEs to set
	 */
	public void setNombreCatPadreEs(String nombreCatPadreEs) {
		this.nombreCatPadreEs = nombreCatPadreEs;
	}

	/**
	 * @return the nombreCatPadreEu
	 */
	public String getNombreCatPadreEu() {
		return nombreCatPadreEu;
	}

	/**
	 * @param nombreCatPadreEu
	 *            the nombreCatPadreEu to set
	 */
	public void setNombreCatPadreEu(String nombreCatPadreEu) {
		this.nombreCatPadreEu = nombreCatPadreEu;
	}

	/**
	 * @return the gruposarr
	 */
	public String getGruposarr() {
		return gruposarr;
	}

	/**
	 * @param gruposarr
	 *            the gruposarr to set
	 */
	public void setGruposarr(String gruposarr) {
		this.gruposarr = gruposarr;
	}

	/**
	 * @return the perfilesarr
	 */
	public String getPerfilesarr() {
		return perfilesarr;
	}

	/**
	 * @param perfilesarr
	 *            the perfilesarr to set
	 */
	public void setPerfilesarr(String perfilesarr) {
		this.perfilesarr = perfilesarr;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "CategoriaDetalle [idCat=" + idCat + ", jerarquiaCategoria="
				+ jerarquiaCategoria + ", idCatPadre=" + idCatPadre
				+ ", nombreCatPadreEs=" + nombreCatPadreEs
				+ ", nombreCatPadreEu=" + nombreCatPadreEu + ", nombreEs="
				+ nombreEs + ", nombreEu=" + nombreEu + ", fechaIniSol="
				+ fechaIniSol + ", fechaFinSol=" + fechaFinSol
				+ ", numAsistentes=" + numAsistentes + ", numFormaciones="
				+ numFormaciones + ", visibleWeb=" + visibleWeb
				+ ", gruposarr=" + gruposarr + ", perfilesarr=" + perfilesarr
				+ "]";
	}

	/**
	 * @param observacionesEs
	 *            the observacionesEs to set
	 */
	public void setObservacionesEs(String observacionesEs) {
		this.observacionesEs = observacionesEs;
	}

	/**
	 * @return the observacionesEs
	 */
	public String getObservacionesEs() {
		return observacionesEs;
	}

	/**
	 * @param observacionesEu
	 *            the observacionesEu to set
	 */
	public void setObservacionesEu(String observacionesEu) {
		this.observacionesEu = observacionesEu;
	}

	/**
	 * @return the observacionesEu
	 */
	public String getObservacionesEu() {
		return observacionesEu;
	}

	/**
	 * @param visiblecontacto
	 *            the visiblecontacto to set
	 */
	public void setVisiblecontacto(String visiblecontacto) {
		this.visiblecontacto = visiblecontacto;
	}

	/**
	 * @return the visiblecontacto
	 */
	public String getVisiblecontacto() {
		return visiblecontacto;
	}

	public String getCampania() {
		return campania;
	}

	public void setCampania(String campania) {
		this.campania = campania;
	}

}
