package com.ejie.y40a.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.y40a.control.Y40aJsonDateDeserializer;
import com.ejie.y40a.control.Y40aJsonDateSerializer;

/**
 * * Categoria  
 * 
 *  
 */

public class Categoria implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String idCat;
	private String jerarquiaCategoria;
	private Categoria categoria;
	private String nombreEs;
	private String nombreEu;
	private Date fechaIniSol;
	private Date fechaFinSol;
	private Long numAsistentes;
	private Long numFormaciones;
	private String visibleWeb;
	private List<Perfil> perfils = new ArrayList<Perfil>();
	private List<Grupo> grupos = new ArrayList<Grupo>();
	private List<Categoria> categorias = new ArrayList<Categoria>();
	private List<Formacion> formacions = new ArrayList<Formacion>();

	private String observacionesEs;
	private String observacionesEu;
	
	private String visiblecontacto;

	/**
	 * Method 'Categoria'.
	 * 
	 */
	public Categoria() {
	}

	/**
	 * Method 'Categoria'.
	 * 
	 * @param idCat
	 *            String
	 * @param nombreEs
	 *            String
	 * @param nombreEu
	 *            String
	 * @param fechaIniSol
	 *            Date
	 * @param fechaFinSol
	 *            Date
	 * @param numAsistentes
	 *            Long
	 * @param numFormaciones
	 *            Long
	 * @param visibleWeb
	 *            String
	 * @param categoria
	 *            Categoria
	 */
	public Categoria(String idCat, String nombreEs, String nombreEu,
			Date fechaIniSol, Date fechaFinSol, Long numAsistentes,
			Long numFormaciones, String visibleWeb, Categoria categoria) {
		this.idCat = idCat;
		this.categoria = categoria;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
		this.fechaIniSol = fechaIniSol;
		this.fechaFinSol = fechaFinSol;
		this.numAsistentes = numAsistentes;
		this.numFormaciones = numFormaciones;
		this.visibleWeb = visibleWeb;
	}

	/**
	 * Method 'Categoria'.
	 * 
	 * @param idCat
	 *            String
	 * @param nombreEs
	 *            String
	 * @param nombreEu
	 *            String
	 * @param fechaIniSol
	 *            Date
	 * @param fechaFinSol
	 *            Date
	 * @param numAsistentes
	 *            Long
	 * @param numFormaciones
	 *            Long
	 * @param visibleWeb
	 *            String
	 * @param categoria
	 *            Categoria
	 * @param perfils
	 *            List<Perfil>
	 * @param grupos
	 *            List<Grupo>
	 * @param categorias
	 *            List<Categoria>
	 * @param formacions
	 *            List<Formacion>
	 */
	public Categoria(String idCat, String nombreEs, String nombreEu,
			Date fechaIniSol, Date fechaFinSol, Long numAsistentes,
			Long numFormaciones, String visibleWeb, Categoria categoria,
			List<Perfil> perfils, List<Grupo> grupos,
			List<Categoria> categorias, List<Formacion> formacions) {

		this.idCat = idCat;
		this.categoria = categoria;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
		this.fechaIniSol = fechaIniSol;
		this.fechaFinSol = fechaFinSol;
		this.numAsistentes = numAsistentes;
		this.numFormaciones = numFormaciones;
		this.visibleWeb = visibleWeb;
		this.perfils = perfils;
		this.grupos = grupos;
		this.categorias = categorias;
		this.formacions = formacions;
	}

	/**
	 * Method 'getIdCat'.
	 * 
	 * @return String
	 */

	public String getIdCat() {
		return this.idCat;
	}

	/**
	 * Method 'setIdCat'.
	 * 
	 * @param idCat
	 *            String
	 * @return
	 */

	public void setIdCat(String idCat) {
		this.idCat = idCat;
	}

	/**
	 * Method 'getCategoria'.
	 * 
	 * @return Categoria
	 */
	@JsonIgnore
	public Categoria getCategoria() {
		return this.categoria;
	}

	/**
	 * Method 'setCategoria'.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return
	 */

	public void setCategoria(Categoria categoria) {
		this.categoria = categoria;
	}

	/**
	 * Method 'getNombreEs'.
	 * 
	 * @return String
	 */

	public String getNombreEs() {
		return this.nombreEs;
	}

	/**
	 * Method 'setNombreEs'.
	 * 
	 * @param nombreEs
	 *            String
	 * @return
	 */

	public void setNombreEs(String nombreEs) {
		this.nombreEs = nombreEs;
	}

	/**
	 * Method 'getNombreEu'.
	 * 
	 * @return String
	 */

	public String getNombreEu() {
		return this.nombreEu;
	}

	/**
	 * Method 'setNombreEu'.
	 * 
	 * @param nombreEu
	 *            String
	 * @return
	 */

	public void setNombreEu(String nombreEu) {
		this.nombreEu = nombreEu;
	}

	/**
	 * Method 'getFechaIniSol'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y40aJsonDateSerializer.class)
	public Date getFechaIniSol() {
		return this.fechaIniSol;
	}

	/**
	 * Method 'setFechaIniSol'.
	 * 
	 * @param fechaIniSol
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y40aJsonDateDeserializer.class)
	public void setFechaIniSol(Date fechaIniSol) {
		this.fechaIniSol = fechaIniSol;
	}

	/**
	 * Method 'getFechaFinSol'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y40aJsonDateSerializer.class)
	public Date getFechaFinSol() {
		return this.fechaFinSol;
	}

	/**
	 * Method 'setFechaFinSol'.
	 * 
	 * @param fechaFinSol
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y40aJsonDateDeserializer.class)
	public void setFechaFinSol(Date fechaFinSol) {
		this.fechaFinSol = fechaFinSol;
	}

	/**
	 * Method 'getNumAsistentes'.
	 * 
	 * @return Long
	 */

	public Long getNumAsistentes() {
		return this.numAsistentes;
	}

	/**
	 * Method 'setNumAsistentes'.
	 * 
	 * @param numAsistentes
	 *            Long
	 * @return
	 */

	public void setNumAsistentes(Long numAsistentes) {
		this.numAsistentes = numAsistentes;
	}

	/**
	 * Method 'getNumFormaciones'.
	 * 
	 * @return Long
	 */

	public Long getNumFormaciones() {
		return this.numFormaciones;
	}

	/**
	 * Method 'setNumFormaciones'.
	 * 
	 * @param numFormaciones
	 *            Long
	 * @return
	 */

	public void setNumFormaciones(Long numFormaciones) {
		this.numFormaciones = numFormaciones;
	}

	/**
	 * Method 'getVisibleWeb'.
	 * 
	 * @return String
	 */

	public String getVisibleWeb() {
		return this.visibleWeb;
	}

	/**
	 * Method 'setVisibleWeb'.
	 * 
	 * @param visibleWeb
	 *            String
	 * @return
	 */

	public void setVisibleWeb(String visibleWeb) {
		this.visibleWeb = visibleWeb;
	}

	/**
	 * Method 'getPerfils'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Perfil> getPerfils() {
		return this.perfils;
	}

	/**
	 * Method 'setPerfils'.
	 * 
	 * @param perfils
	 *            List
	 * @return
	 */
	public void setPerfils(List<Perfil> perfils) {
		this.perfils = perfils;
	}

	/**
	 * Method 'getGrupos'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Grupo> getGrupos() {
		return this.grupos;
	}

	/**
	 * Method 'setGrupos'.
	 * 
	 * @param grupos
	 *            List
	 * @return
	 */
	public void setGrupos(List<Grupo> grupos) {
		this.grupos = grupos;
	}

	/**
	 * Method 'getCategorias'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Categoria> getCategorias() {
		return this.categorias;
	}

	/**
	 * Method 'setCategorias'.
	 * 
	 * @param categorias
	 *            List
	 * @return
	 */
	public void setCategorias(List<Categoria> categorias) {
		this.categorias = categorias;
	}

	/**
	 * Method 'getFormacions'.
	 * 
	 * @return List
	 */
	@JsonIgnore
	public List<Formacion> getFormacions() {
		return this.formacions;
	}

	/**
	 * Method 'setFormacions'.
	 * 
	 * @param formacions
	 *            List
	 * @return
	 */
	public void setFormacions(List<Formacion> formacions) {
		this.formacions = formacions;
	}

	/**
	 * @return the jerarquiaCategoria
	 */
	public String getJerarquiaCategoria() {
		return jerarquiaCategoria;
	}

	/**
	 * @param jerarquiaCategoria
	 *            the jerarquiaCategoria to set
	 */
	public void setJerarquiaCategoria(String jerarquiaCategoria) {
		this.jerarquiaCategoria = jerarquiaCategoria;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "Categoria [idCat=" + idCat + ", jerarquiaCategoria="
				+ jerarquiaCategoria + ", categoria=" + categoria
				+ ", nombreEs=" + nombreEs + ", nombreEu=" + nombreEu
				+ ", fechaIniSol=" + fechaIniSol + ", fechaFinSol="
				+ fechaFinSol + ", numAsistentes=" + numAsistentes
				+ ", numFormaciones=" + numFormaciones + ", visibleWeb="
				+ visibleWeb + ", perfils=" + perfils + ", grupos=" + grupos
				+ ", categorias=" + categorias + ", formacions=" + formacions
				+ "]";
	}

	/**
	 * @param observacionesEu the observacionesEu to set
	 */
	public void setObservacionesEu(String observacionesEu) {
		this.observacionesEu = observacionesEu;
	}

	/**
	 * @return the observacionesEu
	 */
	public String getObservacionesEu() {
		return observacionesEu;
	}

	/**
	 * @param observacionesEs the observacionesEs to set
	 */
	public void setObservacionesEs(String observacionesEs) {
		this.observacionesEs = observacionesEs;
	}

	/**
	 * @return the observacionesEs
	 */
	public String getObservacionesEs() {
		return observacionesEs;
	}

	/**
	 * @param visiblecontacto the visiblecontacto to set
	 */
	public void setVisiblecontacto(String visiblecontacto) {
		this.visiblecontacto = visiblecontacto;
	}

	/**
	 * @return the visiblecontacto
	 */
	public String getVisiblecontacto() {
		return visiblecontacto;
	}

}
