package com.ejie.y40a.model;

import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

import com.ejie.y40a.control.Y40aJsonDateDeserializer;
import com.ejie.y40a.control.Y40aJsonDateSerializer;

/**
 * * Categoria  
 * 
 *  
 */

public class CampainaDetalle implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private String idCat;

	@Length(max = 100, message = "length.nombreEsCategoria")
	@NotEmpty(message = "required.nombreEsCategoria")
	private String nombreEs;
	@Length(max = 100, message = "length.nombreEuCategoria")
	@NotEmpty(message = "required.nombreEuCategoria")
	private String nombreEu;
	private Date fechaIniSol;
	private Date fechaFinSol;

	/**
	 * Method 'CategoriaDetalle'.
	 * 
	 */
	public CampainaDetalle() {
	}

	/**
	 * @param idCat
	 * @param jerarquiaCategoria
	 * @param idCatPadre
	 * @param nombreCatPadreEs
	 * @param nombreCatPadreEu
	 * @param nombreEs
	 * @param nombreEu
	 * @param fechaIniSol
	 * @param fechaFinSol
	 * @param numAsistentes
	 * @param numFormaciones
	 * @param visibleWeb
	 * @param gruposarr
	 * @param perfilesarr
	 */
	public CampainaDetalle(String idCat, String nombreEs, String nombreEu,
			Date fechaIniSol, Date fechaFinSol) {
		this.idCat = idCat;
		this.nombreEs = nombreEs;
		this.nombreEu = nombreEu;
		this.fechaIniSol = fechaIniSol;
		this.fechaFinSol = fechaFinSol;
	}

	/**
	 * Method 'getIdCat'.
	 * 
	 * @return String
	 */

	public String getIdCat() {
		return this.idCat;
	}

	/**
	 * Method 'setIdCat'.
	 * 
	 * @param idCat
	 *            String
	 * @return
	 */

	public void setIdCat(String idCat) {
		this.idCat = idCat;
	}

	/**
	 * Method 'getNombreEs'.
	 * 
	 * @return String
	 */

	public String getNombreEs() {
		return this.nombreEs;
	}

	/**
	 * Method 'setNombreEs'.
	 * 
	 * @param nombreEs
	 *            String
	 * @return
	 */

	public void setNombreEs(String nombreEs) {
		this.nombreEs = nombreEs;
	}

	/**
	 * Method 'getNombreEu'.
	 * 
	 * @return String
	 */

	public String getNombreEu() {
		return this.nombreEu;
	}

	/**
	 * Method 'setNombreEu'.
	 * 
	 * @param nombreEu
	 *            String
	 * @return
	 */

	public void setNombreEu(String nombreEu) {
		this.nombreEu = nombreEu;
	}

	/**
	 * Method 'getFechaIniSol'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y40aJsonDateSerializer.class)
	public Date getFechaIniSol() {
		return this.fechaIniSol;
	}

	/**
	 * Method 'setFechaIniSol'.
	 * 
	 * @param fechaIniSol
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y40aJsonDateDeserializer.class)
	public void setFechaIniSol(Date fechaIniSol) {
		this.fechaIniSol = fechaIniSol;
	}

	/**
	 * Method 'getFechaFinSol'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = Y40aJsonDateSerializer.class)
	public Date getFechaFinSol() {
		return this.fechaFinSol;
	}

	/**
	 * Method 'setFechaFinSol'.
	 * 
	 * @param fechaFinSol
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = Y40aJsonDateDeserializer.class)
	public void setFechaFinSol(Date fechaFinSol) {
		this.fechaFinSol = fechaFinSol;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "CategoriaDetalle [idCat=" + idCat + ", nombreEs=" + nombreEs
				+ ", nombreEu=" + nombreEu + ", fechaIniSol=" + fechaIniSol
				+ ", fechaFinSol=" + fechaFinSol + "]";
	}

}
