package com.ejie.y40a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y40a.model.T17Provincia;

/**
 * * T17ProvinciaDaoImpl  
 * 
 *  
 */
@Repository
@Transactional
public class T17ProvinciaDaoImpl implements T17ProvinciaDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<T17Provincia> rwMap = new RowMapper<T17Provincia>() {
		public T17Provincia mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new T17Provincia(resultSet.getString("ID"),
					resultSet.getString("DSO"),
					resultSet.getString("AUTONOMIAID"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * 
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the T17Provincia table.
	 * 
	 * @param t17provincia
	 *            Pagination
	 * @return T17Provincia
	 */
	public T17Provincia add(T17Provincia t17provincia) {

		String query = "INSERT INTO T17_PROVINCIA( ID,DS_O,AUTONOMIA_ID)"
				+ "VALUES (?,?,?)";

		this.jdbcTemplate.update(query, t17provincia.getId(),
				t17provincia.getDsO(), t17provincia.getAutonomiaId());
		return t17provincia;
	}

	/**
	 * Updates a single row in the T17Provincia table.
	 * 
	 * @param t17provincia
	 *            Pagination
	 * @return T17Provincia
	 */
	public T17Provincia update(T17Provincia t17provincia) {
		String query = "UPDATE T17_PROVINCIA SET DS_O=?,AUTONOMIA_ID=? WHERE ID=?";
		this.jdbcTemplate.update(query, t17provincia.getDsO(),
				t17provincia.getAutonomiaId(), t17provincia.getId());
		return t17provincia;

	}

	/**
	 * Finds a single row in the T17Provincia table.
	 * 
	 * @param t17provincia
	 *            Pagination
	 * @return T17Provincia
	 */
	@Transactional(readOnly = true)
	public T17Provincia find(T17Provincia t17provincia) {
		String query = "SELECT t1.ID ID, t1.DS_O DSO, t1.AUTONOMIA_ID AUTONOMIAID "
				+ "FROM T17_PROVINCIA t1  " + "WHERE t1.ID = ?    ";
		return (T17Provincia) this.jdbcTemplate.queryForObject(query, rwMap,
				t17provincia.getId());
	}

	/**
	 * Removes a single row in the T17Provincia table.
	 * 
	 * @param t17provincia
	 *            Pagination
	 * 
	 */
	public void remove(T17Provincia t17provincia) {
		String query = "DELETE  FROM T17_PROVINCIA WHERE ID=?";
		this.jdbcTemplate.update(query, t17provincia.getId());

	}

	/**
	 * Finds a List of rows in the T17Provincia table.
	 * 
	 * @param t17provincia
	 *            T17Provincia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Provincia> findAll(T17Provincia t17provincia,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID ID,t1.DS_O DSO,t1.AUTONOMIA_ID AUTONOMIAID "
						+ "FROM T17_PROVINCIA t1 ");
		if (t17provincia != null && t17provincia.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17provincia.getId());
		}
		if (t17provincia != null && t17provincia.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17provincia.getDsO());
		}
		if (t17provincia != null && t17provincia.getAutonomiaId() != null) {
			where.append(" AND t1.AUTONOMIA_ID = ?");
			params.add(t17provincia.getAutonomiaId());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<T17Provincia>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the T17Provincia table.
	 * 
	 * @param t17provincia
	 *            T17Provincia
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(T17Provincia t17provincia) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  T17_PROVINCIA t1  ");
		if (t17provincia != null && t17provincia.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17provincia.getId());
		}
		if (t17provincia != null && t17provincia.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17provincia.getDsO());
		}
		if (t17provincia != null && t17provincia.getAutonomiaId() != null) {
			where.append(" AND t1.AUTONOMIA_ID = ?");
			params.add(t17provincia.getAutonomiaId());
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/**
	 * Finds rows in the T17Provincia table using like.
	 * 
	 * @param t17provincia
	 *            T17Provincia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Provincia> findAllLike(T17Provincia t17provincia,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID ID,t1.DS_O DSO,t1.AUTONOMIA_ID AUTONOMIAID "
						+ "FROM T17_PROVINCIA t1 ");
		if (t17provincia != null && t17provincia.getId() != null) {
			where.append(" AND UPPER(t1.ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17provincia.getId().toUpperCase() + "%");
			} else {
				params.add("%" + t17provincia.getId().toUpperCase() + "%");
			}
			where.append(" AND t1.ID IS NOT NULL");

		}
		if (t17provincia != null && t17provincia.getDsO() != null) {
			where.append(" AND UPPER(t1.DS_O) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17provincia.getDsO().toUpperCase() + "%");
			} else {
				params.add("%" + t17provincia.getDsO().toUpperCase() + "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");

		}
		if (t17provincia != null && t17provincia.getAutonomiaId() != null) {
			where.append(" AND UPPER(t1.AUTONOMIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17provincia.getAutonomiaId().toUpperCase() + "%");
			} else {
				params.add("%" + t17provincia.getAutonomiaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AUTONOMIA_ID IS NOT NULL");

		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<T17Provincia>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

}
