package com.ejie.y40a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y40a.model.T17Calle;

/**
 * * T17CalleDaoImpl  
 * 
 *  
 */
@Repository
@Transactional
public class T17CalleDaoImpl implements T17CalleDao {

	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<T17Calle> rwMap = new RowMapper<T17Calle>() {
		public T17Calle mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			return new T17Calle(resultSet.getLong("ID"),
					resultSet.getString("DS_O"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * 
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the T17Calle table.
	 * 
	 * @param t17portal
	 *            Pagination
	 * @return T17Calle
	 */
	@Transactional(readOnly = true)
	public T17Calle find(T17Calle t17calle) {
		String query = "SELECT t1.ID ID, t1.DS_O DS_O " + "FROM T17_CALLE t1  "
				+ "WHERE t1.ID = ?";
		return (T17Calle) this.jdbcTemplate.queryForObject(query, rwMap,
				t17calle.getId());
	}

	/**
	 * Finds a List of rows in the T17Calle table.
	 * 
	 * @param t17portal
	 *            T17Calle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Calle> findAll(T17Calle t17calle, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer(
				"SELECT ID, (t1.tipo_via||'  '||t1.ds_o) AS DS_O  FROM T17_CALLE t1");

		where.append(" AND t1.PROVINCIA_ID = ?");
		params.add(t17calle.getProvinciaId());

		where.append(" AND t1.MUNICIPIO_ID = ?");
		params.add(t17calle.getMunicipioId());

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<T17Calle>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the T17Calle table.
	 * 
	 * @param t17portal
	 *            T17Calle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(T17Calle t17calle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  T17_CALLE t1  ");
		if (t17calle != null && t17calle.getProvinciaId() != null) {
			where.append(" AND t1.PROVINCIA_ID = ?");
			params.add(t17calle.getId());
		}
		if (t17calle != null && t17calle.getMunicipioId() != null) {
			where.append(" AND t1.MUNICIPIO_ID = ?");
			params.add(t17calle.getMunicipioId());
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/**
	 * Finds rows in the T17Calle table using like.
	 * 
	 * @param t17portal
	 *            T17Calle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Calle> findAllLike(T17Calle t17calle, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer(
				"SELECT t1.ID ID, t1.DS_O DS_O FROM T17_CALLE t1  ");

		if (t17calle != null && t17calle.getDsO() != null) {
			where.append(" AND t1.ID like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17calle.getDsO() + "%");
			} else {
				params.add("%" + t17calle.getDsO() + "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");

		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<T17Calle>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Finds rows in the T17Calle table using like.
	 * 
	 * @param t17portal
	 *            T17Calle
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Calle> findAllLike_Calle(T17Calle t17calle,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer(
				"SELECT t1.ID ID, t1.DS_O DS_O FROM T17_CALLE t1  ");

		where.append(" AND t1.PROVINCIA_ID = ?");
		params.add(t17calle.getProvinciaId());

		where.append(" AND t1.MUNICIPIO_ID = ?");
		params.add(t17calle.getMunicipioId());

		if (t17calle != null && t17calle.getDsO() != null) {
			where.append(" AND UPPER(t1.DS_O) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17calle.getDsO().toUpperCase() + "%");
			} else {
				params.add("%" + t17calle.getDsO().toUpperCase() + "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");

		}

		query.append(where);
		query.append(" ORDER BY (t1.DS_O) ASC");

		return (List<T17Calle>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	@Override
	public T17Calle add(T17Calle t17calle) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public T17Calle update(T17Calle t17calle) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void remove(T17Calle t17calle) {
		// TODO Auto-generated method stub

	}

}
