package com.ejie.y40a.dao;

/**
 * T17CalleDao  
 */

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.T17Calle;

/**
 * T17CalleDao  
 * 
 *  
 */
public interface T17CalleDao {
	/**
	 * Inserts a single row in the T17Calle table.
	 * 
	 * @param t17Calle
	 *            T17Calle
	 * @return T17Calle
	 */
	T17Calle add(T17Calle t17calle);

	/**
	 * Updates a single row in the T17Calle table.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * @return T17Calle
	 */
	T17Calle update(T17Calle t17calle);

	/**
	 * Finds a single row in the T17Calle table.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * @return T17Calle
	 */
	T17Calle find(T17Calle t17calle);

	/**
	 * Deletes a single row in the T17Calle table.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * 
	 */
	void remove(T17Calle t17calle);

	/**
	 * Finds a List of rows in the T17Calle table.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<T17Calle> findAll(T17Calle t17calle, Pagination pagination);

	/**
	 * Counts rows in the T17Calle table.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * @return List
	 */
	Long findAllCount(T17Calle t17calle);

	/**
	 * Finds rows in the T17Calle table using like.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * @return List
	 */
	List<T17Calle> findAllLike(T17Calle t17calle, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the T17Calle table using like.
	 * 
	 * @param t17portal
	 *            T17Calle
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<T17Calle> findAllLike_Calle(T17Calle t17calle, Pagination pagination,
			Boolean startsWith);
}
