package com.ejie.y40a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y40a.model.T17Autonomia;

/**
 * * T17AutonomiaDaoImpl  
 * 
 *  
 */
@Repository
@Transactional
public class T17AutonomiaDaoImpl implements T17AutonomiaDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<T17Autonomia> rwMap = new RowMapper<T17Autonomia>() {
		public T17Autonomia mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new T17Autonomia(resultSet.getString("ID"),
					resultSet.getString("DSO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * 
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the T17Autonomia table.
	 * 
	 * @param t17autonomia
	 *            Pagination
	 * @return T17Autonomia
	 */
	public T17Autonomia add(T17Autonomia t17autonomia) {

		String query = "INSERT INTO T17_AUTONOMIA( ID,DS_O)" + "VALUES (?,?)";

		this.jdbcTemplate.update(query, t17autonomia.getId(),
				t17autonomia.getDsO());
		return t17autonomia;
	}

	/**
	 * Updates a single row in the T17Autonomia table.
	 * 
	 * @param t17autonomia
	 *            Pagination
	 * @return T17Autonomia
	 */
	public T17Autonomia update(T17Autonomia t17autonomia) {
		String query = "UPDATE T17_AUTONOMIA SET DS_O=? WHERE ID=?";
		this.jdbcTemplate.update(query, t17autonomia.getDsO(),
				t17autonomia.getId());
		return t17autonomia;

	}

	/**
	 * Finds a single row in the T17Autonomia table.
	 * 
	 * @param t17autonomia
	 *            Pagination
	 * @return T17Autonomia
	 */
	@Transactional(readOnly = true)
	public T17Autonomia find(T17Autonomia t17autonomia) {
		String query = "SELECT t1.ID ID, t1.DS_O DSO "
				+ "FROM T17_AUTONOMIA t1  " + "WHERE t1.ID = ?    ";
		return (T17Autonomia) this.jdbcTemplate.queryForObject(query, rwMap,
				t17autonomia.getId());
	}

	/**
	 * Removes a single row in the T17Autonomia table.
	 * 
	 * @param t17autonomia
	 *            Pagination
	 * 
	 */
	public void remove(T17Autonomia t17autonomia) {
		String query = "DELETE  FROM T17_AUTONOMIA WHERE ID=?";
		this.jdbcTemplate.update(query, t17autonomia.getId());

	}

	/**
	 * Finds a List of rows in the T17Autonomia table.
	 * 
	 * @param t17autonomia
	 *            T17Autonomia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Autonomia> findAll(T17Autonomia t17autonomia,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer("SELECT  t1.ID ID,t1.DS_O DSO "
				+ "FROM T17_AUTONOMIA t1 ");
		if (t17autonomia != null && t17autonomia.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17autonomia.getId());
		}
		if (t17autonomia != null && t17autonomia.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17autonomia.getDsO());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<T17Autonomia>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the T17Autonomia table.
	 * 
	 * @param t17autonomia
	 *            T17Autonomia
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(T17Autonomia t17autonomia) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  T17_AUTONOMIA t1  ");
		if (t17autonomia != null && t17autonomia.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17autonomia.getId());
		}
		if (t17autonomia != null && t17autonomia.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17autonomia.getDsO());
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/**
	 * Finds rows in the T17Autonomia table using like.
	 * 
	 * @param t17autonomia
	 *            T17Autonomia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Autonomia> findAllLike(T17Autonomia t17autonomia,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer("SELECT  t1.ID ID,t1.DS_O DSO "
				+ "FROM T17_AUTONOMIA t1 ");
		if (t17autonomia != null && t17autonomia.getId() != null) {
			where.append(" AND UPPER(t1.ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17autonomia.getId().toUpperCase() + "%");
			} else {
				params.add("%" + t17autonomia.getId().toUpperCase() + "%");
			}
			where.append(" AND t1.ID IS NOT NULL");

		}
		if (t17autonomia != null && t17autonomia.getDsO() != null) {
			where.append(" AND UPPER(t1.DS_O) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17autonomia.getDsO().toUpperCase() + "%");
			} else {
				params.add("%" + t17autonomia.getDsO().toUpperCase() + "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");

		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<T17Autonomia>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

}
