package com.ejie.y40a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.ConsultaDinamicaBusqueda;
import com.ejie.y40a.model.ConsultaDinamicaResultado;
import com.ejie.y40a.model.Entidad;
import com.ejie.y40a.model.Etiqueta;
import com.ejie.y40a.model.Formacion;
import com.ejie.y40a.model.Grupo;
import com.ejie.y40a.model.ObservacionesEntidad;
import com.ejie.y40a.model.PlanificacionFormacionBusqueda;
import com.ejie.y40a.model.PlanificacionSolicitanteBusqueda;
import com.ejie.y40a.model.PlanificacionSolicitanteBusquedaCartas;
import com.ejie.y40a.model.Solicitud;
import com.ejie.y40a.model.Y40aCategoriaTree;
import com.ejie.y40a.service.SolicitudServiceImpl;
import com.ejie.y40a.utils.Y40aUtils;

/**
 * * SolicitudDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class SolicitudDaoImpl implements SolicitudDao {

	private static final Logger logger = LoggerFactory
			.getLogger(SolicitudServiceImpl.class);

	private SimpleJdbcTemplate jdbcTemplate;

	private RowMapper<Solicitud> rwMap = new RowMapper<Solicitud>() {
		public Solicitud mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			List<String> columnasSeleccionadas = Y40aUtils
					.cargarDatosBDVO(resultSet);

			Solicitud modelSolicitud = new Solicitud(
					resultSet.getString("IDSOL"),
					resultSet.getDate("FECHASOL"), new Formacion(
							resultSet.getString("FormacionIDFOR"),
							resultSet.getString("FormacionNOMBREES"),
							resultSet.getString("FormacionNOMBREEU"),
							resultSet.getString("FormacionNOMBRECORTOES"),
							resultSet.getString("FormacionNOMBRECORTOEU"),
							resultSet.getString("FormacionDESCRIPCIONES"),
							resultSet.getString("FormacionDESCRIPCIONEU"),
							resultSet.getString("FormacionVISIBLEWEB"), null,
							new Categoria(
									resultSet.getString("FormacionIDCAT"),
									null, null, null, null, null, null, null,
									null)), new Entidad(
							resultSet.getString("EntidadENTIDADID"),
							resultSet.getString("EntidadNOMBREES"),
							resultSet.getString("EntidadNOMBREEU"),
							resultSet.getString("EntidadACTIVA"),
							resultSet.getString("EntidadISKONTSUMOGEST"),
							resultSet.getString("EntidadISKONTSUMONET"),
							resultSet.getString("EntidadISOFERTAFORM"),
							resultSet.getString("EntidadISCONSULTASWEB"),
							resultSet.getString("EntidadCODORG"),
							resultSet.getString("EntidadOBSERVACIONES"),
							resultSet.getString("EntidadTELEFONO"),
							resultSet.getString("EntidadFAX"),
							resultSet.getString("EntidadEMAIL"),
							resultSet.getString("EntidadURL"),
							resultSet.getString("EntidadUSUARIO"),
							resultSet.getString("EntidadPASSWORD"),
							resultSet.getString("EntidadISNACIONAL"),
							resultSet.getString("EntidadNORAPAISID"),
							resultSet.getString("EntidadNOMBREPAIS"),
							resultSet.getString("EntidadNORAPROVINCIAID"),
							resultSet.getString("EntidadNOMBREPROVINCIA"),
							resultSet.getString("EntidadNORAMUNICIPIOID"),
							resultSet.getString("EntidadNOMBREMUNICIPIO"),
							resultSet.getString("EntidadNORALOCALIDADID"),
							resultSet.getString("EntidadNOMBRELOCALIDAD"),
							resultSet.getString("EntidadNORACALLEID"),
							resultSet.getString("EntidadNOMBRECALLE"),
							resultSet.getString("EntidadNORACPID"),
							resultSet.getString("EntidadNOMBRECP"),
							resultSet.getString("EntidadNORAPORTALID"),
							resultSet.getString("EntidadNOMBREPORTAL"),
							resultSet.getString("EntidadUSUULTMOD"),
							resultSet.getDate("EntidadFECULTMOD"),
							resultSet.getString("EntidadCOMPLEDIREC"),
							resultSet.getString("EntidadORINBDCO"),
							new ObservacionesEntidad(resultSet
									.getString("EntidadENTIDADID"), null)),
					resultSet.getString("GRUPO"),
					resultSet.getLong("PARTICIPANTES"),
					resultSet.getString("PROVINCIA"),
					resultSet.getDate("DIAIMPARTICION"),
					resultSet.getString("HORAINICIO"),
					resultSet.getString("HORAFIN"),
					resultSet.getLong("ASISTENTES"),
					resultSet.getLong("NUMMUJERES"),
					resultSet.getLong("NUMHOMBRES"),
					resultSet.getString("CANCELADO"),
					resultSet.getString("IDIOMA"),
					resultSet.getString("BLOQUEADA"),
					resultSet.getString("MOTIVO_CANC"));

			// Campo nuevo contacto y observaciones
			modelSolicitud.setObservaciones(resultSet
					.getString("OBSERVACIONES"));
			modelSolicitud.setNombapecontacto((columnasSeleccionadas
					.contains("NOMBAPECONTACTO")) ? resultSet
					.getString("NOMBAPECONTACTO") : null);
			modelSolicitud.setEmailcontacto((columnasSeleccionadas
					.contains("EMAILCONTACTO")) ? resultSet
					.getString("EMAILCONTACTO") : null);
			modelSolicitud.setTelcontacto((columnasSeleccionadas
					.contains("TELCONTACTO")) ? resultSet
					.getString("TELCONTACTO") : null);
			modelSolicitud.setObservasolicitante((columnasSeleccionadas
					.contains("OBSERVASOLICITANTE")) ? resultSet
					.getString("OBSERVASOLICITANTE") : null);

			return modelSolicitud;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Pagination
	 * @return Solicitud
	 */
	public Solicitud add(Solicitud solicitud) {

		String query = "INSERT INTO SOLICITUD( ID_SOL,FECHA_SOL,ID_FOR,ENTIDAD_ID,GRUPO,PARTICIPANTES,PROVINCIA,DIA_IMPARTICION,HORA_INICIO, HORA_FIN,ASISTENTES,CANCELADO,IDIOMA,OBSERVACIONES"
				+ ",NOMBAPECONTACTO,EMAILCONTACTO,TELCONTACTO,OBSERVASOLICITANTE, NUMMUJERES, NUMHOMBRES, BLOQUEADA, MOTIVO_CANC )"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getFormacionIdForAux = null;
		if (solicitud.getFormacion() != null
				&& solicitud.getFormacion().getIdFor() != null) {
			getFormacionIdForAux = solicitud.getFormacion().getIdFor();
		}
		Object getEntidadEntidadIdAux = null;
		if (solicitud.getEntidad() != null
				&& solicitud.getEntidad().getEntidadId() != null) {
			getEntidadEntidadIdAux = solicitud.getEntidad().getEntidadId();
		}
		this.jdbcTemplate.update(query, solicitud.getIdSol(),
				solicitud.getFechaSol(), getFormacionIdForAux,
				getEntidadEntidadIdAux, solicitud.getGrupo(),
				solicitud.getParticipantes(), solicitud.getProvincia(),
				solicitud.getDiaImparticion(), solicitud.getHoraInicio(),
				solicitud.getHoraFin(), solicitud.getAsistentes(),
				solicitud.getCancelado(), solicitud.getIdioma(),
				solicitud.getObservaciones(), solicitud.getNombapecontacto(),
				solicitud.getEmailcontacto(), solicitud.getTelcontacto(),
				solicitud.getObservasolicitante(), solicitud.getNumMujeres(),
				solicitud.getNumHombres(), solicitud.getBloqueada(),
				solicitud.getIdMotivo());
		return solicitud;
	}

	/**
	 * Updates a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Pagination
	 * @return Solicitud
	 */
	public Solicitud update(Solicitud solicitud) {
		String query = "UPDATE SOLICITUD SET ID_FOR=?,ENTIDAD_ID=?,GRUPO=?,PARTICIPANTES=?,PROVINCIA=?,DIA_IMPARTICION=?,HORA_INICIO=?,HORA_FIN=?, ASISTENTES=?,CANCELADO=?,IDIOMA=?,OBSERVACIONES=?,NOMBAPECONTACTO=?,EMAILCONTACTO=?,TELCONTACTO=?,OBSERVASOLICITANTE=?, NUMMUJERES=?, NUMHOMBRES=?, BLOQUEADA=?, MOTIVO_CANC=? WHERE ID_SOL=?";
		Object getFormacionIdForAux = null;
		if (solicitud.getFormacion() != null
				&& solicitud.getFormacion().getIdFor() != null) {
			getFormacionIdForAux = solicitud.getFormacion().getIdFor();
		}
		Object getEntidadEntidadIdAux = null;
		if (solicitud.getEntidad() != null
				&& solicitud.getEntidad().getEntidadId() != null) {
			getEntidadEntidadIdAux = solicitud.getEntidad().getEntidadId();
		}
		this.jdbcTemplate.update(query, getFormacionIdForAux,
				getEntidadEntidadIdAux, solicitud.getGrupo(),
				solicitud.getParticipantes(), solicitud.getProvincia(),
				solicitud.getDiaImparticion(), solicitud.getHoraInicio(),
				solicitud.getHoraFin(), solicitud.getAsistentes(),
				solicitud.getCancelado(), solicitud.getIdioma(),
				solicitud.getObservaciones(), solicitud.getNombapecontacto(),
				solicitud.getEmailcontacto(), solicitud.getTelcontacto(),
				solicitud.getObservasolicitante(), solicitud.getNumMujeres(),
				solicitud.getNumHombres(), solicitud.getBloqueada(),
				solicitud.getIdMotivo(), solicitud.getIdSol());
		return solicitud;
	}

	/**
	 * Finds a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Pagination
	 * @return Solicitud
	 */
	@Transactional(readOnly = true)
	public Solicitud find(Solicitud solicitud) {
		String query = "SELECT t1.ID_SOL IDSOL, t1.FECHA_SOL FECHASOL, t1.GRUPO GRUPO, t1.PARTICIPANTES PARTICIPANTES, t1.PROVINCIA PROVINCIA, t1.DIA_IMPARTICION DIAIMPARTICION, t1.HORA_INICIO HORAINICIO, t1.HORA_FIN HORAFIN, t1.ASISTENTES ASISTENTES, t1.CANCELADO CANCELADO, t1.IDIOMA IDIOMA, t2.ID_FOR FORMACIONIDFOR, t2.NOMBRE_ES FORMACIONNOMBREES, t2.NOMBRE_EU FORMACIONNOMBREEU, t2.NOMBRE_CORTO_ES FORMACIONNOMBRECORTOES, t2.NOMBRE_CORTO_EU FORMACIONNOMBRECORTOEU, t2.DESCRIPCION_ES FORMACIONDESCRIPCIONES, t2.DESCRIPCION_EU FORMACIONDESCRIPCIONEU, t2.VISIBLE_WEB FORMACIONVISIBLEWEB, t3.ENTIDAD_ID ENTIDADENTIDADID, t3.NOMBRE_ES ENTIDADNOMBREES, t3.NOMBRE_EU ENTIDADNOMBREEU, t3.ACTIVA ENTIDADACTIVA, t3.ISKONTSUMOGEST ENTIDADISKONTSUMOGEST, t3.ISKONTSUMONET ENTIDADISKONTSUMONET, t3.ISOFERTAFORM ENTIDADISOFERTAFORM, t3.ISCONSULTASWEB ENTIDADISCONSULTASWEB, t3.COD_ORG ENTIDADCODORG, t3.OBSERVACIONES ENTIDADOBSERVACIONES, t3.TELEFONO ENTIDADTELEFONO, t3.FAX ENTIDADFAX, t3.EMAIL ENTIDADEMAIL, t3.URL ENTIDADURL, t3.USUARIO ENTIDADUSUARIO, t3.PASSWORD ENTIDADPASSWORD, t3.ISNACIONAL ENTIDADISNACIONAL, t3.NORA_PAIS_ID ENTIDADNORAPAISID, t3.NOMBRE_PAIS ENTIDADNOMBREPAIS, t3.NORA_PROVINCIA_ID ENTIDADNORAPROVINCIAID, t3.NOMBRE_PROVINCIA ENTIDADNOMBREPROVINCIA, t3.NORA_MUNICIPIO_ID ENTIDADNORAMUNICIPIOID, t3.NOMBRE_MUNICIPIO ENTIDADNOMBREMUNICIPIO, t3.NORA_LOCALIDAD_ID ENTIDADNORALOCALIDADID, t3.NOMBRE_LOCALIDAD ENTIDADNOMBRELOCALIDAD, t3.NORA_CALLE_ID ENTIDADNORACALLEID, t3.NOMBRE_CALLE ENTIDADNOMBRECALLE, t3.NORA_CP_ID ENTIDADNORACPID, t3.NOMBRE_CP ENTIDADNOMBRECP, t3.NORA_PORTAL_ID ENTIDADNORAPORTALID, t3.NOMBRE_PORTAL ENTIDADNOMBREPORTAL, t3.USUULTMOD ENTIDADUSUULTMOD, t3.FECULTMOD ENTIDADFECULTMOD, t3.COMPLE_DIREC ENTIDADCOMPLEDIREC, t3.ORINBDCO ENTIDADORINBDCO, t2.ID_CAT FORMACIONIDCAT "
				+ " ,t1.OBSERVACIONES OBSERVACIONES,t1.NOMBAPECONTACTO NOMBAPECONTACTO,t1.EMAILCONTACTO EMAILCONTACTO,t1.TELCONTACTO TELCONTACTO,t1.OBSERVASOLICITANTE OBSERVASOLICITANTE, t1.NUMMUJERES NUMMUJERES, t1.NUMHOMBRES NUMHOMBRES, t1.BLOQUEADA, t1.MOTIVO_CANC "
				+ "FROM SOLICITUD t1 , FORMACION t2 , ENTIDAD t3  "
				+ "WHERE t1.ID_SOL = ?   AND t1.ID_FOR= t2.ID_FOR(+) AND t1.ENTIDAD_ID= t3.ENTIDAD_ID(+)  ";
		// TODO Judit Introducir los campos FormacionNUMMUJERES Y
		// FormacionNUMHOMBRES
		return (Solicitud) this.jdbcTemplate.queryForObject(query, rwMap,
				solicitud.getIdSol());
	}

	/**
	 * Removes a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Pagination
	 * @return
	 */
	public void remove(Solicitud solicitud) {
		String query = "DELETE  FROM SOLICITUD WHERE ID_SOL=?";
		this.jdbcTemplate.update(query, solicitud.getIdSol());
	}

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Solicitud> findAll(Solicitud solicitud, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ID_FOR= t2.ID_FOR(+) AND t1.ENTIDAD_ID= t3.ENTIDAD_ID(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_SOL IDSOL, t1.FECHA_SOL FECHASOL, t1.GRUPO GRUPO,t1.PARTICIPANTES PARTICIPANTES,t1.PROVINCIA PROVINCIA,t1.DIA_IMPARTICION DIAIMPARTICION,t1.HORA_INICIO HORAINICIO, t1.HORA_FIN HORAFIN,t1.ASISTENTES ASISTENTES,t1.CANCELADO CANCELADO,t1.IDIOMA IDIOMA,t2.ID_FOR FORMACIONIDFOR,t2.NOMBRE_ES FORMACIONNOMBREES,t2.NOMBRE_EU FORMACIONNOMBREEU, t2.NOMBRE_CORTO_ES FORMACIONNOMBRECORTOES, t2.NOMBRE_CORTO_EU FORMACIONNOMBRECORTOEU,t2.DESCRIPCION_ES FORMACIONDESCRIPCIONES,t2.DESCRIPCION_EU FORMACIONDESCRIPCIONEU,t2.VISIBLE_WEB FORMACIONVISIBLEWEB,t3.ENTIDAD_ID ENTIDADENTIDADID,t3.NOMBRE_ES ENTIDADNOMBREES,t3.NOMBRE_EU ENTIDADNOMBREEU,t3.ACTIVA ENTIDADACTIVA,t3.ISKONTSUMOGEST ENTIDADISKONTSUMOGEST,t3.ISKONTSUMONET ENTIDADISKONTSUMONET,t3.ISOFERTAFORM ENTIDADISOFERTAFORM,t3.ISCONSULTASWEB ENTIDADISCONSULTASWEB,t3.COD_ORG ENTIDADCODORG,t3.OBSERVACIONES ENTIDADOBSERVACIONES,t3.TELEFONO ENTIDADTELEFONO,t3.FAX ENTIDADFAX,t3.EMAIL ENTIDADEMAIL,t3.URL ENTIDADURL,t3.USUARIO ENTIDADUSUARIO,t3.PASSWORD ENTIDADPASSWORD,t3.ISNACIONAL ENTIDADISNACIONAL,t3.NORA_PAIS_ID ENTIDADNORAPAISID,t3.NOMBRE_PAIS ENTIDADNOMBREPAIS,t3.NORA_PROVINCIA_ID ENTIDADNORAPROVINCIAID,t3.NOMBRE_PROVINCIA ENTIDADNOMBREPROVINCIA,t3.NORA_MUNICIPIO_ID ENTIDADNORAMUNICIPIOID,t3.NOMBRE_MUNICIPIO ENTIDADNOMBREMUNICIPIO,t3.NORA_LOCALIDAD_ID ENTIDADNORALOCALIDADID,t3.NOMBRE_LOCALIDAD ENTIDADNOMBRELOCALIDAD,t3.NORA_CALLE_ID ENTIDADNORACALLEID,t3.NOMBRE_CALLE ENTIDADNOMBRECALLE,t3.NORA_CP_ID ENTIDADNORACPID,t3.NOMBRE_CP ENTIDADNOMBRECP,t3.NORA_PORTAL_ID ENTIDADNORAPORTALID,t3.NOMBRE_PORTAL ENTIDADNOMBREPORTAL,t3.USUULTMOD ENTIDADUSUULTMOD,t3.FECULTMOD ENTIDADFECULTMOD,t3.COMPLE_DIREC ENTIDADCOMPLEDIREC,t3.ORINBDCO ENTIDADORINBDCO,t2.ID_CAT FORMACIONIDCAT "
						+ " ,t1.OBSERVACIONES OBSERVACIONES, t1.NUMMUJERES NUMMUJERES, t1.NUMHOMBRES NUMHOMBRES  "
						+ "FROM SOLICITUD t1 ,FORMACION t2 ,ENTIDAD t3 ");

		// TODO Judit Introducir los campos FormacionNUMMUJERES Y
		// FormacionNUMHOMBRES

		if (solicitud != null && solicitud.getIdSol() != null) {
			where.append(" AND t1.ID_SOL = ?");
			params.add(solicitud.getIdSol());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getIdFor() != null) {
			where.append(" AND t2.ID_FOR = ?");
			params.add(solicitud.getFormacion().getIdFor());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getCategoria() != null
				&& solicitud.getFormacion().getCategoria().getIdCat() != null) {
			where.append(" AND t2.ID_CAT = ?");
			params.add(solicitud.getFormacion().getCategoria().getIdCat());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(solicitud.getFormacion().getNombreEs());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(solicitud.getFormacion().getNombreEu());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getNombreCortoEs() != null) {
			where.append(" AND t2.NOMBRE_CORTO_ES = ?");
			params.add(solicitud.getFormacion().getNombreCortoEs());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getNombreCortoEu() != null) {
			where.append(" AND t2.NOMBRE_CORTO_EU = ?");
			params.add(solicitud.getFormacion().getNombreCortoEu());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getDescripcionEs() != null) {
			where.append(" AND t2.DESCRIPCION_ES = ?");
			params.add(solicitud.getFormacion().getDescripcionEs());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getDescripcionEu() != null) {
			where.append(" AND t2.DESCRIPCION_EU = ?");
			params.add(solicitud.getFormacion().getDescripcionEu());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getVisibleWeb() != null) {
			where.append(" AND t2.VISIBLE_WEB = ?");
			params.add(solicitud.getFormacion().getVisibleWeb());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getEntidadId() != null) {
			where.append(" AND t3.ENTIDAD_ID = ?");
			params.add(solicitud.getEntidad().getEntidadId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreEs() != null) {
			where.append(" AND t3.NOMBRE_ES = ?");
			params.add(solicitud.getEntidad().getNombreEs());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreEu() != null) {
			where.append(" AND t3.NOMBRE_EU = ?");
			params.add(solicitud.getEntidad().getNombreEu());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getActiva() != null) {
			where.append(" AND t3.ACTIVA = ?");
			params.add(solicitud.getEntidad().getActiva());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getIskontsumogest() != null) {
			where.append(" AND t3.ISKONTSUMOGEST = ?");
			params.add(solicitud.getEntidad().getIskontsumogest());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getIskontsumonet() != null) {
			where.append(" AND t3.ISKONTSUMONET = ?");
			params.add(solicitud.getEntidad().getIskontsumonet());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getIsofertaform() != null) {
			where.append(" AND t3.ISOFERTAFORM = ?");
			params.add(solicitud.getEntidad().getIsofertaform());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getIsconsultasweb() != null) {
			where.append(" AND t3.ISCONSULTASWEB = ?");
			params.add(solicitud.getEntidad().getIsconsultasweb());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getCodOrg() != null) {
			where.append(" AND t3.COD_ORG = ?");
			params.add(solicitud.getEntidad().getCodOrg());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getObservaciones() != null) {
			where.append(" AND t3.OBSERVACIONES = ?");
			params.add(solicitud.getEntidad().getObservaciones());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getTelefono() != null) {
			where.append(" AND t3.TELEFONO = ?");
			params.add(solicitud.getEntidad().getTelefono());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getFax() != null) {
			where.append(" AND t3.FAX = ?");
			params.add(solicitud.getEntidad().getFax());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getEmail() != null) {
			where.append(" AND t3.EMAIL = ?");
			params.add(solicitud.getEntidad().getEmail());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getUrl() != null) {
			where.append(" AND t3.URL = ?");
			params.add(solicitud.getEntidad().getUrl());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getUsuario() != null) {
			where.append(" AND t3.USUARIO = ?");
			params.add(solicitud.getEntidad().getUsuario());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getPassword() != null) {
			where.append(" AND t3.PASSWORD = ?");
			params.add(solicitud.getEntidad().getPassword());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getIsnacional() != null) {
			where.append(" AND t3.ISNACIONAL = ?");
			params.add(solicitud.getEntidad().getIsnacional());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraPaisId() != null) {
			where.append(" AND t3.NORA_PAIS_ID = ?");
			params.add(solicitud.getEntidad().getNoraPaisId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombrePais() != null) {
			where.append(" AND t3.NOMBRE_PAIS = ?");
			params.add(solicitud.getEntidad().getNombrePais());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraProvinciaId() != null) {
			where.append(" AND t3.NORA_PROVINCIA_ID = ?");
			params.add(solicitud.getEntidad().getNoraProvinciaId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreProvincia() != null) {
			where.append(" AND t3.NOMBRE_PROVINCIA = ?");
			params.add(solicitud.getEntidad().getNombreProvincia());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraMunicipioId() != null) {
			where.append(" AND t3.NORA_MUNICIPIO_ID = ?");
			params.add(solicitud.getEntidad().getNoraMunicipioId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreMunicipio() != null) {
			where.append(" AND t3.NOMBRE_MUNICIPIO = ?");
			params.add(solicitud.getEntidad().getNombreMunicipio());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraLocalidadId() != null) {
			where.append(" AND t3.NORA_LOCALIDAD_ID = ?");
			params.add(solicitud.getEntidad().getNoraLocalidadId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreLocalidad() != null) {
			where.append(" AND t3.NOMBRE_LOCALIDAD = ?");
			params.add(solicitud.getEntidad().getNombreLocalidad());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraCalleId() != null) {
			where.append(" AND t3.NORA_CALLE_ID = ?");
			params.add(solicitud.getEntidad().getNoraCalleId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreCalle() != null) {
			where.append(" AND t3.NOMBRE_CALLE = ?");
			params.add(solicitud.getEntidad().getNombreCalle());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraCpId() != null) {
			where.append(" AND t3.NORA_CP_ID = ?");
			params.add(solicitud.getEntidad().getNoraCpId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreCp() != null) {
			where.append(" AND t3.NOMBRE_CP = ?");
			params.add(solicitud.getEntidad().getNombreCp());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraPortalId() != null) {
			where.append(" AND t3.NORA_PORTAL_ID = ?");
			params.add(solicitud.getEntidad().getNoraPortalId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombrePortal() != null) {
			where.append(" AND t3.NOMBRE_PORTAL = ?");
			params.add(solicitud.getEntidad().getNombrePortal());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getUsuultmod() != null) {
			where.append(" AND t3.USUULTMOD = ?");
			params.add(solicitud.getEntidad().getUsuultmod());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getFecultmod() != null) {
			where.append(" AND t3.FECULTMOD = ?");
			params.add(solicitud.getEntidad().getFecultmod());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getCompleDirec() != null) {
			where.append(" AND t3.COMPLE_DIREC = ?");
			params.add(solicitud.getEntidad().getCompleDirec());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getOrinbdco() != null) {
			where.append(" AND t3.ORINBDCO = ?");
			params.add(solicitud.getEntidad().getOrinbdco());
		}
		if (solicitud != null
				&& solicitud.getEntidad() != null
				&& solicitud.getEntidad().getObservacionesEntidad() != null
				&& solicitud.getEntidad().getObservacionesEntidad()
						.getEntidadId() != null) {
			where.append(" AND t3.ENTIDAD_ID = ?");
			params.add(solicitud.getEntidad().getObservacionesEntidad()
					.getEntidadId());
		}
		if (solicitud != null && solicitud.getGrupo() != null) {
			where.append(" AND t1.GRUPO = ?");
			params.add(solicitud.getGrupo());
		}
		if (solicitud != null && solicitud.getParticipantes() != null) {
			where.append(" AND t1.PARTICIPANTES = ?");
			params.add(solicitud.getParticipantes());
		}
		if (solicitud != null && solicitud.getProvincia() != null) {
			where.append(" AND t1.PROVINCIA = ?");
			params.add(solicitud.getProvincia());
		}
		if (solicitud != null && solicitud.getDiaImparticion() != null) {
			where.append(" AND t1.DIA_IMPARTICION = ?");
			params.add(solicitud.getDiaImparticion());
		}
		if (solicitud != null && solicitud.getHoraInicio() != null) {
			where.append(" AND t1.HORA_INICIO = ?");
			params.add(solicitud.getHoraInicio());
		}
		if (solicitud != null && solicitud.getHoraFin() != null) {
			where.append(" AND t1.HORA_FIN = ?");
			params.add(solicitud.getHoraFin());
		}

		// FIXME if (solicitud != null && solicitud.getHorarioImparticion() !=
		// null) {
		// where.append(" AND t1.HORARIO_IMPARTICION = ?");
		// params.add(solicitud.getHorarioImparticion());
		// }
		if (solicitud != null && solicitud.getAsistentes() != null) {
			where.append(" AND t1.ASISTENTES = ?");
			params.add(solicitud.getAsistentes());
		}
		if (solicitud != null && solicitud.getNumMujeres() != null) {
			where.append(" AND t1.NUMMUJERES = ?");
			params.add(solicitud.getNumMujeres());
		}
		if (solicitud != null && solicitud.getNumHombres() != null) {
			where.append(" AND t1.NUMHOMBRES = ?");
			params.add(solicitud.getNumHombres());
		}
		if (solicitud != null && solicitud.getCancelado() != null) {
			where.append(" AND t1.CANCELADO = ?");
			params.add(solicitud.getCancelado());
		}
		if (solicitud != null && solicitud.getIdioma() != null) {
			where.append(" AND t1.IDIOMA = ?");
			params.add(solicitud.getIdioma());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Solicitud>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Solicitud solicitud) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.ID_FOR= t2.ID_FOR(+) and t1.ENTIDAD_ID= t3.ENTIDAD_ID(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  SOLICITUD t1   ,  FORMACION t2   ,  ENTIDAD t3  ");
		if (solicitud != null && solicitud.getIdSol() != null) {
			where.append(" AND t1.ID_SOL = ?");
			params.add(solicitud.getIdSol());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getIdFor() != null) {
			where.append(" AND t2.ID_FOR = ?");
			params.add(solicitud.getFormacion().getIdFor());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getCategoria() != null
				&& solicitud.getFormacion().getCategoria().getIdCat() != null) {
			where.append(" AND t2.ID_CAT = ?");
			params.add(solicitud.getFormacion().getCategoria().getIdCat());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(solicitud.getFormacion().getNombreEs());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(solicitud.getFormacion().getNombreEu());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getNombreCortoEs() != null) {
			where.append(" AND t2.NOMBRE_CORTO_ES = ?");
			params.add(solicitud.getFormacion().getNombreCortoEs());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getNombreCortoEu() != null) {
			where.append(" AND t2.NOMBRE_CORTO_EU = ?");
			params.add(solicitud.getFormacion().getNombreCortoEu());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getDescripcionEs() != null) {
			where.append(" AND t2.DESCRIPCION_ES = ?");
			params.add(solicitud.getFormacion().getDescripcionEs());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getDescripcionEu() != null) {
			where.append(" AND t2.DESCRIPCION_EU = ?");
			params.add(solicitud.getFormacion().getDescripcionEu());
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getVisibleWeb() != null) {
			where.append(" AND t2.VISIBLE_WEB = ?");
			params.add(solicitud.getFormacion().getVisibleWeb());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getEntidadId() != null) {
			where.append(" AND t3.ENTIDAD_ID = ?");
			params.add(solicitud.getEntidad().getEntidadId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreEs() != null) {
			where.append(" AND t3.NOMBRE_ES = ?");
			params.add(solicitud.getEntidad().getNombreEs());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreEu() != null) {
			where.append(" AND t3.NOMBRE_EU = ?");
			params.add(solicitud.getEntidad().getNombreEu());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getActiva() != null) {
			where.append(" AND t3.ACTIVA = ?");
			params.add(solicitud.getEntidad().getActiva());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getIskontsumogest() != null) {
			where.append(" AND t3.ISKONTSUMOGEST = ?");
			params.add(solicitud.getEntidad().getIskontsumogest());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getIskontsumonet() != null) {
			where.append(" AND t3.ISKONTSUMONET = ?");
			params.add(solicitud.getEntidad().getIskontsumonet());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getIsofertaform() != null) {
			where.append(" AND t3.ISOFERTAFORM = ?");
			params.add(solicitud.getEntidad().getIsofertaform());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getIsconsultasweb() != null) {
			where.append(" AND t3.ISCONSULTASWEB = ?");
			params.add(solicitud.getEntidad().getIsconsultasweb());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getCodOrg() != null) {
			where.append(" AND t3.COD_ORG = ?");
			params.add(solicitud.getEntidad().getCodOrg());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getObservaciones() != null) {
			where.append(" AND t3.OBSERVACIONES = ?");
			params.add(solicitud.getEntidad().getObservaciones());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getTelefono() != null) {
			where.append(" AND t3.TELEFONO = ?");
			params.add(solicitud.getEntidad().getTelefono());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getFax() != null) {
			where.append(" AND t3.FAX = ?");
			params.add(solicitud.getEntidad().getFax());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getEmail() != null) {
			where.append(" AND t3.EMAIL = ?");
			params.add(solicitud.getEntidad().getEmail());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getUrl() != null) {
			where.append(" AND t3.URL = ?");
			params.add(solicitud.getEntidad().getUrl());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getUsuario() != null) {
			where.append(" AND t3.USUARIO = ?");
			params.add(solicitud.getEntidad().getUsuario());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getPassword() != null) {
			where.append(" AND t3.PASSWORD = ?");
			params.add(solicitud.getEntidad().getPassword());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getIsnacional() != null) {
			where.append(" AND t3.ISNACIONAL = ?");
			params.add(solicitud.getEntidad().getIsnacional());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraPaisId() != null) {
			where.append(" AND t3.NORA_PAIS_ID = ?");
			params.add(solicitud.getEntidad().getNoraPaisId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombrePais() != null) {
			where.append(" AND t3.NOMBRE_PAIS = ?");
			params.add(solicitud.getEntidad().getNombrePais());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraProvinciaId() != null) {
			where.append(" AND t3.NORA_PROVINCIA_ID = ?");
			params.add(solicitud.getEntidad().getNoraProvinciaId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreProvincia() != null) {
			where.append(" AND t3.NOMBRE_PROVINCIA = ?");
			params.add(solicitud.getEntidad().getNombreProvincia());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraMunicipioId() != null) {
			where.append(" AND t3.NORA_MUNICIPIO_ID = ?");
			params.add(solicitud.getEntidad().getNoraMunicipioId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreMunicipio() != null) {
			where.append(" AND t3.NOMBRE_MUNICIPIO = ?");
			params.add(solicitud.getEntidad().getNombreMunicipio());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraLocalidadId() != null) {
			where.append(" AND t3.NORA_LOCALIDAD_ID = ?");
			params.add(solicitud.getEntidad().getNoraLocalidadId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreLocalidad() != null) {
			where.append(" AND t3.NOMBRE_LOCALIDAD = ?");
			params.add(solicitud.getEntidad().getNombreLocalidad());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraCalleId() != null) {
			where.append(" AND t3.NORA_CALLE_ID = ?");
			params.add(solicitud.getEntidad().getNoraCalleId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreCalle() != null) {
			where.append(" AND t3.NOMBRE_CALLE = ?");
			params.add(solicitud.getEntidad().getNombreCalle());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraCpId() != null) {
			where.append(" AND t3.NORA_CP_ID = ?");
			params.add(solicitud.getEntidad().getNoraCpId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreCp() != null) {
			where.append(" AND t3.NOMBRE_CP = ?");
			params.add(solicitud.getEntidad().getNombreCp());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraPortalId() != null) {
			where.append(" AND t3.NORA_PORTAL_ID = ?");
			params.add(solicitud.getEntidad().getNoraPortalId());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombrePortal() != null) {
			where.append(" AND t3.NOMBRE_PORTAL = ?");
			params.add(solicitud.getEntidad().getNombrePortal());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getUsuultmod() != null) {
			where.append(" AND t3.USUULTMOD = ?");
			params.add(solicitud.getEntidad().getUsuultmod());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getFecultmod() != null) {
			where.append(" AND t3.FECULTMOD = ?");
			params.add(solicitud.getEntidad().getFecultmod());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getCompleDirec() != null) {
			where.append(" AND t3.COMPLE_DIREC = ?");
			params.add(solicitud.getEntidad().getCompleDirec());
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getOrinbdco() != null) {
			where.append(" AND t3.ORINBDCO = ?");
			params.add(solicitud.getEntidad().getOrinbdco());
		}
		if (solicitud != null
				&& solicitud.getEntidad() != null
				&& solicitud.getEntidad().getObservacionesEntidad() != null
				&& solicitud.getEntidad().getObservacionesEntidad()
						.getEntidadId() != null) {
			where.append(" AND t3.ENTIDAD_ID = ?");
			params.add(solicitud.getEntidad().getObservacionesEntidad()
					.getEntidadId());
		}
		if (solicitud != null && solicitud.getGrupo() != null) {
			where.append(" AND t1.GRUPO = ?");
			params.add(solicitud.getGrupo());
		}
		if (solicitud != null && solicitud.getParticipantes() != null) {
			where.append(" AND t1.PARTICIPANTES = ?");
			params.add(solicitud.getParticipantes());
		}
		if (solicitud != null && solicitud.getProvincia() != null) {
			where.append(" AND t1.PROVINCIA = ?");
			params.add(solicitud.getProvincia());
		}
		if (solicitud != null && solicitud.getDiaImparticion() != null) {
			where.append(" AND t1.DIA_IMPARTICION = ?");
			params.add(solicitud.getDiaImparticion());
		}
		if (solicitud != null && solicitud.getHoraInicio() != null) {
			where.append(" AND t1.HORA_INICIO = ?");
			params.add(solicitud.getHoraInicio());
		}
		if (solicitud != null && solicitud.getHoraFin() != null) {
			where.append(" AND t1.HORA_FIN = ?");
			params.add(solicitud.getHoraFin());
		}

		// FIXME if (solicitud != null && solicitud.getHorarioImparticion() !=
		// null) {
		// where.append(" AND t1.HORARIO_IMPARTICION = ?");
		// params.add(solicitud.getHorarioImparticion());
		// }
		if (solicitud != null && solicitud.getAsistentes() != null) {
			where.append(" AND t1.ASISTENTES = ?");
			params.add(solicitud.getAsistentes());
		}
		if (solicitud != null && solicitud.getNumMujeres() != null) {
			where.append(" AND t1.NUMMUJERES = ?");
			params.add(solicitud.getNumMujeres());
		}
		if (solicitud != null && solicitud.getNumHombres() != null) {
			where.append(" AND t1.NUMHOMBRES = ?");
			params.add(solicitud.getNumHombres());
		}
		if (solicitud != null && solicitud.getCancelado() != null) {
			where.append(" AND t1.CANCELADO = ?");
			params.add(solicitud.getCancelado());
		}
		if (solicitud != null && solicitud.getIdioma() != null) {
			where.append(" AND t1.IDIOMA = ?");
			params.add(solicitud.getIdioma());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param y40aCategoriaTree
	 *            Y40aCategoriaTree
	 * @param idEntidad
	 *            String
	 * @param idFormacion
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long countSolicitudesEntidad(Y40aCategoriaTree y40aCategoriaTree,
			String idEntidad, String idFormacion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  AND t1.ID_FOR= t2.ID_FOR AND t2.ID_CAT= t3.ID_CAT ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM SOLICITUD t1, FORMACION t2, CATEGORIA t3 ");

		where.append(" AND t1.ENTIDAD_ID =  ?");
		params.add(idEntidad);

		where.append(" AND t3.ID_CAT = ?");
		params.add(y40aCategoriaTree.getIdCat());

		if (idFormacion != null) {
			where.append(" AND t2.ID_FOR= ?");
			params.add(idFormacion);
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlanificacionSolicitanteBusqueda> findAllPlanificacionSolicitante(
			PlanificacionSolicitanteBusqueda planificacionSolicitanteBusqueda,
			Vector<String> perfiles, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(" WHERE 1=1 AND t1.ID_FOR= t2.ID_FOR(+) AND t1.ENTIDAD_ID= t3.ENTIDAD_ID(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t3.ENTIDAD_ID ENTIDADENTIDADID,t3.NOMBRE_ES ENTIDADNOMBREES,t3.NOMBRE_EU ENTIDADNOMBREEU,t3.NORA_MUNICIPIO_ID ENTIDADNORAMUNICIPIOID,t3.NOMBRE_MUNICIPIO ENTIDADNOMBREMUNICIPIO, COUNT(*) NUMFORMACIONES, COUNT(DIA_IMPARTICION) ACEPTADAS, MAX(FECHA_SOL) FECHA_SOLICITUD, MAX(DIA_IMPARTICION) MAX_IMPARTICION, MIN(DIA_IMPARTICION) MIN_IMPARTICION "
						+ ",t3.TELEFONO TELEENTIDAD, t3.EMAIL EMAILENTIDAD "
						+ "FROM SOLICITUD t1, FORMACION t2 , ENTIDAD t3 ");

		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getIdCat() != null) {
			where.append(" AND ( ");

			boolean firstElement = true;

			for (Categoria e : planificacionSolicitanteBusqueda.getCategorias()) {
				if (firstElement) {
					where.append("t2.ID_CAT = '").append(e.getIdCat())
							.append("'");
					firstElement = false;
				} else {
					where.append(" OR t2.ID_CAT = '").append(e.getIdCat())
							.append("'");
				}
			}

			where.append(") ");
		} else {
			if (perfiles != null && perfiles.size() > 0) {
				where.append(" AND t2.ID_CAT IN ( ");
				where.append(" SELECT  distinct tt1.ID_CAT IDCAT FROM CATEGORIA tt1, CATEGORIA_PERFIL tt2 WHERE 1=1 AND tt1.ID_CAT = tt2.ID_CAT(+) AND tt2.ID_PERFIL IN ( ");

				boolean firstElement = true;
				for (String idPerfilAux : perfiles) {

					if (firstElement) {

						where.append("?");
						params.add(idPerfilAux);
						firstElement = false;

					} else {

						where.append(",?");
						params.add(idPerfilAux);
					}
				}

				where.append(") ) ");
			}
		}

		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getEntidadId() != null) {
			where.append(" AND t3.ENTIDAD_ID= ?");
			params.add(planificacionSolicitanteBusqueda.getEntidadId());
		}

		/*
		 * Colección de etiquetas a las que pueden pertenecer las formaciones
		 */
		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getEtiquetas() != null
				&& planificacionSolicitanteBusqueda.getEtiquetas().size() > 0) {

			if (planificacionSolicitanteBusqueda.getRadioEtiquetas()
					.equalsIgnoreCase("T")) {
				for (Etiqueta e : planificacionSolicitanteBusqueda
						.getEtiquetas()) {
					where.append(" AND t1.ID_SOL IN (SELECT ID_SOL FROM SOLICITUD_ETIQUETA WHERE ");
					where.append(" ID_ETIQUETA = ?) ");
					params.add(e.getIdEtiqueta());
				}
			} else {
				where.append(" AND t1.ID_SOL IN (SELECT ID_SOL FROM SOLICITUD_ETIQUETA WHERE ");
				boolean firstElement = true;

				for (Etiqueta e : planificacionSolicitanteBusqueda
						.getEtiquetas()) {

					if (firstElement) {

						where.append("ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {
						where.append(" OR ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}

				where.append(") ");
			}
		}

		// if (planificacionSolicitanteBusqueda != null
		// && planificacionSolicitanteBusqueda.getSinPlanificarTodas() == null)
		// {

		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getSinPlanificar() != null
				|| ((planificacionSolicitanteBusqueda.getSinPlanificarTodas() != null && planificacionSolicitanteBusqueda
						.getPlanificados() != null))) {
			// where.append(" AND (DIA_IMPARTICION IS NULL ");

			if (planificacionSolicitanteBusqueda != null
					&& planificacionSolicitanteBusqueda.getPlanificados() != null) {
				// where.append(" OR (DIA_IMPARTICION IS NOT NULL ");

				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" AND DIA_IMPARTICION >= ?");
					params.add(planificacionSolicitanteBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionHasta() != null) {
					where.append(" AND DIA_IMPARTICION <= ?");
					params.add(planificacionSolicitanteBusqueda
							.getFechaImparticionHasta());
				}
				// where.append(" ) ");
			} else {

				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" OR ( ").append(" DIA_IMPARTICION >= ?");
					params.add(planificacionSolicitanteBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionHasta() != null) {
					if (planificacionSolicitanteBusqueda != null
							&& planificacionSolicitanteBusqueda
									.getFechaImparticionDesde() != null) {
						where.append(" AND DIA_IMPARTICION <= ? )");
						params.add(planificacionSolicitanteBusqueda
								.getFechaImparticionHasta());
					} else {
						where.append(" OR ( ").append(" DIA_IMPARTICION <= ?)");
						params.add(planificacionSolicitanteBusqueda
								.getFechaImparticionHasta());
					}
				} else {
					if (planificacionSolicitanteBusqueda != null
							&& planificacionSolicitanteBusqueda
									.getFechaImparticionDesde() != null) {
						where.append(" ) ");
					}
				}
			}
			// where.append(" ) ");
		} else {
			if (planificacionSolicitanteBusqueda != null
					&& planificacionSolicitanteBusqueda.getPlanificados() != null) {
				// where.append(" AND (DIA_IMPARTICION IS NOT NULL ");

				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" AND DIA_IMPARTICION >= ?");
					params.add(planificacionSolicitanteBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionHasta() != null) {
					where.append(" AND DIA_IMPARTICION <= ?");
					params.add(planificacionSolicitanteBusqueda
							.getFechaImparticionHasta());
				}
				// where.append(" ) ");
			} else {
				where.append(" AND (1=1 ");

				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" AND DIA_IMPARTICION >= ?");
					params.add(planificacionSolicitanteBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionHasta() != null) {
					where.append(" AND DIA_IMPARTICION <= ?");
					params.add(planificacionSolicitanteBusqueda
							.getFechaImparticionHasta());
				}
				where.append(" ) ");
			}
		}
		// }
		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getFechaSolicitudDesde() != null) {
			where.append(" AND FECHA_SOL >= ?");
			params.add(planificacionSolicitanteBusqueda
					.getFechaSolicitudDesde());
		}
		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getFechaSolicitudHasta() != null) {
			where.append(" AND FECHA_SOL <= ?");
			params.add(planificacionSolicitanteBusqueda
					.getFechaSolicitudHasta());
		}

		where.append(" GROUP BY t3.ENTIDAD_ID,t3.NOMBRE_ES,t3.NOMBRE_EU,t3.NORA_MUNICIPIO_ID,t3.NOMBRE_MUNICIPIO ");
		where.append(" ,t3.TELEFONO,t3.EMAIL ");

		// ññññññññññññññññññññññññññññññññññ

		// opcion clickada 1 - solo solicitudes con todas no planificadas
		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getSinPlanificarTodas() != null
				&& planificacionSolicitanteBusqueda.getSinPlanificar() == null
				&& planificacionSolicitanteBusqueda.getPlanificados() == null) {
			where.append(" HAVING ( COUNT(DIA_IMPARTICION) = 0 ) ");
		}

		// opcion clickada 2 - algunas no planificadas ññññ
		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getSinPlanificarTodas() == null
				&& planificacionSolicitanteBusqueda.getSinPlanificar() != null
				&& planificacionSolicitanteBusqueda.getPlanificados() == null) {
			where.append(" HAVING ((COUNT(*) - COUNT(DIA_IMPARTICION)) > 0 ) ");

		}

		// opcion clickada 3 - algunas planificadas
		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getSinPlanificarTodas() == null
				&& planificacionSolicitanteBusqueda.getSinPlanificar() == null
				&& planificacionSolicitanteBusqueda.getPlanificados() != null) {
			where.append(" HAVING (COUNT(DIA_IMPARTICION) > 0 ) ");
		}

		// opcion clickada 2y3 - algunas solicitudes sin planificar y algunas
		// planificadas
		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getSinPlanificarTodas() == null
				&& planificacionSolicitanteBusqueda.getSinPlanificar() != null
				&& planificacionSolicitanteBusqueda.getPlanificados() != null) {
			where.append(" HAVING ( COUNT(DIA_IMPARTICION) > 0  OR COUNT(DIA_IMPARTICION) = 0 )");
		}

		// opcion clickada 1y3 sin having

		// opcion clickada 1y2 - todas sin planificar y algunas sin planificar
		// planificadas
		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getSinPlanificarTodas() != null
				&& planificacionSolicitanteBusqueda.getSinPlanificar() != null
				&& planificacionSolicitanteBusqueda.getPlanificados() == null) {
			where.append(" HAVING (((COUNT(*) - COUNT(DIA_IMPARTICION)) > 0 ) OR (COUNT(DIA_IMPARTICION) = 0)) ");

		}

		// opcion clickada 1y2y3 sin having

		// ñññññññññññññññññññññññññññññññññññññññññññññññ

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<PlanificacionSolicitanteBusqueda>) this.jdbcTemplate
				.query(query.toString(),
						new RowMapper<PlanificacionSolicitanteBusqueda>() {
							public PlanificacionSolicitanteBusqueda mapRow(
									ResultSet resultSet, int rowNum)
									throws SQLException {

								return new PlanificacionSolicitanteBusqueda(
										null,
										null,
										null,
										resultSet.getString("ENTIDADENTIDADID"),
										resultSet.getString("ENTIDADNOMBREES"),
										resultSet.getString("ENTIDADNOMBREEU"),
										resultSet
												.getString("ENTIDADNORAMUNICIPIOID"),
										resultSet
												.getString("ENTIDADNOMBREMUNICIPIO"),
										resultSet.getString("NUMFORMACIONES"),
										resultSet.getString("ACEPTADAS"),
										resultSet.getDate("FECHA_SOLICITUD"),
										null, resultSet
												.getDate("MIN_IMPARTICION"),
										resultSet.getDate("MAX_IMPARTICION"),
										resultSet.getString("TELEENTIDAD"),
										resultSet.getString("EMAILENTIDAD"),
										null, null, null);
							}
						}, params.toArray());
	}

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllPlanificacionSolicitanteCount(
			PlanificacionSolicitanteBusqueda planificacionSolicitanteBusqueda,
			Vector<String> perfiles) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.ID_FOR= t2.ID_FOR(+) and t1.ENTIDAD_ID= t3.ENTIDAD_ID(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM ( SELECT t3.ENTIDAD_ID ENTIDADENTIDADID,t3.NOMBRE_ES ENTIDADNOMBREES,t3.NOMBRE_EU ENTIDADNOMBREEU,t3.NORA_MUNICIPIO_ID ENTIDADNORAMUNICIPIOID,t3.NOMBRE_MUNICIPIO ENTIDADNOMBREMUNICIPIO, COUNT(*) NUMFORMACIONES, COUNT(DIA_IMPARTICION) ACEPTADAS, MAX(FECHA_SOL) FECHA_SOLICITUD, MAX(DIA_IMPARTICION) MAX_IMPARTICION, MIN(DIA_IMPARTICION) MIN_IMPARTICION "
						+ "FROM SOLICITUD t1, FORMACION t2 , ENTIDAD t3 ");

		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getIdCat() != null) {
			where.append(" AND ( ");

			boolean firstElement = true;

			for (Categoria e : planificacionSolicitanteBusqueda.getCategorias()) {
				if (firstElement) {
					where.append("t2.ID_CAT = '").append(e.getIdCat())
							.append("'");
					firstElement = false;
				} else {
					where.append(" OR t2.ID_CAT = '").append(e.getIdCat())
							.append("'");
				}
			}

			where.append(") ");
		} else {
			if (perfiles != null && perfiles.size() > 0) {
				where.append(" AND t2.ID_CAT IN ( ");
				where.append(" SELECT  distinct tt1.ID_CAT IDCAT FROM CATEGORIA tt1, CATEGORIA_PERFIL tt2 WHERE 1=1 AND tt1.ID_CAT = tt2.ID_CAT(+) AND tt2.ID_PERFIL IN ( ");

				boolean firstElement = true;
				for (String idPerfilAux : perfiles) {

					if (firstElement) {

						where.append("?");
						params.add(idPerfilAux);
						firstElement = false;

					} else {

						where.append(",?");
						params.add(idPerfilAux);
					}
				}

				where.append(") ) ");
			}
		}

		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getEntidadId() != null) {
			where.append(" AND t3.ENTIDAD_ID= ?");
			params.add(planificacionSolicitanteBusqueda.getEntidadId());
		}

		/*
		 * Colección de etiquetas a las que pueden pertenecer las formaciones
		 */
		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getEtiquetas() != null
				&& planificacionSolicitanteBusqueda.getEtiquetas().size() > 0) {

			if (planificacionSolicitanteBusqueda.getRadioEtiquetas()
					.equalsIgnoreCase("T")) {
				for (Etiqueta e : planificacionSolicitanteBusqueda
						.getEtiquetas()) {
					where.append(" AND t1.ID_SOL IN (SELECT ID_SOL FROM SOLICITUD_ETIQUETA WHERE ");
					where.append(" ID_ETIQUETA = ?) ");
					params.add(e.getIdEtiqueta());
				}
			} else {
				where.append(" AND t1.ID_SOL IN (SELECT ID_SOL FROM SOLICITUD_ETIQUETA WHERE ");
				boolean firstElement = true;

				for (Etiqueta e : planificacionSolicitanteBusqueda
						.getEtiquetas()) {

					if (firstElement) {

						where.append("ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {
						where.append(" OR ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}

				}

				where.append(") ");
			}

		}

		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getSinPlanificar() != null
				|| ((planificacionSolicitanteBusqueda.getSinPlanificarTodas() != null && planificacionSolicitanteBusqueda
						.getPlanificados() != null))) {
			where.append(" AND (DIA_IMPARTICION IS NULL ");

			if (planificacionSolicitanteBusqueda != null
					&& planificacionSolicitanteBusqueda.getPlanificados() != null) {
				where.append(" OR (DIA_IMPARTICION IS NOT NULL ");

				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" AND DIA_IMPARTICION >= ?");
					params.add(planificacionSolicitanteBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionHasta() != null) {
					where.append(" AND DIA_IMPARTICION <= ?");
					params.add(planificacionSolicitanteBusqueda
							.getFechaImparticionHasta());
				}
				where.append(" ) ");
			} else {

				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" OR ( ").append(" DIA_IMPARTICION >= ?");
					params.add(planificacionSolicitanteBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionHasta() != null) {
					if (planificacionSolicitanteBusqueda != null
							&& planificacionSolicitanteBusqueda
									.getFechaImparticionDesde() != null) {
						where.append(" AND DIA_IMPARTICION <= ? )");
						params.add(planificacionSolicitanteBusqueda
								.getFechaImparticionHasta());
					} else {
						where.append(" OR ( ").append(" DIA_IMPARTICION <= ?)");
						params.add(planificacionSolicitanteBusqueda
								.getFechaImparticionHasta());
					}
				} else {
					if (planificacionSolicitanteBusqueda != null
							&& planificacionSolicitanteBusqueda
									.getFechaImparticionDesde() != null) {
						where.append(" ) ");
					}
				}
			}
			where.append(" ) ");
		} else {
			if (planificacionSolicitanteBusqueda != null
					&& planificacionSolicitanteBusqueda.getPlanificados() != null) {
				where.append(" AND (DIA_IMPARTICION IS NOT NULL ");

				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" AND DIA_IMPARTICION >= ?");
					params.add(planificacionSolicitanteBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionHasta() != null) {
					where.append(" AND DIA_IMPARTICION <= ?");
					params.add(planificacionSolicitanteBusqueda
							.getFechaImparticionHasta());
				}
				where.append(" ) ");
			} else {
				where.append(" AND (1=1 ");

				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" AND DIA_IMPARTICION >= ?");
					params.add(planificacionSolicitanteBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionSolicitanteBusqueda != null
						&& planificacionSolicitanteBusqueda
								.getFechaImparticionHasta() != null) {
					where.append(" AND DIA_IMPARTICION <= ?");
					params.add(planificacionSolicitanteBusqueda
							.getFechaImparticionHasta());
				}
				where.append(" ) ");
			}
		}

		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getFechaSolicitudDesde() != null) {
			where.append(" AND FECHA_SOL >= ?");
			params.add(planificacionSolicitanteBusqueda
					.getFechaSolicitudDesde());
		}
		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getFechaSolicitudHasta() != null) {
			where.append(" AND FECHA_SOL <= ?");
			params.add(planificacionSolicitanteBusqueda
					.getFechaSolicitudHasta());
		}

		where.append(" GROUP BY t3.ENTIDAD_ID,t3.NOMBRE_ES,t3.NOMBRE_EU,t3.NORA_MUNICIPIO_ID,t3.NOMBRE_MUNICIPIO ");

		// opcion clickada 1 - solo solicitudes con todas no planificadas
		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getSinPlanificarTodas() != null
				&& planificacionSolicitanteBusqueda.getSinPlanificar() == null
				&& planificacionSolicitanteBusqueda.getPlanificados() == null) {
			where.append(" HAVING ( COUNT(DIA_IMPARTICION) = 0 ) ");
		}

		// opcion clickada 2 - algunas no planificadas ññññ
		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getSinPlanificarTodas() == null
				&& planificacionSolicitanteBusqueda.getSinPlanificar() != null
				&& planificacionSolicitanteBusqueda.getPlanificados() == null) {
			where.append(" HAVING ((COUNT(*) - COUNT(DIA_IMPARTICION)) > 0 ) ");

		}

		// opcion clickada 3 - algunas planificadas
		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getSinPlanificarTodas() == null
				&& planificacionSolicitanteBusqueda.getSinPlanificar() == null
				&& planificacionSolicitanteBusqueda.getPlanificados() != null) {
			where.append(" HAVING (COUNT(DIA_IMPARTICION) > 0 ) ");
		}

		// opcion clickada 2y3 - algunas solicitudes sin planificar y algunas
		// planificadas
		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getSinPlanificarTodas() == null
				&& planificacionSolicitanteBusqueda.getSinPlanificar() != null
				&& planificacionSolicitanteBusqueda.getPlanificados() != null) {
			where.append(" HAVING ( COUNT(DIA_IMPARTICION) > 0  OR COUNT(DIA_IMPARTICION) = 0 )");
		}

		// opcion clickada 1y3 sin having

		// opcion clickada 1y2 - todas sin planificar y algunas sin planificar
		// planificadas
		if (planificacionSolicitanteBusqueda != null
				&& planificacionSolicitanteBusqueda.getSinPlanificarTodas() != null
				&& planificacionSolicitanteBusqueda.getSinPlanificar() != null
				&& planificacionSolicitanteBusqueda.getPlanificados() == null) {
			where.append(" HAVING (((COUNT(*) - COUNT(DIA_IMPARTICION)) > 0 ) OR (COUNT(DIA_IMPARTICION) = 0)) ");
		}

		// opcion clickada 1y2y3 sin having

		where.append(" ) ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param planificacionFormacionBusqueda
	 *            PlanificacionFormacionBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlanificacionFormacionBusqueda> findAllPlanificacionFormacion(
			PlanificacionFormacionBusqueda planificacionFormacionBusqueda,
			Vector<String> perfiles, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(" WHERE 1=1 AND t1.ID_FOR= t2.ID_FOR(+) AND t1.ENTIDAD_ID= t3.ENTIDAD_ID(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT   t1.ID_SOL IDSOL, t1.FECHA_SOL FECHASOL, t2.ID_FOR IDFOR,	t2.NOMBRE_ES NOMBREES,	t2.NOMBRE_EU NOMBREEU, t2.NOMBRE_CORTO_ES FORMACIONNOMBRECORTOES, t2.NOMBRE_CORTO_EU FORMACIONNOMBRECORTOEU, t3.ENTIDAD_ID ENTIDADENTIDADID,t3.NOMBRE_ES ENTIDADNOMBREES,t3.NOMBRE_EU ENTIDADNOMBREEU, t1.GRUPO GRUPO, t1.IDIOMA IDIOMA, t1.PARTICIPANTES PARTICIPANTES, t1.DIA_IMPARTICION DIAIMPARTICION, t1.PROVINCIA PROVINCIA, t1.HORA_INICIO HORAINICIO, t1.HORA_FIN HORAFIN, t1.ASISTENTES ASISTENTES, t1.CANCELADO CANCELADO "
						+ " ,t1.NOMBAPECONTACTO NOMBAPECONTACTO,t1.EMAILCONTACTO EMAILCONTACTO,t1.TELCONTACTO TELCONTACTO,t1.OBSERVASOLICITANTE OBSERVASOLICITANTE "
						+ "  ,t3.TELEFONO TELEENTIDAD, t3.EMAIL EMAILENTIDAD, t3.COMPLE_DIREC COMPLEDIREC, t1.BLOQUEADA "
						+ "FROM SOLICITUD t1, FORMACION t2 , ENTIDAD t3 ");

		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getIdCat() != null) {
			where.append(" AND ( ");

			boolean firstElement = true;

			for (Categoria e : planificacionFormacionBusqueda.getCategorias()) {
				if (firstElement) {
					where.append("t2.ID_CAT = '").append(e.getIdCat())
							.append("'");
					firstElement = false;
				} else {
					where.append(" OR t2.ID_CAT = '").append(e.getIdCat())
							.append("'");
				}
			}

			where.append(") ");
		} else {
			if (perfiles != null && perfiles.size() > 0) {
				where.append(" AND t2.ID_CAT IN ( ");
				where.append(" SELECT  distinct tt1.ID_CAT IDCAT FROM CATEGORIA tt1, CATEGORIA_PERFIL tt2 WHERE 1=1 AND tt1.ID_CAT = tt2.ID_CAT(+) AND tt2.ID_PERFIL IN ( ");

				boolean firstElement = true;
				for (String idPerfilAux : perfiles) {

					if (firstElement) {

						where.append("?");
						params.add(idPerfilAux);
						firstElement = false;

					} else {

						where.append(",?");
						params.add(idPerfilAux);
					}
				}

				where.append(") ) ");
			}
		}

		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getEntidadId() != null
				&& !planificacionFormacionBusqueda.getEntidadId().equals("")) {
			where.append(" AND t3.ENTIDAD_ID= ?");
			params.add(planificacionFormacionBusqueda.getEntidadId());
		}

		/*
		 * Colección de etiquetas a las que pueden pertenecer las formaciones
		 */
		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getEtiquetas() != null
				&& planificacionFormacionBusqueda.getEtiquetas().size() > 0) {

			if (planificacionFormacionBusqueda.getRadioEtiquetas()
					.equalsIgnoreCase("T")) {
				for (Etiqueta e : planificacionFormacionBusqueda.getEtiquetas()) {
					where.append(" AND t1.ID_SOL IN (SELECT ID_SOL FROM SOLICITUD_ETIQUETA WHERE ");
					where.append(" ID_ETIQUETA = ?) ");
					params.add(e.getIdEtiqueta());
				}
			} else {
				where.append(" AND t1.ID_SOL IN (SELECT ID_SOL FROM SOLICITUD_ETIQUETA WHERE ");
				boolean firstElement = true;

				for (Etiqueta e : planificacionFormacionBusqueda.getEtiquetas()) {
					if (firstElement) {
						where.append("ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {
						where.append(" OR ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}
				where.append(") ");
			}
		}

		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getSinPlanificar() != null) {

			where.append(" AND (DIA_IMPARTICION IS NULL ");

			if (planificacionFormacionBusqueda != null
					&& planificacionFormacionBusqueda.getPlanificados() != null) {

				where.append(" OR (DIA_IMPARTICION IS NOT NULL ");

				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getProvinciaImparticion() != null) {
					where.append(" AND PROVINCIA  = ?");
					params.add(planificacionFormacionBusqueda
							.getProvinciaImparticion());
				}

				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" AND DIA_IMPARTICION >= ?");
					params.add(planificacionFormacionBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionHasta() != null) {
					where.append(" AND DIA_IMPARTICION <= ?");
					params.add(planificacionFormacionBusqueda
							.getFechaImparticionHasta());
				}
				where.append(" ) ");

			} else {

				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" OR ( ").append(" DIA_IMPARTICION >= ?");
					params.add(planificacionFormacionBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionHasta() != null) {
					if (planificacionFormacionBusqueda != null
							&& planificacionFormacionBusqueda
									.getFechaImparticionDesde() != null) {
						where.append(" AND DIA_IMPARTICION <= ? )");
						params.add(planificacionFormacionBusqueda
								.getFechaImparticionHasta());
					} else {
						where.append(" OR ( ")
								.append(" DIA_IMPARTICION <= ? )");
						params.add(planificacionFormacionBusqueda
								.getFechaImparticionHasta());

					}
				} else {
					if (planificacionFormacionBusqueda != null
							&& planificacionFormacionBusqueda
									.getFechaImparticionDesde() != null) {
						where.append(" ) ");
					}
				}
			}
			where.append(" ) ");
		} else {
			if (planificacionFormacionBusqueda != null
					&& planificacionFormacionBusqueda.getPlanificados() != null) {

				where.append(" AND (DIA_IMPARTICION IS NOT NULL ");

				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getProvinciaImparticion() != null) {
					where.append(" AND PROVINCIA  = ?");
					params.add(planificacionFormacionBusqueda
							.getProvinciaImparticion());
				}

				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" AND DIA_IMPARTICION >= ?");
					params.add(planificacionFormacionBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionHasta() != null) {
					where.append(" AND DIA_IMPARTICION <= ?");
					params.add(planificacionFormacionBusqueda
							.getFechaImparticionHasta());
				}
				where.append(" ) ");
			} else {
				where.append(" AND (1=1 ");
				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getProvinciaImparticion() != null) {
					where.append(" AND PROVINCIA  = ?");
					params.add(planificacionFormacionBusqueda
							.getProvinciaImparticion());
				}

				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" AND DIA_IMPARTICION >= ?");
					params.add(planificacionFormacionBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionHasta() != null) {
					where.append(" AND DIA_IMPARTICION <= ?");
					params.add(planificacionFormacionBusqueda
							.getFechaImparticionHasta());
				}
				where.append(" ) ");
			}
		}

		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getFechaSolicitudDesde() != null) {
			where.append(" AND FECHA_SOL >= ?");
			params.add(planificacionFormacionBusqueda.getFechaSolicitudDesde());
		}
		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getFechaSolicitudHasta() != null) {
			where.append(" AND FECHA_SOL <= ?");
			params.add(planificacionFormacionBusqueda.getFechaSolicitudHasta());
		}

		// TODO TOCHANGE
		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getBloqueada() == null) {
			where.append(" AND BLOQUEADA  != ?");
			params.add(Y40aConstantes.SI);
		}

		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getCancelado() == null) {
			where.append(" AND CANCELADO  != ?");
			params.add(Y40aConstantes.SI);
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<PlanificacionFormacionBusqueda>) this.jdbcTemplate.query(
				query.toString(),
				new RowMapper<PlanificacionFormacionBusqueda>() {
					public PlanificacionFormacionBusqueda mapRow(
							ResultSet resultSet, int rowNum)
							throws SQLException {
						PlanificacionFormacionBusqueda planificacionFormacionBusqueda = new PlanificacionFormacionBusqueda(
								resultSet.getString("IDSOL"), resultSet
										.getDate("FECHASOL"), resultSet
										.getString("IDFOR"), resultSet
										.getString("NOMBREES"), resultSet
										.getString("NOMBREEU"), resultSet
										.getString("FORMACIONNOMBRECORTOES"),
								resultSet.getString("FORMACIONNOMBRECORTOEU"),
								null, null, null, resultSet
										.getString("ENTIDADENTIDADID"),
								resultSet.getString("ENTIDADNOMBREES"),
								resultSet.getString("ENTIDADNOMBREEU"),
								resultSet.getString("GRUPO"), resultSet
										.getString("IDIOMA"), resultSet
										.getLong("PARTICIPANTES"), resultSet
										.getDate("DIAIMPARTICION"), resultSet
										.getString("PROVINCIA"), resultSet
										.getString("HORAINICIO"), resultSet
										.getString("HORAFIN"), resultSet
										.getLong("ASISTENTES"), resultSet
										.getString("CANCELADO"));
						planificacionFormacionBusqueda
								.setNombapecontacto(resultSet
										.getString("NOMBAPECONTACTO"));
						planificacionFormacionBusqueda
								.setEmailcontacto(resultSet
										.getString("EMAILCONTACTO"));
						planificacionFormacionBusqueda.setTelcontacto(resultSet
								.getString("TELCONTACTO"));
						planificacionFormacionBusqueda
								.setObservasolicitante(resultSet
										.getString("OBSERVASOLICITANTE"));
						planificacionFormacionBusqueda
								.setEmailEntidad(resultSet
										.getString("EMAILENTIDAD"));
						planificacionFormacionBusqueda.setTelEntidad(resultSet
								.getString("TELEENTIDAD"));
						planificacionFormacionBusqueda
								.setCompleDirecEnti(resultSet
										.getString("COMPLEDIREC"));
						planificacionFormacionBusqueda.setBloqueada(resultSet
								.getString("BLOQUEADA"));
						return planificacionFormacionBusqueda;
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param planificacionFormacionBusqueda
	 *            PlanificacionFormacionBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllPlanificacionFormacionCount(
			PlanificacionFormacionBusqueda planificacionFormacionBusqueda,
			Vector<String> perfiles) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(" WHERE 1=1 AND t1.ID_FOR= t2.ID_FOR(+) AND t1.ENTIDAD_ID= t3.ENTIDAD_ID(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT   COUNT(1) FROM SOLICITUD t1, FORMACION t2 , ENTIDAD t3 ");

		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getIdCat() != null) {
			where.append(" AND ( ");

			boolean firstElement = true;

			for (Categoria e : planificacionFormacionBusqueda.getCategorias()) {
				if (firstElement) {
					where.append("t2.ID_CAT = '").append(e.getIdCat())
							.append("'");
					firstElement = false;
				} else {
					where.append(" OR t2.ID_CAT = '").append(e.getIdCat())
							.append("'");
				}
			}

			where.append(") ");
		} else {
			if (perfiles != null && perfiles.size() > 0) {
				where.append(" AND t2.ID_CAT IN ( ");
				where.append(" SELECT  distinct tt1.ID_CAT IDCAT FROM CATEGORIA tt1, CATEGORIA_PERFIL tt2 WHERE 1=1 AND tt1.ID_CAT = tt2.ID_CAT(+) AND tt2.ID_PERFIL IN ( ");

				boolean firstElement = true;
				for (String idPerfilAux : perfiles) {

					if (firstElement) {

						where.append("?");
						params.add(idPerfilAux);
						firstElement = false;

					} else {

						where.append(",?");
						params.add(idPerfilAux);
					}
				}

				where.append(") ) ");
			}
		}

		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getEntidadId() != null) {
			where.append(" AND t3.ENTIDAD_ID= ?");
			params.add(planificacionFormacionBusqueda.getEntidadId());
		}

		/*
		 * Colección de etiquetas a las que pueden pertenecer las formaciones
		 */
		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getEtiquetas() != null
				&& planificacionFormacionBusqueda.getEtiquetas().size() > 0) {

			if (planificacionFormacionBusqueda.getRadioEtiquetas()
					.equalsIgnoreCase("T")) {
				for (Etiqueta e : planificacionFormacionBusqueda.getEtiquetas()) {
					where.append(" AND t1.ID_SOL IN (SELECT ID_SOL FROM SOLICITUD_ETIQUETA WHERE ");
					where.append(" ID_ETIQUETA = ?) ");
					params.add(e.getIdEtiqueta());
				}
			} else {
				where.append(" AND t1.ID_SOL IN (SELECT ID_SOL FROM SOLICITUD_ETIQUETA WHERE ");
				boolean firstElement = true;

				for (Etiqueta e : planificacionFormacionBusqueda.getEtiquetas()) {
					if (firstElement) {
						where.append("ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {
						where.append(" OR ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}
				where.append(") ");
			}
		}

		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getSinPlanificar() != null) {
			where.append(" AND (DIA_IMPARTICION IS NULL ");

			if (planificacionFormacionBusqueda != null
					&& planificacionFormacionBusqueda.getPlanificados() != null) {
				where.append(" OR (DIA_IMPARTICION IS NOT NULL ");
				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getProvinciaImparticion() != null) {
					where.append(" AND PROVINCIA  = ?");
					params.add(planificacionFormacionBusqueda
							.getProvinciaImparticion());
				}

				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" AND DIA_IMPARTICION >= ?");
					params.add(planificacionFormacionBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionHasta() != null) {
					where.append(" AND DIA_IMPARTICION <= ?");
					params.add(planificacionFormacionBusqueda
							.getFechaImparticionHasta());
				}
				where.append(" ) ");
			} else {

				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" OR ( ").append(" DIA_IMPARTICION >= ?");
					params.add(planificacionFormacionBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionHasta() != null) {

					if (planificacionFormacionBusqueda != null
							&& planificacionFormacionBusqueda
									.getFechaImparticionDesde() != null) {
						where.append(" AND DIA_IMPARTICION <= ? )");
						params.add(planificacionFormacionBusqueda
								.getFechaImparticionHasta());
					} else {
						where.append(" OR ( ")
								.append(" DIA_IMPARTICION <= ? )");
						params.add(planificacionFormacionBusqueda
								.getFechaImparticionHasta());

					}
				} else {
					if (planificacionFormacionBusqueda != null
							&& planificacionFormacionBusqueda
									.getFechaImparticionDesde() != null) {
						where.append(" ) ");
					}
				}
			}
			where.append(" ) ");
		} else {
			if (planificacionFormacionBusqueda != null
					&& planificacionFormacionBusqueda.getPlanificados() != null) {
				where.append(" AND (DIA_IMPARTICION IS NOT NULL ");

				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getProvinciaImparticion() != null) {
					where.append(" AND PROVINCIA  = ?");
					params.add(planificacionFormacionBusqueda
							.getProvinciaImparticion());
				}
				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" AND DIA_IMPARTICION >= ?");
					params.add(planificacionFormacionBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionHasta() != null) {
					where.append(" AND DIA_IMPARTICION <= ?");
					params.add(planificacionFormacionBusqueda
							.getFechaImparticionHasta());
				}
				where.append(" ) ");
			} else {
				where.append(" AND (1=1 ");
				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getProvinciaImparticion() != null) {
					where.append(" AND PROVINCIA  = ?");
					params.add(planificacionFormacionBusqueda
							.getProvinciaImparticion());
				}
				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionDesde() != null) {
					where.append(" AND DIA_IMPARTICION >= ?");
					params.add(planificacionFormacionBusqueda
							.getFechaImparticionDesde());
				}
				if (planificacionFormacionBusqueda != null
						&& planificacionFormacionBusqueda
								.getFechaImparticionHasta() != null) {
					where.append(" AND DIA_IMPARTICION <= ?");
					params.add(planificacionFormacionBusqueda
							.getFechaImparticionHasta());
				}
				where.append(" ) ");
			}
		}

		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getFechaSolicitudDesde() != null) {
			where.append(" AND FECHA_SOL >= ?");
			params.add(planificacionFormacionBusqueda.getFechaSolicitudDesde());
		}
		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getFechaSolicitudHasta() != null) {
			where.append(" AND FECHA_SOL <= ?");
			params.add(planificacionFormacionBusqueda.getFechaSolicitudHasta());
		}
		// TODO TOCHANGE
		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getBloqueada() == null) {
			where.append(" AND BLOQUEADA  != ?");
			params.add(Y40aConstantes.SI);
		}

		if (planificacionFormacionBusqueda != null
				&& planificacionFormacionBusqueda.getCancelado() == null) {
			where.append(" AND CANCELADO  != ?");
			params.add(Y40aConstantes.SI);
		}

		// if (planificacionFormacionBusqueda != null
		// && planificacionFormacionBusqueda.getBloqueada() != null) {
		// where.append(" AND BLOQUEADA  = ?");
		// params.add(planificacionFormacionBusqueda.getBloqueada());
		// }
		// if (planificacionFormacionBusqueda != null
		// && planificacionFormacionBusqueda.getProvinciaImparticion() != null)
		// {
		// where.append(" AND PROVINCIA  = ?");
		// params.add(planificacionFormacionBusqueda.getProvinciaImparticion());
		// }

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Solicitud table using like.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Solicitud> findAllLike(Solicitud solicitud,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ID_FOR= t2.ID_FOR(+) AND t1.ENTIDAD_ID= t3.ENTIDAD_ID(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_SOL IDSOL,t1.FECHA_SOL FECHASOL,t1.GRUPO GRUPO,t1.PARTICIPANTES PARTICIPANTES,t1.PROVINCIA PROVINCIA,t1.DIA_IMPARTICION DIAIMPARTICION,t1.HORA_INICIO HORAINICIO, t1.HORA_FIN HORAFIN,t1.ASISTENTES ASISTENTES,t1.CANCELADO CANCELADO,t1.IDIOMA IDIOMA,t2.ID_FOR FORMACIONIDFOR,t2.NOMBRE_ES FORMACIONNOMBREES,t2.NOMBRE_EU FORMACIONNOMBREEU, t2.NOMBRE_CORTO_ES FORMACIONNOMBRECORTOES, t2.NOMBRE_CORTO_EU FORMACIONNOMBRECORTOEU,t2.DESCRIPCION_ES FORMACIONDESCRIPCIONES,t2.DESCRIPCION_EU FORMACIONDESCRIPCIONEU,t2.VISIBLE_WEB FORMACIONVISIBLEWEB,t3.ENTIDAD_ID ENTIDADENTIDADID,t3.NOMBRE_ES ENTIDADNOMBREES,t3.NOMBRE_EU ENTIDADNOMBREEU,t3.ACTIVA ENTIDADACTIVA,t3.ISKONTSUMOGEST ENTIDADISKONTSUMOGEST,t3.ISKONTSUMONET ENTIDADISKONTSUMONET,t3.ISOFERTAFORM ENTIDADISOFERTAFORM,t3.ISCONSULTASWEB ENTIDADISCONSULTASWEB,t3.COD_ORG ENTIDADCODORG,t3.OBSERVACIONES ENTIDADOBSERVACIONES,t3.TELEFONO ENTIDADTELEFONO,t3.FAX ENTIDADFAX,t3.EMAIL ENTIDADEMAIL,t3.URL ENTIDADURL,t3.USUARIO ENTIDADUSUARIO,t3.PASSWORD ENTIDADPASSWORD,t3.ISNACIONAL ENTIDADISNACIONAL,t3.NORA_PAIS_ID ENTIDADNORAPAISID,t3.NOMBRE_PAIS ENTIDADNOMBREPAIS,t3.NORA_PROVINCIA_ID ENTIDADNORAPROVINCIAID,t3.NOMBRE_PROVINCIA ENTIDADNOMBREPROVINCIA,t3.NORA_MUNICIPIO_ID ENTIDADNORAMUNICIPIOID,t3.NOMBRE_MUNICIPIO ENTIDADNOMBREMUNICIPIO,t3.NORA_LOCALIDAD_ID ENTIDADNORALOCALIDADID,t3.NOMBRE_LOCALIDAD ENTIDADNOMBRELOCALIDAD,t3.NORA_CALLE_ID ENTIDADNORACALLEID,t3.NOMBRE_CALLE ENTIDADNOMBRECALLE,t3.NORA_CP_ID ENTIDADNORACPID,t3.NOMBRE_CP ENTIDADNOMBRECP,t3.NORA_PORTAL_ID ENTIDADNORAPORTALID,t3.NOMBRE_PORTAL ENTIDADNOMBREPORTAL,t3.USUULTMOD ENTIDADUSUULTMOD,t3.FECULTMOD ENTIDADFECULTMOD,t3.COMPLE_DIREC ENTIDADCOMPLEDIREC,t3.ORINBDCO ENTIDADORINBDCO,t2.ID_CAT FORMACIONIDCAT "
						+ " ,t1.OBSERVACIONES OBSERVACIONES "
						+ "FROM SOLICITUD t1 ,FORMACION t2 ,ENTIDAD t3 ");

		// TODO Judit Introducir los campos FormacionNUMMUJERES Y
		// FormacionNUMHOMBRES
		if (solicitud != null && solicitud.getIdSol() != null) {
			where.append(" AND UPPER(t1.ID_SOL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getIdSol().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getIdSol().toUpperCase() + "%");
			}
			where.append(" AND t1.ID_SOL IS NOT NULL");
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getIdFor() != null) {
			where.append(" AND t2.ID_FOR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getFormacion().getIdFor() + "%");
			} else {
				params.add("%" + solicitud.getFormacion().getIdFor() + "%");
			}
			where.append(" AND t2.ID_FOR IS NOT NULL");
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getCategoria() != null
				&& solicitud.getFormacion().getCategoria().getIdCat() != null) {
			where.append(" AND UPPER(t2.ID_CAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getFormacion().getCategoria().getIdCat()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getFormacion().getCategoria().getIdCat()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ID_CAT IS NOT NULL");
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getNombreEs() != null) {
			where.append(" AND UPPER(t2.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getFormacion().getNombreEs().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getFormacion().getNombreEs().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.NOMBRE_ES IS NOT NULL");
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getNombreEu() != null) {
			where.append(" AND UPPER(t2.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getFormacion().getNombreEu().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getFormacion().getNombreEu().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.NOMBRE_EU IS NOT NULL");
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getNombreCortoEs() != null) {
			where.append(" AND UPPER(t2.NOMBRE_CORTO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getFormacion().getNombreCortoEs()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getFormacion().getNombreCortoEs()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_CORTO_ES IS NOT NULL");
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getNombreCortoEu() != null) {
			where.append(" AND UPPER(t2.NOMBRE_CORTO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getFormacion().getNombreCortoEu()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getFormacion().getNombreCortoEu()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_CORTO_EU IS NOT NULL");
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getDescripcionEs() != null) {
			where.append(" AND UPPER(t2.DESCRIPCION_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getFormacion().getDescripcionEs()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getFormacion().getDescripcionEs()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.DESCRIPCION_ES IS NOT NULL");
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getDescripcionEu() != null) {
			where.append(" AND UPPER(t2.DESCRIPCION_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getFormacion().getDescripcionEu()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getFormacion().getDescripcionEu()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.DESCRIPCION_EU IS NOT NULL");
		}
		if (solicitud != null && solicitud.getFormacion() != null
				&& solicitud.getFormacion().getVisibleWeb() != null) {
			where.append(" AND UPPER(t2.VISIBLE_WEB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getFormacion().getVisibleWeb()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getFormacion().getVisibleWeb()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.VISIBLE_WEB IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getEntidadId() != null) {
			where.append(" AND t3.ENTIDAD_ID like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getEntidadId() + "%");
			} else {
				params.add("%" + solicitud.getEntidad().getEntidadId() + "%");
			}
			where.append(" AND t3.ENTIDAD_ID IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreEs() != null) {
			where.append(" AND UPPER(t3.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNombreEs().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNombreEs().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.NOMBRE_ES IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreEu() != null) {
			where.append(" AND UPPER(t3.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNombreEu().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNombreEu().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.NOMBRE_EU IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getActiva() != null) {
			where.append(" AND UPPER(t3.ACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getActiva().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getActiva().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACTIVA IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getIskontsumogest() != null) {
			where.append(" AND UPPER(t3.ISKONTSUMOGEST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getIskontsumogest()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getIskontsumogest()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ISKONTSUMOGEST IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getIskontsumonet() != null) {
			where.append(" AND UPPER(t3.ISKONTSUMONET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getIskontsumonet()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getIskontsumonet()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ISKONTSUMONET IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getIsofertaform() != null) {
			where.append(" AND UPPER(t3.ISOFERTAFORM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getIsofertaform()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getIsofertaform()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ISOFERTAFORM IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getIsconsultasweb() != null) {
			where.append(" AND UPPER(t3.ISCONSULTASWEB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getIsconsultasweb()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getIsconsultasweb()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ISCONSULTASWEB IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getCodOrg() != null) {
			where.append(" AND UPPER(t3.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getCodOrg().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getCodOrg().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COD_ORG IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getObservaciones() != null) {
			where.append(" AND UPPER(t3.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getObservaciones()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getObservaciones()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.OBSERVACIONES IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getTelefono() != null) {
			where.append(" AND UPPER(t3.TELEFONO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getTelefono().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getTelefono().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.TELEFONO IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getFax() != null) {
			where.append(" AND UPPER(t3.FAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getFax().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getEntidad().getFax().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.FAX IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getEmail() != null) {
			where.append(" AND UPPER(t3.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getEmail().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getEmail().toUpperCase() + "%");
			}
			where.append(" AND t3.EMAIL IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getUrl() != null) {
			where.append(" AND UPPER(t3.URL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getUrl().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getEntidad().getUrl().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.URL IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getUsuario() != null) {
			where.append(" AND UPPER(t3.USUARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getUsuario().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getUsuario().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.USUARIO IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getPassword() != null) {
			where.append(" AND UPPER(t3.PASSWORD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getPassword().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getPassword().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.PASSWORD IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getIsnacional() != null) {
			where.append(" AND UPPER(t3.ISNACIONAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getIsnacional().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getIsnacional().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ISNACIONAL IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraPaisId() != null) {
			where.append(" AND UPPER(t3.NORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNoraPaisId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNoraPaisId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.NORA_PAIS_ID IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombrePais() != null) {
			where.append(" AND UPPER(t3.NOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNombrePais().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNombrePais().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.NOMBRE_PAIS IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t3.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNoraProvinciaId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNoraProvinciaId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreProvincia() != null) {
			where.append(" AND UPPER(t3.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNombreProvincia()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNombreProvincia()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t3.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNoraMunicipioId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNoraMunicipioId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreMunicipio() != null) {
			where.append(" AND UPPER(t3.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNombreMunicipio()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNombreMunicipio()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t3.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNoraLocalidadId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNoraLocalidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreLocalidad() != null) {
			where.append(" AND UPPER(t3.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNombreLocalidad()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNombreLocalidad()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraCalleId() != null) {
			where.append(" AND UPPER(t3.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNoraCalleId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNoraCalleId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.NORA_CALLE_ID IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreCalle() != null) {
			where.append(" AND UPPER(t3.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNombreCalle()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNombreCalle().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.NOMBRE_CALLE IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraCpId() != null) {
			where.append(" AND UPPER(t3.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNoraCpId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNoraCpId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.NORA_CP_ID IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombreCp() != null) {
			where.append(" AND UPPER(t3.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNombreCp().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNombreCp().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.NOMBRE_CP IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNoraPortalId() != null) {
			where.append(" AND UPPER(t3.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNoraPortalId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNoraPortalId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NORA_PORTAL_ID IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getNombrePortal() != null) {
			where.append(" AND UPPER(t3.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getNombrePortal()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getNombrePortal()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NOMBRE_PORTAL IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getUsuultmod() != null) {
			where.append(" AND UPPER(t3.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getUsuultmod().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getUsuultmod().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.USUULTMOD IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getFecultmod() != null) {
			where.append(" AND t3.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getFecultmod() + "%");
			} else {
				params.add("%" + solicitud.getEntidad().getFecultmod() + "%");
			}
			where.append(" AND t3.FECULTMOD IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getCompleDirec() != null) {
			where.append(" AND UPPER(t3.COMPLE_DIREC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getCompleDirec()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getCompleDirec().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.COMPLE_DIREC IS NOT NULL");
		}
		if (solicitud != null && solicitud.getEntidad() != null
				&& solicitud.getEntidad().getOrinbdco() != null) {
			where.append(" AND UPPER(t3.ORINBDCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getOrinbdco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getOrinbdco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ORINBDCO IS NOT NULL");
		}
		if (solicitud != null
				&& solicitud.getEntidad() != null
				&& solicitud.getEntidad().getObservacionesEntidad() != null
				&& solicitud.getEntidad().getObservacionesEntidad()
						.getEntidadId() != null) {
			where.append(" AND UPPER(t3.ENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getEntidad().getObservacionesEntidad()
						.getEntidadId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ solicitud.getEntidad().getObservacionesEntidad()
								.getEntidadId().toUpperCase() + "%");
			}
			where.append(" AND t3.ENTIDAD_ID IS NOT NULL");
		}
		if (solicitud != null && solicitud.getGrupo() != null) {
			where.append(" AND UPPER(t1.GRUPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getGrupo().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getGrupo().toUpperCase() + "%");
			}
			where.append(" AND t1.GRUPO IS NOT NULL");
		}
		if (solicitud != null && solicitud.getParticipantes() != null) {
			where.append(" AND t1.PARTICIPANTES like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getParticipantes() + "%");
			} else {
				params.add("%" + solicitud.getParticipantes() + "%");
			}
			where.append(" AND t1.PARTICIPANTES IS NOT NULL");
		}
		if (solicitud != null && solicitud.getProvincia() != null) {
			where.append(" AND UPPER(t1.PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getProvincia().toUpperCase() + "%");
			}
			where.append(" AND t1.PROVINCIA IS NOT NULL");
		}
		if (solicitud != null && solicitud.getDiaImparticion() != null) {
			where.append(" AND t1.DIA_IMPARTICION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getDiaImparticion() + "%");
			} else {
				params.add("%" + solicitud.getDiaImparticion() + "%");
			}
			where.append(" AND t1.DIA_IMPARTICION IS NOT NULL");
		}
		if (solicitud.getHoraInicio() != null) {
			where.append(" AND t2.HORA_INICIO = ?");
			params.add(solicitud.getHoraInicio());
		}
		if (solicitud.getHoraFin() != null) {
			where.append(" AND t2.HORA_FIN = ?");
			params.add(solicitud.getHoraFin());
		}

		// XXX
		// if (solicitud != null && solicitud.getHorarioImparticion() != null) {
		// where.append(" AND UPPER(t1.HORARIO_IMPARTICION) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(solicitud.getHorarioImparticion().toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + solicitud.getHorarioImparticion().toUpperCase() + "%");
		// }
		// where.append(" AND t1.HORARIO_IMPARTICION IS NOT NULL");
		// }
		if (solicitud != null && solicitud.getAsistentes() != null) {
			where.append(" AND t1.ASISTENTES like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getAsistentes() + "%");
			} else {
				params.add("%" + solicitud.getAsistentes() + "%");
			}
			where.append(" AND t1.ASISTENTES IS NOT NULL");
		}
		if (solicitud != null && solicitud.getCancelado() != null) {
			where.append(" AND UPPER(t1.CANCELADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getCancelado().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getCancelado().toUpperCase() + "%");
			}
			where.append(" AND t1.CANCELADO IS NOT NULL");
		}
		if (solicitud != null && solicitud.getIdioma() != null) {
			where.append(" AND UPPER(t1.IDIOMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitud.getIdioma().toUpperCase() + "%");
			} else {
				params.add("%" + solicitud.getIdioma().toUpperCase() + "%");
			}
			where.append(" AND t1.IDIOMA IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Solicitud>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Inserts a single row in the SolicitudEtiqueta table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Solicitud
	 */
	public Solicitud addSolicitudEtiqueta(Solicitud solicitud) {
		String query = "INSERT INTO Y40A09T00 " + "( ID_SOL,ID_ETIQUETA) "
				+ " values (?, ?)";

		List<Etiqueta> auxiliarEtiqueta = solicitud.getEtiquetas();
		Iterator<Etiqueta> it = auxiliarEtiqueta.iterator();
		while (it.hasNext()) {
			Etiqueta etiqueta = (Etiqueta) it.next();
			this.jdbcTemplate.update(query, solicitud.getIdSol(),
					etiqueta.getIdEtiqueta());
		}
		return solicitud;
	}

	/**
	 * Deletes a single row in the SolicitudEtiqueta table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return
	 */
	public void removeSolicitudEtiqueta(Solicitud solicitud) {
		String query = "DELETE  FROM Y40A09T00 "
				+ " WHERE ID_SOL=? AND ID_ETIQUETA=?";
		List<Etiqueta> auxiliarEtiqueta = solicitud.getEtiquetas();
		Iterator<Etiqueta> it = auxiliarEtiqueta.iterator();
		while (it.hasNext()) {
			Etiqueta etiqueta = (Etiqueta) it.next();
			this.jdbcTemplate.update(query, solicitud.getIdSol(),
					etiqueta.getIdEtiqueta());
		}
	}

	/**
	 * Deletes a single row in the SolicitudEtiqueta table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return
	 */
	public void removeAllSolicitudEtiqueta(Solicitud solicitud) {
		String query = "DELETE  FROM Y40A09T00 " + " WHERE ID_SOL=? ";
		this.jdbcTemplate.update(query, solicitud.getIdSol());
	}

	/**
	 * Find a single row in the findSolicitudEtiqueta Many To Many relationship.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return Solicitud
	 */
	@Transactional(readOnly = true)
	public Solicitud findSolicitudEtiqueta(Solicitud solicitud,
			Etiqueta etiqueta, Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.ID_ETIQUETA = t2.ID_ETIQUETA AND t1.ID_SOL=?");

		params.add(solicitud.getIdSol());

		if (etiqueta != null && etiqueta.getIdEtiqueta() != null) {
			where.append(" AND t2.ID_ETIQUETA = ?");
			params.add(etiqueta.getIdEtiqueta());
		}
		if (etiqueta != null && etiqueta.getNombre() != null) {
			where.append(" AND t2.NOMBRE = ?");
			params.add(etiqueta.getNombre());
		}

		StringBuffer query = new StringBuffer(
				"SELECT t2.Id_etiqueta idEtiqueta, t2.NOMBRE NOMBRE FROM Y40a09t00 t1,Y40A07T00 t2  ");
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		List<Etiqueta> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Etiqueta>() {
					public Etiqueta mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Etiqueta(resultSet.getString("IDETIQUETA"),
								resultSet.getString("NOMBRE"), null, null);
					}
				}, params.toArray());
		solicitud.setEtiquetas(listaHijo);
		return solicitud;
	}

	/**
	 * Counts rows in the SolicitudEtiqueta table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @param etiqueta
	 *            Etiqueta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findSolicitudEtiquetaCount(Solicitud solicitud,
			Etiqueta etiqueta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.ID_ETIQUETA = t2.ID_ETIQUETA AND t1.ID_SOL=?");

		params.add(solicitud.getIdSol());

		if (etiqueta.getIdEtiqueta() != null) {
			where.append(" AND t2.ID_ETIQUETA = ?");
			params.add(etiqueta.getIdEtiqueta());
		}
		if (etiqueta.getNombre() != null) {
			where.append(" AND t2.NOMBRE = ?");
			params.add(etiqueta.getNombre());
		}

		StringBuffer query = new StringBuffer(
				"SELECT count(1) FROM Y40a09t00 t1,Y40A07T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param consultaDinamicaBusqueda
	 *            ConsultaDinamicaBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ConsultaDinamicaResultado> findAllConsultaDinamica(
			ConsultaDinamicaBusqueda consultaDinamicaBusqueda,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones().equals(
						Y40aConstantes.CENTROSFORMACIONES_NOSOLICITADO)) {

			where.append(" WHERE 1=1 AND t1.ID_CAT= t2.ID_CAT AND t4.ENTIDAD_ID= t5.ENTIDAD_ID(+) ");

		} else {
			where.append(" WHERE 1=1 AND t1.ID_CAT= t2.ID_CAT AND t2.ID_FOR= t3.ID_FOR AND t3.ENTIDAD_ID= t4.ENTIDAD_ID AND t4.ENTIDAD_ID= t5.ENTIDAD_ID(+) ");
		}

		StringBuffer query = new StringBuffer(
				"SELECT distinct t1.ID_CAT IDCAT, t1.NOMBRE_ES NOMBREESCAT, t1.NOMBRE_EU NOMBREEUCAT, t2.ID_FOR IDFOR, t2.NOMBRE_ES NOMBREES, t2.NOMBRE_EU NOMBREEU, t2.NOMBRE_CORTO_ES FORMACIONNOMBRECORTOES, t2.NOMBRE_CORTO_EU FORMACIONNOMBRECORTOEU, t4.ENTIDAD_ID ENTIDADENTIDADID, t4.NOMBRE_ES ENTIDADNOMBREES, t4.NOMBRE_EU ENTIDADNOMBREEU, t4.NORA_PAIS_ID ENTIDADNORAPAISID, t4.NOMBRE_PAIS ENTIDADNOMBREPAIS, t4.NORA_PROVINCIA_ID ENTIDADNORAPROVINCIAID, t4.NOMBRE_PROVINCIA ENTIDADNOMBREPROVINCIA, t4.NORA_MUNICIPIO_ID ENTIDADNORAMUNICIPIOID, t4.NOMBRE_MUNICIPIO ENTIDADNOMBREMUNICIPIO, t4.NORA_LOCALIDAD_ID ENTIDADNORALOCALIDADID, t4.NOMBRE_LOCALIDAD ENTIDADNOMBRELOCALIDAD, t4.NORA_CALLE_ID ENTIDADNORACALLEID, t4.NOMBRE_CALLE ENTIDADNOMBRECALLE, t4.NORA_CP_ID ENTIDADNORACPID, t4.NOMBRE_CP ENTIDADNOMBRECP, t4.NORA_PORTAL_ID ENTIDADNORAPORTALID, t4.NOMBRE_PORTAL ENTIDADNOMBREPORTAL, t4.COMPLE_DIREC ENTIDADCOMPLEDIREC ");

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones().equals(
						Y40aConstantes.CENTROSFORMACIONES_NOSOLICITADO)) {
			query.append("FROM CATEGORIA t1,FORMACION t2, ENTIDAD t4, GRUPO_ENTIDAD t5 ");

		} else {
			query.append(", t3.PROVINCIA PROVINCIA, t3.ID_SOL IDSOL, t3.GRUPO GRUPO, t3.PARTICIPANTES PARTICIPANTES,t3.IDIOMA IDIOMA, t3.DIA_IMPARTICION DIAIMPARTICION, t3.HORARIO_IMPARTICION HORARIOIMPARTICION,t3.ASISTENTES ASISTENTES, t3.NUMMUJERES NUMMUJERES, t3.NUMHOMBRES, t3.CANCELADO CANCELADO ");
			query.append(", t3.NOMBAPECONTACTO NOMBAPECONTACTO, t3.EMAILCONTACTO EMAILCONTACTO, t3.TELCONTACTO TELCONTACTO, t3.OBSERVASOLICITANTE OBSERVASOLICITANTE ");

			query.append("FROM CATEGORIA t1,FORMACION t2, SOLICITUD t3, ENTIDAD t4, GRUPO_ENTIDAD t5 ");
		}

		// Categorias
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCategorias() != null
				&& consultaDinamicaBusqueda.getCategorias().size() > 0) {

			where.append(" AND t1.ID_CAT IN ( ");
			boolean firstElement = true;

			for (Categoria e : consultaDinamicaBusqueda.getCategorias()) {

				if (firstElement) {

					where.append(" ? ");
					params.add(e.getIdCat());
					firstElement = false;

				} else {

					where.append(" , ?");
					params.add(e.getIdCat());
				}
			}

			where.append(") ");
		}

		// Formaciones
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getFormaciones() != null
				&& consultaDinamicaBusqueda.getFormaciones().size() > 0) {

			where.append(" AND t2.ID_FOR IN ( ");
			boolean firstElement = true;

			for (Formacion e : consultaDinamicaBusqueda.getFormaciones()) {

				if (firstElement) {

					where.append(" ? ");
					params.add(e.getIdFor());
					firstElement = false;

				} else {

					where.append(" , ?");
					params.add(e.getIdFor());
				}
			}

			where.append(") ");
		}

		// Grupos
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getGrupos() != null
				&& consultaDinamicaBusqueda.getGrupos().size() > 0) {

			where.append(" AND t5.GRUPO_ID IN ( ");
			boolean firstElement = true;

			for (Grupo e : consultaDinamicaBusqueda.getGrupos()) {

				if (firstElement) {

					where.append(" ? ");
					params.add(e.getGrupoId());
					firstElement = false;

				} else {

					where.append(" , ?");
					params.add(e.getGrupoId());
				}
			}

			where.append(") ");
		}

		// TH del solicitante
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getThSolicitanteImparticion() != null
				&& consultaDinamicaBusqueda.getThSolicitanteImparticion()
						.equals(Y40aConstantes.TH_SOLICITANTE)) {

			boolean firstElement = true;

			if (consultaDinamicaBusqueda.getThAraba() != null) {
				if (firstElement) {
					where.append(" AND t4.NORA_PROVINCIA_ID IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThAraba());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThAraba());
				}
			}

			if (consultaDinamicaBusqueda.getThBizkaia() != null) {
				if (firstElement) {
					where.append(" AND t4.NORA_PROVINCIA_ID IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThBizkaia());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThBizkaia());
				}
			}

			if (consultaDinamicaBusqueda.getThGipuzkoa() != null) {
				if (firstElement) {
					where.append(" AND t4.NORA_PROVINCIA_ID IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThGipuzkoa());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThGipuzkoa());
				}
			}

			if (!firstElement) {
				where.append(" ) ");
			}
		} else if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getThSolicitanteImparticion() != null
				&& consultaDinamicaBusqueda.getThSolicitanteImparticion()
						.equals(Y40aConstantes.TH_IMPARTICION)) {

			boolean firstElement = true;

			if (consultaDinamicaBusqueda.getThAraba() != null) {
				if (firstElement) {
					where.append(" AND t3.PROVINCIA IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThAraba());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThAraba());
				}
			}

			if (consultaDinamicaBusqueda.getThBizkaia() != null) {
				if (firstElement) {
					where.append(" AND t3.PROVINCIA IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThBizkaia());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThBizkaia());
				}
			}

			if (consultaDinamicaBusqueda.getThGipuzkoa() != null) {
				if (firstElement) {
					where.append(" AND t3.PROVINCIA IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThGipuzkoa());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThGipuzkoa());
				}
			}

			if (!firstElement) {
				where.append(" ) ");
			}
		}

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getEtiquetasFormacion() != null
				&& consultaDinamicaBusqueda.getEtiquetasFormacion().size() > 0) {

			if (consultaDinamicaBusqueda.getEtiquetasFormacionSeleccionadas() != null
					&& consultaDinamicaBusqueda
							.getEtiquetasFormacionSeleccionadas().equals(
									Y40aConstantes.TODAS_ETIQUETAS_FORMACION)) {

				where.append(" AND ((SELECT COUNT(*) FROM FORMACION_ETIQUETA t6 WHERE 1=1 AND t6.ID_FOR=t2.ID_FOR AND ( ");
				boolean firstElement = true;

				for (Etiqueta e : consultaDinamicaBusqueda
						.getEtiquetasFormacion()) {

					if (firstElement) {

						where.append(" t6.ID_ETIQUETA = ? ");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {

						where.append(" OR t6.ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}

				where.append(")) = ? ");
				params.add(consultaDinamicaBusqueda.getEtiquetasFormacion()
						.size());
				where.append(") ");

			} else if (consultaDinamicaBusqueda
					.getEtiquetasFormacionSeleccionadas() != null
					&& consultaDinamicaBusqueda
							.getEtiquetasFormacionSeleccionadas().equals(
									Y40aConstantes.ALGUNAS_ETIQUETAS_FORMACION)) {
				where.append(" AND ((SELECT COUNT(*) FROM FORMACION_ETIQUETA t6 WHERE 1=1 AND t6.ID_FOR=t2.ID_FOR AND ( ");
				boolean firstElement = true;

				for (Etiqueta e : consultaDinamicaBusqueda
						.getEtiquetasFormacion()) {

					if (firstElement) {

						where.append(" t6.ID_ETIQUETA = ? ");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {

						where.append(" OR t6.ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}

				where.append(")) > ? ");
				params.add(Y40aConstantes.NUM_0);
				where.append(") ");
			}

		}

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getEtiquetasSolicitud() != null
				&& consultaDinamicaBusqueda.getEtiquetasSolicitud().size() > 0) {

			if (consultaDinamicaBusqueda.getEtiquetasSolicitudSeleccionadas() != null
					&& consultaDinamicaBusqueda
							.getEtiquetasSolicitudSeleccionadas().equals(
									Y40aConstantes.TODAS_ETIQUETAS_SOLICITUD)) {

				where.append(" AND ((SELECT COUNT(*) FROM SOLICITUD_ETIQUETA t7 WHERE 1=1 AND t7.ID_SOL=t3.ID_SOL AND ( ");
				boolean firstElement = true;

				for (Etiqueta e : consultaDinamicaBusqueda
						.getEtiquetasSolicitud()) {

					if (firstElement) {

						where.append(" t7.ID_ETIQUETA = ? ");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {

						where.append(" OR t7.ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}

				where.append(")) = ? ");
				params.add(consultaDinamicaBusqueda.getEtiquetasSolicitud()
						.size());
				where.append(") ");

			} else if (consultaDinamicaBusqueda
					.getEtiquetasSolicitudSeleccionadas() != null
					&& consultaDinamicaBusqueda
							.getEtiquetasSolicitudSeleccionadas().equals(
									Y40aConstantes.ALGUNAS_ETIQUETAS_SOLICITUD)) {
				where.append(" AND ((SELECT COUNT(*) FROM SOLICITUD_ETIQUETA t7 WHERE 1=1 AND t7.ID_SOL=t3.ID_SOL AND ( ");
				boolean firstElement = true;

				for (Etiqueta e : consultaDinamicaBusqueda
						.getEtiquetasSolicitud()) {

					if (firstElement) {

						where.append(" t7.ID_ETIQUETA = ? ");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {

						where.append(" OR t7.ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}

				where.append(")) > ? ");
				params.add(Y40aConstantes.NUM_0);
				where.append(") ");
			}

		}

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getFechaImparticionDesde() != null) {
			where.append(" AND t3.DIA_IMPARTICION >= ?");
			params.add(consultaDinamicaBusqueda.getFechaImparticionDesde());
		}
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getFechaImparticionHasta() != null) {
			where.append(" AND t3.DIA_IMPARTICION <= ?");
			params.add(consultaDinamicaBusqueda.getFechaImparticionHasta());
		}

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getFechaSolicitudDesde() != null) {
			where.append(" AND t3.FECHA_SOL >= ?");
			params.add(consultaDinamicaBusqueda.getFechaSolicitudDesde());
		}
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getFechaSolicitudHasta() != null) {
			where.append(" AND t3.FECHA_SOL <= ?");
			params.add(consultaDinamicaBusqueda.getFechaSolicitudHasta());
		}

		// centros & formaciones
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones().equals(
						Y40aConstantes.CENTROSFORMACIONES_SOLICITADOCONCEDIDO)) {

			where.append(" AND t3.FECHA_SOL IS NOT NULL AND t3.DIA_IMPARTICION IS NOT NULL");

		} else if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda
						.getCentrosFormaciones()
						.equals(Y40aConstantes.CENTROSFORMACIONES_SOLICITADONOCONCEDIDO)) {

			where.append(" AND t3.FECHA_SOL IS NOT NULL AND t3.DIA_IMPARTICION IS NULL");

		} else if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones().equals(
						Y40aConstantes.CENTROSFORMACIONES_NOSOLICITADO)) {

			where.append(" AND t4.ENTIDAD_ID IN(SELECT DISTINCT ENTIDAD_ID FROM ENTIDAD WHERE NOT EXISTS (SELECT * FROM SOLICITUD WHERE ENTIDAD.ENTIDAD_ID = SOLICITUD.ENTIDAD_ID))");

		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		} else {
			Locale locale = LocaleContextHolder.getLocale();
			// Order
			if (consultaDinamicaBusqueda != null
					&& consultaDinamicaBusqueda.getAgruparResultado() != null
					&& consultaDinamicaBusqueda.getAgruparResultado().equals(
							Y40aConstantes.AGRUPAR_RESULTADO_TH_SOLICITANTE)) {
				order.append(" ORDER BY (t4.NOMBRE_PROVINCIA) ASC ");
				query.append(order);
			} else if (consultaDinamicaBusqueda != null
					&& consultaDinamicaBusqueda.getAgruparResultado() != null
					&& consultaDinamicaBusqueda.getAgruparResultado().equals(
							Y40aConstantes.AGRUPAR_RESULTADO_TH_IMPARTICION)) {
				order.append(" ORDER BY (t3.PROVINCIA) ASC ");
				query.append(order);
			} else if (consultaDinamicaBusqueda != null
					&& consultaDinamicaBusqueda.getAgruparResultado() != null
					&& consultaDinamicaBusqueda.getAgruparResultado().equals(
							Y40aConstantes.AGRUPAR_RESULTADO_CATEGORIA)) {

				if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					order.append(" ORDER BY (t1.NOMBRE_ES) ASC ");
				} else {
					order.append(" ORDER BY (t1.NOMBRE_EU) ASC ");
				}

				query.append(order);
			} else if (consultaDinamicaBusqueda != null
					&& consultaDinamicaBusqueda.getAgruparResultado() != null
					&& consultaDinamicaBusqueda.getAgruparResultado().equals(
							Y40aConstantes.AGRUPAR_RESULTADO_SOLICITANTE)) {

				if (Y40aConstantes.CASTELLANO.equals(locale.getLanguage())) {
					order.append(" ORDER BY (t4.NOMBRE_ES) ASC ");
				} else {
					order.append(" ORDER BY (t4.NOMBRE_EU) ASC ");
				}

				query.append(order);
			}

		}

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones().equals(
						Y40aConstantes.CENTROSFORMACIONES_NOSOLICITADO)) {
			return (List<ConsultaDinamicaResultado>) this.jdbcTemplate.query(
					query.toString(),
					new RowMapper<ConsultaDinamicaResultado>() {
						public ConsultaDinamicaResultado mapRow(
								ResultSet resultSet, int rowNum)
								throws SQLException {
							ConsultaDinamicaResultado consultaDinamicaResultado = new ConsultaDinamicaResultado(
									resultSet.getString("IDCAT"),
									null,
									resultSet.getString("NOMBREESCAT"),
									resultSet.getString("NOMBREEUCAT"),
									resultSet.getString("IDFOR"),
									resultSet.getString("NOMBREES"),
									resultSet.getString("NOMBREEU"),
									resultSet
											.getString("FORMACIONNOMBRECORTOES"),
									resultSet
											.getString("FORMACIONNOMBRECORTOEU"),
									null,
									null,
									null,
									resultSet.getString("ENTIDADENTIDADID"),
									resultSet.getString("ENTIDADNOMBREES"),
									resultSet.getString("ENTIDADNOMBREEU"),
									resultSet.getString("ENTIDADNORAPAISID"),
									resultSet.getString("ENTIDADNOMBREPAIS"),
									resultSet
											.getString("ENTIDADNORAPROVINCIAID"),
									resultSet
											.getString("ENTIDADNOMBREPROVINCIA"),
									resultSet
											.getString("ENTIDADNORAMUNICIPIOID"),
									resultSet
											.getString("ENTIDADNOMBREMUNICIPIO"),
									resultSet
											.getString("ENTIDADNORALOCALIDADID"),
									resultSet
											.getString("ENTIDADNOMBRELOCALIDAD"),
									resultSet.getString("ENTIDADNORACALLEID"),
									resultSet.getString("ENTIDADNOMBRECALLE"),
									resultSet.getString("ENTIDADNORACPID"),
									resultSet.getString("ENTIDADNOMBRECP"),
									resultSet.getString("ENTIDADNORAPORTALID"),
									resultSet.getString("ENTIDADNOMBREPORTAL"),
									resultSet.getString("ENTIDADCOMPLEDIREC"),
									null, null, null, null, null, null, null,
									null, null, null);

							consultaDinamicaResultado.setNombapecontacto(null);
							consultaDinamicaResultado.setEmailcontacto(null);
							consultaDinamicaResultado.setTelcontacto(null);
							consultaDinamicaResultado
									.setObservasolicitante(null);
							return consultaDinamicaResultado;
						}
					}, params.toArray());

		} else {

			return (List<ConsultaDinamicaResultado>) this.jdbcTemplate.query(
					query.toString(),
					new RowMapper<ConsultaDinamicaResultado>() {
						public ConsultaDinamicaResultado mapRow(
								ResultSet resultSet, int rowNum)
								throws SQLException {
							ConsultaDinamicaResultado consultaDinamicaResultado = new ConsultaDinamicaResultado(
									resultSet.getString("IDCAT"),
									null,
									resultSet.getString("NOMBREESCAT"),
									resultSet.getString("NOMBREEUCAT"),
									resultSet.getString("IDFOR"),
									resultSet.getString("NOMBREES"),
									resultSet.getString("NOMBREEU"),
									resultSet
											.getString("FORMACIONNOMBRECORTOES"),
									resultSet
											.getString("FORMACIONNOMBRECORTOEU"),
									null,
									resultSet.getString("PROVINCIA"),
									resultSet.getString("IDSOL"),
									resultSet.getString("ENTIDADENTIDADID"),
									resultSet.getString("ENTIDADNOMBREES"),
									resultSet.getString("ENTIDADNOMBREEU"),
									resultSet.getString("ENTIDADNORAPAISID"),
									resultSet.getString("ENTIDADNOMBREPAIS"),
									resultSet
											.getString("ENTIDADNORAPROVINCIAID"),
									resultSet
											.getString("ENTIDADNOMBREPROVINCIA"),
									resultSet
											.getString("ENTIDADNORAMUNICIPIOID"),
									resultSet
											.getString("ENTIDADNOMBREMUNICIPIO"),
									resultSet
											.getString("ENTIDADNORALOCALIDADID"),
									resultSet
											.getString("ENTIDADNOMBRELOCALIDAD"),
									resultSet.getString("ENTIDADNORACALLEID"),
									resultSet.getString("ENTIDADNOMBRECALLE"),
									resultSet.getString("ENTIDADNORACPID"),
									resultSet.getString("ENTIDADNOMBRECP"),
									resultSet.getString("ENTIDADNORAPORTALID"),
									resultSet.getString("ENTIDADNOMBREPORTAL"),
									resultSet.getString("ENTIDADCOMPLEDIREC"),
									resultSet.getString("GRUPO"), resultSet
											.getLong("PARTICIPANTES"),
									resultSet.getString("IDIOMA"), resultSet
											.getDate("DIAIMPARTICION"),
									resultSet.getString("HORARIOIMPARTICION"),
									resultSet.getLong("ASISTENTES"), resultSet
											.getLong("NUMMUJERES"), resultSet
											.getLong("NUMHOMBRES"), null,
									resultSet.getString("CANCELADO"));

							consultaDinamicaResultado
									.setNombapecontacto(resultSet
											.getString("NOMBAPECONTACTO"));
							consultaDinamicaResultado
									.setEmailcontacto(resultSet
											.getString("EMAILCONTACTO"));
							consultaDinamicaResultado.setTelcontacto(resultSet
									.getString("TELCONTACTO"));
							consultaDinamicaResultado
									.setObservasolicitante(resultSet
											.getString("OBSERVASOLICITANTE"));
							return consultaDinamicaResultado;
						}
					}, params.toArray());

		}

	}

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param consultaDinamicaBusqueda
	 *            ConsultaDinamicaBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllConsultaDinamicaCount(
			ConsultaDinamicaBusqueda consultaDinamicaBusqueda) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones().equals(
						Y40aConstantes.CENTROSFORMACIONES_NOSOLICITADO)) {

			where.append(" WHERE 1=1 AND t1.ID_CAT= t2.ID_CAT AND t4.ENTIDAD_ID= t5.ENTIDAD_ID(+) ");

		} else {
			where.append(" WHERE 1=1 AND t1.ID_CAT= t2.ID_CAT AND t2.ID_FOR= t3.ID_FOR AND t3.ENTIDAD_ID= t4.ENTIDAD_ID AND t4.ENTIDAD_ID= t5.ENTIDAD_ID(+) ");
		}

		StringBuffer query = new StringBuffer("SELECT COUNT(1) ");

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones().equals(
						Y40aConstantes.CENTROSFORMACIONES_NOSOLICITADO)) {
			query.append("FROM CATEGORIA t1,FORMACION t2, ENTIDAD t4, GRUPO_ENTIDAD t5 ");

		} else {
			query.append("FROM CATEGORIA t1,FORMACION t2, SOLICITUD t3, ENTIDAD t4, GRUPO_ENTIDAD t5 ");
		}

		// Categorias
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCategorias() != null
				&& consultaDinamicaBusqueda.getCategorias().size() > 0) {

			where.append(" AND t1.ID_CAT IN ( ");
			boolean firstElement = true;

			for (Categoria e : consultaDinamicaBusqueda.getCategorias()) {

				if (firstElement) {

					where.append(" ? ");
					params.add(e.getIdCat());
					firstElement = false;

				} else {

					where.append(" , ?");
					params.add(e.getIdCat());
				}
			}

			where.append(") ");
		}

		// Formaciones
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getFormaciones() != null
				&& consultaDinamicaBusqueda.getFormaciones().size() > 0) {

			where.append(" AND t2.ID_FOR IN ( ");
			boolean firstElement = true;

			for (Formacion e : consultaDinamicaBusqueda.getFormaciones()) {

				if (firstElement) {

					where.append(" ? ");
					params.add(e.getIdFor());
					firstElement = false;

				} else {

					where.append(" , ?");
					params.add(e.getIdFor());
				}
			}

			where.append(") ");
		}

		// Grupos
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getGrupos() != null
				&& consultaDinamicaBusqueda.getGrupos().size() > 0) {

			where.append(" AND t5.GRUPO_ID IN ( ");
			boolean firstElement = true;

			for (Grupo e : consultaDinamicaBusqueda.getGrupos()) {

				if (firstElement) {

					where.append(" ? ");
					params.add(e.getGrupoId());
					firstElement = false;

				} else {

					where.append(" , ?");
					params.add(e.getGrupoId());
				}
			}

			where.append(") ");
		}

		// TH del solicitante
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getThSolicitanteImparticion() != null
				&& consultaDinamicaBusqueda.getThSolicitanteImparticion()
						.equals(Y40aConstantes.TH_SOLICITANTE)) {

			boolean firstElement = true;

			if (consultaDinamicaBusqueda.getThAraba() != null) {
				if (firstElement) {
					where.append(" AND t4.NORA_PROVINCIA_ID IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThAraba());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThAraba());
				}
			}

			if (consultaDinamicaBusqueda.getThBizkaia() != null) {
				if (firstElement) {
					where.append(" AND t4.NORA_PROVINCIA_ID IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThBizkaia());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThBizkaia());
				}
			}

			if (consultaDinamicaBusqueda.getThGipuzkoa() != null) {
				if (firstElement) {
					where.append(" AND t4.NORA_PROVINCIA_ID IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThGipuzkoa());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThGipuzkoa());
				}
			}

			if (!firstElement) {
				where.append(" ) ");
			}
		} else if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getThSolicitanteImparticion() != null
				&& consultaDinamicaBusqueda.getThSolicitanteImparticion()
						.equals(Y40aConstantes.TH_IMPARTICION)) {

			boolean firstElement = true;

			if (consultaDinamicaBusqueda.getThAraba() != null) {
				if (firstElement) {
					where.append(" AND t3.PROVINCIA IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThAraba());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThAraba());
				}
			}

			if (consultaDinamicaBusqueda.getThBizkaia() != null) {
				if (firstElement) {
					where.append(" AND t3.PROVINCIA IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThBizkaia());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThBizkaia());
				}
			}

			if (consultaDinamicaBusqueda.getThGipuzkoa() != null) {
				if (firstElement) {
					where.append(" AND t3.PROVINCIA IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThGipuzkoa());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThGipuzkoa());
				}
			}

			if (!firstElement) {
				where.append(" ) ");
			}
		}

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getEtiquetasFormacion() != null
				&& consultaDinamicaBusqueda.getEtiquetasFormacion().size() > 0) {

			if (consultaDinamicaBusqueda.getEtiquetasFormacionSeleccionadas() != null
					&& consultaDinamicaBusqueda
							.getEtiquetasFormacionSeleccionadas().equals(
									Y40aConstantes.TODAS_ETIQUETAS_FORMACION)) {

				where.append(" AND ((SELECT COUNT(*) FROM FORMACION_ETIQUETA t6 WHERE 1=1 AND t6.ID_FOR=t2.ID_FOR AND ( ");
				boolean firstElement = true;

				for (Etiqueta e : consultaDinamicaBusqueda
						.getEtiquetasFormacion()) {

					if (firstElement) {

						where.append(" t6.ID_ETIQUETA = ? ");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {

						where.append(" OR t6.ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}

				where.append(")) = ? ");
				params.add(consultaDinamicaBusqueda.getEtiquetasFormacion()
						.size());
				where.append(") ");

			} else if (consultaDinamicaBusqueda
					.getEtiquetasFormacionSeleccionadas() != null
					&& consultaDinamicaBusqueda
							.getEtiquetasFormacionSeleccionadas().equals(
									Y40aConstantes.ALGUNAS_ETIQUETAS_FORMACION)) {
				where.append(" AND ((SELECT COUNT(*) FROM FORMACION_ETIQUETA t6 WHERE 1=1 AND t6.ID_FOR=t2.ID_FOR AND ( ");
				boolean firstElement = true;

				for (Etiqueta e : consultaDinamicaBusqueda
						.getEtiquetasFormacion()) {

					if (firstElement) {

						where.append(" t6.ID_ETIQUETA = ? ");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {

						where.append(" OR t6.ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}

				where.append(")) > ? ");
				params.add(Y40aConstantes.NUM_0);
				where.append(") ");
			}

		}

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getEtiquetasSolicitud() != null
				&& consultaDinamicaBusqueda.getEtiquetasSolicitud().size() > 0) {

			if (consultaDinamicaBusqueda.getEtiquetasSolicitudSeleccionadas() != null
					&& consultaDinamicaBusqueda
							.getEtiquetasSolicitudSeleccionadas().equals(
									Y40aConstantes.TODAS_ETIQUETAS_SOLICITUD)) {

				where.append(" AND ((SELECT COUNT(*) FROM SOLICITUD_ETIQUETA t7 WHERE 1=1 AND t7.ID_SOL=t3.ID_SOL AND ( ");
				boolean firstElement = true;

				for (Etiqueta e : consultaDinamicaBusqueda
						.getEtiquetasSolicitud()) {

					if (firstElement) {

						where.append(" t7.ID_ETIQUETA = ? ");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {

						where.append(" OR t7.ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}

				where.append(")) = ? ");
				params.add(consultaDinamicaBusqueda.getEtiquetasSolicitud()
						.size());
				where.append(") ");

			} else if (consultaDinamicaBusqueda
					.getEtiquetasSolicitudSeleccionadas() != null
					&& consultaDinamicaBusqueda
							.getEtiquetasSolicitudSeleccionadas().equals(
									Y40aConstantes.ALGUNAS_ETIQUETAS_SOLICITUD)) {
				where.append(" AND ((SELECT COUNT(*) FROM SOLICITUD_ETIQUETA t7 WHERE 1=1 AND t7.ID_SOL=t3.ID_SOL AND ( ");
				boolean firstElement = true;

				for (Etiqueta e : consultaDinamicaBusqueda
						.getEtiquetasSolicitud()) {

					if (firstElement) {

						where.append(" t7.ID_ETIQUETA = ? ");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {

						where.append(" OR t7.ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}

				where.append(")) > ? ");
				params.add(Y40aConstantes.NUM_0);
				where.append(") ");
			}

		}

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getFechaImparticionDesde() != null) {
			where.append(" AND t3.DIA_IMPARTICION >= ?");
			params.add(consultaDinamicaBusqueda.getFechaImparticionDesde());
		}
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getFechaImparticionHasta() != null) {
			where.append(" AND t3.DIA_IMPARTICION <= ?");
			params.add(consultaDinamicaBusqueda.getFechaImparticionHasta());
		}

		// centros & formaciones
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones().equals(
						Y40aConstantes.CENTROSFORMACIONES_SOLICITADOCONCEDIDO)) {

			where.append(" AND t3.FECHA_SOL IS NOT NULL AND t3.DIA_IMPARTICION IS NOT NULL");

		} else if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda
						.getCentrosFormaciones()
						.equals(Y40aConstantes.CENTROSFORMACIONES_SOLICITADONOCONCEDIDO)) {

			where.append(" AND t3.FECHA_SOL IS NOT NULL AND t3.DIA_IMPARTICION IS NULL");

		} else if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones().equals(
						Y40aConstantes.CENTROSFORMACIONES_NOSOLICITADO)) {

			where.append(" AND t4.ENTIDAD_ID IN(SELECT DISTINCT ENTIDAD_ID FROM ENTIDAD WHERE NOT EXISTS (SELECT * FROM SOLICITUD WHERE ENTIDAD.ENTIDAD_ID = SOLICITUD.ENTIDAD_ID))");

		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param consultaDinamicaBusqueda
	 *            ConsultaDinamicaBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ConsultaDinamicaResultado> findAllConsultaDinamicaXML(
			ConsultaDinamicaBusqueda consultaDinamicaBusqueda,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones().equals(
						Y40aConstantes.CENTROSFORMACIONES_NOSOLICITADO)) {

			where.append(" WHERE 1=1 AND t1.ID_CAT= t2.ID_CAT AND t4.ENTIDAD_ID= t5.ENTIDAD_ID(+) ");

		} else {
			where.append(" WHERE 1=1 AND t1.ID_CAT= t2.ID_CAT AND t2.ID_FOR= t3.ID_FOR AND t3.ENTIDAD_ID= t4.ENTIDAD_ID AND t4.ENTIDAD_ID= t5.ENTIDAD_ID(+) ");
		}

		StringBuffer query = new StringBuffer(
				"SELECT distinct t4.ENTIDAD_ID ENTIDADENTIDADID, t4.NOMBRE_ES ENTIDADNOMBREES, t4.NOMBRE_EU ENTIDADNOMBREEU, t4.NORA_PAIS_ID ENTIDADNORAPAISID, t4.NOMBRE_PAIS ENTIDADNOMBREPAIS, t4.NORA_PROVINCIA_ID ENTIDADNORAPROVINCIAID, t4.NOMBRE_PROVINCIA ENTIDADNOMBREPROVINCIA, t4.NORA_MUNICIPIO_ID ENTIDADNORAMUNICIPIOID, t4.NOMBRE_MUNICIPIO ENTIDADNOMBREMUNICIPIO, t4.NORA_LOCALIDAD_ID ENTIDADNORALOCALIDADID, t4.NOMBRE_LOCALIDAD ENTIDADNOMBRELOCALIDAD, t4.NORA_CALLE_ID ENTIDADNORACALLEID, t4.NOMBRE_CALLE ENTIDADNOMBRECALLE, t4.NORA_CP_ID ENTIDADNORACPID, t4.NOMBRE_CP ENTIDADNOMBRECP, t4.NORA_PORTAL_ID ENTIDADNORAPORTALID, t4.NOMBRE_PORTAL ENTIDADNOMBREPORTAL, t4.COMPLE_DIREC ENTIDADCOMPLEDIREC "
		// +
		// "FROM CATEGORIA t1,FORMACION t2, SOLICITUD t3, ENTIDAD t4, GRUPO_ENTIDAD t5 "
		);

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones().equals(
						Y40aConstantes.CENTROSFORMACIONES_NOSOLICITADO)) {

			query.append("FROM CATEGORIA t1,FORMACION t2, ENTIDAD t4, GRUPO_ENTIDAD t5 ");

		} else {
			query.append("FROM CATEGORIA t1,FORMACION t2, SOLICITUD t3, ENTIDAD t4, GRUPO_ENTIDAD t5 ");
		}

		// Categorias
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCategorias() != null
				&& consultaDinamicaBusqueda.getCategorias().size() > 0) {

			where.append(" AND t1.ID_CAT IN ( ");
			boolean firstElement = true;

			for (Categoria e : consultaDinamicaBusqueda.getCategorias()) {

				if (firstElement) {

					where.append(" ? ");
					params.add(e.getIdCat());
					firstElement = false;

				} else {

					where.append(" , ?");
					params.add(e.getIdCat());
				}
			}

			where.append(") ");
		}

		// Formaciones
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getFormaciones() != null
				&& consultaDinamicaBusqueda.getFormaciones().size() > 0) {

			where.append(" AND t2.ID_FOR IN ( ");
			boolean firstElement = true;

			for (Formacion e : consultaDinamicaBusqueda.getFormaciones()) {

				if (firstElement) {

					where.append(" ? ");
					params.add(e.getIdFor());
					firstElement = false;

				} else {

					where.append(" , ?");
					params.add(e.getIdFor());
				}
			}

			where.append(") ");
		}

		// Grupos
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getGrupos() != null
				&& consultaDinamicaBusqueda.getGrupos().size() > 0) {

			where.append(" AND t5.GRUPO_ID IN ( ");
			boolean firstElement = true;

			for (Grupo e : consultaDinamicaBusqueda.getGrupos()) {

				if (firstElement) {

					where.append(" ? ");
					params.add(e.getGrupoId());
					firstElement = false;

				} else {

					where.append(" , ?");
					params.add(e.getGrupoId());
				}
			}

			where.append(") ");
		}

		// TH del solicitante
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getThSolicitanteImparticion() != null
				&& consultaDinamicaBusqueda.getThSolicitanteImparticion()
						.equals(Y40aConstantes.TH_SOLICITANTE)) {

			boolean firstElement = true;

			if (consultaDinamicaBusqueda.getThAraba() != null) {
				if (firstElement) {
					where.append(" AND t4.NORA_PROVINCIA_ID IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThAraba());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThAraba());
				}
			}

			if (consultaDinamicaBusqueda.getThBizkaia() != null) {
				if (firstElement) {
					where.append(" AND t4.NORA_PROVINCIA_ID IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThBizkaia());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThBizkaia());
				}
			}

			if (consultaDinamicaBusqueda.getThGipuzkoa() != null) {
				if (firstElement) {
					where.append(" AND t4.NORA_PROVINCIA_ID IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThGipuzkoa());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThGipuzkoa());
				}
			}

			if (!firstElement) {
				where.append(" ) ");
			}
		} else if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getThSolicitanteImparticion() != null
				&& consultaDinamicaBusqueda.getThSolicitanteImparticion()
						.equals(Y40aConstantes.TH_IMPARTICION)) {

			boolean firstElement = true;

			if (consultaDinamicaBusqueda.getThAraba() != null) {
				if (firstElement) {
					where.append(" AND t3.PROVINCIA IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThAraba());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThAraba());
				}
			}

			if (consultaDinamicaBusqueda.getThBizkaia() != null) {
				if (firstElement) {
					where.append(" AND t3.PROVINCIA IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThBizkaia());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThBizkaia());
				}
			}

			if (consultaDinamicaBusqueda.getThGipuzkoa() != null) {
				if (firstElement) {
					where.append(" AND t3.PROVINCIA IN ( ");
					where.append(" ? ");
					params.add(consultaDinamicaBusqueda.getThGipuzkoa());
					firstElement = false;
				} else {
					where.append(" , ?");
					params.add(consultaDinamicaBusqueda.getThGipuzkoa());
				}
			}

			if (!firstElement) {
				where.append(" ) ");
			}
		}

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getEtiquetasFormacion() != null
				&& consultaDinamicaBusqueda.getEtiquetasFormacion().size() > 0) {

			if (consultaDinamicaBusqueda.getEtiquetasFormacionSeleccionadas() != null
					&& consultaDinamicaBusqueda
							.getEtiquetasFormacionSeleccionadas().equals(
									Y40aConstantes.TODAS_ETIQUETAS_FORMACION)) {

				where.append(" AND ((SELECT COUNT(*) FROM FORMACION_ETIQUETA t6 WHERE 1=1 AND t6.ID_FOR=t2.ID_FOR AND ( ");
				boolean firstElement = true;

				for (Etiqueta e : consultaDinamicaBusqueda
						.getEtiquetasFormacion()) {

					if (firstElement) {

						where.append(" t6.ID_ETIQUETA = ? ");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {

						where.append(" OR t6.ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}

				where.append(")) = ? ");
				params.add(consultaDinamicaBusqueda.getEtiquetasFormacion()
						.size());
				where.append(") ");

			} else if (consultaDinamicaBusqueda
					.getEtiquetasFormacionSeleccionadas() != null
					&& consultaDinamicaBusqueda
							.getEtiquetasFormacionSeleccionadas().equals(
									Y40aConstantes.ALGUNAS_ETIQUETAS_FORMACION)) {
				where.append(" AND ((SELECT COUNT(*) FROM FORMACION_ETIQUETA t6 WHERE 1=1 AND t6.ID_FOR=t2.ID_FOR AND ( ");
				boolean firstElement = true;

				for (Etiqueta e : consultaDinamicaBusqueda
						.getEtiquetasFormacion()) {

					if (firstElement) {

						where.append(" t6.ID_ETIQUETA = ? ");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {

						where.append(" OR t6.ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}

				where.append(")) > ? ");
				params.add(Y40aConstantes.NUM_0);
				where.append(") ");
			}

		}

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getEtiquetasSolicitud() != null
				&& consultaDinamicaBusqueda.getEtiquetasSolicitud().size() > 0) {

			if (consultaDinamicaBusqueda.getEtiquetasSolicitudSeleccionadas() != null
					&& consultaDinamicaBusqueda
							.getEtiquetasSolicitudSeleccionadas().equals(
									Y40aConstantes.TODAS_ETIQUETAS_SOLICITUD)) {

				where.append(" AND ((SELECT COUNT(*) FROM SOLICITUD_ETIQUETA t7 WHERE 1=1 AND t7.ID_SOL=t3.ID_SOL AND ( ");
				boolean firstElement = true;

				for (Etiqueta e : consultaDinamicaBusqueda
						.getEtiquetasSolicitud()) {

					if (firstElement) {

						where.append(" t7.ID_ETIQUETA = ? ");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {

						where.append(" OR t7.ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}

				where.append(")) = ? ");
				params.add(consultaDinamicaBusqueda.getEtiquetasSolicitud()
						.size());
				where.append(") ");

			} else if (consultaDinamicaBusqueda
					.getEtiquetasSolicitudSeleccionadas() != null
					&& consultaDinamicaBusqueda
							.getEtiquetasSolicitudSeleccionadas().equals(
									Y40aConstantes.ALGUNAS_ETIQUETAS_SOLICITUD)) {
				where.append(" AND ((SELECT COUNT(*) FROM SOLICITUD_ETIQUETA t7 WHERE 1=1 AND t7.ID_SOL=t3.ID_SOL AND ( ");
				boolean firstElement = true;

				for (Etiqueta e : consultaDinamicaBusqueda
						.getEtiquetasSolicitud()) {

					if (firstElement) {

						where.append(" t7.ID_ETIQUETA = ? ");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {

						where.append(" OR t7.ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}

				where.append(")) > ? ");
				params.add(Y40aConstantes.NUM_0);
				where.append(") ");
			}

		}

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getFechaImparticionDesde() != null) {
			where.append(" AND t3.DIA_IMPARTICION >= ?");
			params.add(consultaDinamicaBusqueda.getFechaImparticionDesde());
		}
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getFechaImparticionHasta() != null) {
			where.append(" AND t3.DIA_IMPARTICION <= ?");
			params.add(consultaDinamicaBusqueda.getFechaImparticionHasta());
		}

		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getFechaSolicitudDesde() != null) {
			where.append(" AND t3.FECHA_SOL >= ?");
			params.add(consultaDinamicaBusqueda.getFechaSolicitudDesde());
		}
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getFechaSolicitudHasta() != null) {
			where.append(" AND t3.FECHA_SOL <= ?");
			params.add(consultaDinamicaBusqueda.getFechaSolicitudHasta());
		}

		// centros & formaciones
		if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones().equals(
						Y40aConstantes.CENTROSFORMACIONES_SOLICITADOCONCEDIDO)) {

			where.append(" AND t3.FECHA_SOL IS NOT NULL AND t3.DIA_IMPARTICION IS NOT NULL");

		} else if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda
						.getCentrosFormaciones()
						.equals(Y40aConstantes.CENTROSFORMACIONES_SOLICITADONOCONCEDIDO)) {

			where.append(" AND t3.FECHA_SOL IS NOT NULL AND t3.DIA_IMPARTICION IS NULL");

		} else if (consultaDinamicaBusqueda != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones() != null
				&& consultaDinamicaBusqueda.getCentrosFormaciones().equals(
						Y40aConstantes.CENTROSFORMACIONES_NOSOLICITADO)) {

			where.append(" AND t4.ENTIDAD_ID IN(SELECT DISTINCT ENTIDAD_ID FROM ENTIDAD WHERE NOT EXISTS (SELECT * FROM SOLICITUD WHERE ENTIDAD.ENTIDAD_ID = SOLICITUD.ENTIDAD_ID))");
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		} else {
			// Order
			if (consultaDinamicaBusqueda != null
					&& consultaDinamicaBusqueda.getAgruparResultado() != null
					&& consultaDinamicaBusqueda.getAgruparResultado().equals(
							Y40aConstantes.AGRUPAR_RESULTADO_TH_SOLICITANTE)) {
				order.append(" ORDER BY (t4.NORA_PROVINCIA_ID) ASC ");
				query.append(order);
			} else if (consultaDinamicaBusqueda != null
					&& consultaDinamicaBusqueda.getAgruparResultado() != null
					&& consultaDinamicaBusqueda.getAgruparResultado().equals(
							Y40aConstantes.AGRUPAR_RESULTADO_TH_IMPARTICION)) {
				order.append(" ORDER BY (t3.PROVINCIA) ASC ");
				query.append(order);
			} else if (consultaDinamicaBusqueda != null
					&& consultaDinamicaBusqueda.getAgruparResultado() != null
					&& consultaDinamicaBusqueda.getAgruparResultado().equals(
							Y40aConstantes.AGRUPAR_RESULTADO_CATEGORIA)) {
				order.append(" ORDER BY (t1.ID_CAT) ASC ");
				query.append(order);
			} else if (consultaDinamicaBusqueda != null
					&& consultaDinamicaBusqueda.getAgruparResultado() != null
					&& consultaDinamicaBusqueda.getAgruparResultado().equals(
							Y40aConstantes.AGRUPAR_RESULTADO_SOLICITANTE)) {
				order.append(" ORDER BY (t4.ENTIDAD_ID) ASC ");
				query.append(order);
			}

		}
		return (List<ConsultaDinamicaResultado>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<ConsultaDinamicaResultado>() {
					public ConsultaDinamicaResultado mapRow(
							ResultSet resultSet, int rowNum)
							throws SQLException {
						return new ConsultaDinamicaResultado(null, null, null,
								null, null, null, null, null, null, null, null,
								null, resultSet.getString("ENTIDADENTIDADID"),
								resultSet.getString("ENTIDADNOMBREES"),
								resultSet.getString("ENTIDADNOMBREEU"),
								resultSet.getString("ENTIDADNORAPAISID"),
								resultSet.getString("ENTIDADNOMBREPAIS"),
								resultSet.getString("ENTIDADNORAPROVINCIAID"),
								resultSet.getString("ENTIDADNOMBREPROVINCIA"),
								resultSet.getString("ENTIDADNORAMUNICIPIOID"),
								resultSet.getString("ENTIDADNOMBREMUNICIPIO"),
								resultSet.getString("ENTIDADNORALOCALIDADID"),
								resultSet.getString("ENTIDADNOMBRELOCALIDAD"),
								resultSet.getString("ENTIDADNORACALLEID"),
								resultSet.getString("ENTIDADNOMBRECALLE"),
								resultSet.getString("ENTIDADNORACPID"),
								resultSet.getString("ENTIDADNOMBRECP"),
								resultSet.getString("ENTIDADNORAPORTALID"),
								resultSet.getString("ENTIDADNOMBREPORTAL"),
								resultSet.getString("ENTIDADCOMPLEDIREC"),
								null, null, null, null, null, null, null, null,
								null, null);
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findNumFormacionGrupo(Solicitud solicitud) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.ID_FOR= t2.ID_FOR(+) AND t2.ID_CAT= t3.ID_CAT(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1)  FROM SOLICITUD t1,FORMACION t2 , CATEGORIA t3 ");

		where.append(" AND t1.ENTIDAD_ID = ? ");
		params.add(solicitud.getEntidad().getEntidadId());

		where.append(" AND UPPER(t1.GRUPO) = ? ");
		params.add(solicitud.getGrupo().toUpperCase());

		where.append(" AND t3.ID_CAT = ? ");
		params.add(solicitud.getFormacion().getCategoria().getIdCat());

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findNumFormacionGrupoIdioma(Solicitud solicitud) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.ID_FOR= t2.ID_FOR(+) AND t2.ID_CAT= t3.ID_CAT(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1)  FROM SOLICITUD t1,FORMACION t2 , CATEGORIA t3 ");

		where.append(" AND t1.ENTIDAD_ID = ? ");
		params.add(solicitud.getEntidad().getEntidadId());

		where.append(" AND UPPER(t1.GRUPO) = ? ");
		params.add(solicitud.getGrupo().toUpperCase());

		where.append(" AND t1.ID_FOR = ? ");
		params.add(solicitud.getFormacion().getIdFor());

		where.append(" AND t1.IDIOMA = ? ");
		params.add(solicitud.getIdioma());

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<PlanificacionSolicitanteBusquedaCartas> findAllPlanificacionSolicitanteCartas(
			String idCatPadre,
			PlanificacionSolicitanteBusquedaCartas planificacionSolicitanteBusquedaCartas,
			Vector<String> perfiles, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append(" WHERE 1=1 AND t1.ID_FOR= t2.ID_FOR(+) AND t1.ENTIDAD_ID= t3.ENTIDAD_ID(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT '"
						+ idCatPadre
						+ "' ID_CAT, (SELECT NOMBRE_ES FROM CATEGORIA WHERE ID_CAT=?) NOMBRE_ES, (SELECT NOMBRE_EU FROM CATEGORIA WHERE ID_CAT=?) NOMBRE_EU, t3.ENTIDAD_ID ENTIDADENTIDADID,t3.NOMBRE_ES ENTIDADNOMBREES,t3.NOMBRE_EU ENTIDADNOMBREEU,t3.NORA_MUNICIPIO_ID ENTIDADNORAMUNICIPIOID,t3.NOMBRE_MUNICIPIO ENTIDADNOMBREMUNICIPIO, COUNT(*) NUMFORMACIONES,COUNT(DIA_IMPARTICION) ACEPTADAS, MAX(FECHA_SOL) FECHA_SOLICITUD, MAX(DIA_IMPARTICION) MAX_IMPARTICION, MIN(DIA_IMPARTICION) MIN_IMPARTICION "
						+ ",t3.TELEFONO TELEENTIDAD, t3.EMAIL EMAILENTIDAD, t3.NOMBRE_CALLE, t3.NORA_PORTAL_ID, t3.NOMBRE_PORTAL, t3.NOMBRE_CP, t3.NOMBRE_PROVINCIA "
						+ "FROM SOLICITUD t1, FORMACION t2 , ENTIDAD t3 ");

		params.add(idCatPadre);
		params.add(idCatPadre);

		if (planificacionSolicitanteBusquedaCartas != null
				&& planificacionSolicitanteBusquedaCartas.getIdCat() != null) {
			where.append(" AND ( ");

			boolean firstElement = true;

			for (Categoria e : planificacionSolicitanteBusquedaCartas
					.getCategorias()) {
				if (firstElement) {
					where.append("t2.ID_CAT = '").append(e.getIdCat())
							.append("'");
					firstElement = false;
				} else {
					where.append(" OR t2.ID_CAT = '").append(e.getIdCat())
							.append("'");
				}
			}

			where.append(") ");
		} else {
			if (perfiles != null && perfiles.size() > 0) {
				where.append(" AND t2.ID_CAT IN ( ");
				where.append(" SELECT  distinct tt1.ID_CAT IDCAT FROM CATEGORIA tt1, CATEGORIA_PERFIL tt2 WHERE 1=1 AND tt1.ID_CAT = tt2.ID_CAT(+) AND tt2.ID_PERFIL IN ( ");

				boolean firstElement = true;
				for (String idPerfilAux : perfiles) {

					if (firstElement) {

						where.append("?");
						params.add(idPerfilAux);
						firstElement = false;

					} else {

						where.append(",?");
						params.add(idPerfilAux);
					}
				}

				where.append(") ) ");
			}
		}

		if (planificacionSolicitanteBusquedaCartas != null
				&& planificacionSolicitanteBusquedaCartas.getEntidadId() != null) {
			where.append(" AND t3.ENTIDAD_ID= ?");
			params.add(planificacionSolicitanteBusquedaCartas.getEntidadId());
		}

		/*
		 * Colección de etiquetas a las que pueden pertenecer las formaciones
		 */
		if (planificacionSolicitanteBusquedaCartas != null
				&& planificacionSolicitanteBusquedaCartas.getEtiquetas() != null
				&& planificacionSolicitanteBusquedaCartas.getEtiquetas().size() > 0) {

			if (planificacionSolicitanteBusquedaCartas.getRadioEtiquetas()
					.equalsIgnoreCase("T")) {
				for (Etiqueta e : planificacionSolicitanteBusquedaCartas
						.getEtiquetas()) {
					where.append(" AND t1.ID_SOL IN (SELECT ID_SOL FROM SOLICITUD_ETIQUETA WHERE ");
					where.append(" ID_ETIQUETA = ?) ");
					params.add(e.getIdEtiqueta());
				}
			} else {
				where.append(" AND t1.ID_SOL IN (SELECT ID_SOL FROM SOLICITUD_ETIQUETA WHERE ");
				boolean firstElement = true;

				for (Etiqueta e : planificacionSolicitanteBusquedaCartas
						.getEtiquetas()) {

					if (firstElement) {

						where.append("ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
						firstElement = false;

					} else {
						where.append(" OR ID_ETIQUETA = ?");
						params.add(e.getIdEtiqueta());
					}
				}

				where.append(") ");
			}
		}

		if (planificacionSolicitanteBusquedaCartas != null
				&& planificacionSolicitanteBusquedaCartas.getSinPlanificar() != null
				|| ((planificacionSolicitanteBusquedaCartas
						.getSinPlanificarTodas() != null && planificacionSolicitanteBusquedaCartas
						.getPlanificados() != null))) {
			// where.append(" AND (DIA_IMPARTICION IS NULL ");

			if (planificacionSolicitanteBusquedaCartas != null
					&& planificacionSolicitanteBusquedaCartas.getPlanificados() != null) {
				// where.append(" OR (DIA_IMPARTICION IS NOT NULL ");

				if (planificacionSolicitanteBusquedaCartas != null
						&& planificacionSolicitanteBusquedaCartas
								.getFechaImparticionDesde() != null) {
					where.append(" AND DIA_IMPARTICION >= ?");
					params.add(planificacionSolicitanteBusquedaCartas
							.getFechaImparticionDesde());
				}
				if (planificacionSolicitanteBusquedaCartas != null
						&& planificacionSolicitanteBusquedaCartas
								.getFechaImparticionHasta() != null) {
					where.append(" AND DIA_IMPARTICION <= ?");
					params.add(planificacionSolicitanteBusquedaCartas
							.getFechaImparticionHasta());
				}
				// where.append(" ) ");
			} else {

				if (planificacionSolicitanteBusquedaCartas != null
						&& planificacionSolicitanteBusquedaCartas
								.getFechaImparticionDesde() != null) {
					where.append(" OR ( ").append(" DIA_IMPARTICION >= ?");
					params.add(planificacionSolicitanteBusquedaCartas
							.getFechaImparticionDesde());
				}
				if (planificacionSolicitanteBusquedaCartas != null
						&& planificacionSolicitanteBusquedaCartas
								.getFechaImparticionHasta() != null) {
					if (planificacionSolicitanteBusquedaCartas != null
							&& planificacionSolicitanteBusquedaCartas
									.getFechaImparticionDesde() != null) {
						where.append(" AND DIA_IMPARTICION <= ? )");
						params.add(planificacionSolicitanteBusquedaCartas
								.getFechaImparticionHasta());
					} else {
						where.append(" OR ( ").append(" DIA_IMPARTICION <= ?)");
						params.add(planificacionSolicitanteBusquedaCartas
								.getFechaImparticionHasta());
					}
				} else {
					if (planificacionSolicitanteBusquedaCartas != null
							&& planificacionSolicitanteBusquedaCartas
									.getFechaImparticionDesde() != null) {
						where.append(" ) ");
					}
				}
			}
			// where.append(" ) ");
		} else {
			if (planificacionSolicitanteBusquedaCartas != null
					&& planificacionSolicitanteBusquedaCartas.getPlanificados() != null) {
				// where.append(" AND (DIA_IMPARTICION IS NOT NULL ");

				if (planificacionSolicitanteBusquedaCartas != null
						&& planificacionSolicitanteBusquedaCartas
								.getFechaImparticionDesde() != null) {
					where.append(" AND DIA_IMPARTICION >= ?");
					params.add(planificacionSolicitanteBusquedaCartas
							.getFechaImparticionDesde());
				}
				if (planificacionSolicitanteBusquedaCartas != null
						&& planificacionSolicitanteBusquedaCartas
								.getFechaImparticionHasta() != null) {
					where.append(" AND DIA_IMPARTICION <= ?");
					params.add(planificacionSolicitanteBusquedaCartas
							.getFechaImparticionHasta());
				}
				// where.append(" ) ");
			} else {
				where.append(" AND (1=1 ");

				if (planificacionSolicitanteBusquedaCartas != null
						&& planificacionSolicitanteBusquedaCartas
								.getFechaImparticionDesde() != null) {
					where.append(" AND DIA_IMPARTICION >= ?");
					params.add(planificacionSolicitanteBusquedaCartas
							.getFechaImparticionDesde());
				}
				if (planificacionSolicitanteBusquedaCartas != null
						&& planificacionSolicitanteBusquedaCartas
								.getFechaImparticionHasta() != null) {
					where.append(" AND DIA_IMPARTICION <= ?");
					params.add(planificacionSolicitanteBusquedaCartas
							.getFechaImparticionHasta());
				}
				where.append(" ) ");
			}
		}

		if (planificacionSolicitanteBusquedaCartas != null
				&& planificacionSolicitanteBusquedaCartas
						.getFechaSolicitudDesde() != null) {
			where.append(" AND FECHA_SOL >= ?");
			params.add(planificacionSolicitanteBusquedaCartas
					.getFechaSolicitudDesde());
		}
		if (planificacionSolicitanteBusquedaCartas != null
				&& planificacionSolicitanteBusquedaCartas
						.getFechaSolicitudHasta() != null) {
			where.append(" AND FECHA_SOL <= ?");
			params.add(planificacionSolicitanteBusquedaCartas
					.getFechaSolicitudHasta());
		}

		where.append(" GROUP BY  t3.ENTIDAD_ID,t3.NOMBRE_ES,t3.NOMBRE_EU,t3.NORA_MUNICIPIO_ID,t3.NOMBRE_MUNICIPIO ");
		where.append(" ,t3.TELEFONO,t3.EMAIL, t3.NOMBRE_CALLE, t3.NORA_PORTAL_ID ,t3.NOMBRE_PORTAL, t3.NOMBRE_CP, t3.NOMBRE_PROVINCIA ");

		// opcion clickada 1 - solo solicitudes con todas no planificadas
		if (planificacionSolicitanteBusquedaCartas != null
				&& planificacionSolicitanteBusquedaCartas
						.getSinPlanificarTodas() != null
				&& planificacionSolicitanteBusquedaCartas.getSinPlanificar() == null
				&& planificacionSolicitanteBusquedaCartas.getPlanificados() == null) {
			where.append(" HAVING ( COUNT(DIA_IMPARTICION) = 0 ) ");
		}

		// opcion clickada 2 - algunas no planificadas ññññ
		if (planificacionSolicitanteBusquedaCartas != null
				&& planificacionSolicitanteBusquedaCartas
						.getSinPlanificarTodas() == null
				&& planificacionSolicitanteBusquedaCartas.getSinPlanificar() != null
				&& planificacionSolicitanteBusquedaCartas.getPlanificados() == null) {
			where.append(" HAVING ((COUNT(*) - COUNT(DIA_IMPARTICION)) > 0 ) ");

		}

		// opcion clickada 3 - algunas planificadas
		if (planificacionSolicitanteBusquedaCartas != null
				&& planificacionSolicitanteBusquedaCartas
						.getSinPlanificarTodas() == null
				&& planificacionSolicitanteBusquedaCartas.getSinPlanificar() == null
				&& planificacionSolicitanteBusquedaCartas.getPlanificados() != null) {
			where.append(" HAVING (COUNT(DIA_IMPARTICION) > 0 ) ");
		}

		// opcion clickada 2y3 - algunas solicitudes sin planificar y algunas
		// planificadas
		if (planificacionSolicitanteBusquedaCartas != null
				&& planificacionSolicitanteBusquedaCartas
						.getSinPlanificarTodas() == null
				&& planificacionSolicitanteBusquedaCartas.getSinPlanificar() != null
				&& planificacionSolicitanteBusquedaCartas.getPlanificados() != null) {
			where.append(" HAVING ( COUNT(DIA_IMPARTICION) > 0  OR COUNT(DIA_IMPARTICION) = 0 )");
		}

		// opcion clickada 1y3 sin having

		// opcion clickada 1y2 - todas sin planificar y algunas sin planificar
		// planificadas
		if (planificacionSolicitanteBusquedaCartas != null
				&& planificacionSolicitanteBusquedaCartas
						.getSinPlanificarTodas() != null
				&& planificacionSolicitanteBusquedaCartas.getSinPlanificar() != null
				&& planificacionSolicitanteBusquedaCartas.getPlanificados() == null) {
			where.append(" HAVING (((COUNT(*) - COUNT(DIA_IMPARTICION)) > 0 ) OR (COUNT(DIA_IMPARTICION) = 0)) ");
		}

		// opcion clickada 1y2y3 sin having

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<PlanificacionSolicitanteBusquedaCartas>) this.jdbcTemplate
				.query(query.toString(),
						new RowMapper<PlanificacionSolicitanteBusquedaCartas>() {
							public PlanificacionSolicitanteBusquedaCartas mapRow(
									ResultSet resultSet, int rowNum)
									throws SQLException {

								return new PlanificacionSolicitanteBusquedaCartas(
										resultSet.getString("ID_CAT"),
										resultSet.getString("NOMBRE_ES"),
										resultSet.getString("NOMBRE_EU"),
										resultSet.getString("ENTIDADENTIDADID"),
										resultSet.getString("ENTIDADNOMBREES"),
										resultSet.getString("ENTIDADNOMBREEU"),
										resultSet
												.getString("ENTIDADNORAMUNICIPIOID"),
										resultSet
												.getString("ENTIDADNOMBREMUNICIPIO"),
										resultSet.getString("NUMFORMACIONES"),
										resultSet.getString("ACEPTADAS"),
										resultSet.getDate("FECHA_SOLICITUD"),
										null,
										null,
										resultSet.getDate("MIN_IMPARTICION"),
										resultSet.getDate("MAX_IMPARTICION"),
										resultSet.getString("TELEENTIDAD"),
										resultSet.getString("EMAILENTIDAD"),
										null,
										null,
										resultSet.getString("NOMBRE_CALLE"),
										resultSet.getString("NORA_PORTAL_ID"),
										resultSet.getString("NOMBRE_PORTAL"),
										resultSet.getString("NOMBRE_CP"),
										resultSet.getString("NOMBRE_PROVINCIA"),
										null);
							}
						}, params.toArray());
	}

	/**
	 * Blocks a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Pagination
	 * @return
	 */
	public void block(Solicitud solicitud) {
		String query = "UPDATE SOLICITUD SET BLOQUEADA=? WHERE ID_SOL=?";
		this.jdbcTemplate
				.update(query, Y40aConstantes.SI, solicitud.getIdSol());
	}

	/**
	 * Unblocks a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Pagination
	 * @return
	 */
	public void unblock(Solicitud solicitud) {
		String query = "UPDATE SOLICITUD SET BLOQUEADA=? WHERE ID_SOL=?";
		this.jdbcTemplate
				.update(query, Y40aConstantes.NO, solicitud.getIdSol());
	}

	/**
	 * Blocks a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Pagination
	 * @return
	 * @throws Exception
	 */
	public void bloquearSolicitudesAutomaticamente(String diasBloqueo) {

		String query = "UPDATE SOLICITUD SET BLOQUEADA = ? WHERE ID_SOL IN "
				+ "(SELECT ID_SOL FROM SOLICITUD WHERE DIA_IMPARTICION IS NOT NULL "
				+ "AND BLOQUEADA = ? "
				+ "AND TRUNC(DIA_IMPARTICION)<=TRUNC(SYSDATE-?)" + ")";

		logger.info("SolicitudDaoImpl.bloquearSolicitudesAutomaticamente try");

		this.jdbcTemplate.update(query, Y40aConstantes.SI, Y40aConstantes.NO,
				diasBloqueo);

	}

}
