package com.ejie.y40a.dao;

import java.util.List;
import java.util.Vector;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.ConsultaDinamicaBusqueda;
import com.ejie.y40a.model.ConsultaDinamicaResultado;
import com.ejie.y40a.model.Etiqueta;
import com.ejie.y40a.model.PlanificacionFormacionBusqueda;
import com.ejie.y40a.model.PlanificacionSolicitanteBusqueda;
import com.ejie.y40a.model.PlanificacionSolicitanteBusquedaCartas;
import com.ejie.y40a.model.Solicitud;
import com.ejie.y40a.model.Y40aCategoriaTree;

/**
 * * SolicitudDao  
 * 
 *  
 */

public interface SolicitudDao {

	/**
	 * Inserts a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Solicitud
	 */
	Solicitud add(Solicitud solicitud);

	/**
	 * Updates a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Solicitud
	 */
	Solicitud update(Solicitud solicitud);

	/**
	 * Finds a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Solicitud
	 */
	Solicitud find(Solicitud solicitud);

	/**
	 * Deletes a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return
	 */
	void remove(Solicitud solicitud);

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Solicitud> findAll(Solicitud solicitud, Pagination pagination);

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return List
	 */
	Long findAllCount(Solicitud solicitud);

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param y40aCategoriaTree
	 *            Y40aCategoriaTree
	 * @param idEntidad
	 *            String
	 * @param idFormacion
	 *            String
	 * @return Long
	 */
	Long countSolicitudesEntidad(Y40aCategoriaTree y40aCategoriaTree,
			String idEntidad, String idFormacion);

	/**
	 * Finds rows in the Solicitud table using like.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Solicitud> findAllLike(Solicitud solicitud, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlanificacionSolicitanteBusqueda> findAllPlanificacionSolicitante(
			PlanificacionSolicitanteBusqueda planificacionSolicitanteBusqueda,
			Vector<String> perfiles, Pagination pagination);

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @return Long
	 */
	Long findAllPlanificacionSolicitanteCount(
			PlanificacionSolicitanteBusqueda planificacionSolicitanteBusqueda,
			Vector<String> perfiles);

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param planificacionFormacionBusqueda
	 *            PlanificacionFormacionBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlanificacionFormacionBusqueda> findAllPlanificacionFormacion(
			PlanificacionFormacionBusqueda planificacionFormacionBusqueda,
			Vector<String> perfiles, Pagination pagination);

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param planificacionFormacionBusqueda
	 *            PlanificacionFormacionBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @return Long
	 */
	Long findAllPlanificacionFormacionCount(
			PlanificacionFormacionBusqueda planificacionFormacionBusqueda,
			Vector<String> perfiles);

	/**
	 * Inserts a single row in the SolicitudEtiqueta table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Solicitud
	 */
	Solicitud addSolicitudEtiqueta(Solicitud solicitud);

	/**
	 * Deletes a single row in the SolicitudEtiqueta table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return
	 */
	void removeSolicitudEtiqueta(Solicitud solicitud);

	/**
	 * Deletes a single row in the SolicitudEtiqueta table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return
	 */
	void removeAllSolicitudEtiqueta(Solicitud solicitud);

	/**
	 * Find a single row in the findSolicitudEtiqueta Many To Many relationship.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return Solicitud
	 */
	Solicitud findSolicitudEtiqueta(Solicitud solicitud, Etiqueta etiqueta,
			Pagination pagination);

	/**
	 * Counts rows rows in the SolicitudEtiqueta table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @param etiqueta
	 *            Etiqueta
	 * @return Long
	 */
	Long findSolicitudEtiquetaCount(Solicitud solicitud, Etiqueta etiqueta);

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param consultaDinamicaBusqueda
	 *            ConsultaDinamicaBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<ConsultaDinamicaResultado> findAllConsultaDinamica(
			ConsultaDinamicaBusqueda consultaDinamicaBusqueda,
			Pagination pagination);

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param consultaDinamicaBusqueda
	 *            ConsultaDinamicaBusqueda
	 * @return Long
	 */
	Long findAllConsultaDinamicaCount(
			ConsultaDinamicaBusqueda consultaDinamicaBusqueda);

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param consultaDinamicaBusqueda
	 *            ConsultaDinamicaBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<ConsultaDinamicaResultado> findAllConsultaDinamicaXML(
			ConsultaDinamicaBusqueda consultaDinamicaBusqueda,
			Pagination pagination);

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Long
	 */
	Long findNumFormacionGrupo(Solicitud solicitud);

	/**
	 * Counts rows in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Solicitud
	 * @return Long
	 */
	Long findNumFormacionGrupoIdioma(Solicitud solicitud);

	/**
	 * Finds a List of rows in the Solicitud table.
	 * 
	 * @param planificacionSolicitanteBusqueda
	 *            PlanificacionSolicitanteBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<PlanificacionSolicitanteBusquedaCartas> findAllPlanificacionSolicitanteCartas(
			String idCatPadre,
			PlanificacionSolicitanteBusquedaCartas planificacionSolicitanteBusquedaCartas,
			Vector<String> perfiles, Pagination pagination);

	/**
	 * Blocks a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Pagination
	 * @return
	 */
	public void block(Solicitud solicitud);

	/**
	 * Unblocks a single row in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Pagination
	 * @return
	 */
	public void unblock(Solicitud solicitud);

	/**
	 * Blocks rows in the Solicitud table.
	 * 
	 * @param solicitud
	 *            Pagination
	 * @return
	 */
	public void bloquearSolicitudesAutomaticamente(String diasBloqueo);

}
