package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y40a.model.Categoria;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Perfil;

/**
 * * PerfilDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class PerfilDaoImpl implements PerfilDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Perfil> rwMap = new RowMapper<Perfil>() {
		public Perfil mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Perfil(resultSet.getString("IDPERFIL"),
					resultSet.getString("NOMBREES"),
					resultSet.getString("NOMBREEU"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Pagination
	 * @return Perfil
	 */
	public Perfil add(Perfil perfil) {

		String query = "INSERT INTO PERFIL( ID_PERFIL,NOMBRE_ES,NOMBRE_EU)"
				+ "VALUES (?,?,?)";

		this.jdbcTemplate.update(query, perfil.getIdPerfil(),
				perfil.getNombreEs(), perfil.getNombreEu());
		return perfil;
	}

	/**
	 * Updates a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Pagination
	 * @return Perfil
	 */
	public Perfil update(Perfil perfil) {
		String query = "UPDATE PERFIL SET NOMBRE_ES=?,NOMBRE_EU=? WHERE ID_PERFIL=?";
		this.jdbcTemplate.update(query, perfil.getNombreEs(),
				perfil.getNombreEu(), perfil.getIdPerfil());
		return perfil;
	}

	/**
	 * Finds a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Pagination
	 * @return Perfil
	 */
	@Transactional(readOnly = true)
	public Perfil find(Perfil perfil) {
		String query = "SELECT t1.ID_PERFIL IDPERFIL, t1.NOMBRE_ES NOMBREES, t1.NOMBRE_EU NOMBREEU "
				+ "FROM PERFIL t1  " + "WHERE t1.ID_PERFIL = ?    ";
		return (Perfil) this.jdbcTemplate.queryForObject(query, rwMap,
				perfil.getIdPerfil());
	}

	/**
	 * Removes a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Pagination
	 * @return
	 */
	public void remove(Perfil perfil) {
		String query = "DELETE  FROM PERFIL WHERE ID_PERFIL=?";
		this.jdbcTemplate.update(query, perfil.getIdPerfil());
	}

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Perfil> findAll(Perfil perfil, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_PERFIL IDPERFIL,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU "
						+ "FROM PERFIL t1 ");

		if (perfil != null && perfil.getIdPerfil() != null) {
			where.append(" AND t1.ID_PERFIL = ?");
			params.add(perfil.getIdPerfil());
		}
		if (perfil != null && perfil.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(perfil.getNombreEs());
		}
		if (perfil != null && perfil.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(perfil.getNombreEu());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Perfil>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Counts rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Perfil perfil) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  PERFIL t1  ");
		if (perfil != null && perfil.getIdPerfil() != null) {
			where.append(" AND t1.ID_PERFIL = ?");
			params.add(perfil.getIdPerfil());
		}
		if (perfil != null && perfil.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(perfil.getNombreEs());
		}
		if (perfil != null && perfil.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(perfil.getNombreEu());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param idCategoria
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Perfil> findAllPerfilesCategoria(Perfil perfil,
			String idCategoria, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.id_perfil = t2.id_perfil(+)	");

		StringBuffer query = new StringBuffer(
				"SELECT  distinct t1.ID_PERFIL IDPERFIL,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU "
						+ "FROM PERFIL t1, CATEGORIA_PERFIL t2 ");

		if (perfil != null && perfil.getIdPerfil() != null) {
			where.append(" AND t1.ID_PERFIL = ?");
			params.add(perfil.getIdPerfil());
		}
		if (perfil != null && perfil.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(perfil.getNombreEs());
		}
		if (perfil != null && perfil.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(perfil.getNombreEu());
		}
		if (idCategoria != null) {
			where.append(" AND t2.id_cat = ?");
			params.add(idCategoria);
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Perfil>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Finds rows in the Perfil table using like.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Perfil> findAllLike(Perfil perfil, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_PERFIL IDPERFIL,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU "
						+ "FROM PERFIL t1 ");

		if (perfil != null && perfil.getIdPerfil() != null) {
			where.append(" AND UPPER(t1.ID_PERFIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(perfil.getIdPerfil().toUpperCase() + "%");
			} else {
				params.add("%" + perfil.getIdPerfil().toUpperCase() + "%");
			}
			where.append(" AND t1.ID_PERFIL IS NOT NULL");
		}
		if (perfil != null && perfil.getNombreEs() != null) {
			where.append(" AND UPPER(t1.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(perfil.getNombreEs().toUpperCase() + "%");
			} else {
				params.add("%" + perfil.getNombreEs().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (perfil != null && perfil.getNombreEu() != null) {
			where.append(" AND UPPER(t1.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(perfil.getNombreEu().toUpperCase() + "%");
			} else {
				params.add("%" + perfil.getNombreEu().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Perfil>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Inserts a single row in the CategoriaPerfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Perfil
	 */
	public Perfil addCategoriaPerfil(Perfil perfil) {
		String query = "INSERT INTO Y40A06T00 " + "( ID_PERFIL,ID_CAT) "
				+ " values (?, ?)";

		List<Categoria> auxiliarCategoria = perfil.getCategorias();
		Iterator<Categoria> it = auxiliarCategoria.iterator();
		while (it.hasNext()) {
			Categoria categoria = (Categoria) it.next();
			this.jdbcTemplate.update(query, perfil.getIdPerfil(),
					categoria.getIdCat());
		}
		return perfil;
	}

	/**
	 * Deletes a single row in the CategoriaPerfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return
	 */
	public void removeCategoriaPerfil(Perfil perfil) {
		String query = "DELETE  FROM Y40A06T00 "
				+ " WHERE ID_PERFIL=? AND ID_CAT=?";
		List<Categoria> auxiliarCategoria = perfil.getCategorias();
		Iterator<Categoria> it = auxiliarCategoria.iterator();
		while (it.hasNext()) {
			Categoria categoria = (Categoria) it.next();
			this.jdbcTemplate.update(query, perfil.getIdPerfil(),
					categoria.getIdCat());
		}
	}

	/**
	 * Find a single row in the findCategoriaPerfil Many To Many relationship.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param categoria
	 *            Categoria
	 * @param pagination
	 *            Pagination
	 * @return Perfil
	 */
	@Transactional(readOnly = true)
	public Perfil findCategoriaPerfil(Perfil perfil, Categoria categoria,
			Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.ID_CAT = t2.ID_CAT AND t1.ID_PERFIL=?");

		params.add(perfil.getIdPerfil());

		if (categoria.getIdCat() != null) {
			where.append(" AND t2.ID_CAT = ?");
			params.add(categoria.getIdCat());
		}
		if (categoria.getCategoria() != null) {
			where.append(" AND t2.ID_CAT_PADRE = ?");
			params.add(categoria.getCategoria());
		}
		if (categoria.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(categoria.getNombreEs());
		}
		if (categoria.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(categoria.getNombreEu());
		}
		if (categoria.getFechaIniSol() != null) {
			where.append(" AND t2.FECHA_INI_SOL = ?");
			params.add(categoria.getFechaIniSol());
		}
		if (categoria.getFechaFinSol() != null) {
			where.append(" AND t2.FECHA_FIN_SOL = ?");
			params.add(categoria.getFechaFinSol());
		}
		if (categoria.getNumAsistentes() != null) {
			where.append(" AND t2.NUM_ASISTENTES = ?");
			params.add(categoria.getNumAsistentes());
		}
		if (categoria.getNumFormaciones() != null) {
			where.append(" AND t2.NUM_FORMACIONES = ?");
			params.add(categoria.getNumFormaciones());
		}
		if (categoria.getVisibleWeb() != null) {
			where.append(" AND t2.VISIBLE_WEB = ?");
			params.add(categoria.getVisibleWeb());
		}

		StringBuffer query = new StringBuffer(
				"SELECT t2.Id_cat idCat, t2.nombre_Es NOMBREES, t2.nombre_Eu NOMBREEU, t2.fecha_Ini_Sol FECHAINISOL, t2.fecha_Fin_Sol FECHAFINSOL, t2.num_Asistentes NUMASISTENTES, t2.num_Formaciones NUMFORMACIONES, t2.visible_Web VISIBLEWEB FROM Y40a06t00 t1,Y40A01T00 t2  ");
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		List<Categoria> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Categoria>() {
					public Categoria mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Categoria(resultSet.getString("IDCAT"),
								resultSet.getString("NOMBREES"), resultSet
										.getString("NOMBREEU"), resultSet
										.getDate("FECHAINISOL"), resultSet
										.getDate("FECHAFINSOL"), resultSet
										.getLong("NUMASISTENTES"), resultSet
										.getLong("NUMFORMACIONES"), resultSet
										.getString("VISIBLEWEB"), null, null,
								null, null, null);
					}
				}, params.toArray());
		perfil.setCategorias(listaHijo);
		return perfil;
	}

	/**
	 * Counts rows in the CategoriaPerfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param categoria
	 *            Categoria
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findCategoriaPerfilCount(Perfil perfil, Categoria categoria) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.ID_CAT = t2.ID_CAT AND t1.ID_PERFIL=?");

		params.add(perfil.getIdPerfil());

		if (categoria.getIdCat() != null) {
			where.append(" AND t2.ID_CAT = ?");
			params.add(categoria.getIdCat());
		}
		if (categoria.getCategoria() != null) {
			where.append(" AND t2.ID_CAT_PADRE = ?");
			params.add(categoria.getCategoria());
		}
		if (categoria.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(categoria.getNombreEs());
		}
		if (categoria.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(categoria.getNombreEu());
		}
		if (categoria.getFechaIniSol() != null) {
			where.append(" AND t2.FECHA_INI_SOL = ?");
			params.add(categoria.getFechaIniSol());
		}
		if (categoria.getFechaFinSol() != null) {
			where.append(" AND t2.FECHA_FIN_SOL = ?");
			params.add(categoria.getFechaFinSol());
		}
		if (categoria.getNumAsistentes() != null) {
			where.append(" AND t2.NUM_ASISTENTES = ?");
			params.add(categoria.getNumAsistentes());
		}
		if (categoria.getNumFormaciones() != null) {
			where.append(" AND t2.NUM_FORMACIONES = ?");
			params.add(categoria.getNumFormaciones());
		}
		if (categoria.getVisibleWeb() != null) {
			where.append(" AND t2.VISIBLE_WEB = ?");
			params.add(categoria.getVisibleWeb());
		}

		StringBuffer query = new StringBuffer(
				"SELECT count(1) FROM Y40a06t00 t1,Y40A01T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
