package com.ejie.y40a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.Perfil;

/**
 * * PerfilDao  
 * 
 *  
 */

public interface PerfilDao {

	/**
	 * Inserts a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Perfil
	 */
	Perfil add(Perfil perfil);

	/**
	 * Updates a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Perfil
	 */
	Perfil update(Perfil perfil);

	/**
	 * Finds a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Perfil
	 */
	Perfil find(Perfil perfil);

	/**
	 * Deletes a single row in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return
	 */
	void remove(Perfil perfil);

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Perfil> findAll(Perfil perfil, Pagination pagination);

	/**
	 * Counts rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return List
	 */
	Long findAllCount(Perfil perfil);

	/**
	 * Finds a List of rows in the Perfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param idCategoria
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Perfil> findAllPerfilesCategoria(Perfil perfil, String idCategoria,
			Pagination pagination);

	/**
	 * Finds rows in the Perfil table using like.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Perfil> findAllLike(Perfil perfil, Pagination pagination,
			Boolean startsWith);

	/**
	 * Inserts a single row in the CategoriaPerfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Perfil
	 */
	Perfil addCategoriaPerfil(Perfil perfil);

	/**
	 * Deletes a single row in the CategoriaPerfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return
	 */
	void removeCategoriaPerfil(Perfil perfil);

	/**
	 * Find a single row in the findCategoriaPerfil Many To Many relationship.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param categoria
	 *            Categoria
	 * @param pagination
	 *            Pagination
	 * @return Perfil
	 */
	Perfil findCategoriaPerfil(Perfil perfil, Categoria categoria,
			Pagination pagination);

	/**
	 * Counts rows rows in the CategoriaPerfil table.
	 * 
	 * @param perfil
	 *            Perfil
	 * @param categoria
	 *            Categoria
	 * @return Long
	 */
	Long findCategoriaPerfilCount(Perfil perfil, Categoria categoria);
}
