package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Parametros;

/**
 * * ParametrosDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ParametrosDaoImpl implements ParametrosDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Parametros> rwMap = new RowMapper<Parametros>() {
		public Parametros mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Parametros(resultSet.getString("IDPARAMETRO"),
					resultSet.getString("DESCRIPCIONES"),
					resultSet.getString("DESCRIPCIONEU"),
					resultSet.getString("VALOR"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Parametros table.
	 * 
	 * @param parametros
	 *            Pagination
	 * @return Parametros
	 */
	public Parametros add(Parametros parametros) {

		String query = "INSERT INTO PARAMETROS( ID_PARAMETRO,DESCRIPCION_ES,DESCRIPCION_EU,VALOR)"
				+ "VALUES (?,?,?,?)";

		this.jdbcTemplate.update(query, parametros.getIdParametro(),
				parametros.getDescripcionEs(), parametros.getDescripcionEu(),
				parametros.getValor());
		return parametros;
	}

	/**
	 * Updates a single row in the Parametros table.
	 * 
	 * @param parametros
	 *            Pagination
	 * @return Parametros
	 */
	public Parametros update(Parametros parametros) {
		String query = "UPDATE PARAMETROS SET DESCRIPCION_ES=?,DESCRIPCION_EU=?,VALOR=? WHERE ID_PARAMETRO=?";
		this.jdbcTemplate.update(query, parametros.getDescripcionEs(),
				parametros.getDescripcionEu(), parametros.getValor(),
				parametros.getIdParametro());
		return parametros;
	}

	/**
	 * Finds a single row in the Parametros table.
	 * 
	 * @param parametros
	 *            Pagination
	 * @return Parametros
	 */
	@Transactional(readOnly = true)
	public Parametros find(Parametros parametros) {
		String query = "SELECT t1.ID_PARAMETRO IDPARAMETRO, t1.DESCRIPCION_ES DESCRIPCIONES, t1.DESCRIPCION_EU DESCRIPCIONEU, t1.VALOR VALOR "
				+ "FROM PARAMETROS t1  " + "WHERE t1.ID_PARAMETRO = ?    ";
		return (Parametros) this.jdbcTemplate.queryForObject(query, rwMap,
				parametros.getIdParametro());
	}

	/**
	 * Removes a single row in the Parametros table.
	 * 
	 * @param parametros
	 *            Pagination
	 * @return
	 */
	public void remove(Parametros parametros) {
		String query = "DELETE  FROM PARAMETROS WHERE ID_PARAMETRO=?";
		this.jdbcTemplate.update(query, parametros.getIdParametro());
	}

	/**
	 * Finds a List of rows in the Parametros table.
	 * 
	 * @param parametros
	 *            Parametros
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Parametros> findAll(Parametros parametros, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_PARAMETRO IDPARAMETRO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EU DESCRIPCIONEU,t1.VALOR VALOR "
						+ "FROM PARAMETROS t1 ");

		if (parametros != null && parametros.getIdParametro() != null) {
			where.append(" AND t1.ID_PARAMETRO = ?");
			params.add(parametros.getIdParametro());
		}
		if (parametros != null && parametros.getDescripcionEs() != null) {
			where.append(" AND t1.DESCRIPCION_ES = ?");
			params.add(parametros.getDescripcionEs());
		}
		if (parametros != null && parametros.getDescripcionEu() != null) {
			where.append(" AND t1.DESCRIPCION_EU = ?");
			params.add(parametros.getDescripcionEu());
		}
		if (parametros != null && parametros.getValor() != null) {
			where.append(" AND t1.VALOR = ?");
			params.add(parametros.getValor());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Parametros>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Parametros table.
	 * 
	 * @param parametros
	 *            Parametros
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Parametros parametros) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  PARAMETROS t1  ");
		if (parametros != null && parametros.getIdParametro() != null) {
			where.append(" AND t1.ID_PARAMETRO = ?");
			params.add(parametros.getIdParametro());
		}
		if (parametros != null && parametros.getDescripcionEs() != null) {
			where.append(" AND t1.DESCRIPCION_ES = ?");
			params.add(parametros.getDescripcionEs());
		}
		if (parametros != null && parametros.getDescripcionEu() != null) {
			where.append(" AND t1.DESCRIPCION_EU = ?");
			params.add(parametros.getDescripcionEu());
		}
		if (parametros != null && parametros.getValor() != null) {
			where.append(" AND t1.VALOR = ?");
			params.add(parametros.getValor());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Parametros table using like.
	 * 
	 * @param parametros
	 *            Parametros
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Parametros> findAllLike(Parametros parametros,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_PARAMETRO IDPARAMETRO,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EU DESCRIPCIONEU,t1.VALOR VALOR "
						+ "FROM PARAMETROS t1 ");

		if (parametros != null && parametros.getIdParametro() != null) {
			where.append(" AND UPPER(t1.ID_PARAMETRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(parametros.getIdParametro().toUpperCase() + "%");
			} else {
				params.add("%" + parametros.getIdParametro().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ID_PARAMETRO IS NOT NULL");
		}
		if (parametros != null && parametros.getDescripcionEs() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(parametros.getDescripcionEs().toUpperCase() + "%");
			} else {
				params.add("%" + parametros.getDescripcionEs().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESCRIPCION_ES IS NOT NULL");
		}
		if (parametros != null && parametros.getDescripcionEu() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(parametros.getDescripcionEu().toUpperCase() + "%");
			} else {
				params.add("%" + parametros.getDescripcionEu().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESCRIPCION_EU IS NOT NULL");
		}
		if (parametros != null && parametros.getValor() != null) {
			where.append(" AND UPPER(t1.VALOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(parametros.getValor().toUpperCase() + "%");
			} else {
				params.add("%" + parametros.getValor().toUpperCase() + "%");
			}
			where.append(" AND t1.VALOR IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Parametros>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Finds a single row in the Parametros table.
	 * 
	 * @param parametros
	 *            Pagination
	 * @return Parametros
	 */
	@Transactional(readOnly = true)
	public Parametros findByDescES(Parametros parametros) {
		String query = "SELECT t1.ID_PARAMETRO IDPARAMETRO, t1.DESCRIPCION_ES DESCRIPCIONES, t1.DESCRIPCION_EU DESCRIPCIONEU, t1.VALOR VALOR "
				+ "FROM PARAMETROS t1  " + "WHERE t1.DESCRIPCION_ES = ?    ";
		return (Parametros) this.jdbcTemplate.queryForObject(query, rwMap,
				parametros.getDescripcionEs());
	}

	/**
	 * Updates a single row in the Parametros table.
	 * 
	 * @param parametros
	 *            Pagination
	 * @return Parametros
	 */
	public Parametros updateValorByDescES(Parametros parametros) {
		String query = "UPDATE PARAMETROS SET VALOR=? WHERE DESCRIPCION_ES=?";
		this.jdbcTemplate.update(query, parametros.getValor(),
				parametros.getDescripcionEs());
		return parametros;
	}

}
