package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.ObservacionesEntidad;

/**
 * * ObservacionesEntidadDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ObservacionesEntidadDaoImpl implements ObservacionesEntidadDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<ObservacionesEntidad> rwMap = new RowMapper<ObservacionesEntidad>() {
		public ObservacionesEntidad mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new ObservacionesEntidad(resultSet.getString("ENTIDADID"),
					resultSet.getString("OBSERVACIONES"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the ObservacionesEntidad table.
	 * 
	 * @param observacionesentidad
	 *            Pagination
	 * @return ObservacionesEntidad
	 */
	public ObservacionesEntidad add(ObservacionesEntidad observacionesentidad) {

		String query = "INSERT INTO OBSERVACIONES_ENTIDAD( ENTIDAD_ID,OBSERVACIONES)"
				+ "VALUES (?,?)";

		this.jdbcTemplate.update(query, observacionesentidad.getEntidadId(),
				observacionesentidad.getObservaciones());
		return observacionesentidad;
	}

	/**
	 * Updates a single row in the ObservacionesEntidad table.
	 * 
	 * @param observacionesentidad
	 *            Pagination
	 * @return ObservacionesEntidad
	 */
	public ObservacionesEntidad update(ObservacionesEntidad observacionesentidad) {
		String query = "UPDATE OBSERVACIONES_ENTIDAD SET OBSERVACIONES=? WHERE ENTIDAD_ID=?";
		this.jdbcTemplate.update(query,
				observacionesentidad.getObservaciones(),
				observacionesentidad.getEntidadId());
		return observacionesentidad;
	}

	/**
	 * Finds a single row in the ObservacionesEntidad table.
	 * 
	 * @param observacionesentidad
	 *            Pagination
	 * @return ObservacionesEntidad
	 */
	@Transactional(readOnly = true)
	public ObservacionesEntidad find(ObservacionesEntidad observacionesentidad) {
		String query = "SELECT t1.ENTIDAD_ID ENTIDADID, t1.OBSERVACIONES OBSERVACIONES "
				+ "FROM OBSERVACIONES_ENTIDAD t1  "
				+ "WHERE t1.ENTIDAD_ID = ?    ";
		return (ObservacionesEntidad) this.jdbcTemplate.queryForObject(query,
				rwMap, observacionesentidad.getEntidadId());
	}

	/**
	 * Removes a single row in the ObservacionesEntidad table.
	 * 
	 * @param observacionesentidad
	 *            Pagination
	 * @return
	 */
	public void remove(ObservacionesEntidad observacionesentidad) {
		String query = "DELETE  FROM OBSERVACIONES_ENTIDAD WHERE ENTIDAD_ID=?";
		this.jdbcTemplate.update(query, observacionesentidad.getEntidadId());
	}

	/**
	 * Finds a List of rows in the ObservacionesEntidad table.
	 * 
	 * @param observacionesentidad
	 *            ObservacionesEntidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ObservacionesEntidad> findAll(
			ObservacionesEntidad observacionesentidad, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ENTIDAD_ID ENTIDADID,t1.OBSERVACIONES OBSERVACIONES "
						+ "FROM OBSERVACIONES_ENTIDAD t1 ");

		if (observacionesentidad != null
				&& observacionesentidad.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(observacionesentidad.getEntidadId());
		}
		if (observacionesentidad != null
				&& observacionesentidad.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(observacionesentidad.getObservaciones());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<ObservacionesEntidad>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ObservacionesEntidad table.
	 * 
	 * @param observacionesentidad
	 *            ObservacionesEntidad
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ObservacionesEntidad observacionesentidad) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  OBSERVACIONES_ENTIDAD t1  ");
		if (observacionesentidad != null
				&& observacionesentidad.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(observacionesentidad.getEntidadId());
		}
		if (observacionesentidad != null
				&& observacionesentidad.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(observacionesentidad.getObservaciones());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the ObservacionesEntidad table using like.
	 * 
	 * @param observacionesentidad
	 *            ObservacionesEntidad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ObservacionesEntidad> findAllLike(
			ObservacionesEntidad observacionesentidad, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ENTIDAD_ID ENTIDADID,t1.OBSERVACIONES OBSERVACIONES "
						+ "FROM OBSERVACIONES_ENTIDAD t1 ");

		if (observacionesentidad != null
				&& observacionesentidad.getEntidadId() != null) {
			where.append(" AND UPPER(t1.ENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(observacionesentidad.getEntidadId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ observacionesentidad.getEntidadId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ENTIDAD_ID IS NOT NULL");
		}
		if (observacionesentidad != null
				&& observacionesentidad.getObservaciones() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(observacionesentidad.getObservaciones()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ observacionesentidad.getObservaciones().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.OBSERVACIONES IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<ObservacionesEntidad>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}
}
