package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Observaciones;

/**
 * * ObservacionesDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ObservacionesDaoImpl implements ObservacionesDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Observaciones> rwMap = new RowMapper<Observaciones>() {
		public Observaciones mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Observaciones(resultSet.getString("ENTIDADID"),
					resultSet.getString("OBSERVACIONES"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Observaciones table.
	 * 
	 * @param observaciones
	 *            Pagination
	 * @return Observaciones
	 */
	public Observaciones add(Observaciones observaciones) {

		String query = "INSERT INTO OBSERVACIONES( ENTIDAD_ID,OBSERVACIONES)"
				+ "VALUES (?,?)";

		this.jdbcTemplate.update(query, observaciones.getEntidadId(),
				observaciones.getObservaciones());
		return observaciones;
	}

	/**
	 * Updates a single row in the Observaciones table.
	 * 
	 * @param observaciones
	 *            Pagination
	 * @return Observaciones
	 */
	public Observaciones update(Observaciones observaciones) {
		String query = "UPDATE OBSERVACIONES SET OBSERVACIONES=? WHERE ENTIDAD_ID=?";
		this.jdbcTemplate.update(query, observaciones.getObservaciones(),
				observaciones.getEntidadId());
		return observaciones;
	}

	/**
	 * Finds a single row in the Observaciones table.
	 * 
	 * @param observaciones
	 *            Pagination
	 * @return Observaciones
	 */
	@Transactional(readOnly = true)
	public Observaciones find(Observaciones observaciones) {
		String query = "SELECT t1.ENTIDAD_ID ENTIDADID, t1.OBSERVACIONES OBSERVACIONES "
				+ "FROM OBSERVACIONES t1  " + "WHERE t1.ENTIDAD_ID = ?    ";
		return (Observaciones) this.jdbcTemplate.queryForObject(query, rwMap,
				observaciones.getEntidadId());
	}

	/**
	 * Removes a single row in the Observaciones table.
	 * 
	 * @param observaciones
	 *            Pagination
	 * @return
	 */
	public void remove(Observaciones observaciones) {
		String query = "DELETE  FROM OBSERVACIONES WHERE ENTIDAD_ID=?";
		this.jdbcTemplate.update(query, observaciones.getEntidadId());
	}

	/**
	 * Finds a List of rows in the Observaciones table.
	 * 
	 * @param observaciones
	 *            Observaciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Observaciones> findAll(Observaciones observaciones,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ENTIDAD_ID ENTIDADID,t1.OBSERVACIONES OBSERVACIONES "
						+ "FROM OBSERVACIONES t1 ");

		if (observaciones != null && observaciones.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(observaciones.getEntidadId());
		}
		if (observaciones != null && observaciones.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(observaciones.getObservaciones());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Observaciones>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Observaciones table.
	 * 
	 * @param observaciones
	 *            Observaciones
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Observaciones observaciones) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  OBSERVACIONES t1  ");
		if (observaciones != null && observaciones.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(observaciones.getEntidadId());
		}
		if (observaciones != null && observaciones.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(observaciones.getObservaciones());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Observaciones table using like.
	 * 
	 * @param observaciones
	 *            Observaciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Observaciones> findAllLike(Observaciones observaciones,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ENTIDAD_ID ENTIDADID,t1.OBSERVACIONES OBSERVACIONES "
						+ "FROM OBSERVACIONES t1 ");

		if (observaciones != null && observaciones.getEntidadId() != null) {
			where.append(" AND UPPER(t1.ENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(observaciones.getEntidadId().toUpperCase() + "%");
			} else {
				params.add("%" + observaciones.getEntidadId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ENTIDAD_ID IS NOT NULL");
		}
		if (observaciones != null && observaciones.getObservaciones() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(observaciones.getObservaciones().toUpperCase() + "%");
			} else {
				params.add("%" + observaciones.getObservaciones().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.OBSERVACIONES IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Observaciones>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
