package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.MotivosCancelacion;

/**
 *  * MotivosCancelacionDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class MotivosCancelacionDaoImpl implements MotivosCancelacionDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<MotivosCancelacion> rwMap = new RowMapper<MotivosCancelacion>() {
		public MotivosCancelacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new MotivosCancelacion(
               resultSet.getLong("IDMOTIVO"), resultSet.getString("DESCMOTIVOES"), resultSet.getString("DESCMOTIVOEU")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the MotivosCancelacion table.
     *
     * @param motivoscancelacion Pagination
     * @return MotivosCancelacion
     */
	public MotivosCancelacion add(MotivosCancelacion motivoscancelacion) {

    	String query = "INSERT INTO MOTIVOS_CANCELACION( ID_MOTIVO,DESC_MOTIVO_ES,DESC_MOTIVO_EU)"
        + "VALUES (?,?,?)";

		this.jdbcTemplate.update(query, motivoscancelacion.getIdMotivo(), motivoscancelacion.getDescMotivoEs(), motivoscancelacion.getDescMotivoEu());
		return motivoscancelacion;
	}

    /**
     * Updates a single row in the MotivosCancelacion table.
     *
     * @param motivoscancelacion Pagination
     * @return MotivosCancelacion
     */
    public MotivosCancelacion update(MotivosCancelacion motivoscancelacion) {
		String query = "UPDATE MOTIVOS_CANCELACION SET DESC_MOTIVO_ES=?,DESC_MOTIVO_EU=? WHERE ID_MOTIVO=?";
		this.jdbcTemplate.update(query, motivoscancelacion.getDescMotivoEs(), motivoscancelacion.getDescMotivoEu(), motivoscancelacion.getIdMotivo());
		return motivoscancelacion;
	}

    /**
     * Finds a single row in the MotivosCancelacion table.
     *
     * @param motivoscancelacion Pagination
     * @return MotivosCancelacion
     */
    @Transactional (readOnly = true)
    public MotivosCancelacion find(MotivosCancelacion motivoscancelacion) {
		String query = "SELECT t1.ID_MOTIVO IDMOTIVO, t1.DESC_MOTIVO_ES DESCMOTIVOES, t1.DESC_MOTIVO_EU DESCMOTIVOEU " 
         + "FROM MOTIVOS_CANCELACION t1  " 
         + "WHERE t1.ID_MOTIVO = ?    ";
		return (MotivosCancelacion) this.jdbcTemplate.queryForObject(query, 
			rwMap , motivoscancelacion.getIdMotivo());	 
    }

    /**
     * Removes a single row in the MotivosCancelacion table.
     *
     * @param motivoscancelacion Pagination
     * @return
     */
    public void remove(MotivosCancelacion motivoscancelacion) {
		String query = "DELETE  FROM MOTIVOS_CANCELACION WHERE ID_MOTIVO=?";
		this.jdbcTemplate.update(query, motivoscancelacion.getIdMotivo());
    	}
    
   /**
    * Finds a List of rows in the MotivosCancelacion table.
    * 
    * @param motivoscancelacion MotivosCancelacion
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<MotivosCancelacion> findAll(MotivosCancelacion motivoscancelacion, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.ID_MOTIVO IDMOTIVO,t1.DESC_MOTIVO_ES DESCMOTIVOES,t1.DESC_MOTIVO_EU DESCMOTIVOEU " 
			+ "FROM MOTIVOS_CANCELACION t1 ");
		
		if (motivoscancelacion  != null  && motivoscancelacion.getIdMotivo() != null ) {
			where.append(" AND t1.ID_MOTIVO = ?");
			params.add(motivoscancelacion.getIdMotivo());
		}
		if (motivoscancelacion  != null  && motivoscancelacion.getDescMotivoEs() != null ) {
			where.append(" AND t1.DESC_MOTIVO_ES = ?");
			params.add(motivoscancelacion.getDescMotivoEs());
		}
		if (motivoscancelacion  != null  && motivoscancelacion.getDescMotivoEu() != null ) {
			where.append(" AND t1.DESC_MOTIVO_EU = ?");
			params.add(motivoscancelacion.getDescMotivoEu());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<MotivosCancelacion>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the MotivosCancelacion table.
     * 
     * @param motivoscancelacion MotivosCancelacion
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(MotivosCancelacion motivoscancelacion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  MOTIVOS_CANCELACION t1  ");
		if (motivoscancelacion  != null  && motivoscancelacion.getIdMotivo() != null ) {
			where.append(" AND t1.ID_MOTIVO = ?");
			params.add(motivoscancelacion.getIdMotivo());
		}
		if (motivoscancelacion  != null  && motivoscancelacion.getDescMotivoEs() != null ) {
			where.append(" AND t1.DESC_MOTIVO_ES = ?");
			params.add(motivoscancelacion.getDescMotivoEs());
		}
		if (motivoscancelacion  != null  && motivoscancelacion.getDescMotivoEu() != null ) {
			where.append(" AND t1.DESC_MOTIVO_EU = ?");
			params.add(motivoscancelacion.getDescMotivoEu());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the MotivosCancelacion table using like.
     * 
     * @param motivoscancelacion MotivosCancelacion
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<MotivosCancelacion> findAllLike(MotivosCancelacion motivoscancelacion, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.ID_MOTIVO IDMOTIVO,t1.DESC_MOTIVO_ES DESCMOTIVOES,t1.DESC_MOTIVO_EU DESCMOTIVOEU " 
        	+ "FROM MOTIVOS_CANCELACION t1 ");
      	
		if (motivoscancelacion  != null  && motivoscancelacion.getIdMotivo() != null ) {
			where.append(" AND t1.ID_MOTIVO like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(motivoscancelacion.getIdMotivo()  +"%");
			}else{
				params.add("%"+motivoscancelacion.getIdMotivo() +"%");
			}	
			where.append(" AND t1.ID_MOTIVO IS NOT NULL");
        }
		if (motivoscancelacion  != null  && motivoscancelacion.getDescMotivoEs() != null ) {
			where.append(" AND UPPER(t1.DESC_MOTIVO_ES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(motivoscancelacion.getDescMotivoEs().toUpperCase()  +"%");
			}else{
				params.add("%"+motivoscancelacion.getDescMotivoEs().toUpperCase() +"%");
			}	
			where.append(" AND t1.DESC_MOTIVO_ES IS NOT NULL");
        }
		if (motivoscancelacion  != null  && motivoscancelacion.getDescMotivoEu() != null ) {
			where.append(" AND UPPER(t1.DESC_MOTIVO_EU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(motivoscancelacion.getDescMotivoEu().toUpperCase()  +"%");
			}else{
				params.add("%"+motivoscancelacion.getDescMotivoEu().toUpperCase() +"%");
			}	
			where.append(" AND t1.DESC_MOTIVO_EU IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<MotivosCancelacion>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

