package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Historico;
import com.ejie.y40a.utils.jdbc.Y40aJdbcUtils;

/**
 * * HistoricoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class HistoricoDaoImpl implements HistoricoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Historico> rwMap = new RowMapper<Historico>() {
		public Historico mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Historico(resultSet.getString("IDHIST"),
					resultSet.getBlob("ARCHIVO"),
					resultSet.getString("NOMBRE"), resultSet.getString("TIPO"),
					resultSet.getLong("TAMANIO"), resultSet.getDate("FECHA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Historico table.
	 * 
	 * @param historico
	 *            Pagination
	 * @return Historico
	 */
	public Historico add(Historico historico) {

		String query = "INSERT INTO HISTORICO( ID_HIST,ARCHIVO,NOMBRE,TIPO,TAMANIO,FECHA)"
				+ "VALUES (?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, historico.getIdHist(),
				Y40aJdbcUtils.ConvertBlobToByte(historico.getArchivo()),
				historico.getNombre(), historico.getTipo(),
				historico.getTamanio(), historico.getFecha());
		return historico;
	}

	/**
	 * Updates a single row in the Historico table.
	 * 
	 * @param historico
	 *            Pagination
	 * @return Historico
	 */
	public Historico update(Historico historico) {
		String query = "UPDATE HISTORICO SET ARCHIVO=?,NOMBRE=?,TIPO=?,TAMANIO=?,FECHA=? WHERE ID_HIST=?";
		this.jdbcTemplate.update(query, historico.getArchivo(),
				historico.getNombre(), historico.getTipo(),
				historico.getTamanio(), historico.getFecha(),
				historico.getIdHist());
		return historico;
	}

	/**
	 * Finds a single row in the Historico table.
	 * 
	 * @param historico
	 *            Pagination
	 * @return Historico
	 */
	@Transactional(readOnly = true)
	public Historico find(Historico historico) {
		String query = "SELECT t1.ID_HIST IDHIST, t1.ARCHIVO ARCHIVO, t1.NOMBRE NOMBRE, t1.TIPO TIPO, t1.TAMANIO TAMANIO, t1.FECHA FECHA "
				+ "FROM HISTORICO t1  " + "WHERE t1.ID_HIST = ?    ";
		return (Historico) this.jdbcTemplate.queryForObject(query, rwMap,
				historico.getIdHist());
	}

	/**
	 * Removes a single row in the Historico table.
	 * 
	 * @param historico
	 *            Pagination
	 * @return
	 */
	public void remove(Historico historico) {
		String query = "DELETE  FROM HISTORICO WHERE ID_HIST=?";
		this.jdbcTemplate.update(query, historico.getIdHist());
	}

	/**
	 * Finds a List of rows in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Historico> findAll(Historico historico, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_HIST IDHIST,t1.ARCHIVO ARCHIVO,t1.NOMBRE NOMBRE,t1.TIPO TIPO,t1.TAMANIO TAMANIO,t1.FECHA FECHA "
						+ "FROM HISTORICO t1 ");

		if (historico != null && historico.getIdHist() != null) {
			where.append(" AND t1.ID_HIST = ?");
			params.add(historico.getIdHist());
		}
		if (historico != null && historico.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(historico.getNombre());
		}
		if (historico != null && historico.getTipo() != null) {
			where.append(" AND t1.TIPO = ?");
			params.add(historico.getTipo());
		}
		if (historico != null && historico.getTamanio() != null) {
			where.append(" AND t1.TAMANIO = ?");
			params.add(historico.getTamanio());
		}
		if (historico != null && historico.getFecha() != null) {
			where.append(" AND t1.FECHA = ?");
			params.add(historico.getFecha());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Historico>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Historico table.
	 * 
	 * @param historico
	 *            Historico
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Historico historico) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  HISTORICO t1  ");
		if (historico != null && historico.getIdHist() != null) {
			where.append(" AND t1.ID_HIST = ?");
			params.add(historico.getIdHist());
		}
		if (historico != null && historico.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(historico.getNombre());
		}
		if (historico != null && historico.getTipo() != null) {
			where.append(" AND t1.TIPO = ?");
			params.add(historico.getTipo());
		}
		if (historico != null && historico.getTamanio() != null) {
			where.append(" AND t1.TAMANIO = ?");
			params.add(historico.getTamanio());
		}
		if (historico != null && historico.getFecha() != null) {
			where.append(" AND t1.FECHA = ?");
			params.add(historico.getFecha());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Historico table using like.
	 * 
	 * @param historico
	 *            Historico
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Historico> findAllLike(Historico historico,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_HIST IDHIST,t1.ARCHIVO ARCHIVO,t1.NOMBRE NOMBRE,t1.TIPO TIPO,t1.TAMANIO TAMANIO,t1.FECHA FECHA "
						+ "FROM HISTORICO t1 ");

		if (historico != null && historico.getIdHist() != null) {
			where.append(" AND UPPER(t1.ID_HIST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getIdHist().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getIdHist().toUpperCase() + "%");
			}
			where.append(" AND t1.ID_HIST IS NOT NULL");
		}
		if (historico != null && historico.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (historico != null && historico.getTipo() != null) {
			where.append(" AND UPPER(t1.TIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getTipo().toUpperCase() + "%");
			} else {
				params.add("%" + historico.getTipo().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPO IS NOT NULL");
		}
		if (historico != null && historico.getTamanio() != null) {
			where.append(" AND t1.TAMANIO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getTamanio() + "%");
			} else {
				params.add("%" + historico.getTamanio() + "%");
			}
			where.append(" AND t1.TAMANIO IS NOT NULL");
		}
		if (historico != null && historico.getFecha() != null) {
			where.append(" AND UPPER(t1.FECHA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(historico.getFecha() + "%");
			} else {
				params.add("%" + historico.getFecha() + "%");
			}
			where.append(" AND t1.FECHA IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Historico>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
