package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.GrupoEntidad;

/**
 * * GrupoEntidadDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class GrupoEntidadDaoImpl implements GrupoEntidadDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<GrupoEntidad> rwMap = new RowMapper<GrupoEntidad>() {
		public GrupoEntidad mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new GrupoEntidad(resultSet.getString("GRUPOID"),
					resultSet.getString("ENTIDADID"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the GrupoEntidad table.
	 * 
	 * @param grupoentidad
	 *            Pagination
	 * @return GrupoEntidad
	 */
	public GrupoEntidad add(GrupoEntidad grupoentidad) {

		String query = "INSERT INTO GRUPO_ENTIDAD( GRUPO_ID,ENTIDAD_ID)"
				+ "VALUES (?,?)";

		this.jdbcTemplate.update(query, grupoentidad.getGrupoId(),
				grupoentidad.getEntidadId());
		return grupoentidad;
	}

	/**
	 * Updates a single row in the GrupoEntidad table.
	 * 
	 * @param grupoentidad
	 *            Pagination
	 * @return GrupoEntidad
	 */
	public GrupoEntidad update(GrupoEntidad grupoentidad) {
		String query = "UPDATE GRUPO_ENTIDAD SET  WHERE GRUPO_ID=? AND ENTIDAD_ID=?";
		this.jdbcTemplate.update(query, grupoentidad.getGrupoId(),
				grupoentidad.getEntidadId());
		return grupoentidad;
	}

	/**
	 * Finds a single row in the GrupoEntidad table.
	 * 
	 * @param grupoentidad
	 *            Pagination
	 * @return GrupoEntidad
	 */
	@Transactional(readOnly = true)
	public GrupoEntidad find(GrupoEntidad grupoentidad) {
		String query = "SELECT t1.GRUPO_ID GRUPOID, t1.ENTIDAD_ID ENTIDADID "
				+ "FROM GRUPO_ENTIDAD t1  "
				+ "WHERE t1.GRUPO_ID = ?   AND t1.ENTIDAD_ID = ?    ";
		return (GrupoEntidad) this.jdbcTemplate.queryForObject(query, rwMap,
				grupoentidad.getGrupoId(), grupoentidad.getEntidadId());
	}

	/**
	 * Removes a single row in the GrupoEntidad table.
	 * 
	 * @param grupoentidad
	 *            Pagination
	 * @return
	 */
	public void remove(GrupoEntidad grupoentidad) {
		String query = "DELETE  FROM GRUPO_ENTIDAD WHERE GRUPO_ID=? AND ENTIDAD_ID=?";
		this.jdbcTemplate.update(query, grupoentidad.getGrupoId(),
				grupoentidad.getEntidadId());
	}

	/**
	 * Finds a List of rows in the GrupoEntidad table.
	 * 
	 * @param grupoentidad
	 *            GrupoEntidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<GrupoEntidad> findAll(GrupoEntidad grupoentidad,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.GRUPO_ID GRUPOID,t1.ENTIDAD_ID ENTIDADID "
						+ "FROM GRUPO_ENTIDAD t1 ");

		if (grupoentidad != null && grupoentidad.getGrupoId() != null) {
			where.append(" AND t1.GRUPO_ID = ?");
			params.add(grupoentidad.getGrupoId());
		}
		if (grupoentidad != null && grupoentidad.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(grupoentidad.getEntidadId());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<GrupoEntidad>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the GrupoEntidad table.
	 * 
	 * @param grupoentidad
	 *            GrupoEntidad
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(GrupoEntidad grupoentidad) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  GRUPO_ENTIDAD t1  ");
		if (grupoentidad != null && grupoentidad.getGrupoId() != null) {
			where.append(" AND t1.GRUPO_ID = ?");
			params.add(grupoentidad.getGrupoId());
		}
		if (grupoentidad != null && grupoentidad.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(grupoentidad.getEntidadId());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the GrupoEntidad table using like.
	 * 
	 * @param grupoentidad
	 *            GrupoEntidad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<GrupoEntidad> findAllLike(GrupoEntidad grupoentidad,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.GRUPO_ID GRUPOID,t1.ENTIDAD_ID ENTIDADID "
						+ "FROM GRUPO_ENTIDAD t1 ");

		if (grupoentidad != null && grupoentidad.getGrupoId() != null) {
			where.append(" AND UPPER(t1.GRUPO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupoentidad.getGrupoId().toUpperCase() + "%");
			} else {
				params.add("%" + grupoentidad.getGrupoId().toUpperCase() + "%");
			}
			where.append(" AND t1.GRUPO_ID IS NOT NULL");
		}
		if (grupoentidad != null && grupoentidad.getEntidadId() != null) {
			where.append(" AND UPPER(t1.ENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupoentidad.getEntidadId().toUpperCase() + "%");
			} else {
				params.add("%" + grupoentidad.getEntidadId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ENTIDAD_ID IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<GrupoEntidad>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
