package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y40a.model.GrupoEntidad;

/**
 *  * GrupoEntidadDao  
 *  
 */

public interface GrupoEntidadDao {
    
    /**
     * Inserts a single row in the GrupoEntidad table.
     *
     * @param grupoentidad GrupoEntidad
     * @return GrupoEntidad
     */
    GrupoEntidad add(GrupoEntidad grupoentidad);

    /**
     * Updates a single row in the GrupoEntidad table.
     *
     * @param grupoentidad GrupoEntidad
     * @return GrupoEntidad
     */
    GrupoEntidad update(GrupoEntidad grupoentidad);

    /**
     * Finds a single row in the GrupoEntidad table.
     *
     * @param grupoentidad GrupoEntidad
     * @return GrupoEntidad
     */
    GrupoEntidad find(GrupoEntidad grupoentidad);

    /**
     * Deletes a single row in the GrupoEntidad table.
     *
     * @param grupoentidad GrupoEntidad
     * @return 
     */
    void remove(GrupoEntidad grupoentidad);

    /**
     * Finds a List of rows in the GrupoEntidad table.
     *
     * @param grupoentidad GrupoEntidad
     * @param pagination Pagination
     * @return List
     */
    List<GrupoEntidad> findAll(GrupoEntidad grupoentidad, Pagination pagination);

    /**
     * Counts rows in the GrupoEntidad table.
     *
     * @param grupoentidad GrupoEntidad
     * @return List
     */
    Long findAllCount(GrupoEntidad grupoentidad);
	
	/**
     * Finds rows in the GrupoEntidad table using like.
     *
     * @param grupoentidad GrupoEntidad
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<GrupoEntidad> findAllLike(GrupoEntidad grupoentidad, Pagination pagination, Boolean startsWith);
}

