package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.Y40aGrupoTree;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Grupo;

/**
 * * GrupoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class GrupoDaoImpl implements GrupoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Grupo> rwMap = new RowMapper<Grupo>() {
		public Grupo mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Grupo(resultSet.getString("GRUPOID"),
					resultSet.getBigDecimal("NIVEL"),
					resultSet.getString("NOMBREES"),
					resultSet.getString("NOMBREEU"),
					resultSet.getString("GRUPOPADREID"),
					resultSet.getString("ACTIVA"),
					resultSet.getString("USUULTMOD"),
					resultSet.getDate("FECULTMOD"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Pagination
	 * @return Grupo
	 */
	public Grupo add(Grupo grupo) {

		String query = "INSERT INTO GRUPO( GRUPO_ID,NIVEL,NOMBRE_ES,NOMBRE_EU,GRUPO_PADRE_ID,ACTIVA,USUULTMOD,FECULTMOD)"
				+ "VALUES (?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, grupo.getGrupoId(), grupo.getNivel(),
				grupo.getNombreEs(), grupo.getNombreEu(),
				grupo.getGrupoPadreId(), grupo.getActiva(),
				grupo.getUsuultmod(), grupo.getFecultmod());
		return grupo;
	}

	/**
	 * Updates a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Pagination
	 * @return Grupo
	 */
	public Grupo update(Grupo grupo) {
		String query = "UPDATE GRUPO SET NIVEL=?,NOMBRE_ES=?,NOMBRE_EU=?,GRUPO_PADRE_ID=?,ACTIVA=?,USUULTMOD=?,FECULTMOD=? WHERE GRUPO_ID=?";
		this.jdbcTemplate.update(query, grupo.getNivel(), grupo.getNombreEs(),
				grupo.getNombreEu(), grupo.getGrupoPadreId(),
				grupo.getActiva(), grupo.getUsuultmod(), grupo.getFecultmod(),
				grupo.getGrupoId());
		return grupo;
	}

	/**
	 * Finds a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Pagination
	 * @return Grupo
	 */
	@Transactional(readOnly = true)
	public Grupo find(Grupo grupo) {
		String query = "SELECT t1.GRUPO_ID GRUPOID, t1.NIVEL NIVEL, t1.NOMBRE_ES NOMBREES, t1.NOMBRE_EU NOMBREEU, t1.GRUPO_PADRE_ID GRUPOPADREID, t1.ACTIVA ACTIVA, t1.USUULTMOD USUULTMOD, t1.FECULTMOD FECULTMOD "
				+ "FROM GRUPO t1  " + "WHERE t1.GRUPO_ID = ?    ";
		return (Grupo) this.jdbcTemplate.queryForObject(query, rwMap,
				grupo.getGrupoId());
	}

	/**
	 * Removes a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Pagination
	 * @return
	 */
	public void remove(Grupo grupo) {
		String query = "DELETE  FROM GRUPO WHERE GRUPO_ID=?";
		this.jdbcTemplate.update(query, grupo.getGrupoId());
	}

	/**
	 * Finds a List of rows in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Grupo> findAll(Grupo grupo, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.GRUPO_ID GRUPOID,t1.NIVEL NIVEL,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.GRUPO_PADRE_ID GRUPOPADREID,t1.ACTIVA ACTIVA,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD "
						+ "FROM GRUPO t1");

		if (grupo != null && grupo.getGrupoId() != null) {
			where.append(" AND t1.GRUPO_ID = ?");
			params.add(grupo.getGrupoId());
		}
		if (grupo != null && grupo.getNivel() != null) {
			where.append(" AND t1.NIVEL = ?");
			params.add(grupo.getNivel());
		}
		if (grupo != null && grupo.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(grupo.getNombreEs());
		}
		if (grupo != null && grupo.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(grupo.getNombreEu());
		}
		if (grupo != null && grupo.getGrupoPadreId() != null) {
			where.append(" AND t1.GRUPO_PADRE_ID = ?");
			params.add(grupo.getGrupoPadreId());
		}
		if (grupo != null && grupo.getActiva() != null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(grupo.getActiva());
		}
		if (grupo != null && grupo.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(grupo.getUsuultmod());
		}
		if (grupo != null && grupo.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(grupo.getFecultmod());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Grupo>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Counts rows in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Grupo grupo) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  GRUPO t1  ");
		if (grupo != null && grupo.getGrupoId() != null) {
			where.append(" AND t1.GRUPO_ID = ?");
			params.add(grupo.getGrupoId());
		}
		if (grupo != null && grupo.getNivel() != null) {
			where.append(" AND t1.NIVEL = ?");
			params.add(grupo.getNivel());
		}
		if (grupo != null && grupo.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(grupo.getNombreEs());
		}
		if (grupo != null && grupo.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(grupo.getNombreEu());
		}
		if (grupo != null && grupo.getGrupoPadreId() != null) {
			where.append(" AND t1.GRUPO_PADRE_ID = ?");
			params.add(grupo.getGrupoPadreId());
		}
		if (grupo != null && grupo.getActiva() != null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(grupo.getActiva());
		}
		if (grupo != null && grupo.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(grupo.getUsuultmod());
		}
		if (grupo != null && grupo.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(grupo.getFecultmod());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param idCategoria
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Grupo> findAllGruposCategoria(Grupo grupo, String idCategoria,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.grupo_id = t2.grupo_id(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT  distinct t1.GRUPO_ID GRUPOID,t1.NIVEL NIVEL,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.GRUPO_PADRE_ID GRUPOPADREID,t1.ACTIVA ACTIVA,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD "
						+ "FROM GRUPO t1, CATEGORIA_GRUPOS t2 ");

		if (grupo != null && grupo.getGrupoId() != null) {
			where.append(" AND t1.GRUPO_ID = ?");
			params.add(grupo.getGrupoId());
		}
		if (grupo != null && grupo.getNivel() != null) {
			where.append(" AND t1.NIVEL = ?");
			params.add(grupo.getNivel());
		}
		if (grupo != null && grupo.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(grupo.getNombreEs());
		}
		if (grupo != null && grupo.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(grupo.getNombreEu());
		}
		if (grupo != null && grupo.getGrupoPadreId() != null) {
			where.append(" AND t1.GRUPO_PADRE_ID = ?");
			params.add(grupo.getGrupoPadreId());
		}
		if (grupo != null && grupo.getActiva() != null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(grupo.getActiva());
		}
		if (grupo != null && grupo.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(grupo.getUsuultmod());
		}
		if (grupo != null && grupo.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(grupo.getFecultmod());
		}
		if (grupo != null && grupo.getGrupoPadreId() == null) {
			where.append(" AND (t1.GRUPO_PADRE_ID IS NULL OR t1.GRUPO_PADRE_ID='0') ");
		}

		if (idCategoria != null) {
			where.append(" AND t2.id_cat = ?");
			params.add(idCategoria);
		}

		where.append(" AND t1.GRUPO_ID <> ? ");
		params.add(Y40aConstantes.GRUPO_RAIZ_ID);

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Grupo>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Finds rows in the Grupo table using like.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Grupo> findAllLike(Grupo grupo, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.GRUPO_ID GRUPOID,t1.NIVEL NIVEL,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.GRUPO_PADRE_ID GRUPOPADREID,t1.ACTIVA ACTIVA,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD "
						+ "FROM GRUPO t1 ");

		if (grupo != null && grupo.getGrupoId() != null) {
			where.append(" AND UPPER(t1.GRUPO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getGrupoId().toUpperCase() + "%");
			} else {
				params.add("%" + grupo.getGrupoId().toUpperCase() + "%");
			}
			where.append(" AND t1.GRUPO_ID IS NOT NULL");
		}
		if (grupo != null && grupo.getNivel() != null) {
			where.append(" AND t1.NIVEL like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getNivel() + "%");
			} else {
				params.add("%" + grupo.getNivel() + "%");
			}
			where.append(" AND t1.NIVEL IS NOT NULL");
		}
		if (grupo != null && grupo.getNombreEs() != null) {
			where.append(" AND UPPER(t1.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getNombreEs().toUpperCase() + "%");
			} else {
				params.add("%" + grupo.getNombreEs().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (grupo != null && grupo.getNombreEu() != null) {
			where.append(" AND UPPER(t1.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getNombreEu().toUpperCase() + "%");
			} else {
				params.add("%" + grupo.getNombreEu().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (grupo != null && grupo.getGrupoPadreId() != null) {
			where.append(" AND UPPER(t1.GRUPO_PADRE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getGrupoPadreId().toUpperCase() + "%");
			} else {
				params.add("%" + grupo.getGrupoPadreId().toUpperCase() + "%");
			}
			where.append(" AND t1.GRUPO_PADRE_ID IS NOT NULL");
		}
		if (grupo != null && grupo.getActiva() != null) {
			where.append(" AND UPPER(t1.ACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getActiva().toUpperCase() + "%");
			} else {
				params.add("%" + grupo.getActiva().toUpperCase() + "%");
			}
			where.append(" AND t1.ACTIVA IS NOT NULL");
		}
		if (grupo != null && grupo.getUsuultmod() != null) {
			where.append(" AND UPPER(t1.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getUsuultmod().toUpperCase() + "%");
			} else {
				params.add("%" + grupo.getUsuultmod().toUpperCase() + "%");
			}
			where.append(" AND t1.USUULTMOD IS NOT NULL");
		}
		if (grupo != null && grupo.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(grupo.getFecultmod() + "%");
			} else {
				params.add("%" + grupo.getFecultmod() + "%");
			}
			where.append(" AND t1.FECULTMOD IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Grupo>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Inserts a single row in the CategoriaGrupos table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Grupo
	 */
	public Grupo addCategoriaGrupos(Grupo grupo) {
		String query = "INSERT INTO Y40A04T00 " + "( GRUPO_ID,ID_CAT) "
				+ " values (?, ?)";

		List<Categoria> auxiliarCategoria = grupo.getCategorias();
		Iterator<Categoria> it = auxiliarCategoria.iterator();
		while (it.hasNext()) {
			Categoria categoria = (Categoria) it.next();
			this.jdbcTemplate.update(query, grupo.getGrupoId(),
					categoria.getIdCat());
		}
		return grupo;
	}

	/**
	 * Deletes a single row in the CategoriaGrupos table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return
	 */
	public void removeCategoriaGrupos(Grupo grupo) {
		String query = "DELETE  FROM Y40A04T00 "
				+ " WHERE GRUPO_ID=? AND ID_CAT=?";
		List<Categoria> auxiliarCategoria = grupo.getCategorias();
		Iterator<Categoria> it = auxiliarCategoria.iterator();
		while (it.hasNext()) {
			Categoria categoria = (Categoria) it.next();
			this.jdbcTemplate.update(query, grupo.getGrupoId(),
					categoria.getIdCat());
		}
	}

	/**
	 * Find a single row in the findCategoriaGrupos Many To Many relationship.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param categoria
	 *            Categoria
	 * @param pagination
	 *            Pagination
	 * @return Grupo
	 */
	@Transactional(readOnly = true)
	public Grupo findCategoriaGrupos(Grupo grupo, Categoria categoria,
			Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.ID_CAT = t2.ID_CAT AND t1.GRUPO_ID=?");

		params.add(grupo.getGrupoId());

		if (categoria.getIdCat() != null) {
			where.append(" AND t2.ID_CAT = ?");
			params.add(categoria.getIdCat());
		}
		if (categoria.getCategoria() != null) {
			where.append(" AND t2.ID_CAT_PADRE = ?");
			params.add(categoria.getCategoria());
		}
		if (categoria.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(categoria.getNombreEs());
		}
		if (categoria.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(categoria.getNombreEu());
		}
		if (categoria.getFechaIniSol() != null) {
			where.append(" AND t2.FECHA_INI_SOL = ?");
			params.add(categoria.getFechaIniSol());
		}
		if (categoria.getFechaFinSol() != null) {
			where.append(" AND t2.FECHA_FIN_SOL = ?");
			params.add(categoria.getFechaFinSol());
		}
		if (categoria.getNumAsistentes() != null) {
			where.append(" AND t2.NUM_ASISTENTES = ?");
			params.add(categoria.getNumAsistentes());
		}
		if (categoria.getNumFormaciones() != null) {
			where.append(" AND t2.NUM_FORMACIONES = ?");
			params.add(categoria.getNumFormaciones());
		}
		if (categoria.getVisibleWeb() != null) {
			where.append(" AND t2.VISIBLE_WEB = ?");
			params.add(categoria.getVisibleWeb());
		}

		StringBuffer query = new StringBuffer(
				"SELECT t2.Id_cat idCat, t2.nombre_Es NOMBREES, t2.nombre_Eu NOMBREEU, t2.fecha_Ini_Sol FECHAINISOL, t2.fecha_Fin_Sol FECHAFINSOL, t2.num_Asistentes NUMASISTENTES, t2.num_Formaciones NUMFORMACIONES, t2.visible_Web VISIBLEWEB FROM Y40a04t00 t1,Y40A01T00 t2  ");
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		List<Categoria> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Categoria>() {
					public Categoria mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Categoria(resultSet.getString("IDCAT"),
								resultSet.getString("NOMBREES"), resultSet
										.getString("NOMBREEU"), resultSet
										.getDate("FECHAINISOL"), resultSet
										.getDate("FECHAFINSOL"), resultSet
										.getLong("NUMASISTENTES"), resultSet
										.getLong("NUMFORMACIONES"), resultSet
										.getString("VISIBLEWEB"), null, null,
								null, null, null);
					}
				}, params.toArray());
		grupo.setCategorias(listaHijo);
		return grupo;
	}

	/**
	 * Counts rows in the CategoriaGrupos table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param categoria
	 *            Categoria
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findCategoriaGruposCount(Grupo grupo, Categoria categoria) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.ID_CAT = t2.ID_CAT AND t1.GRUPO_ID=?");

		params.add(grupo.getGrupoId());

		if (categoria.getIdCat() != null) {
			where.append(" AND t2.ID_CAT = ?");
			params.add(categoria.getIdCat());
		}
		if (categoria.getCategoria() != null) {
			where.append(" AND t2.ID_CAT_PADRE = ?");
			params.add(categoria.getCategoria());
		}
		if (categoria.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(categoria.getNombreEs());
		}
		if (categoria.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(categoria.getNombreEu());
		}
		if (categoria.getFechaIniSol() != null) {
			where.append(" AND t2.FECHA_INI_SOL = ?");
			params.add(categoria.getFechaIniSol());
		}
		if (categoria.getFechaFinSol() != null) {
			where.append(" AND t2.FECHA_FIN_SOL = ?");
			params.add(categoria.getFechaFinSol());
		}
		if (categoria.getNumAsistentes() != null) {
			where.append(" AND t2.NUM_ASISTENTES = ?");
			params.add(categoria.getNumAsistentes());
		}
		if (categoria.getNumFormaciones() != null) {
			where.append(" AND t2.NUM_FORMACIONES = ?");
			params.add(categoria.getNumFormaciones());
		}
		if (categoria.getVisibleWeb() != null) {
			where.append(" AND t2.VISIBLE_WEB = ?");
			params.add(categoria.getVisibleWeb());
		}

		StringBuffer query = new StringBuffer(
				"SELECT count(1) FROM Y40a04t00 t1,Y40A01T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long countEntidadesOFE(Y40aGrupoTree y40aGrupoTree) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND tt1.ENTIDAD_ID= tt2.ENTIDAD_ID AND tt2.GRUPO_ID = tt3.GRUPO_ID AND tt2.grupo_id=? AND tt3.ACTIVA = ? AND tt1.ACTIVA = ? AND tt1.ISOFERTAFORM=? ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM ENTIDAD tt1, GRUPO_ENTIDAD tt2, GRUPO tt3   ");

		params.add(y40aGrupoTree.getGrupoId());
		params.add(Y40aConstantes.SI);
		params.add(Y40aConstantes.SI);
		params.add(Y40aConstantes.SI);

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
