package com.ejie.y40a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.Grupo;
import com.ejie.y40a.model.Y40aGrupoTree;

/**
 * * GrupoDao  
 * 
 *  
 */

public interface GrupoDao {

	/**
	 * Inserts a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Grupo
	 */
	Grupo add(Grupo grupo);

	/**
	 * Updates a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Grupo
	 */
	Grupo update(Grupo grupo);

	/**
	 * Finds a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Grupo
	 */
	Grupo find(Grupo grupo);

	/**
	 * Deletes a single row in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return
	 */
	void remove(Grupo grupo);

	/**
	 * Finds a List of rows in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Grupo> findAll(Grupo grupo, Pagination pagination);

	/**
	 * Counts rows in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return List
	 */
	Long findAllCount(Grupo grupo);

	/**
	 * Finds a List of rows in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param idCategoria
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Grupo> findAllGruposCategoria(Grupo grupo, String idCategoria,
			Pagination pagination);

	/**
	 * Finds rows in the Grupo table using like.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Grupo> findAllLike(Grupo grupo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Inserts a single row in the CategoriaGrupos table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Grupo
	 */
	Grupo addCategoriaGrupos(Grupo grupo);

	/**
	 * Deletes a single row in the CategoriaGrupos table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return
	 */
	void removeCategoriaGrupos(Grupo grupo);

	/**
	 * Find a single row in the findCategoriaGrupos Many To Many relationship.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param categoria
	 *            Categoria
	 * @param pagination
	 *            Pagination
	 * @return Grupo
	 */
	Grupo findCategoriaGrupos(Grupo grupo, Categoria categoria,
			Pagination pagination);

	/**
	 * Counts rows rows in the CategoriaGrupos table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @param categoria
	 *            Categoria
	 * @return Long
	 */
	Long findCategoriaGruposCount(Grupo grupo, Categoria categoria);

	/**
	 * Counts rows in the Grupo table.
	 * 
	 * @param grupo
	 *            Grupo
	 * @return Long
	 */
	Long countEntidadesOFE(Y40aGrupoTree y40aGrupoTree);
}
