package com.ejie.y40a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.Etiqueta;
import com.ejie.y40a.model.Formacion;
import com.ejie.y40a.model.FormacionBusqueda;
import com.ejie.y40a.utils.Y40aUtils;

/**
 * * FormacionDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class FormacionDaoImpl implements FormacionDao {
	private SimpleJdbcTemplate jdbcTemplate;

	private RowMapper<Formacion> rwMap = new RowMapper<Formacion>() {
		public Formacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			List<String> columnasSeleccionadas = Y40aUtils
					.cargarDatosBDVO(resultSet);

			Formacion formacion = new Formacion(resultSet.getString("IDFOR"),
					resultSet.getString("NOMBREES"),
					resultSet.getString("NOMBREEU"),
					resultSet.getString("NOMBRECORTOES"),
					resultSet.getString("NOMBRECORTOEU"),
					resultSet.getString("DESCRIPCIONES"),
					resultSet.getString("DESCRIPCIONEU"),
					resultSet.getString("VISIBLEWEB"),
					resultSet.getString("NUEVA"), new Categoria(
							resultSet.getString("CategoriaIDCAT"),
							resultSet.getString("CategoriaNOMBREES"),
							resultSet.getString("CategoriaNOMBREEU"),
							resultSet.getDate("CategoriaFECHAINISOL"),
							resultSet.getDate("CategoriaFECHAFINSOL"),
							resultSet.getLong("CategoriaNUMASISTENTES"),
							resultSet.getLong("CategoriaNUMFORMACIONES"),
							resultSet.getString("CategoriaVISIBLEWEB"),
							new Categoria(resultSet
									.getString("CategoriaIDCATPADRE"), null,
									null, null, null, null, null, null, null,
									null, null, null, null)));

			formacion.setVisibleContactoCat((columnasSeleccionadas
					.contains("VISIBLECONTACTO")) ? resultSet
					.getString("VISIBLECONTACTO") : null);

			return formacion;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Pagination
	 * @return Formacion
	 */
	public Formacion add(Formacion formacion) {

		String query = "INSERT INTO FORMACION( ID_FOR,ID_CAT,NOMBRE_ES,NOMBRE_EU,NOMBRE_CORTO_ES,NOMBRE_CORTO_EU,DESCRIPCION_ES,DESCRIPCION_EU,VISIBLE_WEB,NUEVA)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?)";

		Object getCategoriaIdCatAux = null;
		if (formacion.getCategoria() != null
				&& formacion.getCategoria().getIdCat() != null) {
			getCategoriaIdCatAux = formacion.getCategoria().getIdCat();
		}
		this.jdbcTemplate.update(query, formacion.getIdFor(),
				getCategoriaIdCatAux, formacion.getNombreEs(),
				formacion.getNombreEu(), formacion.getNombreCortoEs(),
				formacion.getNombreCortoEu(), formacion.getDescripcionEs(),
				formacion.getDescripcionEu(), formacion.getVisibleWeb(),
				formacion.getNueva());
		return formacion;
	}

	/**
	 * Updates a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Pagination
	 * @return Formacion
	 */
	public Formacion update(Formacion formacion) {
		String query = "UPDATE FORMACION SET ID_CAT=?,NOMBRE_ES=?,NOMBRE_EU=?,NOMBRE_CORTO_ES=?,NOMBRE_CORTO_EU=?,DESCRIPCION_ES=?,DESCRIPCION_EU=?,NUEVA=? WHERE ID_FOR=?";
		Object getCategoriaIdCatAux = null;
		if (formacion.getCategoria() != null
				&& formacion.getCategoria().getIdCat() != null) {
			getCategoriaIdCatAux = formacion.getCategoria().getIdCat();
		}
		this.jdbcTemplate.update(query, getCategoriaIdCatAux,
				formacion.getNombreEs(), formacion.getNombreEu(),
				formacion.getNombreCortoEs(), formacion.getNombreCortoEu(),
				formacion.getDescripcionEs(), formacion.getDescripcionEu(),
				formacion.getNueva(), formacion.getIdFor());
		return formacion;
	}

	/**
	 * Updates a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Pagination
	 * @return Formacion
	 */
	public Formacion updateVisibleWeb(Formacion formacion) {
		String query = "UPDATE FORMACION SET VISIBLE_WEB=? WHERE ID_FOR=?";
		this.jdbcTemplate.update(query, formacion.getVisibleWeb(),
				formacion.getIdFor());
		return formacion;
	}

	/**
	 * Finds a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Pagination
	 * @return Formacion
	 */
	@Transactional(readOnly = true)
	public Formacion find(Formacion formacion) {
		String query = "SELECT t1.ID_FOR IDFOR, t1.NOMBRE_ES NOMBREES, t1.NOMBRE_EU NOMBREEU, t1.NOMBRE_CORTO_ES NOMBRECORTOES, t1.NOMBRE_CORTO_EU NOMBRECORTOEU, t1.DESCRIPCION_ES DESCRIPCIONES, t1.DESCRIPCION_EU DESCRIPCIONEU, t1.VISIBLE_WEB VISIBLEWEB, t2.ID_CAT CATEGORIAIDCAT, t2.NOMBRE_ES CATEGORIANOMBREES, t2.NOMBRE_EU CATEGORIANOMBREEU, t2.FECHA_INI_SOL CATEGORIAFECHAINISOL, t2.FECHA_FIN_SOL CATEGORIAFECHAFINSOL, t2.NUM_ASISTENTES CATEGORIANUMASISTENTES, t2.NUM_FORMACIONES CATEGORIANUMFORMACIONES, t2.VISIBLE_WEB CATEGORIAVISIBLEWEB, t2.ID_CAT_PADRE CATEGORIAIDCATPADRE, t2.VISIBLECONTACTO VISIBLECONTACTO, t1.NUEVA NUEVA "
				+ "FROM FORMACION t1 , CATEGORIA t2  "
				+ "WHERE t1.ID_FOR = ?   AND t1.ID_CAT= t2.ID_CAT(+)  ";
		return (Formacion) this.jdbcTemplate.queryForObject(query, rwMap,
				formacion.getIdFor());
	}

	/**
	 * Removes a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Pagination
	 * @return
	 */
	public void remove(Formacion formacion) {
		String query = "DELETE  FROM FORMACION WHERE ID_FOR=?";
		this.jdbcTemplate.update(query, formacion.getIdFor());
	}

	/**
	 * Finds a List of rows in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Formacion> findAll(Formacion formacion, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ID_CAT= t2.ID_CAT(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_FOR IDFOR,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.NOMBRE_CORTO_ES NOMBRECORTOES, t1.NOMBRE_CORTO_EU NOMBRECORTOEU,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EU DESCRIPCIONEU,t1.VISIBLE_WEB VISIBLEWEB,t1.NUEVA NUEVA,t2.ID_CAT CATEGORIAIDCAT,t2.NOMBRE_ES CATEGORIANOMBREES,t2.NOMBRE_EU CATEGORIANOMBREEU,t2.FECHA_INI_SOL CATEGORIAFECHAINISOL,t2.FECHA_FIN_SOL CATEGORIAFECHAFINSOL,t2.NUM_ASISTENTES CATEGORIANUMASISTENTES,t2.NUM_FORMACIONES CATEGORIANUMFORMACIONES,t2.VISIBLE_WEB CATEGORIAVISIBLEWEB,t2.ID_CAT_PADRE CATEGORIAIDCATPADRE "
						+ "FROM FORMACION t1 ,CATEGORIA t2 ");

		if (formacion != null && formacion.getIdFor() != null) {
			where.append(" AND t1.ID_FOR = ?");
			params.add(formacion.getIdFor());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getIdCat() != null) {
			where.append(" AND t2.ID_CAT = ?");
			params.add(formacion.getCategoria().getIdCat());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getCategoria() != null
				&& formacion.getCategoria().getCategoria().getIdCat() != null) {
			where.append(" AND t2.ID_CAT_PADRE = ?");
			params.add(formacion.getCategoria().getCategoria().getIdCat());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(formacion.getCategoria().getNombreEs());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(formacion.getCategoria().getNombreEu());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getFechaIniSol() != null) {
			where.append(" AND t2.FECHA_INI_SOL = ?");
			params.add(formacion.getCategoria().getFechaIniSol());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getFechaFinSol() != null) {
			where.append(" AND t2.FECHA_FIN_SOL = ?");
			params.add(formacion.getCategoria().getFechaFinSol());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getNumAsistentes() != null) {
			where.append(" AND t2.NUM_ASISTENTES = ?");
			params.add(formacion.getCategoria().getNumAsistentes());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getNumFormaciones() != null) {
			where.append(" AND t2.NUM_FORMACIONES = ?");
			params.add(formacion.getCategoria().getNumFormaciones());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getVisibleWeb() != null) {
			where.append(" AND t2.VISIBLE_WEB = ?");
			params.add(formacion.getCategoria().getVisibleWeb());
		}
		if (formacion != null && formacion.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(formacion.getNombreEs());
		}
		if (formacion != null && formacion.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(formacion.getNombreEu());
		}
		if (formacion != null && formacion.getNombreCortoEs() != null) {
			where.append(" AND t1.NOMBRE_CORTO_ES = ?");
			params.add(formacion.getNombreCortoEs());
		}
		if (formacion != null && formacion.getNombreCortoEu() != null) {
			where.append(" AND t1.NOMBRE_CORTO_EU = ?");
			params.add(formacion.getNombreCortoEu());
		}
		if (formacion != null && formacion.getDescripcionEs() != null) {
			where.append(" AND t1.DESCRIPCION_ES = ?");
			params.add(formacion.getDescripcionEs());
		}
		if (formacion != null && formacion.getDescripcionEu() != null) {
			where.append(" AND t1.DESCRIPCION_EU = ?");
			params.add(formacion.getDescripcionEu());
		}
		if (formacion != null && formacion.getVisibleWeb() != null) {
			where.append(" AND t1.VISIBLE_WEB = ?");
			params.add(formacion.getVisibleWeb());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Formacion>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Formacion formacion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.ID_CAT= t2.ID_CAT(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  FORMACION t1   ,  CATEGORIA t2  ");
		if (formacion != null && formacion.getIdFor() != null) {
			where.append(" AND t1.ID_FOR = ?");
			params.add(formacion.getIdFor());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getIdCat() != null) {
			where.append(" AND t2.ID_CAT = ?");
			params.add(formacion.getCategoria().getIdCat());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getCategoria() != null
				&& formacion.getCategoria().getCategoria().getIdCat() != null) {
			where.append(" AND t2.ID_CAT_PADRE = ?");
			params.add(formacion.getCategoria().getCategoria().getIdCat());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(formacion.getCategoria().getNombreEs());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(formacion.getCategoria().getNombreEu());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getFechaIniSol() != null) {
			where.append(" AND t2.FECHA_INI_SOL = ?");
			params.add(formacion.getCategoria().getFechaIniSol());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getFechaFinSol() != null) {
			where.append(" AND t2.FECHA_FIN_SOL = ?");
			params.add(formacion.getCategoria().getFechaFinSol());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getNumAsistentes() != null) {
			where.append(" AND t2.NUM_ASISTENTES = ?");
			params.add(formacion.getCategoria().getNumAsistentes());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getNumFormaciones() != null) {
			where.append(" AND t2.NUM_FORMACIONES = ?");
			params.add(formacion.getCategoria().getNumFormaciones());
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getVisibleWeb() != null) {
			where.append(" AND t2.VISIBLE_WEB = ?");
			params.add(formacion.getCategoria().getVisibleWeb());
		}
		if (formacion != null && formacion.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(formacion.getNombreEs());
		}
		if (formacion != null && formacion.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(formacion.getNombreEu());
		}
		if (formacion != null && formacion.getNombreCortoEs() != null) {
			where.append(" AND t1.NOMBRE_CORTO_ES = ?");
			params.add(formacion.getNombreCortoEs());
		}
		if (formacion != null && formacion.getNombreCortoEu() != null) {
			where.append(" AND t1.NOMBRE_CORTO_EU = ?");
			params.add(formacion.getNombreCortoEu());
		}
		if (formacion != null && formacion.getDescripcionEs() != null) {
			where.append(" AND t1.DESCRIPCION_ES = ?");
			params.add(formacion.getDescripcionEs());
		}
		if (formacion != null && formacion.getDescripcionEu() != null) {
			where.append(" AND t1.DESCRIPCION_EU = ?");
			params.add(formacion.getDescripcionEu());
		}
		if (formacion != null && formacion.getVisibleWeb() != null) {
			where.append(" AND t1.VISIBLE_WEB = ?");
			params.add(formacion.getVisibleWeb());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Formacion table using like.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Formacion> findAllLike(Formacion formacion,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ID_CAT= t2.ID_CAT(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_FOR IDFOR,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.NOMBRE_CORTO_ES NOMBRECORTOES, t1.NOMBRE_CORTO_EU NOMBRECORTOEU,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EU DESCRIPCIONEU,t1.VISIBLE_WEB VISIBLEWEB,t2.ID_CAT CATEGORIAIDCAT,t2.NOMBRE_ES CATEGORIANOMBREES,t2.NOMBRE_EU CATEGORIANOMBREEU,t2.FECHA_INI_SOL CATEGORIAFECHAINISOL,t2.FECHA_FIN_SOL CATEGORIAFECHAFINSOL,t2.NUM_ASISTENTES CATEGORIANUMASISTENTES,t2.NUM_FORMACIONES CATEGORIANUMFORMACIONES,t2.VISIBLE_WEB CATEGORIAVISIBLEWEB,t2.ID_CAT_PADRE CATEGORIAIDCATPADRE "
						+ "FROM FORMACION t1 ,CATEGORIA t2 ");

		if (formacion != null && formacion.getIdFor() != null) {
			where.append(" AND UPPER(t1.ID_FOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getIdFor().toUpperCase() + "%");
			} else {
				params.add("%" + formacion.getIdFor().toUpperCase() + "%");
			}
			where.append(" AND t1.ID_FOR IS NOT NULL");
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getIdCat() != null) {
			where.append(" AND t2.ID_CAT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getCategoria().getIdCat() + "%");
			} else {
				params.add("%" + formacion.getCategoria().getIdCat() + "%");
			}
			where.append(" AND t2.ID_CAT IS NOT NULL");
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getCategoria() != null
				&& formacion.getCategoria().getCategoria().getIdCat() != null) {
			where.append(" AND UPPER(t2.ID_CAT_PADRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getCategoria().getCategoria().getIdCat()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ formacion.getCategoria().getCategoria().getIdCat()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ID_CAT_PADRE IS NOT NULL");
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getNombreEs() != null) {
			where.append(" AND UPPER(t2.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getCategoria().getNombreEs().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ formacion.getCategoria().getNombreEs().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.NOMBRE_ES IS NOT NULL");
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getNombreEu() != null) {
			where.append(" AND UPPER(t2.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getCategoria().getNombreEu().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ formacion.getCategoria().getNombreEu().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.NOMBRE_EU IS NOT NULL");
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getFechaIniSol() != null) {
			where.append(" AND t2.FECHA_INI_SOL like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getCategoria().getFechaIniSol() + "%");
			} else {
				params.add("%" + formacion.getCategoria().getFechaIniSol()
						+ "%");
			}
			where.append(" AND t2.FECHA_INI_SOL IS NOT NULL");
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getFechaFinSol() != null) {
			where.append(" AND t2.FECHA_FIN_SOL like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getCategoria().getFechaFinSol() + "%");
			} else {
				params.add("%" + formacion.getCategoria().getFechaFinSol()
						+ "%");
			}
			where.append(" AND t2.FECHA_FIN_SOL IS NOT NULL");
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getNumAsistentes() != null) {
			where.append(" AND t2.NUM_ASISTENTES like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getCategoria().getNumAsistentes() + "%");
			} else {
				params.add("%" + formacion.getCategoria().getNumAsistentes()
						+ "%");
			}
			where.append(" AND t2.NUM_ASISTENTES IS NOT NULL");
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getNumFormaciones() != null) {
			where.append(" AND t2.NUM_FORMACIONES like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getCategoria().getNumFormaciones() + "%");
			} else {
				params.add("%" + formacion.getCategoria().getNumFormaciones()
						+ "%");
			}
			where.append(" AND t2.NUM_FORMACIONES IS NOT NULL");
		}
		if (formacion != null && formacion.getCategoria() != null
				&& formacion.getCategoria().getVisibleWeb() != null) {
			where.append(" AND UPPER(t2.VISIBLE_WEB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getCategoria().getVisibleWeb()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ formacion.getCategoria().getVisibleWeb()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.VISIBLE_WEB IS NOT NULL");
		}
		if (formacion != null && formacion.getNombreEs() != null) {
			where.append(" AND UPPER(t1.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getNombreEs().toUpperCase() + "%");
			} else {
				params.add("%" + formacion.getNombreEs().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (formacion != null && formacion.getNombreEu() != null) {
			where.append(" AND UPPER(t1.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getNombreEu().toUpperCase() + "%");
			} else {
				params.add("%" + formacion.getNombreEu().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (formacion != null && formacion.getNombreCortoEs() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CORTO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getNombreCortoEs().toUpperCase() + "%");
			} else {
				params.add("%" + formacion.getNombreCortoEs().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_CORTO_ES IS NOT NULL");
		}
		if (formacion != null && formacion.getNombreCortoEu() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CORTO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getNombreCortoEu().toUpperCase() + "%");
			} else {
				params.add("%" + formacion.getNombreCortoEu().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_CORTO_EU IS NOT NULL");
		}
		if (formacion != null && formacion.getDescripcionEs() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getDescripcionEs().toUpperCase() + "%");
			} else {
				params.add("%" + formacion.getDescripcionEs().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESCRIPCION_ES IS NOT NULL");
		}
		if (formacion != null && formacion.getDescripcionEu() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getDescripcionEu().toUpperCase() + "%");
			} else {
				params.add("%" + formacion.getDescripcionEu().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESCRIPCION_EU IS NOT NULL");
		}
		if (formacion != null && formacion.getVisibleWeb() != null) {
			where.append(" AND UPPER(t1.VISIBLE_WEB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacion.getVisibleWeb().toUpperCase() + "%");
			} else {
				params.add("%" + formacion.getVisibleWeb().toUpperCase() + "%");
			}
			where.append(" AND t1.VISIBLE_WEB IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Formacion>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Formacion table using like.
	 * 
	 * @param formacionBusqueda
	 *            FormacionBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<FormacionBusqueda> findAllLikeFormacion(
			FormacionBusqueda formacionBusqueda, Vector<String> perfiles,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ID_CAT= t2.ID_CAT(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_FOR IDFOR,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.NOMBRE_CORTO_ES NOMBRECORTOES, t1.NOMBRE_CORTO_EU NOMBRECORTOEU,t1.DESCRIPCION_ES DESCRIPCIONES,t1.DESCRIPCION_EU DESCRIPCIONEU,t1.VISIBLE_WEB VISIBLEWEB,t1.NUEVA NUEVA,t2.ID_CAT CATEGORIAIDCAT,t2.NOMBRE_ES CATEGORIANOMBREES,t2.NOMBRE_EU CATEGORIANOMBREEU,t2.FECHA_INI_SOL CATEGORIAFECHAINISOL,t2.FECHA_FIN_SOL CATEGORIAFECHAFINSOL,t2.NUM_ASISTENTES CATEGORIANUMASISTENTES,t2.NUM_FORMACIONES CATEGORIANUMFORMACIONES,t2.VISIBLE_WEB CATEGORIAVISIBLEWEB,t2.ID_CAT_PADRE CATEGORIAIDCATPADRE "
						+ "FROM FORMACION t1 ,CATEGORIA t2 ");

		if (formacionBusqueda != null && formacionBusqueda.getIdCat() != null) {
			where.append(" AND ( ");

			boolean firstElement = true;

			for (Categoria e : formacionBusqueda.getCategorias()) {

				if (firstElement) {
					where.append("t2.ID_CAT = '").append(e.getIdCat())
							.append("'");
					firstElement = false;
				} else {
					where.append(" OR t2.ID_CAT = '").append(e.getIdCat())
							.append("'");
				}
			}

			where.append(") ");
		} else {
			if (perfiles != null && perfiles.size() > 0) {
				where.append(" AND t2.ID_CAT IN ( ");
				where.append(" SELECT  distinct tt1.ID_CAT IDCAT FROM CATEGORIA tt1, CATEGORIA_PERFIL tt2 WHERE 1=1 AND tt1.ID_CAT = tt2.ID_CAT(+) AND tt2.ID_PERFIL IN ( ");

				boolean firstElement = true;
				for (String idPerfilAux : perfiles) {

					if (firstElement) {

						where.append("?");
						params.add(idPerfilAux);
						firstElement = false;

					} else {

						where.append(",?");
						params.add(idPerfilAux);
					}
				}

				where.append(") ) ");
			}
		}

		if (formacionBusqueda != null && formacionBusqueda.getNombre() != null) {
			where.append(" AND (UPPER(t1.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacionBusqueda.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + formacionBusqueda.getNombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");

			where.append(" OR UPPER(t1.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacionBusqueda.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + formacionBusqueda.getNombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL)");
		}

		/*
		 * Colección de etiquetas a las que pueden pertenecer las formaciones
		 */
		if (formacionBusqueda != null
				&& formacionBusqueda.getEtiquetas() != null
				&& formacionBusqueda.getEtiquetas().size() > 0) {

			where.append(" AND t1.ID_FOR IN (SELECT ID_FOR FROM FORMACION_ETIQUETA WHERE ");
			boolean firstElement = true;

			for (Etiqueta e : formacionBusqueda.getEtiquetas()) {

				if (firstElement) {

					where.append("ID_ETIQUETA = ?");
					params.add(e.getIdEtiqueta());
					firstElement = false;

				} else {

					where.append(" OR ID_ETIQUETA = ?");
					params.add(e.getIdEtiqueta());
				}
			}

			where.append(") ");
		}

		if (formacionBusqueda != null
				&& formacionBusqueda.getMostrarOcultasWeb() != null) {
			where.append(" AND t1.VISIBLE_WEB = ?");
			params.add(Y40aConstantes.SI);
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<FormacionBusqueda>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<FormacionBusqueda>() {
					public FormacionBusqueda mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new FormacionBusqueda(resultSet
								.getString("IDFOR"), resultSet
								.getString("CategoriaIDCAT"), resultSet
								.getString("CategoriaNOMBREES"), resultSet
								.getString("CategoriaNOMBREEU"), null,
								resultSet.getString("NOMBREES"), resultSet
										.getString("NOMBREEU"), resultSet
										.getString("NOMBRECORTOES"), resultSet
										.getString("NOMBRECORTOEU"), resultSet
										.getString("DESCRIPCIONES"), resultSet
										.getString("DESCRIPCIONEU"), resultSet
										.getString("VISIBLEWEB"), null, null,
								resultSet.getString("NUEVA"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the Formacion table.
	 * 
	 * @param formacionBusqueda
	 *            FormacionBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeFormacionCount(FormacionBusqueda formacionBusqueda,
			Vector<String> perfiles, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ID_CAT= t2.ID_CAT(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  COUNT(1) FROM FORMACION t1 ,CATEGORIA t2 ");

		if (formacionBusqueda != null && formacionBusqueda.getIdCat() != null) {
			where.append(" AND ( ");

			boolean firstElement = true;

			for (Categoria e : formacionBusqueda.getCategorias()) {
				if (firstElement) {
					where.append("t2.ID_CAT = '").append(e.getIdCat())
							.append("'");
					firstElement = false;
				} else {
					where.append(" OR t2.ID_CAT = '").append(e.getIdCat())
							.append("'");
				}
			}

			where.append(") ");
		} else {
			if (perfiles != null && perfiles.size() > 0) {
				where.append(" AND t2.ID_CAT IN ( ");
				where.append(" SELECT  distinct tt1.ID_CAT IDCAT FROM CATEGORIA tt1, CATEGORIA_PERFIL tt2 WHERE 1=1 AND tt1.ID_CAT = tt2.ID_CAT(+) AND tt2.ID_PERFIL IN ( ");

				boolean firstElement = true;
				for (String idPerfilAux : perfiles) {

					if (firstElement) {

						where.append("?");
						params.add(idPerfilAux);
						firstElement = false;

					} else {

						where.append(",?");
						params.add(idPerfilAux);
					}
				}

				where.append(") ) ");
			}
		}

		if (formacionBusqueda != null && formacionBusqueda.getNombre() != null) {
			where.append(" AND (UPPER(t1.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacionBusqueda.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + formacionBusqueda.getNombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");

			where.append(" OR UPPER(t1.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(formacionBusqueda.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + formacionBusqueda.getNombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL)");
		}

		/*
		 * Colección de etiquetas a las que pueden pertenecer las formaciones
		 */
		if (formacionBusqueda != null
				&& formacionBusqueda.getEtiquetas() != null
				&& formacionBusqueda.getEtiquetas().size() > 0) {

			where.append(" AND t1.ID_FOR IN (SELECT ID_FOR FROM FORMACION_ETIQUETA WHERE ");
			boolean firstElement = true;

			for (Etiqueta e : formacionBusqueda.getEtiquetas()) {

				if (firstElement) {

					where.append("ID_ETIQUETA = ?");
					params.add(e.getIdEtiqueta());
					firstElement = false;

				} else {

					where.append(" OR ID_ETIQUETA = ?");
					params.add(e.getIdEtiqueta());
				}
			}

			where.append(") ");
		}

		if (formacionBusqueda != null
				&& formacionBusqueda.getMostrarOcultasWeb() != null) {
			where.append(" AND t1.VISIBLE_WEB = ?");
			params.add(Y40aConstantes.SI);
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Formacion table.
	 * 
	 * @param formacionBusqueda
	 *            FormacionBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllNameFormacionCount(FormacionBusqueda formacionBusqueda) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ID_CAT= t2.ID_CAT(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  COUNT(1) FROM FORMACION t1 ,CATEGORIA t2 ");

		if (formacionBusqueda != null && formacionBusqueda.getIdFor() != null) {
			where.append(" AND t1.ID_FOR <> ?");
			params.add(formacionBusqueda.getIdFor());
		}

		if (formacionBusqueda != null && formacionBusqueda.getIdCat() != null) {
			where.append(" AND t2.ID_CAT = ?");
			params.add(formacionBusqueda.getIdCat());
		}

		if (formacionBusqueda != null
				&& formacionBusqueda.getNombreEs() != null) {
			where.append(" AND UPPER(t1.NOMBRE_ES) = ?");
			params.add(formacionBusqueda.getNombreEs().toUpperCase());
		}

		if (formacionBusqueda != null
				&& formacionBusqueda.getNombreEu() != null) {
			where.append(" AND UPPER(t1.NOMBRE_EU) = ?");
			params.add(formacionBusqueda.getNombreEu().toUpperCase());
		}

		if (formacionBusqueda != null
				&& formacionBusqueda.getNombreCortoEs() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CORTO_ES) = ?");
			params.add(formacionBusqueda.getNombreCortoEs().toUpperCase());
		}

		if (formacionBusqueda != null
				&& formacionBusqueda.getNombreCortoEu() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CORTO_EU) = ?");
			params.add(formacionBusqueda.getNombreCortoEu().toUpperCase());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Inserts a single row in the FormacionEtiqueta table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Formacion
	 */
	public Formacion addFormacionEtiqueta(Formacion formacion) {
		String query = "INSERT INTO Y40A08T00 " + "( ID_FOR,ID_ETIQUETA) "
				+ " values (?, ?)";

		List<Etiqueta> auxiliarEtiqueta = formacion.getEtiquetas();
		Iterator<Etiqueta> it = auxiliarEtiqueta.iterator();
		while (it.hasNext()) {
			Etiqueta etiqueta = (Etiqueta) it.next();
			this.jdbcTemplate.update(query, formacion.getIdFor(),
					etiqueta.getIdEtiqueta());
		}
		return formacion;
	}

	/**
	 * Deletes a single row in the FormacionEtiqueta table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return
	 */
	public void removeFormacionEtiqueta(Formacion formacion) {
		String query = "DELETE  FROM Y40A08T00 "
				+ " WHERE ID_FOR=? AND ID_ETIQUETA=?";
		List<Etiqueta> auxiliarEtiqueta = formacion.getEtiquetas();
		Iterator<Etiqueta> it = auxiliarEtiqueta.iterator();
		while (it.hasNext()) {
			Etiqueta etiqueta = (Etiqueta) it.next();
			this.jdbcTemplate.update(query, formacion.getIdFor(),
					etiqueta.getIdEtiqueta());
		}
	}

	/**
	 * Deletes a single row in the FormacionEtiqueta table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return
	 */
	public void removeAllFormacionEtiqueta(Formacion formacion) {
		String query = "DELETE  FROM Y40A08T00 " + " WHERE ID_FOR=? ";
		this.jdbcTemplate.update(query, formacion.getIdFor());
	}

	/**
	 * Find a single row in the findFormacionEtiqueta Many To Many relationship.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return Formacion
	 */
	@Transactional(readOnly = true)
	public Formacion findFormacionEtiqueta(Formacion formacion,
			Etiqueta etiqueta, Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.ID_ETIQUETA = t2.ID_ETIQUETA AND t1.ID_FOR=?");

		params.add(formacion.getIdFor());

		if (etiqueta != null && etiqueta.getIdEtiqueta() != null) {
			where.append(" AND t2.ID_ETIQUETA = ?");
			params.add(etiqueta.getIdEtiqueta());
		}
		if (etiqueta != null && etiqueta.getNombre() != null) {
			where.append(" AND t2.NOMBRE = ?");
			params.add(etiqueta.getNombre());
		}

		StringBuffer query = new StringBuffer(
				"SELECT t2.Id_etiqueta idEtiqueta, t2.NOMBRE NOMBRE FROM Y40a08t00 t1,Y40A07T00 t2  ");
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		List<Etiqueta> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Etiqueta>() {
					public Etiqueta mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Etiqueta(resultSet.getString("IDETIQUETA"),
								resultSet.getString("NOMBRE"), null, null);
					}
				}, params.toArray());
		formacion.setEtiquetas(listaHijo);
		return formacion;
	}

	/**
	 * Counts rows in the FormacionEtiqueta table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param etiqueta
	 *            Etiqueta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findFormacionEtiquetaCount(Formacion formacion,
			Etiqueta etiqueta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.ID_ETIQUETA = t2.ID_ETIQUETA AND t1.ID_FOR=?");

		params.add(formacion.getIdFor());

		if (etiqueta.getIdEtiqueta() != null) {
			where.append(" AND t2.ID_ETIQUETA = ?");
			params.add(etiqueta.getIdEtiqueta());
		}
		if (etiqueta.getNombre() != null) {
			where.append(" AND t2.NOMBRE = ?");
			params.add(etiqueta.getNombre());
		}

		StringBuffer query = new StringBuffer(
				"SELECT count(1) FROM Y40a08t00 t1,Y40A07T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Devuelve el numero de solicitudes de una formacion.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return
	 */
	@Transactional(readOnly = true)
	public Long findFormacionSolicitudCount(Formacion formacion) {

		StringBuffer where = new StringBuffer();
		List<Object> params = new ArrayList<Object>();
		where.append("where ID_FOR = ?");
		params.add(formacion.getIdFor());

		StringBuffer query = new StringBuffer("SELECT count(1) FROM SOLICITUD ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}// end findFormacionSolicitudCount

	/**
	 * Busca todas las etiquetas asociadas a una formacion.
	 * 
	 * @param formacion
	 *            Formacion objeto con la informacion de la formacion
	 * @return List<Object> con toda la informacion
	 */
	@Transactional(readOnly = true)
	public List<Object> buscaFormacionEtiqueta(Formacion formacion) {

		String sql = "select ID_ETIQUETA from FORMACION_ETIQUETA where ID_FOR = ?";
		List<Object> params = new ArrayList<Object>();
		params.add(formacion.getIdFor());
		List<Object> lstPerfil = this.jdbcTemplate.query(sql, rwMapObjE,
				params.toArray());

		return lstPerfil;
	}// end buscaFormacionEtiqueta

	private RowMapper<Object> rwMapObjE = new RowMapper<Object>() {
		public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
			// String id = rs.getString("ID_FOR");
			// return id;
			return rs.getString("ID_ETIQUETA");
		}
	};

	/**
	 * Guarda una etiqueta para una categoria en la tabla FORMACION_ETIQUETA
	 * (Y40A08T00).
	 * 
	 * @param idFormacion
	 *            String con el identificador de la formacion
	 * @param idEtiqueta
	 *            String con el identificador de la etiqueta
	 */
	public void copiaFormacionEtiqueta(String idFormacion, String idEtiqueta) {

		String sql = "insert into Y40A08T00 values(?, ?)";
		List<Object> params = new ArrayList<Object>();
		params.add(idFormacion);
		params.add(idEtiqueta);
		this.jdbcTemplate.update(sql, params.toArray());
	}// end copiaFormacionEtiqueta

}
