package com.ejie.y40a.dao;

import java.util.List;
import java.util.Vector;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.Etiqueta;
import com.ejie.y40a.model.Formacion;
import com.ejie.y40a.model.FormacionBusqueda;

/**
 * * FormacionDao  
 * 
 *  
 */

public interface FormacionDao {

	/**
	 * Inserts a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Formacion
	 */
	Formacion add(Formacion formacion);

	/**
	 * Updates a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Formacion
	 */
	Formacion update(Formacion formacion);

	/**
	 * Updates a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Pagination
	 * @return Formacion
	 */
	Formacion updateVisibleWeb(Formacion formacion);

	/**
	 * Finds a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Formacion
	 */
	Formacion find(Formacion formacion);

	/**
	 * Deletes a single row in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return
	 */
	void remove(Formacion formacion);

	/**
	 * Finds a List of rows in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Formacion> findAll(Formacion formacion, Pagination pagination);

	/**
	 * Counts rows in the Formacion table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return List
	 */
	Long findAllCount(Formacion formacion);

	/**
	 * Finds rows in the Formacion table using like.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Formacion> findAllLike(Formacion formacion, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Formacion table using like.
	 * 
	 * @param formacionBusqueda
	 *            FormacionBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<FormacionBusqueda> findAllLikeFormacion(
			FormacionBusqueda formacionBusqueda, Vector<String> perfiles,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Formacion table.
	 * 
	 * @param formacionBusqueda
	 *            FormacionBusqueda
	 * @param perfiles
	 *            Vector<String>
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeFormacionCount(FormacionBusqueda formacionBusqueda,
			Vector<String> perfiles, Boolean startsWith);

	/**
	 * Inserts a single row in the FormacionEtiqueta table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return Formacion
	 */
	Formacion addFormacionEtiqueta(Formacion formacion);

	/**
	 * Deletes a single row in the FormacionEtiqueta table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return
	 */
	void removeFormacionEtiqueta(Formacion formacion);

	/**
	 * Deletes a single row in the FormacionEtiqueta table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return
	 */
	void removeAllFormacionEtiqueta(Formacion formacion);

	/**
	 * Find a single row in the findFormacionEtiqueta Many To Many relationship.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return Formacion
	 */
	Formacion findFormacionEtiqueta(Formacion formacion, Etiqueta etiqueta,
			Pagination pagination);

	/**
	 * Counts rows rows in the FormacionEtiqueta table.
	 * 
	 * @param formacion
	 *            Formacion
	 * @param etiqueta
	 *            Etiqueta
	 * @return Long
	 */
	Long findFormacionEtiquetaCount(Formacion formacion, Etiqueta etiqueta);

	/**
	 * Counts rows in the Formacion table.
	 * 
	 * @param formacionBusqueda
	 *            FormacionBusqueda
	 * @return Long
	 */
	Long findAllNameFormacionCount(FormacionBusqueda formacionBusqueda);

	/**
	 * Devuelve el numero de solicitudes de una formacion.
	 * 
	 * @param formacion
	 *            Formacion
	 * @return
	 */
	Long findFormacionSolicitudCount(Formacion formacion);

	/**
	 * Busca todas las etiquetas asociadas a una formacion.
	 * 
	 * @param formacion
	 *            Formacion objeto con la informacion de la formacion
	 * @return List<Object> con toda la informacion
	 */
	List<Object> buscaFormacionEtiqueta(Formacion formacion);

	/**
	 * Guarda una etiqueta para una categoria en la tabla FORMACION_ETIQUETA
	 * (Y40A08T00).
	 * 
	 * @param idFormacion
	 *            String con el identificador de la formacion
	 * @param idEtiqueta
	 *            String con el identificador de la etiqueta
	 */
	void copiaFormacionEtiqueta(String idFormacion, String idEtiqueta);

}
