package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y40a.model.Formacion;
import com.ejie.y40a.model.Solicitud;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Etiqueta;

/**
 * * EtiquetaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class EtiquetaDaoImpl implements EtiquetaDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Etiqueta> rwMap = new RowMapper<Etiqueta>() {
		public Etiqueta mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Etiqueta(resultSet.getString("IDETIQUETA"),
					resultSet.getString("NOMBRE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Pagination
	 * @return Etiqueta
	 */
	public Etiqueta add(Etiqueta etiqueta) {

		String query = "INSERT INTO ETIQUETA( ID_ETIQUETA,NOMBRE)"
				+ "VALUES (?,?)";

		this.jdbcTemplate.update(query, etiqueta.getIdEtiqueta(),
				etiqueta.getNombre());
		return etiqueta;
	}

	/**
	 * Updates a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Pagination
	 * @return Etiqueta
	 */
	public Etiqueta update(Etiqueta etiqueta) {
		String query = "UPDATE ETIQUETA SET NOMBRE=? WHERE ID_ETIQUETA=?";
		this.jdbcTemplate.update(query, etiqueta.getNombre(),
				etiqueta.getIdEtiqueta());
		return etiqueta;
	}

	/**
	 * Finds a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Pagination
	 * @return Etiqueta
	 */
	@Transactional(readOnly = true)
	public Etiqueta find(Etiqueta etiqueta) {
		String query = "SELECT t1.ID_ETIQUETA IDETIQUETA, t1.NOMBRE NOMBRE "
				+ "FROM ETIQUETA t1  " + "WHERE t1.ID_ETIQUETA = ?    ";
		return (Etiqueta) this.jdbcTemplate.queryForObject(query, rwMap,
				etiqueta.getIdEtiqueta());
	}

	/**
	 * Removes a single row in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Pagination
	 * @return
	 */
	public void remove(Etiqueta etiqueta) {
		String query = "DELETE  FROM ETIQUETA WHERE ID_ETIQUETA=?";
		this.jdbcTemplate.update(query, etiqueta.getIdEtiqueta());
	}

	/**
	 * Finds a List of rows in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Etiqueta> findAll(Etiqueta etiqueta, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_ETIQUETA IDETIQUETA,t1.NOMBRE NOMBRE "
						+ "FROM ETIQUETA t1 ");

		if (etiqueta != null && etiqueta.getIdEtiqueta() != null) {
			where.append(" AND t1.ID_ETIQUETA = ?");
			params.add(etiqueta.getIdEtiqueta());
		}
		if (etiqueta != null && etiqueta.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			params.add("%" + etiqueta.getNombre().toUpperCase() + "%");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		} else {
			order.append(" ORDER BY UPPER(NOMBRE) ASC");
			query.append(order);
		}

		return (List<Etiqueta>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Etiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Etiqueta etiqueta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  ETIQUETA t1  ");
		if (etiqueta != null && etiqueta.getIdEtiqueta() != null) {
			where.append(" AND t1.ID_ETIQUETA = ?");
			params.add(etiqueta.getIdEtiqueta());
		}
		if (etiqueta != null && etiqueta.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			params.add("%" + etiqueta.getNombre().toUpperCase() + "%");
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Etiqueta table using like.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Etiqueta> findAllLike(Etiqueta etiqueta, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_ETIQUETA IDETIQUETA,t1.NOMBRE NOMBRE "
						+ "FROM ETIQUETA t1 ");

		if (etiqueta != null && etiqueta.getIdEtiqueta() != null) {
			where.append(" AND UPPER(t1.ID_ETIQUETA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(etiqueta.getIdEtiqueta().toUpperCase() + "%");
			} else {
				params.add("%" + etiqueta.getIdEtiqueta().toUpperCase() + "%");
			}
			where.append(" AND t1.ID_ETIQUETA IS NOT NULL");
		}
		if (etiqueta != null && etiqueta.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(etiqueta.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + etiqueta.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Etiqueta>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Inserts a single row in the FormacionEtiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	public Etiqueta addFormacionEtiqueta(Etiqueta etiqueta) {
		String query = "INSERT INTO Y40A08T00 " + "( ID_ETIQUETA,ID_FOR) "
				+ " values (?, ?)";

		List<Formacion> auxiliarFormacion = etiqueta.getFormacions();
		Iterator<Formacion> it = auxiliarFormacion.iterator();
		while (it.hasNext()) {
			Formacion formacion = (Formacion) it.next();
			this.jdbcTemplate.update(query, etiqueta.getIdEtiqueta(),
					formacion.getIdFor());
		}
		return etiqueta;
	}

	/**
	 * Deletes a single row in the FormacionEtiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return
	 */
	public void removeFormacionEtiqueta(Etiqueta etiqueta) {
		String query = "DELETE  FROM Y40A08T00 "
				+ " WHERE ID_ETIQUETA=? AND ID_FOR=?";
		List<Formacion> auxiliarFormacion = etiqueta.getFormacions();
		Iterator<Formacion> it = auxiliarFormacion.iterator();
		while (it.hasNext()) {
			Formacion formacion = (Formacion) it.next();
			this.jdbcTemplate.update(query, etiqueta.getIdEtiqueta(),
					formacion.getIdFor());
		}
	}

	/**
	 * Find a single row in the findFormacionEtiqueta Many To Many relationship.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param formacion
	 *            Formacion
	 * @param pagination
	 *            Pagination
	 * @return Etiqueta
	 */
	@Transactional(readOnly = true)
	public Etiqueta findFormacionEtiqueta(Etiqueta etiqueta,
			Formacion formacion, Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.ID_FOR = t2.ID_FOR AND t1.ID_ETIQUETA=?");

		params.add(etiqueta.getIdEtiqueta());

		if (formacion.getIdFor() != null) {
			where.append(" AND t2.ID_FOR = ?");
			params.add(formacion.getIdFor());
		}
		if (formacion.getCategoria() != null) {
			where.append(" AND t2.ID_CAT = ?");
			params.add(formacion.getCategoria());
		}
		if (formacion.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(formacion.getNombreEs());
		}
		if (formacion.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(formacion.getNombreEu());
		}
		if (formacion.getNombreCortoEs() != null) {
			where.append(" AND t2.NOMBRE_CORTO_ES = ?");
			params.add(formacion.getNombreCortoEs());
		}
		if (formacion.getNombreCortoEu() != null) {
			where.append(" AND t2.NOMBRE_CORTO_EU = ?");
			params.add(formacion.getNombreCortoEu());
		}
		if (formacion.getDescripcionEs() != null) {
			where.append(" AND t2.DESCRIPCION_ES = ?");
			params.add(formacion.getDescripcionEs());
		}
		if (formacion.getDescripcionEu() != null) {
			where.append(" AND t2.DESCRIPCION_EU = ?");
			params.add(formacion.getDescripcionEu());
		}
		if (formacion.getVisibleWeb() != null) {
			where.append(" AND t2.VISIBLE_WEB = ?");
			params.add(formacion.getVisibleWeb());
		}

		StringBuffer query = new StringBuffer(
				"SELECT t2.Id_for idFor, t2.nombre_Es NOMBREES, t2.nombre_Eu NOMBREEU, t2.NOMBRE_CORTO_ES NOMBRECORTOES, t2.NOMBRE_CORTO_EU NOMBRECORTOEU, t2.descripcion_Es DESCRIPCIONES, t2.descripcion_Eu DESCRIPCIONEU, t2.visible_Web VISIBLEWEB FROM Y40a08t00 t1,Y40A02T00 t2  ");
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		List<Formacion> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Formacion>() {
					public Formacion mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Formacion(resultSet.getString("IDFOR"),
								resultSet.getString("NOMBREES"), resultSet
										.getString("NOMBREEU"), resultSet
										.getString("NOMBRECORTOES"), resultSet
										.getString("NOMBRECORTOEU"), resultSet
										.getString("DESCRIPCIONES"), resultSet
										.getString("DESCRIPCIONEU"), resultSet
										.getString("VISIBLEWEB"), null, null,
								null);
					}
				}, params.toArray());
		etiqueta.setFormacions(listaHijo);
		return etiqueta;
	}

	/**
	 * Counts rows in the FormacionEtiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param formacion
	 *            Formacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findFormacionEtiquetaCount(Etiqueta etiqueta,
			Formacion formacion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.ID_FOR = t2.ID_FOR AND t1.ID_ETIQUETA=?");

		params.add(etiqueta.getIdEtiqueta());

		if (formacion.getIdFor() != null) {
			where.append(" AND t2.ID_FOR = ?");
			params.add(formacion.getIdFor());
		}
		if (formacion.getCategoria() != null) {
			where.append(" AND t2.ID_CAT = ?");
			params.add(formacion.getCategoria());
		}
		if (formacion.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(formacion.getNombreEs());
		}
		if (formacion.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(formacion.getNombreEu());
		}
		if (formacion.getNombreCortoEs() != null) {
			where.append(" AND t2.NOMBRE_CORTO_ES = ?");
			params.add(formacion.getNombreCortoEs());
		}
		if (formacion.getNombreCortoEu() != null) {
			where.append(" AND t2.NOMBRE_CORTO_EU = ?");
			params.add(formacion.getNombreCortoEu());
		}
		if (formacion.getDescripcionEs() != null) {
			where.append(" AND t2.DESCRIPCION_ES = ?");
			params.add(formacion.getDescripcionEs());
		}
		if (formacion.getDescripcionEu() != null) {
			where.append(" AND t2.DESCRIPCION_EU = ?");
			params.add(formacion.getDescripcionEu());
		}
		if (formacion.getVisibleWeb() != null) {
			where.append(" AND t2.VISIBLE_WEB = ?");
			params.add(formacion.getVisibleWeb());
		}

		StringBuffer query = new StringBuffer(
				"SELECT count(1) FROM Y40a08t00 t1,Y40A02T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Inserts a single row in the SolicitudEtiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return Etiqueta
	 */
	public Etiqueta addSolicitudEtiqueta(Etiqueta etiqueta) {
		String query = "INSERT INTO Y40A09T00 " + "( ID_ETIQUETA,ID_SOL) "
				+ " values (?, ?)";

		List<Solicitud> auxiliarSolicitud = etiqueta.getSolicituds();
		Iterator<Solicitud> it = auxiliarSolicitud.iterator();
		while (it.hasNext()) {
			Solicitud solicitud = (Solicitud) it.next();
			this.jdbcTemplate.update(query, etiqueta.getIdEtiqueta(),
					solicitud.getIdSol());
		}
		return etiqueta;
	}

	/**
	 * Deletes a single row in the SolicitudEtiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @return
	 */
	public void removeSolicitudEtiqueta(Etiqueta etiqueta) {
		String query = "DELETE  FROM Y40A09T00 "
				+ " WHERE ID_ETIQUETA=? AND ID_SOL=?";
		List<Solicitud> auxiliarSolicitud = etiqueta.getSolicituds();
		Iterator<Solicitud> it = auxiliarSolicitud.iterator();
		while (it.hasNext()) {
			Solicitud solicitud = (Solicitud) it.next();
			this.jdbcTemplate.update(query, etiqueta.getIdEtiqueta(),
					solicitud.getIdSol());
		}
	}

	/**
	 * Find a single row in the findSolicitudEtiqueta Many To Many relationship.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param solicitud
	 *            Solicitud
	 * @param pagination
	 *            Pagination
	 * @return Etiqueta
	 */
	@Transactional(readOnly = true)
	public Etiqueta findSolicitudEtiqueta(Etiqueta etiqueta,
			Solicitud solicitud, Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.ID_SOL = t2.ID_SOL AND t1.ID_ETIQUETA=?");

		params.add(etiqueta.getIdEtiqueta());

		if (solicitud.getIdSol() != null) {
			where.append(" AND t2.ID_SOL = ?");
			params.add(solicitud.getIdSol());
		}
		if (solicitud.getFormacion() != null) {
			where.append(" AND t2.ID_FOR = ?");
			params.add(solicitud.getFormacion());
		}
		if (solicitud.getEntidad() != null) {
			where.append(" AND t2.ENTIDAD_ID = ?");
			params.add(solicitud.getEntidad());
		}
		if (solicitud.getGrupo() != null) {
			where.append(" AND t2.GRUPO = ?");
			params.add(solicitud.getGrupo());
		}
		if (solicitud.getParticipantes() != null) {
			where.append(" AND t2.PARTICIPANTES = ?");
			params.add(solicitud.getParticipantes());
		}
		if (solicitud.getProvincia() != null) {
			where.append(" AND t2.PROVINCIA = ?");
			params.add(solicitud.getProvincia());
		}
		if (solicitud.getDiaImparticion() != null) {
			where.append(" AND t2.DIA_IMPARTICION = ?");
			params.add(solicitud.getDiaImparticion());
		}
		if (solicitud.getHoraInicio() != null) {
			where.append(" AND t2.HORA_INICIO = ?");
			params.add(solicitud.getHoraInicio());
		}
		if (solicitud.getHoraFin() != null) {
			where.append(" AND t2.HORA_FIN = ?");
			params.add(solicitud.getHoraFin());
		}
		// XXX
		// if (solicitud.getHorarioImparticion() != null) {
		// where.append(" AND t2.HORARIO_IMPARTICION = ?");
		// params.add(solicitud.getHorarioImparticion());
		// }
		if (solicitud.getAsistentes() != null) {
			where.append(" AND t2.ASISTENTES = ?");
			params.add(solicitud.getAsistentes());
		}
		if (solicitud.getCancelado() != null) {
			where.append(" AND t2.CANCELADO = ?");
			params.add(solicitud.getCancelado());
		}
		if (solicitud.getIdioma() != null) {
			where.append(" AND t2.IDIOMA = ?");
			params.add(solicitud.getIdioma());
		}

		StringBuffer query = new StringBuffer(
				"SELECT t2.Id_sol idSol, t2.FECHA_SOL FECHASOL, t2.GRUPO GRUPO, t2.PARTICIPANTES PARTICIPANTES, t2.PROVINCIA PROVINCIA, t2.dia_Imparticion DIAIMPARTICION, t2.hora_inicio HORAINICIO, t2.hora_fin HORAFIN, t2.ASISTENTES ASISTENTES, t2.CANCELADO CANCELADO, t2.IDIOMA IDIOMA FROM Y40a09t00 t1,Y40A03T00 t2  ");
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		List<Solicitud> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Solicitud>() {
					public Solicitud mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Solicitud(resultSet.getString("IDSOL"),
								resultSet.getDate("FECHASOL"), null, null,
								resultSet.getString("GRUPO"), resultSet
										.getLong("PARTICIPANTES"), resultSet
										.getString("PROVINCIA"), resultSet
										.getDate("DIAIMPARTICION"), resultSet
										.getString("HORAINICIO"), resultSet
										.getString("HORAFIN"), resultSet
										.getLong("ASISTENTES"), resultSet
										.getLong("NUMMUJERES"), resultSet
										.getLong("NUMHOMBRES"), resultSet
										.getString("CANCELADO"), resultSet
										.getString("IDIOMA"), null, null);
					}
				}, params.toArray());
		etiqueta.setSolicituds(listaHijo);
		return etiqueta;
	}

	/**
	 * Counts rows in the SolicitudEtiqueta table.
	 * 
	 * @param etiqueta
	 *            Etiqueta
	 * @param solicitud
	 *            Solicitud
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findSolicitudEtiquetaCount(Etiqueta etiqueta,
			Solicitud solicitud) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.ID_SOL = t2.ID_SOL AND t1.ID_ETIQUETA=?");

		params.add(etiqueta.getIdEtiqueta());

		if (solicitud.getIdSol() != null) {
			where.append(" AND t2.ID_SOL = ?");
			params.add(solicitud.getIdSol());
		}
		if (solicitud.getFormacion() != null) {
			where.append(" AND t2.ID_FOR = ?");
			params.add(solicitud.getFormacion());
		}
		if (solicitud.getEntidad() != null) {
			where.append(" AND t2.ENTIDAD_ID = ?");
			params.add(solicitud.getEntidad());
		}
		if (solicitud.getGrupo() != null) {
			where.append(" AND t2.GRUPO = ?");
			params.add(solicitud.getGrupo());
		}
		if (solicitud.getParticipantes() != null) {
			where.append(" AND t2.PARTICIPANTES = ?");
			params.add(solicitud.getParticipantes());
		}
		if (solicitud.getProvincia() != null) {
			where.append(" AND t2.PROVINCIA = ?");
			params.add(solicitud.getProvincia());
		}
		if (solicitud.getDiaImparticion() != null) {
			where.append(" AND t2.DIA_IMPARTICION = ?");
			params.add(solicitud.getDiaImparticion());
		}
		if (solicitud.getHoraInicio() != null) {
			where.append(" AND t2.HORA_INICIO = ?");
			params.add(solicitud.getHoraInicio());
		}
		if (solicitud.getHoraFin() != null) {
			where.append(" AND t2.HORA_FIN = ?");
			params.add(solicitud.getHoraFin());
		}
		// XXX
		// if (solicitud.getHorarioImparticion() != null) {
		// where.append(" AND t2.HORARIO_IMPARTICION = ?");
		// params.add(solicitud.getHorarioImparticion());
		// }
		if (solicitud.getAsistentes() != null) {
			where.append(" AND t2.ASISTENTES = ?");
			params.add(solicitud.getAsistentes());
		}
		if (solicitud.getCancelado() != null) {
			where.append(" AND t2.CANCELADO = ?");
			params.add(solicitud.getCancelado());
		}
		if (solicitud.getIdioma() != null) {
			where.append(" AND t2.IDIOMA = ?");
			params.add(solicitud.getIdioma());
		}

		StringBuffer query = new StringBuffer(
				"SELECT count(1) FROM Y40a09t00 t1,Y40A03T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
