package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.Formacion;
import com.ejie.y40a.model.Solicitud;
import java.util.List;

import com.ejie.y40a.model.Etiqueta;

/**
 *  * EtiquetaDao  
 *  
 */

public interface EtiquetaDao {
    
    /**
     * Inserts a single row in the Etiqueta table.
     *
     * @param etiqueta Etiqueta
     * @return Etiqueta
     */
    Etiqueta add(Etiqueta etiqueta);

    /**
     * Updates a single row in the Etiqueta table.
     *
     * @param etiqueta Etiqueta
     * @return Etiqueta
     */
    Etiqueta update(Etiqueta etiqueta);

    /**
     * Finds a single row in the Etiqueta table.
     *
     * @param etiqueta Etiqueta
     * @return Etiqueta
     */
    Etiqueta find(Etiqueta etiqueta);

    /**
     * Deletes a single row in the Etiqueta table.
     *
     * @param etiqueta Etiqueta
     * @return 
     */
    void remove(Etiqueta etiqueta);

    /**
     * Finds a List of rows in the Etiqueta table.
     *
     * @param etiqueta Etiqueta
     * @param pagination Pagination
     * @return List
     */
    List<Etiqueta> findAll(Etiqueta etiqueta, Pagination pagination);

    /**
     * Counts rows in the Etiqueta table.
     *
     * @param etiqueta Etiqueta
     * @return List
     */
    Long findAllCount(Etiqueta etiqueta);
	
	/**
     * Finds rows in the Etiqueta table using like.
     *
     * @param etiqueta Etiqueta
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Etiqueta> findAllLike(Etiqueta etiqueta, Pagination pagination, Boolean startsWith);
	
	/**
	 * Inserts a single row in the FormacionEtiqueta table.
	 *
	 * @param etiqueta  Etiqueta
	 * @return Etiqueta 
	 */
	Etiqueta addFormacionEtiqueta(Etiqueta etiqueta);   

    /**
     * Deletes a single row in the FormacionEtiqueta table.
     *
     * @param etiqueta Etiqueta
     * @return 
     */
	void removeFormacionEtiqueta(Etiqueta etiqueta);

    /**
     * Find a single row in the findFormacionEtiqueta Many To Many relationship.
     *
     * @param etiqueta Etiqueta
     * @param  formacion Formacion
     * @param pagination Pagination
     * @return Etiqueta
     */
	Etiqueta findFormacionEtiqueta(Etiqueta etiqueta, Formacion formacion, Pagination pagination);

    /**
     * Counts rows rows in the FormacionEtiqueta table.
     *
     * @param etiqueta Etiqueta
     * @param  formacion Formacion
     * @return Long
     */
	Long findFormacionEtiquetaCount(Etiqueta etiqueta, Formacion formacion);
	
	/**
	 * Inserts a single row in the SolicitudEtiqueta table.
	 *
	 * @param etiqueta  Etiqueta
	 * @return Etiqueta 
	 */
	Etiqueta addSolicitudEtiqueta(Etiqueta etiqueta);   

    /**
     * Deletes a single row in the SolicitudEtiqueta table.
     *
     * @param etiqueta Etiqueta
     * @return 
     */
	void removeSolicitudEtiqueta(Etiqueta etiqueta);

    /**
     * Find a single row in the findSolicitudEtiqueta Many To Many relationship.
     *
     * @param etiqueta Etiqueta
     * @param  solicitud Solicitud
     * @param pagination Pagination
     * @return Etiqueta
     */
	Etiqueta findSolicitudEtiqueta(Etiqueta etiqueta, Solicitud solicitud, Pagination pagination);

    /**
     * Counts rows rows in the SolicitudEtiqueta table.
     *
     * @param etiqueta Etiqueta
     * @param  solicitud Solicitud
     * @return Long
     */
	Long findSolicitudEtiquetaCount(Etiqueta etiqueta, Solicitud solicitud);
}

