package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.EntidadHistorico;

/**
 * * EntidadHistoricoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class EntidadHistoricoDaoImpl implements EntidadHistoricoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<EntidadHistorico> rwMap = new RowMapper<EntidadHistorico>() {
		public EntidadHistorico mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EntidadHistorico(resultSet.getString("IDENTHIST"),resultSet.getString("ENTIDADID"),
					resultSet.getString("OBSERVACIONES"),resultSet.getTimestamp("FECHAACTUALIZA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the EntidadHistorico table.
	 * 
	 * @param entidadhistorico
	 *            Pagination
	 * @return EntidadHistorico
	 */
	public EntidadHistorico add(EntidadHistorico entidadhistorico) {

		String query = "INSERT INTO ENTIDAD_HISTORICO(ID_ENTHIST,ENTIDAD_ID,OBSERVACIONES,FECHA_ACTUALIZA)"
				+ "VALUES (?,?,?,?)";

		this.jdbcTemplate.update(query, entidadhistorico.getIdenthist(),entidadhistorico.getEntidadId(),
				entidadhistorico.getObservaciones(),entidadhistorico.getFechaactualiza());
		return entidadhistorico;
	}

	/**
	 * Updates a single row in the EntidadHistorico table.
	 * 
	 * @param entidadhistorico
	 *            Pagination
	 * @return EntidadHistorico
	 */
	public EntidadHistorico update(EntidadHistorico entidadhistorico) {
		String query = "UPDATE ENTIDAD_HISTORICO SET ENTIDAD_ID=?, OBSERVACIONES=? ,FECHA_ACTUALIZA=? WHERE ID_ENTHIST=?";
		this.jdbcTemplate.update(query, entidadhistorico.getEntidadId(),
				entidadhistorico.getObservaciones(),entidadhistorico.getFechaactualiza(),entidadhistorico.getIdenthist());
		return entidadhistorico;
	}

	/**
	 * Finds a single row in the EntidadHistorico table.
	 * 
	 * @param entidadhistorico
	 *            Pagination
	 * @return EntidadHistorico
	 */
	@Transactional(readOnly = true)
	public EntidadHistorico find(EntidadHistorico entidadhistorico) {
		String query = "SELECT t1.ID_ENTHIST IDENTHIST,t1.ENTIDAD_ID ENTIDADID, t1.OBSERVACIONES OBSERVACIONES, t1.FECHA_ACTUALIZA FECHAACTUALIZA "
				+ "FROM ENTIDAD_HISTORICO t1  "
				+ "WHERE t1.ID_ENTHIST = ? ";
		return (EntidadHistorico) this.jdbcTemplate
				.queryForObject(query, rwMap, entidadhistorico.getIdenthist());
	}

	/**
	 * Removes a single row in the EntidadHistorico table.
	 * 
	 * @param entidadhistorico
	 *            Pagination
	 * @return
	 */
	public void remove(EntidadHistorico entidadhistorico) {
		String query = "DELETE  FROM ENTIDAD_HISTORICO WHERE ID_ENTHIST=? ";
		this.jdbcTemplate.update(query, entidadhistorico.getIdenthist());
	}

	/**
	 * Finds a List of rows in the EntidadHistorico table.
	 * 
	 * @param entidadhistorico
	 *            EntidadHistorico
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EntidadHistorico> findAll(EntidadHistorico entidadhistorico,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_ENTHIST IDENTHIST,t1.ENTIDAD_ID ENTIDADID, t1.OBSERVACIONES OBSERVACIONES, t1.FECHA_ACTUALIZA FECHAACTUALIZA "
						+ "FROM ENTIDAD_HISTORICO t1 ");

		if (entidadhistorico != null && entidadhistorico.getIdenthist() != null) {
			where.append(" AND t1.ID_ENTHIST = ?");
			params.add(entidadhistorico.getIdenthist());
		}
		if (entidadhistorico != null && entidadhistorico.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(entidadhistorico.getEntidadId());
		}
		if (entidadhistorico != null && entidadhistorico.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(entidadhistorico.getObservaciones());
		}
		if (entidadhistorico != null && entidadhistorico.getFechaactualiza() != null) {
			where.append(" AND t1.FECHA_ACTUALIZA = ?");
			params.add(entidadhistorico.getFechaactualiza());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<EntidadHistorico>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the EntidadHistorico table.
	 * 
	 * @param entidadhistorico
	 *            EntidadHistorico
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(EntidadHistorico entidadhistorico) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  ENTIDAD_HISTORICO t1  ");
		if (entidadhistorico != null && entidadhistorico.getIdenthist() != null) {
			where.append(" AND t1.ID_ENTHIST = ?");
			params.add(entidadhistorico.getIdenthist());
		}
		if (entidadhistorico != null && entidadhistorico.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(entidadhistorico.getEntidadId());
		}
		if (entidadhistorico != null && entidadhistorico.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(entidadhistorico.getObservaciones());
		}
		if (entidadhistorico != null && entidadhistorico.getFechaactualiza() != null) {
			where.append(" AND t1.FECHA_ACTUALIZA = ?");
			params.add(entidadhistorico.getFechaactualiza());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the EntidadHistorico table using like.
	 * 
	 * @param entidadhistorico
	 *            EntidadHistorico
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EntidadHistorico> findAllLike(EntidadHistorico entidadhistorico,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_ENTHIST IDENTHIST,t1.ENTIDAD_ID ENTIDADID, t1.OBSERVACIONES OBSERVACIONES, t1.FECHA_ACTUALIZA FECHAACTUALIZA "
						+ "FROM ENTIDAD_HISTORICO t1 ");

		if (entidadhistorico != null && entidadhistorico.getIdenthist() != null) {
			where.append(" AND UPPER(t1.ID_ENTHIST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidadhistorico.getIdenthist().toUpperCase() + "%");
			} else {
				params.add("%" + entidadhistorico.getIdenthist().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ID_ENTHIST IS NOT NULL");
		}
		if (entidadhistorico != null && entidadhistorico.getEntidadId() != null) {
			where.append(" AND UPPER(t1.ENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidadhistorico.getEntidadId().toUpperCase() + "%");
			} else {
				params.add("%" + entidadhistorico.getEntidadId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ENTIDAD_ID IS NOT NULL");
		}
		if (entidadhistorico != null && entidadhistorico.getObservaciones() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidadhistorico.getObservaciones().toUpperCase() + "%");
			} else {
				params.add("%" + entidadhistorico.getObservaciones().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.OBSERVACIONES IS NOT NULL");
		}
		if (entidadhistorico != null && entidadhistorico.getFechaactualiza() != null) {
			where.append(" AND t1.FECHA_ACTUALIZA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidadhistorico.getFechaactualiza() + "%");
			} else {
				params.add("%" + entidadhistorico.getFechaactualiza() + "%");
			}
			where.append(" AND t1.FECHA_ACTUALIZA IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<EntidadHistorico>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}
}
