package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y40a.model.EntidadHistorico;

/**
 *  * EntidadHistoricoDao  
 *  
 */

public interface EntidadHistoricoDao {
    
    /**
     * Inserts a single row in the EntidadHistorico table.
     *
     * @param entidadHistorico EntidadHistorico
     * @return EntidadHistorico
     */
    EntidadHistorico add(EntidadHistorico entidadHistorico);

    /**
     * Updates a single row in the EntidadHistorico table.
     *
     * @param entidadHistorico EntidadHistorico
     * @return EntidadHistorico
     */
    EntidadHistorico update(EntidadHistorico entidadHistorico);

    /**
     * Finds a single row in the EntidadHistorico table.
     *
     * @param entidadHistorico EntidadHistorico
     * @return EntidadHistorico
     */
    EntidadHistorico find(EntidadHistorico entidadHistorico);

    /**
     * Deletes a single row in the EntidadHistorico table.
     *
     * @param entidadHistorico EntidadHistorico
     * @return 
     */
    void remove(EntidadHistorico entidadHistorico);

    /**
     * Finds a List of rows in the EntidadHistorico table.
     *
     * @param entidadHistorico EntidadHistorico
     * @param pagination Pagination
     * @return List
     */
    List<EntidadHistorico> findAll(EntidadHistorico entidadHistorico, Pagination pagination);

    /**
     * Counts rows in the EntidadHistorico table.
     *
     * @param entidadHistorico EntidadHistorico
     * @return List
     */
    Long findAllCount(EntidadHistorico entidadHistorico);
	
	/**
     * Finds rows in the EntidadHistorico table using like.
     *
     * @param entidadHistorico EntidadHistorico
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<EntidadHistorico> findAllLike(EntidadHistorico entidadHistorico, Pagination pagination, Boolean startsWith);
}

