package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y40a.model.Grupo;
import com.ejie.y40a.model.ObservacionesEntidad;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Entidad;
import com.ejie.y40a.utils.Y40aUtils;

/**
 * * EntidadDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class EntidadDaoImpl implements EntidadDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Entidad> rwMap = new RowMapper<Entidad>() {
		public Entidad mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			List<String> columnasSeleccionadas = Y40aUtils
					.cargarDatosBDVO(resultSet);

			Entidad entidad = new Entidad(resultSet.getString("ENTIDADID"),
					resultSet.getString("NOMBREES"),
					resultSet.getString("NOMBREEU"),
					resultSet.getString("ACTIVA"),
					resultSet.getString("ISKONTSUMOGEST"),
					resultSet.getString("ISKONTSUMONET"),
					resultSet.getString("ISOFERTAFORM"),
					resultSet.getString("ISCONSULTASWEB"),
					resultSet.getString("CODORG"),
					resultSet.getString("OBSERVACIONES"),
					resultSet.getString("TELEFONO"),
					resultSet.getString("FAX"), resultSet.getString("EMAIL"),
					resultSet.getString("URL"), resultSet.getString("USUARIO"),
					resultSet.getString("PASSWORD"),
					resultSet.getString("ISNACIONAL"),
					resultSet.getString("NORAPAISID"),
					resultSet.getString("NOMBREPAIS"),
					resultSet.getString("NORAPROVINCIAID"),
					resultSet.getString("NOMBREPROVINCIA"),
					resultSet.getString("NORAMUNICIPIOID"),
					resultSet.getString("NOMBREMUNICIPIO"),
					resultSet.getString("NORALOCALIDADID"),
					resultSet.getString("NOMBRELOCALIDAD"),
					resultSet.getString("NORACALLEID"),
					resultSet.getString("NOMBRECALLE"),
					resultSet.getString("NORACPID"),
					resultSet.getString("NOMBRECP"),
					resultSet.getString("NORAPORTALID"),
					resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("USUULTMOD"),
					resultSet.getDate("FECULTMOD"),
					resultSet.getString("COMPLEDIREC"),
					resultSet.getString("ORINBDCO"), new ObservacionesEntidad(
							resultSet.getString("OBSERVACIONESENTIDADID"),
							resultSet.getString("OBSERVACIONESENTIDAD")));

			entidad.setNumHistObserv((columnasSeleccionadas
					.contains("NUMHISTOBSERV")) ? resultSet
					.getLong("NUMHISTOBSERV") : null);

			return entidad;
		}
	};

	private RowMapper<Entidad> rwMapTabla = new RowMapper<Entidad>() {
		public Entidad mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Entidad entidad = new Entidad();
			entidad.setEntidadId(resultSet.getString("ENTIDADID"));
			entidad.setNombreEs(resultSet.getString("NOMBREES"));
			entidad.setNombreEu(resultSet.getString("NOMBREEU"));
			entidad.setEmail(resultSet.getString("EMAIL"));
			entidad.setUsuario(resultSet.getString("USUARIO"));
			entidad.setPassword(resultSet.getString("PASSWORD"));

			return entidad;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Pagination
	 * @return Entidad
	 */
	public Entidad add(Entidad entidad) {

		String query = "INSERT INTO ENTIDAD( ENTIDAD_ID,NOMBRE_ES,NOMBRE_EU,ACTIVA,ISKONTSUMOGEST,ISKONTSUMONET,ISOFERTAFORM,ISCONSULTASWEB,COD_ORG,OBSERVACIONES,TELEFONO,FAX,EMAIL,URL,USUARIO,PASSWORD,ISNACIONAL,NORA_PAIS_ID,NOMBRE_PAIS,NORA_PROVINCIA_ID,NOMBRE_PROVINCIA,NORA_MUNICIPIO_ID,NOMBRE_MUNICIPIO,NORA_LOCALIDAD_ID,NOMBRE_LOCALIDAD,NORA_CALLE_ID,NOMBRE_CALLE,NORA_CP_ID,NOMBRE_CP,NORA_PORTAL_ID,NOMBRE_PORTAL,USUULTMOD,FECULTMOD,COMPLE_DIREC,ORINBDCO)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, entidad.getEntidadId(),
				entidad.getNombreEs(), entidad.getNombreEu(),
				entidad.getActiva(), entidad.getIskontsumogest(),
				entidad.getIskontsumonet(), entidad.getIsofertaform(),
				entidad.getIsconsultasweb(), entidad.getCodOrg(),
				entidad.getObservaciones(), entidad.getTelefono(),
				entidad.getFax(), entidad.getEmail(), entidad.getUrl(),
				entidad.getUsuario(), entidad.getPassword(),
				entidad.getIsnacional(), entidad.getNoraPaisId(),
				entidad.getNombrePais(), entidad.getNoraProvinciaId(),
				entidad.getNombreProvincia(), entidad.getNoraMunicipioId(),
				entidad.getNombreMunicipio(), entidad.getNoraLocalidadId(),
				entidad.getNombreLocalidad(), entidad.getNoraCalleId(),
				entidad.getNombreCalle(), entidad.getNoraCpId(),
				entidad.getNombreCp(), entidad.getNoraPortalId(),
				entidad.getNombrePortal(), entidad.getUsuultmod(),
				entidad.getFecultmod(), entidad.getCompleDirec(),
				entidad.getOrinbdco());
		return entidad;
	}

	/**
	 * Updates a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Pagination
	 * @return Entidad
	 */
	public Entidad update(Entidad entidad) {
		String query = "UPDATE ENTIDAD SET NOMBRE_ES=?,NOMBRE_EU=?,ACTIVA=?,ISKONTSUMOGEST=?,ISKONTSUMONET=?,ISOFERTAFORM=?,ISCONSULTASWEB=?,COD_ORG=?,OBSERVACIONES=?,TELEFONO=?,FAX=?,EMAIL=?,URL=?,USUARIO=?,PASSWORD=?,ISNACIONAL=?,NORA_PAIS_ID=?,NOMBRE_PAIS=?,NORA_PROVINCIA_ID=?,NOMBRE_PROVINCIA=?,NORA_MUNICIPIO_ID=?,NOMBRE_MUNICIPIO=?,NORA_LOCALIDAD_ID=?,NOMBRE_LOCALIDAD=?,NORA_CALLE_ID=?,NOMBRE_CALLE=?,NORA_CP_ID=?,NOMBRE_CP=?,NORA_PORTAL_ID=?,NOMBRE_PORTAL=?,USUULTMOD=?,FECULTMOD=?,COMPLE_DIREC=?,ORINBDCO=? WHERE ENTIDAD_ID=?";
		this.jdbcTemplate.update(query, entidad.getNombreEs(),
				entidad.getNombreEu(), entidad.getActiva(),
				entidad.getIskontsumogest(), entidad.getIskontsumonet(),
				entidad.getIsofertaform(), entidad.getIsconsultasweb(),
				entidad.getCodOrg(), entidad.getObservaciones(),
				entidad.getTelefono(), entidad.getFax(), entidad.getEmail(),
				entidad.getUrl(), entidad.getUsuario(), entidad.getPassword(),
				entidad.getIsnacional(), entidad.getNoraPaisId(),
				entidad.getNombrePais(), entidad.getNoraProvinciaId(),
				entidad.getNombreProvincia(), entidad.getNoraMunicipioId(),
				entidad.getNombreMunicipio(), entidad.getNoraLocalidadId(),
				entidad.getNombreLocalidad(), entidad.getNoraCalleId(),
				entidad.getNombreCalle(), entidad.getNoraCpId(),
				entidad.getNombreCp(), entidad.getNoraPortalId(),
				entidad.getNombrePortal(), entidad.getUsuultmod(),
				entidad.getFecultmod(), entidad.getCompleDirec(),
				entidad.getOrinbdco(), entidad.getEntidadId());
		return entidad;
	}

	/**
	 * Finds a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Pagination
	 * @return Entidad
	 */
	@Transactional(readOnly = true)
	public Entidad find(Entidad entidad) {
		String query = "SELECT t1.ENTIDAD_ID ENTIDADID, t1.NOMBRE_ES NOMBREES, t1.NOMBRE_EU NOMBREEU, t1.ACTIVA ACTIVA, t1.ISKONTSUMOGEST ISKONTSUMOGEST, t1.ISKONTSUMONET ISKONTSUMONET, t1.ISOFERTAFORM ISOFERTAFORM, t1.ISCONSULTASWEB ISCONSULTASWEB, t1.COD_ORG CODORG, t1.OBSERVACIONES OBSERVACIONES, t1.TELEFONO TELEFONO, t1.FAX FAX, t1.EMAIL EMAIL, t1.URL URL, t1.USUARIO USUARIO, t1.PASSWORD PASSWORD, t1.ISNACIONAL ISNACIONAL, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.USUULTMOD USUULTMOD, t1.FECULTMOD FECULTMOD, t1.COMPLE_DIREC COMPLEDIREC, t1.ORINBDCO ORINBDCO, t2.ENTIDAD_ID OBSERVACIONESENTIDADID, t2.OBSERVACIONES OBSERVACIONESENTIDAD "
				+ " ,(select count(ENTIDAD_ID) from ENTIDAD_HISTORICO t3 where t3.ENTIDAD_ID=t1.ENTIDAD_ID) NUMHISTOBSERV "
				+ "FROM ENTIDAD t1 , OBSERVACIONES_ENTIDAD t2  "
				+ "WHERE t1.ENTIDAD_ID = ?   AND t1.ENTIDAD_ID= t2.ENTIDAD_ID(+)  ";
		return (Entidad) this.jdbcTemplate.queryForObject(query, rwMap,
				entidad.getEntidadId());
	}

	/**
	 * Removes a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Pagination
	 * @return
	 */
	public void remove(Entidad entidad) {
		String query = "DELETE  FROM ENTIDAD WHERE ENTIDAD_ID=?";
		this.jdbcTemplate.update(query, entidad.getEntidadId());
	}

	/**
	 * Finds a List of rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Entidad> findAll(Entidad entidad, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ENTIDAD_ID= t2.ENTIDAD_ID(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.COD_ORG CODORG,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.ISNACIONAL ISNACIONAL,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.COMPLE_DIREC COMPLEDIREC,t1.ORINBDCO ORINBDCO, t2.ENTIDAD_ID OBSERVACIONESENTIDADID, t2.OBSERVACIONES OBSERVACIONESENTIDAD "
						+ "FROM ENTIDAD t1 ,OBSERVACIONES_ENTIDAD t2 ");

		if (entidad != null && entidad.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(entidad.getEntidadId());
		}
		if (entidad != null && entidad.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(entidad.getNombreEs());
		}
		if (entidad != null && entidad.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(entidad.getNombreEu());
		}
		if (entidad != null && entidad.getActiva() != null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(entidad.getActiva());
		}
		if (entidad != null && entidad.getIskontsumogest() != null) {
			where.append(" AND t1.ISKONTSUMOGEST = ?");
			params.add(entidad.getIskontsumogest());
		}
		if (entidad != null && entidad.getIskontsumonet() != null) {
			where.append(" AND t1.ISKONTSUMONET = ?");
			params.add(entidad.getIskontsumonet());
		}
		if (entidad != null && entidad.getIsofertaform() != null) {
			where.append(" AND t1.ISOFERTAFORM = ?");
			params.add(entidad.getIsofertaform());
		}
		if (entidad != null && entidad.getIsconsultasweb() != null) {
			where.append(" AND t1.ISCONSULTASWEB = ?");
			params.add(entidad.getIsconsultasweb());
		}
		if (entidad != null && entidad.getCodOrg() != null) {
			where.append(" AND t1.COD_ORG = ?");
			params.add(entidad.getCodOrg());
		}
		if (entidad != null && entidad.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(entidad.getObservaciones());
		}
		if (entidad != null && entidad.getTelefono() != null) {
			where.append(" AND t1.TELEFONO = ?");
			params.add(entidad.getTelefono());
		}
		if (entidad != null && entidad.getFax() != null) {
			where.append(" AND t1.FAX = ?");
			params.add(entidad.getFax());
		}
		if (entidad != null && entidad.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(entidad.getEmail());
		}
		if (entidad != null && entidad.getUrl() != null) {
			where.append(" AND t1.URL = ?");
			params.add(entidad.getUrl());
		}
		if (entidad != null && entidad.getUsuario() != null) {
			where.append(" AND t1.USUARIO = ?");
			params.add(entidad.getUsuario());
		}
		if (entidad != null && entidad.getPassword() != null) {
			where.append(" AND t1.PASSWORD = ?");
			params.add(entidad.getPassword());
		}
		if (entidad != null && entidad.getIsnacional() != null) {
			where.append(" AND t1.ISNACIONAL = ?");
			params.add(entidad.getIsnacional());
		}
		if (entidad != null && entidad.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(entidad.getNoraPaisId());
		}
		if (entidad != null && entidad.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(entidad.getNombrePais());
		}
		if (entidad != null && entidad.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(entidad.getNoraProvinciaId());
		}
		if (entidad != null && entidad.getNombreProvincia() != null) {
			where.append(" AND t1.NOMBRE_PROVINCIA = ?");
			params.add(entidad.getNombreProvincia());
		}
		if (entidad != null && entidad.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(entidad.getNoraMunicipioId());
		}
		if (entidad != null && entidad.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(entidad.getNombreMunicipio());
		}
		if (entidad != null && entidad.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(entidad.getNoraLocalidadId());
		}
		if (entidad != null && entidad.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(entidad.getNombreLocalidad());
		}
		if (entidad != null && entidad.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(entidad.getNoraCalleId());
		}
		if (entidad != null && entidad.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(entidad.getNombreCalle());
		}
		if (entidad != null && entidad.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(entidad.getNoraCpId());
		}
		if (entidad != null && entidad.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(entidad.getNombreCp());
		}
		if (entidad != null && entidad.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(entidad.getNoraPortalId());
		}
		if (entidad != null && entidad.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(entidad.getNombrePortal());
		}
		if (entidad != null && entidad.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(entidad.getUsuultmod());
		}
		if (entidad != null && entidad.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(entidad.getFecultmod());
		}
		if (entidad != null && entidad.getCompleDirec() != null) {
			where.append(" AND t1.COMPLE_DIREC = ?");
			params.add(entidad.getCompleDirec());
		}
		if (entidad != null && entidad.getOrinbdco() != null) {
			where.append(" AND t1.ORINBDCO = ?");
			params.add(entidad.getOrinbdco());
		}
		if (entidad != null && entidad.getObservacionesEntidad() != null
				&& entidad.getObservacionesEntidad().getEntidadId() != null) {
			where.append(" AND t2.ENTIDAD_ID = ?");
			params.add(entidad.getObservacionesEntidad().getEntidadId());
		}
		if (entidad != null && entidad.getObservacionesEntidad() != null
				&& entidad.getObservacionesEntidad().getObservaciones() != null) {
			where.append(" AND t2.OBSERVACIONES = ?");
			params.add(entidad.getObservacionesEntidad().getObservaciones());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Entidad>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Entidad entidad) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.ENTIDAD_ID= t2.ENTIDAD_ID(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  ENTIDAD t1   ,  OBSERVACIONES_ENTIDAD t2  ");
		if (entidad != null && entidad.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(entidad.getEntidadId());
		}
		if (entidad != null && entidad.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(entidad.getNombreEs());
		}
		if (entidad != null && entidad.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(entidad.getNombreEu());
		}
		if (entidad != null && entidad.getActiva() != null) {
			where.append(" AND t1.ACTIVA = ?");
			params.add(entidad.getActiva());
		}
		if (entidad != null && entidad.getIskontsumogest() != null) {
			where.append(" AND t1.ISKONTSUMOGEST = ?");
			params.add(entidad.getIskontsumogest());
		}
		if (entidad != null && entidad.getIskontsumonet() != null) {
			where.append(" AND t1.ISKONTSUMONET = ?");
			params.add(entidad.getIskontsumonet());
		}
		if (entidad != null && entidad.getIsofertaform() != null) {
			where.append(" AND t1.ISOFERTAFORM = ?");
			params.add(entidad.getIsofertaform());
		}
		if (entidad != null && entidad.getIsconsultasweb() != null) {
			where.append(" AND t1.ISCONSULTASWEB = ?");
			params.add(entidad.getIsconsultasweb());
		}
		if (entidad != null && entidad.getCodOrg() != null) {
			where.append(" AND t1.COD_ORG = ?");
			params.add(entidad.getCodOrg());
		}
		if (entidad != null && entidad.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(entidad.getObservaciones());
		}
		if (entidad != null && entidad.getTelefono() != null) {
			where.append(" AND t1.TELEFONO = ?");
			params.add(entidad.getTelefono());
		}
		if (entidad != null && entidad.getFax() != null) {
			where.append(" AND t1.FAX = ?");
			params.add(entidad.getFax());
		}
		if (entidad != null && entidad.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(entidad.getEmail());
		}
		if (entidad != null && entidad.getUrl() != null) {
			where.append(" AND t1.URL = ?");
			params.add(entidad.getUrl());
		}
		if (entidad != null && entidad.getUsuario() != null) {
			where.append(" AND t1.USUARIO = ?");
			params.add(entidad.getUsuario());
		}
		if (entidad != null && entidad.getPassword() != null) {
			where.append(" AND t1.PASSWORD = ?");
			params.add(entidad.getPassword());
		}
		if (entidad != null && entidad.getIsnacional() != null) {
			where.append(" AND t1.ISNACIONAL = ?");
			params.add(entidad.getIsnacional());
		}
		if (entidad != null && entidad.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(entidad.getNoraPaisId());
		}
		if (entidad != null && entidad.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(entidad.getNombrePais());
		}
		if (entidad != null && entidad.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(entidad.getNoraProvinciaId());
		}
		if (entidad != null && entidad.getNombreProvincia() != null) {
			where.append(" AND t1.NOMBRE_PROVINCIA = ?");
			params.add(entidad.getNombreProvincia());
		}
		if (entidad != null && entidad.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(entidad.getNoraMunicipioId());
		}
		if (entidad != null && entidad.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(entidad.getNombreMunicipio());
		}
		if (entidad != null && entidad.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(entidad.getNoraLocalidadId());
		}
		if (entidad != null && entidad.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(entidad.getNombreLocalidad());
		}
		if (entidad != null && entidad.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(entidad.getNoraCalleId());
		}
		if (entidad != null && entidad.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(entidad.getNombreCalle());
		}
		if (entidad != null && entidad.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(entidad.getNoraCpId());
		}
		if (entidad != null && entidad.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(entidad.getNombreCp());
		}
		if (entidad != null && entidad.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(entidad.getNoraPortalId());
		}
		if (entidad != null && entidad.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(entidad.getNombrePortal());
		}
		if (entidad != null && entidad.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(entidad.getUsuultmod());
		}
		if (entidad != null && entidad.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(entidad.getFecultmod());
		}
		if (entidad != null && entidad.getCompleDirec() != null) {
			where.append(" AND t1.COMPLE_DIREC = ?");
			params.add(entidad.getCompleDirec());
		}
		if (entidad != null && entidad.getOrinbdco() != null) {
			where.append(" AND t1.ORINBDCO = ?");
			params.add(entidad.getOrinbdco());
		}
		if (entidad != null && entidad.getObservacionesEntidad() != null
				&& entidad.getObservacionesEntidad().getEntidadId() != null) {
			where.append(" AND t2.ENTIDAD_ID = ?");
			params.add(entidad.getObservacionesEntidad().getEntidadId());
		}
		if (entidad != null && entidad.getObservacionesEntidad() != null
				&& entidad.getObservacionesEntidad().getObservaciones() != null) {
			where.append(" AND t2.OBSERVACIONES = ?");
			params.add(entidad.getObservacionesEntidad().getObservaciones());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Entidad table using like.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Entidad> findAllLike(Entidad entidad, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ENTIDAD_ID= t2.ENTIDAD_ID(+) AND t1.ENTIDAD_ID= t3.ENTIDAD_ID(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT DISTINCT t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.ACTIVA ACTIVA,t1.ISKONTSUMOGEST ISKONTSUMOGEST,t1.ISKONTSUMONET ISKONTSUMONET,t1.ISOFERTAFORM ISOFERTAFORM,t1.ISCONSULTASWEB ISCONSULTASWEB,t1.COD_ORG CODORG,t1.OBSERVACIONES OBSERVACIONES,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD,t1.ISNACIONAL ISNACIONAL,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.COMPLE_DIREC COMPLEDIREC,t1.ORINBDCO ORINBDCO, t2.ENTIDAD_ID OBSERVACIONESENTIDADID, t2.OBSERVACIONES OBSERVACIONESENTIDAD "
						+ "FROM ENTIDAD t1 ,OBSERVACIONES_ENTIDAD t2, GRUPO_ENTIDAD t3 ");

		// Grupos
		if (entidad != null && entidad.getGrupos() != null
				&& entidad.getGrupos().size() > 0) {

			where.append(" AND t3.GRUPO_ID IN ( ");
			boolean firstElement = true;

			for (Grupo e : entidad.getGrupos()) {

				if (firstElement) {

					where.append(" ? ");
					params.add(e.getGrupoId());
					firstElement = false;

				} else {

					where.append(" , ?");
					params.add(e.getGrupoId());
				}
			}

			where.append(") ");
		}

		if (entidad != null && entidad.getEntidadId() != null) {
			where.append(" AND UPPER(t1.ENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getEntidadId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getEntidadId().toUpperCase() + "%");
			}
			where.append(" AND t1.ENTIDAD_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreEs() != null) {
			where.append(" AND UPPER(t1.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreEs().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreEs().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreEu() != null) {
			where.append(" AND UPPER(t1.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreEu().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreEu().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (entidad != null && entidad.getActiva() != null) {
			where.append(" AND UPPER(t1.ACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getActiva().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getActiva().toUpperCase() + "%");
			}
			where.append(" AND t1.ACTIVA IS NOT NULL");
		}
		if (entidad != null && entidad.getIskontsumogest() != null) {
			where.append(" AND UPPER(t1.ISKONTSUMOGEST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getIskontsumogest().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getIskontsumogest().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ISKONTSUMOGEST IS NOT NULL");
		}
		if (entidad != null && entidad.getIskontsumonet() != null) {
			where.append(" AND UPPER(t1.ISKONTSUMONET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getIskontsumonet().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getIskontsumonet().toUpperCase() + "%");
			}
			where.append(" AND t1.ISKONTSUMONET IS NOT NULL");
		}
		if (entidad != null && entidad.getIsofertaform() != null) {
			where.append(" AND UPPER(t1.ISOFERTAFORM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getIsofertaform().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getIsofertaform().toUpperCase() + "%");
			}
			where.append(" AND t1.ISOFERTAFORM IS NOT NULL");
		}
		if (entidad != null && entidad.getIsconsultasweb() != null) {
			where.append(" AND UPPER(t1.ISCONSULTASWEB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getIsconsultasweb().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getIsconsultasweb().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ISCONSULTASWEB IS NOT NULL");
		}
		if (entidad != null && entidad.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getCodOrg().toUpperCase() + "%");
			}
			where.append(" AND t1.COD_ORG IS NOT NULL");
		}
		if (entidad != null && entidad.getObservaciones() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getObservaciones().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getObservaciones().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERVACIONES IS NOT NULL");
		}
		if (entidad != null && entidad.getTelefono() != null) {
			where.append(" AND UPPER(t1.TELEFONO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getTelefono().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getTelefono().toUpperCase() + "%");
			}
			where.append(" AND t1.TELEFONO IS NOT NULL");
		}
		if (entidad != null && entidad.getFax() != null) {
			where.append(" AND UPPER(t1.FAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getFax().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getFax().toUpperCase() + "%");
			}
			where.append(" AND t1.FAX IS NOT NULL");
		}
		if (entidad != null && entidad.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getEmail().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}
		if (entidad != null && entidad.getUrl() != null) {
			where.append(" AND UPPER(t1.URL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getUrl().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getUrl().toUpperCase() + "%");
			}
			where.append(" AND t1.URL IS NOT NULL");
		}
		if (entidad != null && entidad.getUsuario() != null) {
			where.append(" AND UPPER(t1.USUARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getUsuario().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getUsuario().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO IS NOT NULL");
		}
		if (entidad != null && entidad.getPassword() != null) {
			where.append(" AND UPPER(t1.PASSWORD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getPassword().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getPassword().toUpperCase() + "%");
			}
			where.append(" AND t1.PASSWORD IS NOT NULL");
		}
		if (entidad != null && entidad.getIsnacional() != null) {
			where.append(" AND UPPER(t1.ISNACIONAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getIsnacional().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getIsnacional().toUpperCase() + "%");
			}
			where.append(" AND t1.ISNACIONAL IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraPaisId() != null) {
			where.append(" AND UPPER(t1.NORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PAIS_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombrePais() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombrePais().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombrePais().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PAIS IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraProvinciaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreProvincia() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreProvincia().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraMunicipioId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreMunicipio() != null) {
			where.append(" AND UPPER(t1.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreMunicipio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraLocalidadId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreLocalidad() != null) {
			where.append(" AND UPPER(t1.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreLocalidad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraCalleId() != null) {
			where.append(" AND UPPER(t1.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CALLE_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreCalle() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CALLE IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraCpId() != null) {
			where.append(" AND UPPER(t1.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CP_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreCp() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreCp().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CP IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraPortalId() != null) {
			where.append(" AND UPPER(t1.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PORTAL_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombrePortal() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PORTAL IS NOT NULL");
		}
		if (entidad != null && entidad.getUsuultmod() != null) {
			where.append(" AND UPPER(t1.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getUsuultmod().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getUsuultmod().toUpperCase() + "%");
			}
			where.append(" AND t1.USUULTMOD IS NOT NULL");
		}
		if (entidad != null && entidad.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getFecultmod() + "%");
			} else {
				params.add("%" + entidad.getFecultmod() + "%");
			}
			where.append(" AND t1.FECULTMOD IS NOT NULL");
		}
		if (entidad != null && entidad.getCompleDirec() != null) {
			where.append(" AND UPPER(t1.COMPLE_DIREC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getCompleDirec().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getCompleDirec().toUpperCase() + "%");
			}
			where.append(" AND t1.COMPLE_DIREC IS NOT NULL");
		}
		if (entidad != null && entidad.getOrinbdco() != null) {
			where.append(" AND UPPER(t1.ORINBDCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getOrinbdco().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getOrinbdco().toUpperCase() + "%");
			}
			where.append(" AND t1.ORINBDCO IS NOT NULL");
		}
		if (entidad != null && entidad.getObservacionesEntidad() != null
				&& entidad.getObservacionesEntidad().getEntidadId() != null) {
			where.append(" AND t2.ENTIDAD_ID like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getObservacionesEntidad().getEntidadId()
						+ "%");
			} else {
				params.add("%"
						+ entidad.getObservacionesEntidad().getEntidadId()
						+ "%");
			}
			where.append(" AND t2.ENTIDAD_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getObservacionesEntidad() != null
				&& entidad.getObservacionesEntidad().getObservaciones() != null) {
			where.append(" AND UPPER(t2.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getObservacionesEntidad().getObservaciones()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ entidad.getObservacionesEntidad().getObservaciones()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.OBSERVACIONES IS NOT NULL");
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Entidad>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Finds rows in the Entidad table using like.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Entidad> findAllLikeTabla(Entidad entidad,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND ACTIVA='S' AND ISOFERTAFORM='S' ");

		StringBuffer query = new StringBuffer(
				"SELECT DISTINCT t1.ENTIDAD_ID ENTIDADID,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU, t1.EMAIL EMAIL,t1.USUARIO USUARIO,t1.PASSWORD PASSWORD "
						+ "FROM ENTIDAD t1  ");

		if (entidad != null && entidad.getNombreEs() != null) {
			where.append(" AND ( UPPER(t1.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreEs().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreEs().toUpperCase() + "%");
			}
			where.append(" OR UPPER(t1.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreEs().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreEs().toUpperCase() + "%");
			}
			where.append(" ) ");
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}

		if (entidad != null && entidad.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getEmail().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}

		if (entidad != null && entidad.getUsuario() != null) {
			where.append(" AND UPPER(t1.USUARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getUsuario().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getUsuario().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO IS NOT NULL");
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Entidad>) this.jdbcTemplate.query(query.toString(),
				rwMapTabla, params.toArray());
	}

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Entidad entidad, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ENTIDAD_ID= t2.ENTIDAD_ID(+) AND t1.ENTIDAD_ID= t3.ENTIDAD_ID(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(DISTINCT t1.ENTIDAD_ID) FROM ENTIDAD t1 ,OBSERVACIONES_ENTIDAD t2, GRUPO_ENTIDAD t3 ");

		// Grupos
		if (entidad != null && entidad.getGrupos() != null
				&& entidad.getGrupos().size() > 0) {

			where.append(" AND t3.GRUPO_ID IN ( ");
			boolean firstElement = true;

			for (Grupo e : entidad.getGrupos()) {

				if (firstElement) {

					where.append(" ? ");
					params.add(e.getGrupoId());
					firstElement = false;

				} else {

					where.append(" , ?");
					params.add(e.getGrupoId());
				}
			}

			where.append(") ");
		}
		if (entidad != null && entidad.getEntidadId() != null) {
			where.append(" AND UPPER(t1.ENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getEntidadId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getEntidadId().toUpperCase() + "%");
			}
			where.append(" AND t1.ENTIDAD_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreEs() != null) {
			where.append(" AND UPPER(t1.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreEs().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreEs().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreEu() != null) {
			where.append(" AND UPPER(t1.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreEu().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreEu().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (entidad != null && entidad.getActiva() != null) {
			where.append(" AND UPPER(t1.ACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getActiva().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getActiva().toUpperCase() + "%");
			}
			where.append(" AND t1.ACTIVA IS NOT NULL");
		}
		if (entidad != null && entidad.getIskontsumogest() != null) {
			where.append(" AND UPPER(t1.ISKONTSUMOGEST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getIskontsumogest().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getIskontsumogest().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ISKONTSUMOGEST IS NOT NULL");
		}
		if (entidad != null && entidad.getIskontsumonet() != null) {
			where.append(" AND UPPER(t1.ISKONTSUMONET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getIskontsumonet().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getIskontsumonet().toUpperCase() + "%");
			}
			where.append(" AND t1.ISKONTSUMONET IS NOT NULL");
		}
		if (entidad != null && entidad.getIsofertaform() != null) {
			where.append(" AND UPPER(t1.ISOFERTAFORM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getIsofertaform().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getIsofertaform().toUpperCase() + "%");
			}
			where.append(" AND t1.ISOFERTAFORM IS NOT NULL");
		}
		if (entidad != null && entidad.getIsconsultasweb() != null) {
			where.append(" AND UPPER(t1.ISCONSULTASWEB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getIsconsultasweb().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getIsconsultasweb().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ISCONSULTASWEB IS NOT NULL");
		}
		if (entidad != null && entidad.getCodOrg() != null) {
			where.append(" AND UPPER(t1.COD_ORG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getCodOrg().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getCodOrg().toUpperCase() + "%");
			}
			where.append(" AND t1.COD_ORG IS NOT NULL");
		}
		if (entidad != null && entidad.getObservaciones() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getObservaciones().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getObservaciones().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERVACIONES IS NOT NULL");
		}
		if (entidad != null && entidad.getTelefono() != null) {
			where.append(" AND UPPER(t1.TELEFONO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getTelefono().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getTelefono().toUpperCase() + "%");
			}
			where.append(" AND t1.TELEFONO IS NOT NULL");
		}
		if (entidad != null && entidad.getFax() != null) {
			where.append(" AND UPPER(t1.FAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getFax().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getFax().toUpperCase() + "%");
			}
			where.append(" AND t1.FAX IS NOT NULL");
		}
		if (entidad != null && entidad.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getEmail().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}
		if (entidad != null && entidad.getUrl() != null) {
			where.append(" AND UPPER(t1.URL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getUrl().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getUrl().toUpperCase() + "%");
			}
			where.append(" AND t1.URL IS NOT NULL");
		}
		if (entidad != null && entidad.getUsuario() != null) {
			where.append(" AND UPPER(t1.USUARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getUsuario().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getUsuario().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO IS NOT NULL");
		}
		if (entidad != null && entidad.getPassword() != null) {
			where.append(" AND UPPER(t1.PASSWORD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getPassword().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getPassword().toUpperCase() + "%");
			}
			where.append(" AND t1.PASSWORD IS NOT NULL");
		}
		if (entidad != null && entidad.getIsnacional() != null) {
			where.append(" AND UPPER(t1.ISNACIONAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getIsnacional().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getIsnacional().toUpperCase() + "%");
			}
			where.append(" AND t1.ISNACIONAL IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraPaisId() != null) {
			where.append(" AND UPPER(t1.NORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PAIS_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombrePais() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombrePais().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombrePais().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PAIS IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraProvinciaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreProvincia() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreProvincia().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraMunicipioId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreMunicipio() != null) {
			where.append(" AND UPPER(t1.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreMunicipio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraLocalidadId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreLocalidad() != null) {
			where.append(" AND UPPER(t1.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreLocalidad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraCalleId() != null) {
			where.append(" AND UPPER(t1.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CALLE_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreCalle() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CALLE IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraCpId() != null) {
			where.append(" AND UPPER(t1.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CP_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombreCp() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreCp().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CP IS NOT NULL");
		}
		if (entidad != null && entidad.getNoraPortalId() != null) {
			where.append(" AND UPPER(t1.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PORTAL_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getNombrePortal() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PORTAL IS NOT NULL");
		}
		if (entidad != null && entidad.getUsuultmod() != null) {
			where.append(" AND UPPER(t1.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getUsuultmod().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getUsuultmod().toUpperCase() + "%");
			}
			where.append(" AND t1.USUULTMOD IS NOT NULL");
		}
		if (entidad != null && entidad.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getFecultmod() + "%");
			} else {
				params.add("%" + entidad.getFecultmod() + "%");
			}
			where.append(" AND t1.FECULTMOD IS NOT NULL");
		}
		if (entidad != null && entidad.getCompleDirec() != null) {
			where.append(" AND UPPER(t1.COMPLE_DIREC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getCompleDirec().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getCompleDirec().toUpperCase() + "%");
			}
			where.append(" AND t1.COMPLE_DIREC IS NOT NULL");
		}
		if (entidad != null && entidad.getOrinbdco() != null) {
			where.append(" AND UPPER(t1.ORINBDCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getOrinbdco().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getOrinbdco().toUpperCase() + "%");
			}
			where.append(" AND t1.ORINBDCO IS NOT NULL");
		}
		if (entidad != null && entidad.getObservacionesEntidad() != null
				&& entidad.getObservacionesEntidad().getEntidadId() != null) {
			where.append(" AND t2.ENTIDAD_ID like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getObservacionesEntidad().getEntidadId()
						+ "%");
			} else {
				params.add("%"
						+ entidad.getObservacionesEntidad().getEntidadId()
						+ "%");
			}
			where.append(" AND t2.ENTIDAD_ID IS NOT NULL");
		}
		if (entidad != null && entidad.getObservacionesEntidad() != null
				&& entidad.getObservacionesEntidad().getObservaciones() != null) {
			where.append(" AND UPPER(t2.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getObservacionesEntidad().getObservaciones()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ entidad.getObservacionesEntidad().getObservaciones()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.OBSERVACIONES IS NOT NULL");
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeTablaCount(Entidad entidad, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND ACTIVA='S' AND ISOFERTAFORM='S' ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(DISTINCT t1.ENTIDAD_ID) FROM ENTIDAD t1 ");
		if (entidad != null && entidad.getNombreEs() != null) {
			where.append(" AND ( UPPER(t1.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreEs().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreEs().toUpperCase() + "%");
			}
			where.append(" OR UPPER(t1.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getNombreEs().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getNombreEs().toUpperCase() + "%");
			}
			where.append(" ) ");
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}

		if (entidad != null && entidad.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getEmail().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}

		if (entidad != null && entidad.getUsuario() != null) {
			where.append(" AND UPPER(t1.USUARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidad.getUsuario().toUpperCase() + "%");
			} else {
				params.add("%" + entidad.getUsuario().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO IS NOT NULL");
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Pagination
	 * @return Entidad
	 */
	@Transactional(readOnly = true)
	public Entidad findEntidadUser(Entidad entidad) {
		String query = "SELECT t1.ENTIDAD_ID ENTIDADID, t1.NOMBRE_ES NOMBREES, t1.NOMBRE_EU NOMBREEU, t1.ACTIVA ACTIVA, t1.ISKONTSUMOGEST ISKONTSUMOGEST, t1.ISKONTSUMONET ISKONTSUMONET, t1.ISOFERTAFORM ISOFERTAFORM, t1.ISCONSULTASWEB ISCONSULTASWEB, t1.COD_ORG CODORG, t1.OBSERVACIONES OBSERVACIONES, t1.TELEFONO TELEFONO, t1.FAX FAX, t1.EMAIL EMAIL, t1.URL URL, t1.USUARIO USUARIO, t1.PASSWORD PASSWORD, t1.ISNACIONAL ISNACIONAL, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.USUULTMOD USUULTMOD, t1.FECULTMOD FECULTMOD, t1.COMPLE_DIREC COMPLEDIREC, t1.ORINBDCO ORINBDCO, t2.ENTIDAD_ID OBSERVACIONESENTIDADID, t2.OBSERVACIONES OBSERVACIONESENTIDAD "
				+ "FROM ENTIDAD t1 , OBSERVACIONES_ENTIDAD t2  "
				+ "WHERE t1.USUARIO = ?   AND t1.ENTIDAD_ID= t2.ENTIDAD_ID(+)  ";
		return (Entidad) this.jdbcTemplate.queryForObject(query, rwMap,
				entidad.getUsuario());
	}

	/**
	 * Updates a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Pagination
	 * @return Entidad
	 */
	public Entidad updatePassword(Entidad entidad) {
		String query = "UPDATE ENTIDAD SET PASSWORD=? WHERE ENTIDAD_ID=?";
		this.jdbcTemplate.update(query, entidad.getPassword(),
				entidad.getEntidadId());
		return entidad;
	}
}
