package com.ejie.y40a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.Entidad;

/**
 * * EntidadDao  
 * 
 *  
 */

public interface EntidadDao {

	/**
	 * Inserts a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad add(Entidad entidad);

	/**
	 * Updates a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad update(Entidad entidad);

	/**
	 * Finds a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad find(Entidad entidad);

	/**
	 * Deletes a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return
	 */
	void remove(Entidad entidad);

	/**
	 * Finds a List of rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Entidad> findAll(Entidad entidad, Pagination pagination);

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return List
	 */
	Long findAllCount(Entidad entidad);

	/**
	 * Finds rows in the Entidad table using like.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Entidad> findAllLike(Entidad entidad, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	Long findAllLikeCount(Entidad entidad, Boolean startsWith);

	/**
	 * Finds rows in the Entidad table using like.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Entidad> findAllLikeTabla(Entidad entidad, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Long
	 */
	Long findAllLikeTablaCount(Entidad entidad, Boolean startsWith);

	/**
	 * Finds a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Pagination
	 * @return Entidad
	 */
	Entidad findEntidadUser(Entidad entidad);

	/**
	 * Updates a single row in the Entidad table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @return Entidad
	 */
	Entidad updatePassword(Entidad entidad);
}
