package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.EntidadContacto;

/**
 * * EntidadContactoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class EntidadContactoDaoImpl implements EntidadContactoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<EntidadContacto> rwMap = new RowMapper<EntidadContacto>() {
		public EntidadContacto mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EntidadContacto(resultSet.getString("ENTIDADID"),
					resultSet.getString("CONTACTOID"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the EntidadContacto table.
	 * 
	 * @param entidadcontacto
	 *            Pagination
	 * @return EntidadContacto
	 */
	public EntidadContacto add(EntidadContacto entidadcontacto) {

		String query = "INSERT INTO ENTIDAD_CONTACTO( ENTIDAD_ID,CONTACTO_ID)"
				+ "VALUES (?,?)";

		this.jdbcTemplate.update(query, entidadcontacto.getEntidadId(),
				entidadcontacto.getContactoId());
		return entidadcontacto;
	}

	/**
	 * Updates a single row in the EntidadContacto table.
	 * 
	 * @param entidadcontacto
	 *            Pagination
	 * @return EntidadContacto
	 */
	public EntidadContacto update(EntidadContacto entidadcontacto) {
		String query = "UPDATE ENTIDAD_CONTACTO SET  WHERE ENTIDAD_ID=? AND CONTACTO_ID=?";
		this.jdbcTemplate.update(query, entidadcontacto.getEntidadId(),
				entidadcontacto.getContactoId());
		return entidadcontacto;
	}

	/**
	 * Finds a single row in the EntidadContacto table.
	 * 
	 * @param entidadcontacto
	 *            Pagination
	 * @return EntidadContacto
	 */
	@Transactional(readOnly = true)
	public EntidadContacto find(EntidadContacto entidadcontacto) {
		String query = "SELECT t1.ENTIDAD_ID ENTIDADID, t1.CONTACTO_ID CONTACTOID "
				+ "FROM ENTIDAD_CONTACTO t1  "
				+ "WHERE t1.ENTIDAD_ID = ?   AND t1.CONTACTO_ID = ?    ";
		return (EntidadContacto) this.jdbcTemplate
				.queryForObject(query, rwMap, entidadcontacto.getEntidadId(),
						entidadcontacto.getContactoId());
	}

	/**
	 * Removes a single row in the EntidadContacto table.
	 * 
	 * @param entidadcontacto
	 *            Pagination
	 * @return
	 */
	public void remove(EntidadContacto entidadcontacto) {
		String query = "DELETE  FROM ENTIDAD_CONTACTO WHERE ENTIDAD_ID=? AND CONTACTO_ID=?";
		this.jdbcTemplate.update(query, entidadcontacto.getEntidadId(),
				entidadcontacto.getContactoId());
	}

	/**
	 * Finds a List of rows in the EntidadContacto table.
	 * 
	 * @param entidadcontacto
	 *            EntidadContacto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EntidadContacto> findAll(EntidadContacto entidadcontacto,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ENTIDAD_ID ENTIDADID,t1.CONTACTO_ID CONTACTOID "
						+ "FROM ENTIDAD_CONTACTO t1 ");

		if (entidadcontacto != null && entidadcontacto.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(entidadcontacto.getEntidadId());
		}
		if (entidadcontacto != null && entidadcontacto.getContactoId() != null) {
			where.append(" AND t1.CONTACTO_ID = ?");
			params.add(entidadcontacto.getContactoId());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<EntidadContacto>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the EntidadContacto table.
	 * 
	 * @param entidadcontacto
	 *            EntidadContacto
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(EntidadContacto entidadcontacto) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  ENTIDAD_CONTACTO t1  ");
		if (entidadcontacto != null && entidadcontacto.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(entidadcontacto.getEntidadId());
		}
		if (entidadcontacto != null && entidadcontacto.getContactoId() != null) {
			where.append(" AND t1.CONTACTO_ID = ?");
			params.add(entidadcontacto.getContactoId());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the EntidadContacto table using like.
	 * 
	 * @param entidadcontacto
	 *            EntidadContacto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EntidadContacto> findAllLike(EntidadContacto entidadcontacto,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ENTIDAD_ID ENTIDADID,t1.CONTACTO_ID CONTACTOID "
						+ "FROM ENTIDAD_CONTACTO t1 ");

		if (entidadcontacto != null && entidadcontacto.getEntidadId() != null) {
			where.append(" AND UPPER(t1.ENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidadcontacto.getEntidadId().toUpperCase() + "%");
			} else {
				params.add("%" + entidadcontacto.getEntidadId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ENTIDAD_ID IS NOT NULL");
		}
		if (entidadcontacto != null && entidadcontacto.getContactoId() != null) {
			where.append(" AND UPPER(t1.CONTACTO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(entidadcontacto.getContactoId().toUpperCase() + "%");
			} else {
				params.add("%" + entidadcontacto.getContactoId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CONTACTO_ID IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<EntidadContacto>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}
}
