package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y40a.model.EntidadContacto;

/**
 *  * EntidadContactoDao  
 *  
 */

public interface EntidadContactoDao {
    
    /**
     * Inserts a single row in the EntidadContacto table.
     *
     * @param entidadcontacto EntidadContacto
     * @return EntidadContacto
     */
    EntidadContacto add(EntidadContacto entidadcontacto);

    /**
     * Updates a single row in the EntidadContacto table.
     *
     * @param entidadcontacto EntidadContacto
     * @return EntidadContacto
     */
    EntidadContacto update(EntidadContacto entidadcontacto);

    /**
     * Finds a single row in the EntidadContacto table.
     *
     * @param entidadcontacto EntidadContacto
     * @return EntidadContacto
     */
    EntidadContacto find(EntidadContacto entidadcontacto);

    /**
     * Deletes a single row in the EntidadContacto table.
     *
     * @param entidadcontacto EntidadContacto
     * @return 
     */
    void remove(EntidadContacto entidadcontacto);

    /**
     * Finds a List of rows in the EntidadContacto table.
     *
     * @param entidadcontacto EntidadContacto
     * @param pagination Pagination
     * @return List
     */
    List<EntidadContacto> findAll(EntidadContacto entidadcontacto, Pagination pagination);

    /**
     * Counts rows in the EntidadContacto table.
     *
     * @param entidadcontacto EntidadContacto
     * @return List
     */
    Long findAllCount(EntidadContacto entidadcontacto);
	
	/**
     * Finds rows in the EntidadContacto table using like.
     *
     * @param entidadcontacto EntidadContacto
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<EntidadContacto> findAllLike(EntidadContacto entidadcontacto, Pagination pagination, Boolean startsWith);
}

