package com.ejie.y40a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y40a.model.Contacto;
import com.ejie.y40a.model.Entidad;

/**
 * * ContactoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ContactoDaoImpl implements ContactoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Contacto> rwMap = new RowMapper<Contacto>() {
		public Contacto mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Contacto(resultSet.getString("CONTACTOID"),
					resultSet.getString("NOMBRE"),
					resultSet.getString("CARGO"),
					resultSet.getString("TELEFONO"),
					resultSet.getString("FAX"), resultSet.getString("EMAIL"),
					resultSet.getString("URL"),
					resultSet.getString("ISNACIONAL"),
					resultSet.getString("NORAPAISID"),
					resultSet.getString("NOMBREPAIS"),
					resultSet.getString("NORAPROVINCIAID"),
					resultSet.getString("NOMBREPROVINCIA"),
					resultSet.getString("NORAMUNICIPIOID"),
					resultSet.getString("NOMBREMUNICIPIO"),
					resultSet.getString("NORALOCALIDADID"),
					resultSet.getString("NOMBRELOCALIDAD"),
					resultSet.getString("NORACALLEID"),
					resultSet.getString("NOMBRECALLE"),
					resultSet.getString("NORACPID"),
					resultSet.getString("NOMBRECP"),
					resultSet.getString("NORAPORTALID"),
					resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("USUULTMOD"),
					resultSet.getDate("FECULTMOD"),
					resultSet.getString("COMPLEDIREC"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Pagination
	 * @return Contacto
	 */
	public Contacto add(Contacto contacto) {

		String query = "INSERT INTO CONTACTO( CONTACTO_ID,NOMBRE,CARGO,TELEFONO,FAX,EMAIL,URL,ISNACIONAL,NORA_PAIS_ID,NOMBRE_PAIS,NORA_PROVINCIA_ID,NOMBRE_PROVINCIA,NORA_MUNICIPIO_ID,NOMBRE_MUNICIPIO,NORA_LOCALIDAD_ID,NOMBRE_LOCALIDAD,NORA_CALLE_ID,NOMBRE_CALLE,NORA_CP_ID,NOMBRE_CP,NORA_PORTAL_ID,NOMBRE_PORTAL,USUULTMOD,FECULTMOD,COMPLE_DIREC)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, contacto.getContactoId(),
				contacto.getNombre(), contacto.getCargo(),
				contacto.getTelefono(), contacto.getFax(), contacto.getEmail(),
				contacto.getUrl(), contacto.getIsnacional(),
				contacto.getNoraPaisId(), contacto.getNombrePais(),
				contacto.getNoraProvinciaId(), contacto.getNombreProvincia(),
				contacto.getNoraMunicipioId(), contacto.getNombreMunicipio(),
				contacto.getNoraLocalidadId(), contacto.getNombreLocalidad(),
				contacto.getNoraCalleId(), contacto.getNombreCalle(),
				contacto.getNoraCpId(), contacto.getNombreCp(),
				contacto.getNoraPortalId(), contacto.getNombrePortal(),
				contacto.getUsuultmod(), contacto.getFecultmod(),
				contacto.getCompleDirec());
		return contacto;
	}

	/**
	 * Updates a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Pagination
	 * @return Contacto
	 */
	public Contacto update(Contacto contacto) {
		String query = "UPDATE CONTACTO SET NOMBRE=?,CARGO=?,TELEFONO=?,FAX=?,EMAIL=?,URL=?,ISNACIONAL=?,NORA_PAIS_ID=?,NOMBRE_PAIS=?,NORA_PROVINCIA_ID=?,NOMBRE_PROVINCIA=?,NORA_MUNICIPIO_ID=?,NOMBRE_MUNICIPIO=?,NORA_LOCALIDAD_ID=?,NOMBRE_LOCALIDAD=?,NORA_CALLE_ID=?,NOMBRE_CALLE=?,NORA_CP_ID=?,NOMBRE_CP=?,NORA_PORTAL_ID=?,NOMBRE_PORTAL=?,USUULTMOD=?,FECULTMOD=?,COMPLE_DIREC=? WHERE CONTACTO_ID=?";
		this.jdbcTemplate.update(query, contacto.getNombre(),
				contacto.getCargo(), contacto.getTelefono(), contacto.getFax(),
				contacto.getEmail(), contacto.getUrl(),
				contacto.getIsnacional(), contacto.getNoraPaisId(),
				contacto.getNombrePais(), contacto.getNoraProvinciaId(),
				contacto.getNombreProvincia(), contacto.getNoraMunicipioId(),
				contacto.getNombreMunicipio(), contacto.getNoraLocalidadId(),
				contacto.getNombreLocalidad(), contacto.getNoraCalleId(),
				contacto.getNombreCalle(), contacto.getNoraCpId(),
				contacto.getNombreCp(), contacto.getNoraPortalId(),
				contacto.getNombrePortal(), contacto.getUsuultmod(),
				contacto.getFecultmod(), contacto.getCompleDirec(),
				contacto.getContactoId());
		return contacto;
	}

	/**
	 * Finds a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Pagination
	 * @return Contacto
	 */
	@Transactional(readOnly = true)
	public Contacto find(Contacto contacto) {
		String query = "SELECT t1.CONTACTO_ID CONTACTOID, t1.NOMBRE NOMBRE, t1.CARGO CARGO, t1.TELEFONO TELEFONO, t1.FAX FAX, t1.EMAIL EMAIL, t1.URL URL, t1.ISNACIONAL ISNACIONAL, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.USUULTMOD USUULTMOD, t1.FECULTMOD FECULTMOD, t1.COMPLE_DIREC COMPLEDIREC "
				+ "FROM CONTACTO t1  " + "WHERE t1.CONTACTO_ID = ?    ";
		return (Contacto) this.jdbcTemplate.queryForObject(query, rwMap,
				contacto.getContactoId());
	}

	/**
	 * Removes a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Pagination
	 * @return
	 */
	public void remove(Contacto contacto) {
		String query = "DELETE  FROM CONTACTO WHERE CONTACTO_ID=?";
		this.jdbcTemplate.update(query, contacto.getContactoId());
	}

	/**
	 * Finds a List of rows in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Contacto> findAll(Contacto contacto, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.CONTACTO_ID CONTACTOID,t1.NOMBRE NOMBRE,t1.CARGO CARGO,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.ISNACIONAL ISNACIONAL,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM CONTACTO t1 ");

		if (contacto != null && contacto.getContactoId() != null) {
			where.append(" AND t1.CONTACTO_ID = ?");
			params.add(contacto.getContactoId());
		}
		if (contacto != null && contacto.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(contacto.getNombre());
		}
		if (contacto != null && contacto.getCargo() != null) {
			where.append(" AND t1.CARGO = ?");
			params.add(contacto.getCargo());
		}
		if (contacto != null && contacto.getTelefono() != null) {
			where.append(" AND t1.TELEFONO = ?");
			params.add(contacto.getTelefono());
		}
		if (contacto != null && contacto.getFax() != null) {
			where.append(" AND t1.FAX = ?");
			params.add(contacto.getFax());
		}
		if (contacto != null && contacto.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(contacto.getEmail());
		}
		if (contacto != null && contacto.getUrl() != null) {
			where.append(" AND t1.URL = ?");
			params.add(contacto.getUrl());
		}
		if (contacto != null && contacto.getIsnacional() != null) {
			where.append(" AND t1.ISNACIONAL = ?");
			params.add(contacto.getIsnacional());
		}
		if (contacto != null && contacto.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(contacto.getNoraPaisId());
		}
		if (contacto != null && contacto.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(contacto.getNombrePais());
		}
		if (contacto != null && contacto.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(contacto.getNoraProvinciaId());
		}
		if (contacto != null && contacto.getNombreProvincia() != null) {
			where.append(" AND t1.NOMBRE_PROVINCIA = ?");
			params.add(contacto.getNombreProvincia());
		}
		if (contacto != null && contacto.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(contacto.getNoraMunicipioId());
		}
		if (contacto != null && contacto.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(contacto.getNombreMunicipio());
		}
		if (contacto != null && contacto.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(contacto.getNoraLocalidadId());
		}
		if (contacto != null && contacto.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(contacto.getNombreLocalidad());
		}
		if (contacto != null && contacto.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(contacto.getNoraCalleId());
		}
		if (contacto != null && contacto.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(contacto.getNombreCalle());
		}
		if (contacto != null && contacto.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(contacto.getNoraCpId());
		}
		if (contacto != null && contacto.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(contacto.getNombreCp());
		}
		if (contacto != null && contacto.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(contacto.getNoraPortalId());
		}
		if (contacto != null && contacto.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(contacto.getNombrePortal());
		}
		if (contacto != null && contacto.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(contacto.getUsuultmod());
		}
		if (contacto != null && contacto.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(contacto.getFecultmod());
		}
		if (contacto != null && contacto.getCompleDirec() != null) {
			where.append(" AND t1.COMPLE_DIREC = ?");
			params.add(contacto.getCompleDirec());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Contacto>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Contacto contacto) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  CONTACTO t1  ");
		if (contacto != null && contacto.getContactoId() != null) {
			where.append(" AND t1.CONTACTO_ID = ?");
			params.add(contacto.getContactoId());
		}
		if (contacto != null && contacto.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(contacto.getNombre());
		}
		if (contacto != null && contacto.getCargo() != null) {
			where.append(" AND t1.CARGO = ?");
			params.add(contacto.getCargo());
		}
		if (contacto != null && contacto.getTelefono() != null) {
			where.append(" AND t1.TELEFONO = ?");
			params.add(contacto.getTelefono());
		}
		if (contacto != null && contacto.getFax() != null) {
			where.append(" AND t1.FAX = ?");
			params.add(contacto.getFax());
		}
		if (contacto != null && contacto.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(contacto.getEmail());
		}
		if (contacto != null && contacto.getUrl() != null) {
			where.append(" AND t1.URL = ?");
			params.add(contacto.getUrl());
		}
		if (contacto != null && contacto.getIsnacional() != null) {
			where.append(" AND t1.ISNACIONAL = ?");
			params.add(contacto.getIsnacional());
		}
		if (contacto != null && contacto.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(contacto.getNoraPaisId());
		}
		if (contacto != null && contacto.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(contacto.getNombrePais());
		}
		if (contacto != null && contacto.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(contacto.getNoraProvinciaId());
		}
		if (contacto != null && contacto.getNombreProvincia() != null) {
			where.append(" AND t1.NOMBRE_PROVINCIA = ?");
			params.add(contacto.getNombreProvincia());
		}
		if (contacto != null && contacto.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(contacto.getNoraMunicipioId());
		}
		if (contacto != null && contacto.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(contacto.getNombreMunicipio());
		}
		if (contacto != null && contacto.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(contacto.getNoraLocalidadId());
		}
		if (contacto != null && contacto.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(contacto.getNombreLocalidad());
		}
		if (contacto != null && contacto.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(contacto.getNoraCalleId());
		}
		if (contacto != null && contacto.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(contacto.getNombreCalle());
		}
		if (contacto != null && contacto.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(contacto.getNoraCpId());
		}
		if (contacto != null && contacto.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(contacto.getNombreCp());
		}
		if (contacto != null && contacto.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(contacto.getNoraPortalId());
		}
		if (contacto != null && contacto.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(contacto.getNombrePortal());
		}
		if (contacto != null && contacto.getUsuultmod() != null) {
			where.append(" AND t1.USUULTMOD = ?");
			params.add(contacto.getUsuultmod());
		}
		if (contacto != null && contacto.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD = ?");
			params.add(contacto.getFecultmod());
		}
		if (contacto != null && contacto.getCompleDirec() != null) {
			where.append(" AND t1.COMPLE_DIREC = ?");
			params.add(contacto.getCompleDirec());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Contacto table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Contacto> findAllContactoEntidad(Entidad entidad,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.CONTACTO_ID = t2.CONTACTO_ID(+)	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.CONTACTO_ID CONTACTOID,t1.NOMBRE NOMBRE,t1.CARGO CARGO,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.ISNACIONAL ISNACIONAL,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM CONTACTO t1, ENTIDAD_CONTACTO t2 ");

		if (entidad != null && entidad.getEntidadId() != null) {
			where.append(" AND t2.ENTIDAD_ID = ?");
			params.add(entidad.getEntidadId());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Contacto>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllContactoEntidadCount(Entidad entidad) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.CONTACTO_ID = t2.CONTACTO_ID(+)  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM CONTACTO t1, ENTIDAD_CONTACTO t2 ");

		if (entidad != null && entidad.getEntidadId() != null) {
			where.append(" AND t2.ENTIDAD_ID = ?");
			params.add(entidad.getEntidadId());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Contacto table using like.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Contacto> findAllLike(Contacto contacto, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.CONTACTO_ID CONTACTOID,t1.NOMBRE NOMBRE,t1.CARGO CARGO,t1.TELEFONO TELEFONO,t1.FAX FAX,t1.EMAIL EMAIL,t1.URL URL,t1.ISNACIONAL ISNACIONAL,t1.NORA_PAIS_ID NORAPAISID,t1.NOMBRE_PAIS NOMBREPAIS,t1.NORA_PROVINCIA_ID NORAPROVINCIAID,t1.NOMBRE_PROVINCIA NOMBREPROVINCIA,t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID,t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO,t1.NORA_LOCALIDAD_ID NORALOCALIDADID,t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD,t1.NORA_CALLE_ID NORACALLEID,t1.NOMBRE_CALLE NOMBRECALLE,t1.NORA_CP_ID NORACPID,t1.NOMBRE_CP NOMBRECP,t1.NORA_PORTAL_ID NORAPORTALID,t1.NOMBRE_PORTAL NOMBREPORTAL,t1.USUULTMOD USUULTMOD,t1.FECULTMOD FECULTMOD,t1.COMPLE_DIREC COMPLEDIREC "
						+ "FROM CONTACTO t1 ");

		if (contacto != null && contacto.getContactoId() != null) {
			where.append(" AND UPPER(t1.CONTACTO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getContactoId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getContactoId().toUpperCase() + "%");
			}
			where.append(" AND t1.CONTACTO_ID IS NOT NULL");
		}
		if (contacto != null && contacto.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (contacto != null && contacto.getCargo() != null) {
			where.append(" AND UPPER(t1.CARGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getCargo().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getCargo().toUpperCase() + "%");
			}
			where.append(" AND t1.CARGO IS NOT NULL");
		}
		if (contacto != null && contacto.getTelefono() != null) {
			where.append(" AND UPPER(t1.TELEFONO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getTelefono().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getTelefono().toUpperCase() + "%");
			}
			where.append(" AND t1.TELEFONO IS NOT NULL");
		}
		if (contacto != null && contacto.getFax() != null) {
			where.append(" AND UPPER(t1.FAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getFax().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getFax().toUpperCase() + "%");
			}
			where.append(" AND t1.FAX IS NOT NULL");
		}
		if (contacto != null && contacto.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getEmail().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}
		if (contacto != null && contacto.getUrl() != null) {
			where.append(" AND UPPER(t1.URL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getUrl().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getUrl().toUpperCase() + "%");
			}
			where.append(" AND t1.URL IS NOT NULL");
		}
		if (contacto != null && contacto.getIsnacional() != null) {
			where.append(" AND UPPER(t1.ISNACIONAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getIsnacional().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getIsnacional().toUpperCase() + "%");
			}
			where.append(" AND t1.ISNACIONAL IS NOT NULL");
		}
		if (contacto != null && contacto.getNoraPaisId() != null) {
			where.append(" AND UPPER(t1.NORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNoraPaisId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PAIS_ID IS NOT NULL");
		}
		if (contacto != null && contacto.getNombrePais() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombrePais().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombrePais().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PAIS IS NOT NULL");
		}
		if (contacto != null && contacto.getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNoraProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNoraProvinciaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (contacto != null && contacto.getNombreProvincia() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombreProvincia().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombreProvincia().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (contacto != null && contacto.getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNoraMunicipioId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNoraMunicipioId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (contacto != null && contacto.getNombreMunicipio() != null) {
			where.append(" AND UPPER(t1.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombreMunicipio().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombreMunicipio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (contacto != null && contacto.getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNoraLocalidadId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNoraLocalidadId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (contacto != null && contacto.getNombreLocalidad() != null) {
			where.append(" AND UPPER(t1.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombreLocalidad().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombreLocalidad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (contacto != null && contacto.getNoraCalleId() != null) {
			where.append(" AND UPPER(t1.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNoraCalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CALLE_ID IS NOT NULL");
		}
		if (contacto != null && contacto.getNombreCalle() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombreCalle().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CALLE IS NOT NULL");
		}
		if (contacto != null && contacto.getNoraCpId() != null) {
			where.append(" AND UPPER(t1.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNoraCpId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_CP_ID IS NOT NULL");
		}
		if (contacto != null && contacto.getNombreCp() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombreCp().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_CP IS NOT NULL");
		}
		if (contacto != null && contacto.getNoraPortalId() != null) {
			where.append(" AND UPPER(t1.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNoraPortalId().toUpperCase() + "%");
			}
			where.append(" AND t1.NORA_PORTAL_ID IS NOT NULL");
		}
		if (contacto != null && contacto.getNombrePortal() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getNombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getNombrePortal().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_PORTAL IS NOT NULL");
		}
		if (contacto != null && contacto.getUsuultmod() != null) {
			where.append(" AND UPPER(t1.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getUsuultmod().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getUsuultmod().toUpperCase() + "%");
			}
			where.append(" AND t1.USUULTMOD IS NOT NULL");
		}
		if (contacto != null && contacto.getFecultmod() != null) {
			where.append(" AND t1.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getFecultmod() + "%");
			} else {
				params.add("%" + contacto.getFecultmod() + "%");
			}
			where.append(" AND t1.FECULTMOD IS NOT NULL");
		}
		if (contacto != null && contacto.getCompleDirec() != null) {
			where.append(" AND UPPER(t1.COMPLE_DIREC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(contacto.getCompleDirec().toUpperCase() + "%");
			} else {
				params.add("%" + contacto.getCompleDirec().toUpperCase() + "%");
			}
			where.append(" AND t1.COMPLE_DIREC IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Contacto>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
