package com.ejie.y40a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.Contacto;
import com.ejie.y40a.model.Entidad;

/**
 * * ContactoDao  
 * 
 *  
 */

public interface ContactoDao {

	/**
	 * Inserts a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Contacto
	 */
	Contacto add(Contacto contacto);

	/**
	 * Updates a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Contacto
	 */
	Contacto update(Contacto contacto);

	/**
	 * Finds a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Contacto
	 */
	Contacto find(Contacto contacto);

	/**
	 * Deletes a single row in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return
	 */
	void remove(Contacto contacto);

	/**
	 * Finds a List of rows in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Contacto> findAll(Contacto contacto, Pagination pagination);

	/**
	 * Counts rows in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return List
	 */
	Long findAllCount(Contacto contacto);

	/**
	 * Finds rows in the Contacto table using like.
	 * 
	 * @param contacto
	 *            Contacto
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Contacto> findAllLike(Contacto contacto, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds a List of rows in the Contacto table.
	 * 
	 * @param entidad
	 *            Entidad
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Contacto> findAllContactoEntidad(Entidad entidad, Pagination pagination);

	/**
	 * Counts rows in the Contacto table.
	 * 
	 * @param contacto
	 *            Contacto
	 * @return Long
	 */
	Long findAllContactoEntidadCount(Entidad entidad);

}
