package com.ejie.y40a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y40a.constantes.Y40aConstantes;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.Grupo;
import com.ejie.y40a.model.Perfil;
import com.ejie.y40a.utils.Y40aUtils;

/**
 * * CategoriaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class CategoriaDaoImpl implements CategoriaDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Categoria> rwMap = new RowMapper<Categoria>() {
		public Categoria mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			List<String> columnasSeleccionadas = Y40aUtils
					.cargarDatosBDVO(resultSet);

			Categoria categoria = new Categoria(resultSet.getString("IDCAT"),
					resultSet.getString("NOMBREES"),
					resultSet.getString("NOMBREEU"),
					resultSet.getDate("FECHAINISOL"),
					resultSet.getDate("FECHAFINSOL"),
					resultSet.getLong("NUMASISTENTES"),
					resultSet.getLong("NUMFORMACIONES"),
					resultSet.getString("VISIBLEWEB"), new Categoria(
							resultSet.getString("CategoriaIDCATPADRE"), null,
							null, null, null, null, null, null, null, null,
							null, null, null));

			categoria.setObservacionesEs((columnasSeleccionadas
					.contains("OBSERVACIONESES")) ? resultSet
					.getString("OBSERVACIONESES") : null);
			categoria.setObservacionesEu((columnasSeleccionadas
					.contains("OBSERVACIONESEU")) ? resultSet
					.getString("OBSERVACIONESEU") : null);

			categoria.setVisiblecontacto((columnasSeleccionadas
					.contains("VISIBLECONTACTO")) ? resultSet
					.getString("VISIBLECONTACTO") : null);

			return categoria;

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Pagination
	 * @return Categoria
	 */
	public Categoria add(Categoria categoria) {

		String query = "INSERT INTO CATEGORIA( ID_CAT,ID_CAT_PADRE,NOMBRE_ES,NOMBRE_EU,FECHA_INI_SOL,FECHA_FIN_SOL,NUM_ASISTENTES,NUM_FORMACIONES,VISIBLE_WEB,OBSERVACIONES_ES,OBSERVACIONES_EU,VISIBLECONTACTO)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getCategoriaIdCatAux = null;
		if (categoria.getCategoria() != null
				&& categoria.getCategoria().getIdCat() != null) {
			getCategoriaIdCatAux = categoria.getCategoria().getIdCat();
		}
		this.jdbcTemplate.update(query, categoria.getIdCat(),
				getCategoriaIdCatAux, categoria.getNombreEs(),
				categoria.getNombreEu(), categoria.getFechaIniSol(),
				categoria.getFechaFinSol(), categoria.getNumAsistentes(),
				categoria.getNumFormaciones(), categoria.getVisibleWeb(),
				categoria.getObservacionesEs(), categoria.getObservacionesEu(),
				categoria.getVisiblecontacto());
		return categoria;
	}

	/**
	 * Updates a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Pagination
	 * @return Categoria
	 */
	public Categoria update(Categoria categoria) {
		String query = "UPDATE CATEGORIA SET ID_CAT_PADRE=?,NOMBRE_ES=?,NOMBRE_EU=?,FECHA_INI_SOL=?,FECHA_FIN_SOL=?,NUM_ASISTENTES=?,NUM_FORMACIONES=?,OBSERVACIONES_ES=?,OBSERVACIONES_EU=?,VISIBLECONTACTO=? WHERE ID_CAT=?";
		Object getCategoriaIdCatAux = null;
		if (categoria.getCategoria() != null
				&& categoria.getCategoria().getIdCat() != null) {
			getCategoriaIdCatAux = categoria.getCategoria().getIdCat();
		}
		this.jdbcTemplate.update(query, getCategoriaIdCatAux,
				categoria.getNombreEs(), categoria.getNombreEu(),
				categoria.getFechaIniSol(), categoria.getFechaFinSol(),
				categoria.getNumAsistentes(), categoria.getNumFormaciones(),
				categoria.getObservacionesEs(), categoria.getObservacionesEu(),
				categoria.getVisiblecontacto(), categoria.getIdCat());
		return categoria;
	}

	/**
	 * Updates a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Pagination
	 * @return Categoria
	 */
	public Categoria updateNombre(Categoria categoria) {
		String query = "UPDATE CATEGORIA SET NOMBRE_ES=?,NOMBRE_EU=? WHERE ID_CAT=?";

		this.jdbcTemplate.update(query, categoria.getNombreEs(),
				categoria.getNombreEu(), categoria.getIdCat());
		return categoria;
	}

	/**
	 * Updates a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Pagination
	 * @return Categoria
	 */
	public Categoria updateVisibleWeb(Categoria categoria) {
		String query = "UPDATE CATEGORIA SET VISIBLE_WEB=? WHERE ID_CAT=?";
		this.jdbcTemplate.update(query, categoria.getVisibleWeb(),
				categoria.getIdCat());
		return categoria;
	}

	/**
	 * Finds a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Pagination
	 * @return Categoria
	 */
	@Transactional(readOnly = true)
	public Categoria find(Categoria categoria) {
		String query = "SELECT t1.ID_CAT IDCAT, t1.NOMBRE_ES NOMBREES, t1.NOMBRE_EU NOMBREEU, t1.FECHA_INI_SOL FECHAINISOL, t1.FECHA_FIN_SOL FECHAFINSOL, t1.NUM_ASISTENTES NUMASISTENTES, t1.NUM_FORMACIONES NUMFORMACIONES, t1.VISIBLE_WEB VISIBLEWEB, t1.ID_CAT_PADRE CATEGORIAIDCATPADRE, t1.OBSERVACIONES_ES OBSERVACIONESES, t1.OBSERVACIONES_EU OBSERVACIONESEU, t1.VISIBLECONTACTO VISIBLECONTACTO  "

				+ "FROM CATEGORIA t1  " + "WHERE t1.ID_CAT = ? ";
		return (Categoria) this.jdbcTemplate.queryForObject(query, rwMap,
				categoria.getIdCat());
	}

	/**
	 * Finds a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Pagination
	 * @return Categoria
	 */
	@Transactional(readOnly = true)
	public Categoria findCategoriaPadre(Categoria categoria) {
		String query = "SELECT t2.ID_CAT IDCAT, t2.NOMBRE_ES NOMBREES, t2.NOMBRE_EU NOMBREEU, t2.FECHA_INI_SOL FECHAINISOL, t2.FECHA_FIN_SOL FECHAFINSOL, t2.NUM_ASISTENTES NUMASISTENTES, t2.NUM_FORMACIONES NUMFORMACIONES, t2.VISIBLE_WEB VISIBLEWEB "
				+ "FROM CATEGORIA t1 , CATEGORIA t2  "
				+ "WHERE t1.ID_CAT = ?   AND t1.ID_CAT_PADRE= t2.ID_CAT(+)  ";
		return (Categoria) this.jdbcTemplate.queryForObject(query,
				new RowMapper<Categoria>() {
					public Categoria mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Categoria(resultSet.getString("IDCAT"),
								resultSet.getString("NOMBREES"), resultSet
										.getString("NOMBREEU"), resultSet
										.getDate("FECHAINISOL"), resultSet
										.getDate("FECHAFINSOL"), resultSet
										.getLong("NUMASISTENTES"), resultSet
										.getLong("NUMFORMACIONES"), resultSet
										.getString("VISIBLEWEB"), null);
					}
				}, categoria.getIdCat());
	}

	/**
	 * Removes a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Pagination
	 * @return
	 */
	public void remove(Categoria categoria) {
		String query = "DELETE  FROM CATEGORIA WHERE ID_CAT=?";
		this.jdbcTemplate.update(query, categoria.getIdCat());
	}

	/**
	 * Finds a List of rows in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Categoria> findAll(Categoria categoria, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_CAT IDCAT,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.FECHA_INI_SOL FECHAINISOL,t1.FECHA_FIN_SOL FECHAFINSOL,t1.NUM_ASISTENTES NUMASISTENTES,t1.NUM_FORMACIONES NUMFORMACIONES,t1.VISIBLE_WEB VISIBLEWEB,t1.ID_CAT_PADRE CATEGORIAIDCATPADRE "
						+ "FROM CATEGORIA t1 ");

		if (categoria != null && categoria.getIdCat() != null) {
			where.append(" AND t1.ID_CAT = ?");
			params.add(categoria.getIdCat());
		}
		if (categoria != null && categoria.getCategoria() != null
				&& categoria.getCategoria().getIdCat() != null) {
			where.append(" AND t1.ID_CAT_PADRE = ?");
			params.add(categoria.getCategoria().getIdCat());
		}
		if (categoria != null && categoria.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(categoria.getNombreEs());
		}
		if (categoria != null && categoria.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(categoria.getNombreEu());
		}
		if (categoria != null && categoria.getFechaIniSol() != null) {
			where.append(" AND t1.FECHA_INI_SOL = ?");
			params.add(categoria.getFechaIniSol());
		}
		if (categoria != null && categoria.getFechaFinSol() != null) {
			where.append(" AND t1.FECHA_FIN_SOL = ?");
			params.add(categoria.getFechaFinSol());
		}
		if (categoria != null && categoria.getNumAsistentes() != null) {
			where.append(" AND t1.NUM_ASISTENTES = ?");
			params.add(categoria.getNumAsistentes());
		}
		if (categoria != null && categoria.getNumFormaciones() != null) {
			where.append(" AND t1.NUM_FORMACIONES = ?");
			params.add(categoria.getNumFormaciones());
		}
		if (categoria != null && categoria.getVisibleWeb() != null) {
			where.append(" AND t1.VISIBLE_WEB = ?");
			params.add(categoria.getVisibleWeb());
		}

		if (categoria != null && categoria.getCategoria() == null) {
			where.append(" AND ");
			where.append("t1.ID_CAT_PADRE IS NULL");
		}

		where.append(" AND t1.ID_CAT <> ? ");
		params.add(Y40aConstantes.CATEGORIA_RAIZ_ID);

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Categoria>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Categoria categoria) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  CATEGORIA t1 ");
		if (categoria != null && categoria.getIdCat() != null) {
			where.append(" AND t1.ID_CAT = ?");
			params.add(categoria.getIdCat());
		}

		if (categoria != null && categoria.getCategoria() != null
				&& categoria.getCategoria().getIdCat() != null) {
			where.append(" AND t1.ID_CAT_PADRE = ?");
			params.add(categoria.getCategoria().getIdCat());
		}
		if (categoria != null && categoria.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(categoria.getNombreEs());
		}
		if (categoria != null && categoria.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(categoria.getNombreEu());
		}
		if (categoria != null && categoria.getFechaIniSol() != null) {
			where.append(" AND t1.FECHA_INI_SOL = ?");
			params.add(categoria.getFechaIniSol());
		}
		if (categoria != null && categoria.getFechaFinSol() != null) {
			where.append(" AND t1.FECHA_FIN_SOL = ?");
			params.add(categoria.getFechaFinSol());
		}
		if (categoria != null && categoria.getNumAsistentes() != null) {
			where.append(" AND t1.NUM_ASISTENTES = ?");
			params.add(categoria.getNumAsistentes());
		}
		if (categoria != null && categoria.getNumFormaciones() != null) {
			where.append(" AND t1.NUM_FORMACIONES = ?");
			params.add(categoria.getNumFormaciones());
		}
		if (categoria != null && categoria.getVisibleWeb() != null) {
			where.append(" AND t1.VISIBLE_WEB = ?");
			params.add(categoria.getVisibleWeb());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param perfiles
	 *            Vector<String>
	 * @param grupos
	 *            List<Grupo>
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Categoria> findAllCategoriaSeguridad(Categoria categoria,
			Vector<String> perfiles, List<Grupo> grupos, Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ID_CAT = t2.ID_CAT(+) AND t1.ID_CAT = t3.ID_CAT(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT  distinct t1.ID_CAT IDCAT,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.FECHA_INI_SOL FECHAINISOL,t1.FECHA_FIN_SOL FECHAFINSOL,t1.NUM_ASISTENTES NUMASISTENTES,t1.NUM_FORMACIONES NUMFORMACIONES,t1.VISIBLE_WEB VISIBLEWEB,t1.ID_CAT_PADRE CATEGORIAIDCATPADRE "
						+ "FROM CATEGORIA t1, CATEGORIA_GRUPOS t2, CATEGORIA_PERFIL t3 ");

		if (categoria != null && categoria.getIdCat() != null) {
			where.append(" AND t1.ID_CAT = ?");
			params.add(categoria.getIdCat());
		}
		if (categoria != null && categoria.getCategoria() != null
				&& categoria.getCategoria().getIdCat() != null) {
			where.append(" AND t1.ID_CAT_PADRE = ?");
			params.add(categoria.getCategoria().getIdCat());
		}
		if (categoria != null && categoria.getNombreEs() != null) {
			where.append(" AND t1.NOMBRE_ES = ?");
			params.add(categoria.getNombreEs());
		}
		if (categoria != null && categoria.getNombreEu() != null) {
			where.append(" AND t1.NOMBRE_EU = ?");
			params.add(categoria.getNombreEu());
		}
		if (categoria != null && categoria.getFechaIniSol() != null) {
			where.append(" AND t1.FECHA_INI_SOL = ?");
			params.add(categoria.getFechaIniSol());
		}
		if (categoria != null && categoria.getFechaFinSol() != null) {
			where.append(" AND t1.FECHA_FIN_SOL = ?");
			params.add(categoria.getFechaFinSol());
		}
		if (categoria != null && categoria.getNumAsistentes() != null) {
			where.append(" AND t1.NUM_ASISTENTES = ?");
			params.add(categoria.getNumAsistentes());
		}
		if (categoria != null && categoria.getNumFormaciones() != null) {
			where.append(" AND t1.NUM_FORMACIONES = ?");
			params.add(categoria.getNumFormaciones());
		}
		if (categoria != null && categoria.getVisibleWeb() != null) {
			where.append(" AND t1.VISIBLE_WEB = ?");
			params.add(categoria.getVisibleWeb());
		}

		if (categoria != null && categoria.getCategoria() == null) {
			where.append(" AND ");
			where.append("t1.ID_CAT_PADRE IS NULL");
		}

		where.append(" AND t1.ID_CAT <> ? ");
		params.add(Y40aConstantes.CATEGORIA_RAIZ_ID);

		if (grupos != null && grupos.size() > 0) {

			where.append(" AND t2.GRUPO_ID IN ( ");
			boolean firstElement = true;

			for (Grupo grupoAux : grupos) {

				if (firstElement) {

					where.append("?");
					params.add(grupoAux.getGrupoId());
					firstElement = false;

				} else {

					where.append(",?");
					params.add(grupoAux.getGrupoId());
				}
			}
			where.append(") ");
		}

		if (perfiles != null && perfiles.size() > 0) {

			where.append(" AND t3.ID_PERFIL IN ( ");
			boolean firstElement = true;
			for (String idPerfilAux : perfiles) {

				if (firstElement) {

					where.append("?");
					params.add(idPerfilAux);
					firstElement = false;

				} else {

					where.append(",?");
					params.add(idPerfilAux);
				}
			}

			where.append(") ");
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<Categoria>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Categoria table using like.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Categoria> findAllLike(Categoria categoria,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ID_CAT IDCAT,t1.NOMBRE_ES NOMBREES,t1.NOMBRE_EU NOMBREEU,t1.FECHA_INI_SOL FECHAINISOL,t1.FECHA_FIN_SOL FECHAFINSOL,t1.NUM_ASISTENTES NUMASISTENTES,t1.NUM_FORMACIONES NUMFORMACIONES,t1.VISIBLE_WEB VISIBLEWEB,t2.ID_CAT_PADRE CATEGORIAIDCATPADRE "
						+ "FROM CATEGORIA t1 ");

		if (categoria != null && categoria.getIdCat() != null) {
			where.append(" AND UPPER(t1.ID_CAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(categoria.getIdCat().toUpperCase() + "%");
			} else {
				params.add("%" + categoria.getIdCat().toUpperCase() + "%");
			}
			where.append(" AND t1.ID_CAT IS NOT NULL");
		}

		if (categoria != null && categoria.getCategoria() != null
				&& categoria.getCategoria().getIdCat() != null) {
			where.append(" AND UPPER(t1.ID_CAT_PADRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(categoria.getCategoria().getIdCat().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ categoria.getCategoria().getIdCat().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ID_CAT_PADRE IS NOT NULL");
		}
		if (categoria != null && categoria.getNombreEs() != null) {
			where.append(" AND UPPER(t1.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(categoria.getNombreEs().toUpperCase() + "%");
			} else {
				params.add("%" + categoria.getNombreEs().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_ES IS NOT NULL");
		}
		if (categoria != null && categoria.getNombreEu() != null) {
			where.append(" AND UPPER(t1.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(categoria.getNombreEu().toUpperCase() + "%");
			} else {
				params.add("%" + categoria.getNombreEu().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_EU IS NOT NULL");
		}
		if (categoria != null && categoria.getFechaIniSol() != null) {
			where.append(" AND t1.FECHA_INI_SOL like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(categoria.getFechaIniSol() + "%");
			} else {
				params.add("%" + categoria.getFechaIniSol() + "%");
			}
			where.append(" AND t1.FECHA_INI_SOL IS NOT NULL");
		}
		if (categoria != null && categoria.getFechaFinSol() != null) {
			where.append(" AND t1.FECHA_FIN_SOL like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(categoria.getFechaFinSol() + "%");
			} else {
				params.add("%" + categoria.getFechaFinSol() + "%");
			}
			where.append(" AND t1.FECHA_FIN_SOL IS NOT NULL");
		}
		if (categoria != null && categoria.getNumAsistentes() != null) {
			where.append(" AND t1.NUM_ASISTENTES like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(categoria.getNumAsistentes() + "%");
			} else {
				params.add("%" + categoria.getNumAsistentes() + "%");
			}
			where.append(" AND t1.NUM_ASISTENTES IS NOT NULL");
		}
		if (categoria != null && categoria.getNumFormaciones() != null) {
			where.append(" AND t1.NUM_FORMACIONES like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(categoria.getNumFormaciones() + "%");
			} else {
				params.add("%" + categoria.getNumFormaciones() + "%");
			}
			where.append(" AND t1.NUM_FORMACIONES IS NOT NULL");
		}
		if (categoria != null && categoria.getVisibleWeb() != null) {
			where.append(" AND UPPER(t1.VISIBLE_WEB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(categoria.getVisibleWeb().toUpperCase() + "%");
			} else {
				params.add("%" + categoria.getVisibleWeb().toUpperCase() + "%");
			}
			where.append(" AND t1.VISIBLE_WEB IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Categoria>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllNameCategoriaCount(Categoria categoria) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  CATEGORIA t1 ");

		if (categoria != null && categoria.getIdCat() != null) {
			where.append(" AND t1.ID_CAT <> ?");
			params.add(categoria.getIdCat());
		}

		if (categoria != null && categoria.getCategoria() != null
				&& categoria.getCategoria().getIdCat() != null) {
			where.append(" AND t1.ID_CAT_PADRE = ?");
			params.add(categoria.getCategoria().getIdCat());
		} else {
			where.append(" AND t1.ID_CAT_PADRE IS NULL ");
		}

		if (categoria != null && categoria.getNombreEs() != null) {
			where.append(" AND UPPER(t1.NOMBRE_ES) = ?");
			params.add(categoria.getNombreEs().toUpperCase());
		}

		if (categoria != null && categoria.getNombreEu() != null) {
			where.append(" AND UPPER(t1.NOMBRE_EU) = ?");
			params.add(categoria.getNombreEu().toUpperCase());
		}

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Inserts a single row in the CategoriaPerfil table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	public Categoria addCategoriaPerfil(Categoria categoria) {
		String query = "INSERT INTO Y40A06T00 " + "( ID_CAT,ID_PERFIL) "
				+ " values (?, ?)";

		List<Perfil> auxiliarPerfil = categoria.getPerfils();
		Iterator<Perfil> it = auxiliarPerfil.iterator();
		while (it.hasNext()) {
			Perfil perfil = (Perfil) it.next();
			this.jdbcTemplate.update(query, categoria.getIdCat(),
					perfil.getIdPerfil());
		}
		return categoria;
	}

	/**
	 * Deletes a single row in the CategoriaPerfil table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return
	 */
	public void removeCategoriaPerfil(Categoria categoria) {
		String query = "DELETE  FROM Y40A06T00 "
				+ " WHERE ID_CAT=? AND ID_PERFIL=?";
		List<Perfil> auxiliarPerfil = categoria.getPerfils();
		Iterator<Perfil> it = auxiliarPerfil.iterator();
		while (it.hasNext()) {
			Perfil perfil = (Perfil) it.next();
			this.jdbcTemplate.update(query, categoria.getIdCat(),
					perfil.getIdPerfil());
		}
	}

	/**
	 * Deletes a single row in the CategoriaPerfil table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return
	 */
	public void removeAllCategoriaPerfil(Categoria categoria) {
		String query = "DELETE  FROM Y40A06T00 " + " WHERE ID_CAT=? ";
		this.jdbcTemplate.update(query, categoria.getIdCat());
	}

	/**
	 * Find a single row in the findCategoriaPerfil Many To Many relationship.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return Categoria
	 */
	@Transactional(readOnly = true)
	public Categoria findCategoriaPerfil(Categoria categoria, Perfil perfil,
			Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.ID_PERFIL = t2.ID_PERFIL AND t1.ID_CAT=?");

		params.add(categoria.getIdCat());

		if (perfil.getIdPerfil() != null) {
			where.append(" AND t2.ID_PERFIL = ?");
			params.add(perfil.getIdPerfil());
		}
		if (perfil.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(perfil.getNombreEs());
		}
		if (perfil.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(perfil.getNombreEu());
		}

		StringBuffer query = new StringBuffer(
				"SELECT t2.Id_perfil idPerfil, t2.nombre_Es NOMBREES, t2.nombre_Eu NOMBREEU FROM Y40a06t00 t1,Y40A05T00 t2  ");
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		List<Perfil> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Perfil>() {
					public Perfil mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Perfil(resultSet.getString("IDPERFIL"),
								resultSet.getString("NOMBREES"), resultSet
										.getString("NOMBREEU"), null);
					}
				}, params.toArray());
		categoria.setPerfils(listaHijo);
		return categoria;
	}

	/**
	 * Counts rows in the CategoriaPerfil table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param perfil
	 *            Perfil
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findCategoriaPerfilCount(Categoria categoria, Perfil perfil) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.ID_PERFIL = t2.ID_PERFIL AND t1.ID_CAT=?");

		params.add(categoria.getIdCat());

		if (perfil.getIdPerfil() != null) {
			where.append(" AND t2.ID_PERFIL = ?");
			params.add(perfil.getIdPerfil());
		}
		if (perfil.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(perfil.getNombreEs());
		}
		if (perfil.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(perfil.getNombreEu());
		}

		StringBuffer query = new StringBuffer(
				"SELECT count(1) FROM Y40a06t00 t1,Y40A05T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Inserts a single row in the CategoriaGrupos table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	public Categoria addCategoriaGrupos(Categoria categoria) {
		String query = "INSERT INTO Y40A04T00 " + "( ID_CAT,GRUPO_ID) "
				+ " values (?, ?)";

		List<Grupo> auxiliarGrupo = categoria.getGrupos();
		Iterator<Grupo> it = auxiliarGrupo.iterator();
		while (it.hasNext()) {
			Grupo grupo = (Grupo) it.next();
			this.jdbcTemplate.update(query, categoria.getIdCat(),
					grupo.getGrupoId());
		}
		return categoria;
	}

	/**
	 * Deletes a single row in the CategoriaGrupos table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return
	 */
	public void removeCategoriaGrupos(Categoria categoria) {
		String query = "DELETE  FROM Y40A04T00 "
				+ " WHERE ID_CAT=? AND GRUPO_ID=?";
		List<Grupo> auxiliarGrupo = categoria.getGrupos();
		Iterator<Grupo> it = auxiliarGrupo.iterator();
		while (it.hasNext()) {
			Grupo grupo = (Grupo) it.next();
			this.jdbcTemplate.update(query, categoria.getIdCat(),
					grupo.getGrupoId());
		}
	}

	/**
	 * Deletes a single row in the CategoriaGrupos table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return
	 */
	public void removeAllCategoriaGrupos(Categoria categoria) {
		String query = "DELETE  FROM Y40A04T00 " + " WHERE ID_CAT=? ";
		this.jdbcTemplate.update(query, categoria.getIdCat());
	}

	/**
	 * Find a single row in the findCategoriaGrupos Many To Many relationship.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @return Categoria
	 */
	@Transactional(readOnly = true)
	public Categoria findCategoriaGrupos(Categoria categoria, Grupo grupo,
			Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();

		where.append("where t1.GRUPO_ID = t2.GRUPO_ID AND t1.ID_CAT=?");

		params.add(categoria.getIdCat());

		if (grupo != null && grupo.getGrupoId() != null) {
			where.append(" AND t2.GRUPO_ID = ?");
			params.add(grupo.getGrupoId());
		}
		if (grupo != null && grupo.getNivel() != null) {
			where.append(" AND t2.NIVEL = ?");
			params.add(grupo.getNivel());
		}
		if (grupo != null && grupo.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(grupo.getNombreEs());
		}
		if (grupo != null && grupo.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(grupo.getNombreEu());
		}
		if (grupo != null && grupo.getGrupoPadreId() != null) {
			where.append(" AND t2.GRUPO_PADRE_ID = ?");
			params.add(grupo.getGrupoPadreId());
		}
		if (grupo != null && grupo.getActiva() != null) {
			where.append(" AND t2.ACTIVA = ?");
			params.add(grupo.getActiva());
		}
		if (grupo != null && grupo.getUsuultmod() != null) {
			where.append(" AND t2.USUULTMOD = ?");
			params.add(grupo.getUsuultmod());
		}
		if (grupo != null && grupo.getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD = ?");
			params.add(grupo.getFecultmod());
		}

		StringBuffer query = new StringBuffer(
				"SELECT t2.Grupo_id grupoId, t2.NIVEL NIVEL, t2.nombre_Es NOMBREES, t2.nombre_Eu NOMBREEU, t2.grupo_Padre_Id GRUPOPADREID, t2.ACTIVA ACTIVA, t2.USUULTMOD USUULTMOD, t2.FECULTMOD FECULTMOD FROM Y40a04t00 t1,Y42B00T00 t2  ");
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY (" + pagination.getSort() + ") "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		List<Grupo> listaHijo = this.jdbcTemplate.query(query.toString(),
				new RowMapper<Grupo>() {
					public Grupo mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Grupo(resultSet.getString("GRUPOID"),
								resultSet.getBigDecimal("NIVEL"), resultSet
										.getString("NOMBREES"), resultSet
										.getString("NOMBREEU"), resultSet
										.getString("GRUPOPADREID"), resultSet
										.getString("ACTIVA"), resultSet
										.getString("USUULTMOD"), resultSet
										.getDate("FECULTMOD"), null);
					}
				}, params.toArray());
		categoria.setGrupos(listaHijo);
		return categoria;
	}

	/**
	 * Counts rows in the CategoriaGrupos table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param grupo
	 *            Grupo
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findCategoriaGruposCount(Categoria categoria, Grupo grupo) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append("where t1.GRUPO_ID = t2.GRUPO_ID AND t1.ID_CAT=?");

		params.add(categoria.getIdCat());

		if (grupo.getGrupoId() != null) {
			where.append(" AND t2.GRUPO_ID = ?");
			params.add(grupo.getGrupoId());
		}
		if (grupo.getNivel() != null) {
			where.append(" AND t2.NIVEL = ?");
			params.add(grupo.getNivel());
		}
		if (grupo.getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(grupo.getNombreEs());
		}
		if (grupo.getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(grupo.getNombreEu());
		}
		if (grupo.getGrupoPadreId() != null) {
			where.append(" AND t2.GRUPO_PADRE_ID = ?");
			params.add(grupo.getGrupoPadreId());
		}
		if (grupo.getActiva() != null) {
			where.append(" AND t2.ACTIVA = ?");
			params.add(grupo.getActiva());
		}
		if (grupo.getUsuultmod() != null) {
			where.append(" AND t2.USUULTMOD = ?");
			params.add(grupo.getUsuultmod());
		}
		if (grupo.getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD = ?");
			params.add(grupo.getFecultmod());
		}

		StringBuffer query = new StringBuffer(
				"SELECT count(1) FROM Y40a04t00 t1,Y42B00T00 t2  ");
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Busca todos los grupos asociados a una categoria.
	 * 
	 * @param categoria
	 *            Categoria objeto con la informacion de la categoria
	 * @return List<Object> con la informacion
	 */
	@Transactional(readOnly = true)
	public List<Object> buscaCategoriaGrupo(Categoria categoria) {

		String sql = "select GRUPO_ID from CATEGORIA_GRUPOS where ID_CAT = ?";
		List<Object> params = new ArrayList<Object>();
		params.add(categoria.getIdCat());
		List<Object> lstGrupos = this.jdbcTemplate.query(sql, rwMapObjG,
				params.toArray());

		return lstGrupos;
	}// end buscaCategoriaGrupo

	private RowMapper<Object> rwMapObjG = new RowMapper<Object>() {
		public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
			// String id = rs.getString("GRUPO_ID");
			// return id;
			return rs.getString("GRUPO_ID");
		}
	};

	/**
	 * Guarda un grupo para una categoria en la tabla CATEGORIA_GRUPO
	 * (Y40A04T00).
	 * 
	 * @param idCategoria
	 *            String con el identificador de la categoria
	 * @param idGrupo
	 *            String con el identificador del grupo
	 */
	public void copiaCategoriaGrupo(String idCategoria, String idGrupo) {

		String sql = "insert into Y40A04T00 values(?, ?)";
		List<Object> params = new ArrayList<Object>();
		params.add(idCategoria);
		params.add(idGrupo);
		this.jdbcTemplate.update(sql, params.toArray());
	}// end copiaCategoriaGrupo

	/**
	 * Busca todos los perfiles asociados a una categoria.
	 * 
	 * @param categoria
	 *            Categoria objeto con la informacion de la categoria
	 * @return List<Object> con la informacion
	 */
	@Transactional(readOnly = true)
	public List<Object> buscaCategoriaPerfil(Categoria categoria) {

		String sql = "select ID_PERFIL from CATEGORIA_PERFIL where ID_CAT = ?";
		List<Object> params = new ArrayList<Object>();
		params.add(categoria.getIdCat());
		List<Object> lstPerfil = this.jdbcTemplate.query(sql, rwMapObjP,
				params.toArray());

		return lstPerfil;
	}// end buscaCategoriaPerfil

	private RowMapper<Object> rwMapObjP = new RowMapper<Object>() {
		public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
			// String id = rs.getString("ID_PERFIL");
			// return id;
			return rs.getString("ID_PERFIL");
		}
	};

	/**
	 * Guarda un perfil para una categoria en la tabla CATEGORIA_PERFIL
	 * (Y40A06T00).
	 * 
	 * @param idCategoria
	 *            String con el identificador de la categoria
	 * @param idPerfil
	 *            String con el identificador del perfil
	 */
	public void copiaCategoriaPerfil(String idCategoria, String idPerfil) {

		String sql = "insert into Y40A06T00 values(?, ?)";
		List<Object> params = new ArrayList<Object>();
		params.add(idCategoria);
		params.add(idPerfil);
		this.jdbcTemplate.update(sql, params.toArray());
	}// end copiaCategoriaPerfil

}// end DAO
