package com.ejie.y40a.dao;

import java.util.List;
import java.util.Vector;

import com.ejie.x38.dto.Pagination;
import com.ejie.y40a.model.Categoria;
import com.ejie.y40a.model.Grupo;
import com.ejie.y40a.model.Perfil;

/**
 * * CategoriaDao  
 * 
 *  
 */

public interface CategoriaDao {

	/**
	 * Inserts a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	Categoria add(Categoria categoria);

	/**
	 * Updates a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	Categoria update(Categoria categoria);

	/**
	 * Updates a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Pagination
	 * @return Categoria
	 */
	Categoria updateVisibleWeb(Categoria categoria);

	/**
	 * Updates a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Pagination
	 * @return Categoria
	 */
	Categoria updateNombre(Categoria categoria);

	/**
	 * Finds a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	Categoria find(Categoria categoria);

	/**
	 * Finds a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Pagination
	 * @return Categoria
	 */
	Categoria findCategoriaPadre(Categoria categoria);

	/**
	 * Deletes a single row in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return
	 */
	void remove(Categoria categoria);

	/**
	 * Finds a List of rows in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Categoria> findAll(Categoria categoria, Pagination pagination);

	/**
	 * Counts rows in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return List
	 */
	Long findAllCount(Categoria categoria);

	/**
	 * Finds a List of rows in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param perfiles
	 *            Vector<String>
	 * @param grupos
	 *            List<Grupo>
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Categoria> findAllCategoriaSeguridad(Categoria categoria,
			Vector<String> perfiles, List<Grupo> grupos, Pagination pagination);

	/**
	 * Finds rows in the Categoria table using like.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Categoria> findAllLike(Categoria categoria, Pagination pagination,
			Boolean startsWith);

	/**
	 * Inserts a single row in the CategoriaPerfil table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	Categoria addCategoriaPerfil(Categoria categoria);

	/**
	 * Deletes a single row in the CategoriaPerfil table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return
	 */
	void removeCategoriaPerfil(Categoria categoria);

	/**
	 * Deletes a single row in the CategoriaPerfil table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return
	 */
	void removeAllCategoriaPerfil(Categoria categoria);

	/**
	 * Find a single row in the findCategoriaPerfil Many To Many relationship.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param perfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return Categoria
	 */
	Categoria findCategoriaPerfil(Categoria categoria, Perfil perfil,
			Pagination pagination);

	/**
	 * Counts rows rows in the CategoriaPerfil table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param perfil
	 *            Perfil
	 * @return Long
	 */
	Long findCategoriaPerfilCount(Categoria categoria, Perfil perfil);

	/**
	 * Inserts a single row in the CategoriaGrupos table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return Categoria
	 */
	Categoria addCategoriaGrupos(Categoria categoria);

	/**
	 * Deletes a single row in the CategoriaGrupos table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return
	 */
	void removeCategoriaGrupos(Categoria categoria);

	/**
	 * Deletes a single row in the CategoriaGrupos table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @return
	 */
	void removeAllCategoriaGrupos(Categoria categoria);

	/**
	 * Find a single row in the findCategoriaGrupos Many To Many relationship.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param grupo
	 *            Grupo
	 * @param pagination
	 *            Pagination
	 * @return Categoria
	 */
	Categoria findCategoriaGrupos(Categoria categoria, Grupo grupo,
			Pagination pagination);

	/**
	 * Counts rows rows in the CategoriaGrupos table.
	 * 
	 * @param categoria
	 *            Categoria
	 * @param grupo
	 *            Grupo
	 * @return Long
	 */
	Long findCategoriaGruposCount(Categoria categoria, Grupo grupo);

	/**
	 * Counts rows in the Categoria table.
	 * 
	 * @param categoria
	 *            Categoria
	 * 
	 * @return Long
	 */
	Long findAllNameCategoriaCount(Categoria categoria);

	/**
	 * Busca todos los grupos asociados a una categoria.
	 * 
	 * @param categoria
	 *            Categoria objeto con la informacion de la categoria
	 * @return List<Object> con la informacion
	 */
	List<Object> buscaCategoriaGrupo(Categoria categoria);

	/**
	 * Guarda un grupo para una categoria en la tabla CATEGORIA_GRUPO
	 * (Y40A04T00).
	 * 
	 * @param idCategoria
	 *            String con el identificador de la categoria
	 * @param idGrupo
	 *            String con el identificador del grupo
	 */
	void copiaCategoriaGrupo(String idCategoria, String idGrupo);

	/**
	 * Busca todos los perfiles asociados a una categoria.
	 * 
	 * @param categoria
	 *            Categoria objeto con la informacion de la categoria
	 * @return List<Object> con la informacion
	 */
	List<Object> buscaCategoriaPerfil(Categoria categoria);

	/**
	 * Guarda un perfil para una categoria en la tabla CATEGORIA_PERFIL
	 * (Y40A06T00).
	 * 
	 * @param idCategoria
	 *            String con el identificador de la categoria
	 * @param idPerfil
	 *            String con el identificador del perfil
	 */
	void copiaCategoriaPerfil(String idCategoria, String idPerfil);
}
