/*!
 * Copyright 2011 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 *      http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito, 
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */

//variable para modal categorias (arbol)
var y40aIdCategoria = "";
var y40aIdCategoriaSelec = "";
//variable utilizada en formaciones (diferenciar modo alta o edicion)
var y40aVarFormacionCodigo = "";
//variables utilizadas para saber el desde donde se abre la modal y como (botton añadir activo o no)
var y40aVarOrigenEtiquetas = ""; //formacion o solicitudes
var y40aVarModoEtiquetas = ""; //busqueda o alta, modificacion
var y40aVarIdOrigen = ""; //idFor o idSol para cuando sea modificacion
var y40aVarEtiquetasKeyList = ""; //ids de etiquetas seleccionadas
var y40aVarEtiquetasKeyListNames = ""; //descs de etiquetas seleccionadas
var y40aVarEsModal = false;
var y40ablnMostrarCategorias = "false"; //Controlas visibilidad check categorías
var y40aIdSolicitante = "";	
var y40aDesSolicitante = "";
var y40aIdProvinciaSolicitante = "";
var y40aEmailSolicitante = "";
var y40aTelefonoSolicitante = "";
var idSolicitudFormacionGrupo = ""; //para diferenciar modal formacion alta o modificacion
var y40aVarNuevaConSolicitante = false; //cuando es nuevo 2 - desde planificacion solicitante con solicitante seleccionado
var y40aVarMostrarSolicitudes = false;//Controlas visibilidad check solicitudes / arbol 
var y40aVarCategoriaConHijas = false;//Variable para controlar si al modificar una categoria tiene hijos
var y40aVar_Duplicado = false; //Variable que se utiliza para saber si la solicitud que se esta visualizando es una copia
var y40aVarJerarquiaFormacion = ""; //Variable que contiene la jerarquia del arbol hasta la formacion solicitada
var y40aVarIdFormacionArbol = ""; //Variable que contiene el id de la formacion seleciconada en el arbol

jQuery(document).ready(function(){
	
	$("#rup_dept_logo").attr("src", $.rup.APP_STATICS + "/images/dept_logo_" + $.rup.lang + ".gif");
	var vertical = false, mixto = false;
	if ($.rup.LAYOUT === "vertical") {
		vertical = true;
	} else if ($.rup.LAYOUT === "mixto") {
		mixto = true;
	}
	
	//rastro de migas
	$("#y40aVistaWar_migas").rup_breadCrumb({
		breadCrumb: {
			"busquedaCategorias":{
				"i18nCaption" : "busquedaCategorias",
				"url"   : "/y40aVistaWar/categoria/busquedaCategorias?R01HNoPortal=true"
			},
			"mantenimientoCategorias":{
				"i18nCaption" : "nuevaCategoria",
				"url"   : "/y40aVistaWar/categoria/mantenimientoCategorias?R01HNoPortal=true"
			},
			"modificacionCategorias":{
				"i18nCaption" : "modificacionCategoria",
				"url"   : "/y40aVistaWar/categoria/modificacionCategorias?R01HNoPortal=true"
			},
			"etiqueta":{
				"i18nCaption" : "etiqueta",
				"url"   : "/y40aVistaWar/etiqueta?R01HNoPortal=true"	
			},
			"historico":{
				"i18nCaption" : "historico",
				"url"   : "/y40aVistaWar/historico?R01HNoPortal=true"
				
			},
			"consultaDinamica":{
				"i18nCaption" : "busquedaDinamica",
				"url": "/y40aVistaWar/consultaDinamica?R01HNoPortal=true"
				
			},
			"y40aFormacionesBusqueda":{
				"i18nCaption" : "busquedaFormaciones",
				"url"   : "/y40aVistaWar/formacion/y40aFormacionesBusqueda?R01HNoPortal=true"
			},
			"y40aFormacion":{
				"i18nCaption" : "nuevaFormacion",
				"url"   : "/y40aVistaWar/formacion/y40aFormacion?R01HNoPortal=true"
			},
			"y40aFormacionGrupo":{
				"i18nCaption" : "planificacionFormacionGrupo",
				"url"   : "/y40aVistaWar/y40aFormacionGrupo/maint?R01HNoPortal=true"
			},
			"y40aTabsBusquedaDetalleSolicitante":{
				"i18nCaption" : "y40aTabsBusquedaDetalleSolicitante",
				"url"   : "/y40aVistaWar/entidad/y40aTabsBusquedaDetalleSolicitante?R01HNoPortal=true"
			}
	}
	});
	//idioma
	$("#y40aVistaWar_language").rup_language({languages: ["es", "eu"]});
	
	//Funciones para abril las modales del pie
	$("#btn_aviso_legal").click(function () {
		
		showModalaviso();
	});
	function showModalaviso(params){
		
		$("#modal_aviso").rup_dialog({
			modal: true,
			autoOpen: true,
			width: "700",
			height: "350",
			title: $.rup.i18n.app.comun.aviso_legal,
			url: "/y40aVistaWar/inicio/aviso_legal?R01HNoPortal=true",  
			type:$.rup.dialog.AJAX
		});		
	}
	
		$("#btn_privacidad").click(function () {
			
			showModalprivacidad();
		});
		
		function showModalprivacidad(params){
			$("#modal_privacidad").rup_dialog({
				modal: true,
				autoOpen: true,
				width: "700",
				height: "250",
				title: $.rup.i18n.app.comun.privacidad,
				url: "/y40aVistaWar/inicio/privacidad?R01HNoPortal=true",    
				type:$.rup.dialog.AJAX
			});		
		}
		

	
    	
	// Accordion para que se ajuste la altura de cada elemento
	$("#accordion").accordion({ 
			header: "h3",
			collapsible: true, 
		/*    autoHeight: false,*/ 
		    active: false 
			});
		
	/*	$("#accordion0").accordion({ header: "h3" });
		$("#accordion1").accordion({ header: "h3" });
		$("#accordion2").accordion({ header: "h3" });
		$("#accordion3").accordion({ header: "h3" });
		$("#accordion4").accordion({ header: "h3" });
	
		$( "#accordion0" ).accordion({
			autoHeight: false,
			navigation: true
		});
		
		$( "#accordion1" ).accordion({
			autoHeight: false,
			navigation: true
		});
		$( "#accordion2" ).accordion({
			autoHeight: false,
			navigation: true
		});
		$( "#accordion3" ).accordion({
			autoHeight: false,
			navigation: true
		});
		$( "#accordion4" ).accordion({
			autoHeight: false,
			navigation: true
		});
		
		//*****************************************/
		//             LINK MENUS                 //
		//*****************************************//
		//campnias
		$("#menu_campanias_copiaCampania").click(function () {	
			location.href = "/y40aVistaWar/campania/copiaCampanias?R01HNoPortal=true";
		});	
	
		//categorias
		$("#menu_categorias_busquedaCategorias").click(function () {	
			location.href = "/y40aVistaWar/categoria/busquedaCategorias?R01HNoPortal=true";
		});
		$("#menu_categorias_nuevaCategorias").click(function () {	
			location.href = "/y40aVistaWar/categoria/mantenimientoCategorias?R01HNoPortal=true";
		});
		//formaciones
		$("#menu_formaciones_busquedaFormacion").click(function () {	
			location.href = "/y40aVistaWar/formacion/y40aFormacionesBusqueda?R01HNoPortal=true";
		});
		$("#menu_formaciones_nuevaFormacion").click(function () {	
			location.href = "/y40aVistaWar/formacion/y40aFormacion?R01HNoPortal=true";
		});
		//planificacion
		$("#menu_planificacion_porFormacion").click(function () {	
			location.href = "/y40aVistaWar/y40aFormacionGrupo/maint?R01HNoPortal=true";
		});
		$("#menu_planificacion_porSolicitante").click(function () {	
			location.href = "/y40aVistaWar/entidad/y40aTabsBusquedaDetalleSolicitante?R01HNoPortal=true";
		});
		//etiquetas
		$("#menu_etiquetas_busquedaEtiquetas").click(function () {	
			location.href = "/y40aVistaWar/etiqueta/maint?R01HNoPortal=true";
		});
		//informes
		$("#menu_informes_historico").click(function () {	
			location.href = "/y40aVistaWar/historico/maint?R01HNoPortal=true";
		});
		$("#menu_informes_consultaDinamica").click(function () {	
			location.href = "/y40aVistaWar/consultaDinamica/maint?R01HNoPortal=true";
		});
		$("#menu_informes_consultaDinamica").click(function () {	
			location.href = "/y40aVistaWar/consultaDinamica/maint?R01HNoPortal=true";
		});
		// AGENDA CONTACTOS INICIO
		$("#menu_agendacontactos").click(function () {	
			window.open(urlAgendaContactos,'_blank');
		});
		// AGENDA CONTACTOS FIN

		establecerValorBlankCombo();
});


function validateBean(beanName, object, group, feedBack) {
	
	VALIDATE_MESSAGE = "";
	var t=0;
		$.ajax({
			type : "GET",
			async : false,
			url : "/y40aVistaWar/validate?bean=" + beanName + "&group="+ group + "&R01HNoPortal=true",
			dataType : "json",
			data : {data:$.toJSON(object)},
			contentType : 'application/json',
			statusCode : {
				200 : function() {
				},
				406 : function(data) {
				
					var message = "";
					var response = $.parseJSON(data.responseText);
					var errors = $.parseJSON(response[1]);
					var error = null;
					for(name in errors) {
						
						error = errors[name];
						for(var e=0; e<error.length; e++) {
							
							for(assertion in error[e]) {
								
								VALIDATE_MESSAGE += "<li>" + error[e][assertion] + "</li>\n";
							}
						}
					}
					
					
					t++;
				},
				500 : function(data) {
					
					var message = "";
					var response = $.parseJSON(data.responseText);
					var errors = $.parseJSON(response[1]);
					
					VALIDATE_MESSAGE += "<li>" + "Error 500" + "</li>\n";
					t++;
				}	
			}
		});
	
	if(t>0) {
		$("#" + feedBack).rup_feedback("option", "delay", null);
		$("#" + feedBack).rup_feedback("set", "<ul>" + VALIDATE_MESSAGE + "</ul>", "error");
		return false;
		
	} else {	
		return true;
	}
}

function validateBean(beanName, object, group, feedBack, arrayErrores) {
	
	
	VALIDATE_MESSAGE = "";
	var t=0;
		$.ajax({
			type : "GET",
			async : false,
			url : "/y40aVistaWar/validate?bean=" + beanName + "&group="+ group + "&R01HNoPortal=true",
			dataType : "json",
			data : {data:$.toJSON(object)},
			contentType : 'application/json',
			statusCode : {
				200 : function() {
				},
				406 : function(data) {
					var message = "";
					var response = $.parseJSON(data.responseText);
					var errors = $.parseJSON(response[1]);
					var error = null;
					for(name in errors) {
						
						error = errors[name];
						for(var e=0; e<error.length; e++) {
							
							for(assertion in error[e]) {
								
								VALIDATE_MESSAGE += "<li>" + error[e][assertion] + "</li>\n";
							}
						}
					}
					
					
					t++;
				}
			}
		});
	
	if(arrayErrores != null) {
		for (i=0; i<arrayErrores.length;i++)
		{
			VALIDATE_MESSAGE += "<li>" + arrayErrores[i] + "</li>\n";
			t++;
		}
	}
	
	if(t>0) {
		$("#" + feedBack).rup_feedback("option", "delay", null);
		$("#" + feedBack).rup_feedback("set", "<ul>" + VALIDATE_MESSAGE + "</ul>", "error");
		return false;
		
	} else {
		return true;
	}
}



function controlY40aUDAException(data, feedBack) {
	var VALIDATE_MESSAGE = "";
	var errors = $.parseJSON(data.responseText);
	var error = null;
	for(name in errors) {
		error = errors[name];
		VALIDATE_MESSAGE += "<li>" + char_convert(error) + "</li>\n";
	}
	$("#" + feedBack).rup_feedback("option", "delay",null);
	$("#" + feedBack).rup_feedback("set","<ul>" + VALIDATE_MESSAGE + "</ul>", "error");
}

function char_convert(cadena){
	  
	// Sustituyo caracteres en la cadena final
	cadena = cadena.replace(/Ã¡/g, "&aacute;");
	cadena = cadena.replace(/Ã©/g, "&eacute;");
	cadena = cadena.replace(/Â®/g, "&reg;");
	cadena = cadena.replace(/Ã­/g, "&iacute;");
	cadena = cadena.replace(/ï¿½/g, "&iacute;");
	cadena = cadena.replace(/Ã³/g, "&oacute;");
	cadena = cadena.replace(/Ãº/g, "&uacute;");
	cadena = cadena.replace(/n~/g, "&ntilde;");
	cadena = cadena.replace(/Âº/g, "&ordm;");
	cadena = cadena.replace(/Âª/g, "&ordf;");
	cadena = cadena.replace(/ÃƒÂ¡/g, "&aacute;");
	cadena = cadena.replace(/Ã±/g, "&ntilde;");
	cadena = cadena.replace(/Ã‘/g, "&Ntilde;");
	cadena = cadena.replace(/ÃƒÂ±/g, "&ntilde;");
	cadena = cadena.replace(/n~/g, "&ntilde;");
	cadena = cadena.replace(/Ãš/g, "&Uacute;");
	return cadena;
}

/* ********************************************************************************************
 * Funcion que devuelve la letra a agregar al nombre del campo idiomatico en funcion del idioma 
 * ********************************************************************************************
 */
function recuperarLetraIdioma(){
	var letra ="";
	if ("eu"==$.rup_utils.get("language")){
		letra="e";
	}	
	return letra;
}
function recuperarLetraIdiomaMayuscula(){
	var letra ="Es";
	if ("eu"==$.rup_utils.get("language")){
		letra="Eu";
	}	
	return letra;
}

/* ********************************************************************************************
 * Funcion que valida que en un campo input solo se introduzcan valores numericos
 * ********************************************************************************************
 */
function validarInput(e) { 
    tecla = (document.all) ? e.keyCode : e.which; 

    if (tecla==8) return true; 
    else if (tecla==0)  return true;
    patron = /\d/;
    te = String.fromCharCode(tecla); 
    return patron.test(te); 
} 

/* ********************************************************************************************
 * Funcion para calcular los puntos en función del %
 * ********************************************************************************************
 */
function funcPercentage(porcentajeColumna, widthTabla){

//	var is_chrome = navigator.userAgent.toLowerCase().indexOf('chrome') > -1;
//	
//	if (is_chrome){
//		
//	}else{
	    var x = (porcentajeColumna*widthTabla)/100;
	    //console.log("Percentage:" + porcentajeColumna + " - " + widthTabla + " - " + x);
	    return x;
//	}
}

/* ********************************************************************************************
 * Funcion que sobreescribe el literal generico de la opcion blank_ del rup combo
 * ********************************************************************************************
 */
function establecerValorBlankCombo(){
	if ("eu"==$.rup_utils.get("language")){
		$.rup.i18n.base.rup_combo.blankNotDefined = " [Hautatu elementu bat]";
	}else{
		$.rup.i18n.base.rup_combo.blankNotDefined = " [Seleccione un elemento]";
	}	
	
}

// Funcion que devuelve el tamaño ed un string
function y40aFunTamanyoString(cadena){
	return cadena.length;	
}

//Funcion que devuelve el string de descripciones de etiquetas sin corchetes
function y40aFunEliminarCorchetes(cadena){
	var tamanyo = y40aFunTamanyoString(cadena);
	return cadena.substring(1,tamanyo-1);
}

//pasandole la jerarquia cat>subcat>Formacion devuelve la formacion
function y40aFunSoloFormacion(jerarquia){
	var ultimo = jerarquia.lastIndexOf(">");
	var tamanyo = y40aFunTamanyoString(jerarquia);
	return jerarquia.substring(ultimo+1,tamanyo);
}



/* *************************************************
 * Funcion que devuelve la fecha actual sin horas  * 
 * *************************************************
 */
function fechaActualSinHoras(){
	var hoy = new Date();
	dia = hoy.getDate(); 
	mes = hoy.getMonth();
	anio= hoy.getFullYear();
	if (dia<10) dia='0'+dia; 
	mes = mes + 1;
	if (mes<10) mes='0'+mes; 
	if ("eu"==$.rup_utils.get("language")){
		fecha_actual = String(anio+"/"+mes+"/"+dia);
	}else{
		fecha_actual = String(dia+"/"+mes+"/"+anio);
	}
	return fecha_actual;
}

/* ********************************************************************************************
 * Funcion que valida fecha es=dd/mm/aaaa eu=aaaa/mm/dd
 * - Devuelve false si no es una fecha valida
 * ********************************************************************************************
 */
function isDate(txtDate)
{
  var currDateIdioma = $.rup_utils.get("language");
  var currVal = txtDate;
  if(currVal == '')
    return false;
  //ES,EN -> dd/mm/yyyy
  var rxDatePattern = /^(\d{1,2})(\/|-)(\d{1,2})(\/|-)(\d{4})$/; 
  if(currDateIdioma == 'eu'){
	  //EU -> yyyy/mm/dd
	  var rxDatePattern = /^(\d{4})(\/|-)(\d{1,2})(\/|-)(\d{1,2})$/; 
  }
  var dtArray = currVal.match(rxDatePattern); // is format OK?
  if (dtArray == null)
     return false;
  //ES,EN -> dd/mm/yyyy
  dtDay = dtArray[1];
  dtMonth= dtArray[3];
  dtYear = dtArray[5];
  if(currDateIdioma == 'eu'){
	  //EU -> yyyy/mm/dd
	  dtDay = dtArray[5];
	  dtMonth= dtArray[3];
	  dtYear = dtArray[1];
  }
  if (dtMonth < 1 || dtMonth > 12)
      return false;
  else if (dtDay < 1 || dtDay> 31)
      return false;
  else if ((dtMonth==4 || dtMonth==6 || dtMonth==9 || dtMonth==11) && dtDay ==31)
      return false;
  else if (dtMonth == 2)
  {
     var isleap = (dtYear % 4 == 0 && (dtYear % 100 != 0 || dtYear % 400 == 0));
     if (dtDay> 29 || (dtDay ==29 && !isleap))
          return false;
  }
  return true;
}


/* ********************************************************************************************
 * Funcion que compara 2 fechas es=dd/mm/aaaa eu=aaaa/mm/dd
 * - Devuelve true si fechaFin >= fechaInicio
 * ********************************************************************************************
 */
function comparaFechas(fechaInicio, fechaFin){
	
	var fec1=fechaInicio.split("/");
	var fec2=fechaFin.split("/");

	var xDay="";  
	var xMonth="";  
    var xYear="";  

    var yDay="";
    var yMonth="";  
    var yYear="";  
    
    
    //fecha en espaÃ±ol - cuando la longitud del primer split sea 2 __/__/____
    if ("es"==$.rup_utils.get("language")){
    	//alert("estamos en fecha espaÃ±ol");
    	xDay = fec1[0];
    	xMonth = fec1[1];
    	xYear = fec1[2];
    	yDay = fec2[0];
    	yMonth = fec2[1];
    	yYear = fec2[2];
    }else{//fecha en euskera - cuando la longitud del primer split sea 4 ____/__/__
    	if(fec1[0].length = 4){
    		//alert("estamos en fecha en euskera");
        	xDay = fec1[2];
        	xMonth = fec1[1];
        	xYear = fec1[0];
        	yDay = fec2[2];
        	yMonth = fec2[1];
        	yYear = fec2[0];
    	}
    }

	//alert("<ul><li>xDay: "+ xDay + " xMonth: " + xMonth+ " xYear: "+xYear +
	//	  "</li><li>yDay: "+ yDay + " yMonth: " + yMonth+ " yYear: "+yYear+"</li></ul>");
    
    //javascript meses 0-11
    var Fecha_X = new Date(xYear,xMonth-1,xDay);
    var Fecha_Y = new Date(yYear,yMonth-1,yDay);
 
    if(Fecha_Y >= Fecha_X){
    	//alert('consulta------>'+fecha1+ 'respuesta------>'+fecha2);
    	//alert("TRUE, fecha respuesta (2) "+Fecha_Y+" > fecha consulta (1) "+Fecha_X);
    	return true;
    }else{
    	//alert('consulta------>'+fecha1+ 'respuesta------>'+fecha2);
    	//alert("TRUE, fecha respuesta (2) "+Fecha_Y+" <= fecha consulta (1) "+Fecha_X);
    	return false;
    }
}


/* ********************************************************************************************
 * Funcion que compara 2 fechas es=dd/mm/aaaa eu=aaaa/mm/dd
 * - Devuelve "<" si fechaFin < fechaInicio
 * - Devuelve "=" si fechaFin = fechaInicio
 * - Devuelve "=" si fechaFin > fechaInicio
 * ********************************************************************************************
 */
function devuelveValor_ComparacionFechas(fechaInicio, fechaFin){
	
	var fec1=fechaInicio.split("/");
	var fec2=fechaFin.split("/");

	var xDay="";  
	var xMonth="";  
    var xYear="";  

    var yDay="";
    var yMonth="";  
    var yYear="";  
    
    
    //fecha en espaÃ±ol - cuando la longitud del primer split sea 2 __/__/____
    if ("es"==$.rup_utils.get("language")){
    	//alert("estamos en fecha espaÃ±ol");
    	xDay = fec1[0];
    	xMonth = fec1[1];
    	xYear = fec1[2];
    	yDay = fec2[0];
    	yMonth = fec2[1];
    	yYear = fec2[2];
    }else{//fecha en euskera - cuando la longitud del primer split sea 4 ____/__/__
    	if(fec1[0].length = 4){
    		//alert("estamos en fecha en euskera");
        	xDay = fec1[2];
        	xMonth = fec1[1];
        	xYear = fec1[0];
        	yDay = fec2[2];
        	yMonth = fec2[1];
        	yYear = fec2[0];
    	}
    }

    
    var Fecha_X = new Date(xYear,xMonth-1,xDay);
    var Fecha_Y = new Date(yYear,yMonth-1,yDay);
    

    if(Fecha_Y > Fecha_X){
    	return ">";
    }else if(Fecha_Y < Fecha_X){
    	return "<";
    }else{
    	return "=";
    }
}


/* ********************************************************************************************
 * Funcion que compara 2 fechas es=dd/mm/aaaa eu=aaaa/mm/dd
 * - Devuelve true si fechaFin > fechaInicio
 * ********************************************************************************************
 */
function comparaFechasMayor(fechaInicio, fechaFin){
	
	var fec1=fechaInicio.split("/");
	var fec2=fechaFin.split("/");

	var xDay="";  
	var xMonth="";  
    var xYear="";  

    var yDay="";
    var yMonth="";  
    var yYear="";  
    
    
    //fecha en espaÃ±ol - cuando la longitud del primer split sea 2 __/__/____
    if ("es"==$.rup_utils.get("language")){
    	//alert("estamos en fecha espaÃ±ol");
    	xDay = fec1[0];
    	xMonth = fec1[1];
    	xYear = fec1[2];
    	yDay = fec2[0];
    	yMonth = fec2[1];
    	yYear = fec2[2];
    }else{//fecha en euskera - cuando la longitud del primer split sea 4 ____/__/__
    	if(fec1[0].length = 4){
    		//alert("estamos en fecha en euskera");
        	xDay = fec1[2];
        	xMonth = fec1[1];
        	xYear = fec1[0];
        	yDay = fec2[2];
        	yMonth = fec2[1];
        	yYear = fec2[0];
    	}
    }

	//alert("<ul><li>xDay: "+ xDay + " xMonth: " + xMonth+ " xYear: "+xYear +
	//	  "</li><li>yDay: "+ yDay + " yMonth: " + yMonth+ " yYear: "+yYear+"</li></ul>");
    
    var Fecha_X = new Date(xYear,xMonth-1,xDay);
    var Fecha_Y = new Date(yYear,yMonth-1,yDay);
 
    if(Fecha_Y > Fecha_X){
    	//alert('consulta------>'+fecha1+ 'respuesta------>'+fecha2);
    	//alert("TRUE, fecha respuesta (2) "+Fecha_Y+" > fecha consulta (1) "+Fecha_X);
    	return true;
    }else{
    	//alert('consulta------>'+fecha1+ 'respuesta------>'+fecha2);
    	//alert("TRUE, fecha respuesta (2) "+Fecha_Y+" <= fecha consulta (1) "+Fecha_X);
    	return false;
    }
}




/* ********************************************************************************************
 * Funcion que compara 2 horas
 * - Devuelve true si hora2 > hora1
 * ********************************************************************************************
 */
function comparaHoras(sHora1, sHora2) { 
    
    var arHora1 = sHora1.split(":"); 
    var arHora2 = sHora2.split(":"); 
     
    // Obtener horas y minutos (hora 1) 
    var hh1 = parseInt(arHora1[0],10); 
    var mm1 = parseInt(arHora1[1],10); 

    // Obtener horas y minutos (hora 2) 
    var hh2 = parseInt(arHora2[0],10); 
    var mm2 = parseInt(arHora2[1],10); 

    // Comparar 
    if (hh1<hh2 || (hh1==hh2 && mm1<mm2) )//|| (hh1==hh2 && mm1==mm2) ) 
        return true; 
    else  
        return false; 
} 



