/* BLOQUE INICIALIZACIONES ************************************************************** */
jQuery(function($) {
	
	
	//feedback
	$("#y40aTabDetalleSolicitante_feedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});
	
	;
	$("#accordionSolicitante").accordion({ 
		header: "h3",
		collapsible: true, 
	/*    autoHeight: false,*/ 
	    active: true
		});
	$("#accordionHistoriciSolicitante").accordion({ 
		header: "h3",
		collapsible: true, 
	/*    autoHeight: false,*/ 
	    active: true 
		});
	
	$("#accordionSolicitante").accordion('activate', 0);
	$("#accordionHistoriciSolicitante").accordion('activate', 0);
	
	//cacheo tab
	$(document).ready(function () {
	    // cache content for the current tab
	    var currentTabIndex = $("#y40aTabsBusquedaDetalleSolicitante").tabs('option', 'selected');
	    var currentTabAnchor = $("#y40aTabsBusquedaDetalleSolicitante").data('tabs').anchors[currentTabIndex];
	    $(currentTabAnchor).data('cache.tabs', false);
	});

	
	
	document.getElementById("y40aTabDetalleSolicitanteFiltro").innerHTML = y40aFunTabDetalleSolicitanteGeneraFiltro();
	//y40aFunTabDetalleSolicitanteGeneraFiltro();
	
	//alert($("#y40aTabBusquedaSolicitanteIdEntidad").val());
	y40aFunObtenerDatosEntidad();
	y40aFunTabDetalleSolicitanteReloadTablaFormaciones();
	y40aVarMostrarSolicitudes = "false";
	y40aFunTabDetalleSolicitantePintarArbolSolicitudes();
	
});


/* BLOQUE FUNCIONES ********************************************************************* */

//Obtiene los datos de la cabecera
function y40aFunObtenerDatosEntidad(){
	$.ajax({
		type : "GET",
		url : "/y40aVistaWar/entidad/entidadbyid/" + $("#y40aTabBusquedaSolicitanteIdEntidad").val() + "?R01HNoPortal=true",
		dataType : "json",
		error : function(jqXHR, textStatus, errorThrown) {
			$("#y40aTabDetalleSolicitante_feedback").rup_feedback("option", "delay", null);
			$("#y40aTabDetalleSolicitante_feedback").rup_feedback("set", textStatus + ": error", "error");
		},
		success : function(data, textStatus, jqXHR) {	
			
			$("#y40aTabDetalleSolicitanteIdEntidad").val($("#y40aTabBusquedaSolicitanteIdEntidad").val());		
			
			if(data.numHistObserv>1){
				$("#y40aTabDetalleSolicitanteHistorico").removeClass("y40a-oculto");
				$("#y40aTabDetalleSolicitanteHistorico").addClass("y40a-visibleInline");
			}else{
				$("#y40aTabDetalleSolicitanteHistorico").addClass("y40a-oculto");
				$("#y40aTabDetalleSolicitanteHistorico").removeClass("y40a-visibleInline");
			}
			
			if ("eu"==$.rup_utils.get("language")){
				document.getElementById("y40aTabDetalleSolicitanteEntidadNombre").innerHTML= data.nombreEu;
				$("#y40aTabDetalleSolicitanteNbEntidad").val(data.nombreEu);
			}else{
				document.getElementById("y40aTabDetalleSolicitanteEntidadNombre").innerHTML= data.nombreEs;
				$("#y40aTabDetalleSolicitanteNbEntidad").val(data.nombreEs);
			}
			
			document.getElementById("y40aTabDetalleSolicitanteProvincia").innerHTML = data.nombreProvincia;
			document.getElementById("y40aTabDetalleSolicitanteMunicipio").innerHTML = data.nombreMunicipio;
			document.getElementById("y40aTabDetalleSolicitanteTelefono").innerHTML = data.telefono;																
			//document.getElementById("y40aTabDetalleSolicitanteEmail").innerHTML = data.emailContacto;
			y40aFunTabDetalleSolicitanteMailTo(data.email);
				
			if(data.observacionesOFE!=null && data.observacionesOFE!="null"){
			$("#y40aTabDetalleSolicitanteObservaciones").val(data.observacionesOFE);
		}
		}
	});
}

//TABLA FORMACIONES
function y40aFunTabDetalleSolicitanteReloadTablaFormaciones(){
	//alert("reconstruccion tabla DETALLE");
	$('#y40aTabDetalleSolicitanteTabla').jqGrid('GridUnload');
	y40aFunTabDetalleSolicitantePintarTablaFormaciones();
}


function y40aFunTabDetalleSolicitantePintarTablaFormaciones(){

	//tabla
	var y40aVarTabDetalleSolicitanteTablaFormacionesWidth = $("#contentMV").width()-32;
	var query = $("#y40aFormTabBusquedaSolicitante").serialize();
	
	//alert("/y40aVistaWar/y40aFormacionGrupo/like?entidadId="+$("#y40aTabBusquedaSolicitanteIdEntidad").val()+ "&" + query + "&R01HNoPortal=true");
	$("#y40aTabDetalleSolicitanteTabla").rup_grid({
		url:"/y40aVistaWar/y40aFormacionGrupo/like?entidadIdBusquedaSol="+$("#y40aTabBusquedaSolicitanteIdEntidad").val()+ "&" + query + "&R01HNoPortal=true",
		loadOnStartUp: true,
		width: y40aVarTabDetalleSolicitanteTablaFormacionesWidth,
		pagerName:"y40aTabDetalleSolicitanteTablaPager", 
		rowNum: "10",
		sortorder: "asc",
		sortname: "nombreCortoFormacion" + recuperarLetraIdiomaMayuscula(),
		colNames:[
		    $.rup.i18n.app.y40aTabDetalleSolicitanteTabla.idformacion,
		    $.rup.i18n.app.y40aTabDetalleSolicitanteTabla.formacion,
		    $.rup.i18n.app.y40aTabDetalleSolicitanteTabla.fechaSol,
		    $.rup.i18n.app.y40aTabDetalleSolicitanteTabla.grupo,
		    $.rup.i18n.app.y40aTabDetalleSolicitanteTabla.idioma,
		    $.rup.i18n.app.y40aTabDetalleSolicitanteTabla.numparticipantes,
		    $.rup.i18n.app.y40aTabDetalleSolicitanteTabla.diaimparticion,
		    $.rup.i18n.app.y40aTabDetalleSolicitanteTabla.horaInicio,
		    $.rup.i18n.app.y40aTabDetalleSolicitanteTabla.horaFin,
		    $.rup.i18n.app.y40aTabDetalleSolicitanteTabla.numasistentes,
		    $.rup.i18n.app.y40aTabDetalleSolicitanteTabla.cancelado,
		    $.rup.i18n.app.y40aTabDetalleSolicitanteTabla.contacto
		],
		colModel: [		    
		    { 	name: "idSol", 
		    	index: "idSol",
		    	hidden: true
		    },
		    { 	name: "nombreCortoFormacion" + recuperarLetraIdiomaMayuscula(),
		    	index: "nombreCortoFormacion" + recuperarLetraIdiomaMayuscula(),
		    	width: funcPercentage(20,y40aVarTabDetalleSolicitanteTablaFormacionesWidth), 
		    	cellattr: function (rowId, val, rawObject, cm, rdata) {
		    		if ("es"==$.rup_utils.get("language")){
		    			return 'title= "'+  rawObject.nombreFormacionEs +'"';
					}else if("eu"==$.rup_utils.get("language")){
						return 'title= "'+  rawObject.nombreFormacionEu +'"';
					}
                }
		    },
		    { 	name: "fechaSol",
		    	index: "fechaSol",
		    	align:'center',
		    	width: funcPercentage(10,y40aVarTabDetalleSolicitanteTablaFormacionesWidth)
		    },
		    { 	name: "grupo",
		    	index: "grupo",
		    	align:'center',
		    	width: funcPercentage(10,y40aVarTabDetalleSolicitanteTablaFormacionesWidth)
		    },
		    { 	name: "idioma",
		    	index: "idioma",
		    	formatter:function(cellvalue, el, opts){
	    			var idioma = "";
	    			
	    			if(cellvalue == "ES" || cellvalue == "es"){
	    				idioma = 	$.rup.i18n.app.y40aFormacionGrupoMantenimientoIdioma.castellano;
	    			}else if(cellvalue == "EU" || cellvalue == "eu"){
	    				idioma = $.rup.i18n.app.y40aFormacionGrupoMantenimientoIdioma.euskera;
	    			}else if(cellvalue == "EN" || cellvalue == "en"){
	    				idioma = $.rup.i18n.app.y40aFormacionGrupoMantenimientoIdioma.ingles;
	    			}

	    			
	    			return idioma;
	    		},		    	
		    	width: funcPercentage(14,y40aVarTabDetalleSolicitanteTablaFormacionesWidth)
		    },
		    {	name: "participantes", 
		    	index: "participantes",
		    	align:'center',
		    	width: funcPercentage(12,y40aVarTabDetalleSolicitanteTablaFormacionesWidth)
		    },
		    {	name: "diaImparticion", 
		    	index: "diaImparticion",
		    	align:'center',
		    	width: funcPercentage(14,y40aVarTabDetalleSolicitanteTablaFormacionesWidth)
		    },
		    {	name: "horaInicio", 
		    	index: "horaInicio",
		    	align:'center',
		    	width: funcPercentage(10,y40aVarTabDetalleSolicitanteTablaFormacionesWidth)
		    },
		    {	name: "horaFin", 
		    	index: "horaFin",
		    	align:'center',
		    	width: funcPercentage(10,y40aVarTabDetalleSolicitanteTablaFormacionesWidth)
		    },

//		    {	name: "horarioImparticion", 
//		    	index: "horarioImparticion",
//		    	align:'center',
//		    	width: funcPercentage(10,y40aVarTabDetalleSolicitanteTablaFormacionesWidth)
//		    },
		    {	name: "asistentes", 
		    	index: "asistentes",
		    	align:'center',
		    	width: funcPercentage(10,y40aVarTabDetalleSolicitanteTablaFormacionesWidth)
		    },
		    {	name: "cancelado", 
		    	index: "cancelado",
		    	align:'center',
		    	editoptions: {
					value:{"S":'<img src="'+$.rup.APP_STATICS+'/images/y40a-false.png"  width="12" height="12">'}
					},
				formatter:"select",
		    	width: funcPercentage(10,y40aVarTabDetalleSolicitanteTablaFormacionesWidth)
		    },
		    {	name: "nombapecontacto", 
		    	index: "nombapecontacto",
		    	align:'center',
		    	formatter:function(cellvalue, el, opts){
		    			var tienecont = "";
		    			
		    			if(cellvalue == null || cellvalue == "")
		    			{
		    				tienecont = "";
		    			}else
		    			{
		    				tienecont = "<img src=\""+$.rup.APP_STATICS+"/images/y40a-true.png\"  width=\"12\" height=\"12\">";
		    			}		
		    			
		    			
		    			return tienecont;
		    		},
		    		width: funcPercentage(10,y40aVarTabDetalleSolicitanteTablaFormacionesWidth)
		    	
		    }
		],
		altRows:true,
		onSelectRow : function(id, selectR) {
		}
	});
}

//NUEVO
$("#y40aTabDetalleSolicitanteNuevo").click(function(){
	idSolicitudFormacionGrupo = "";
	y40aVarNuevaConSolicitante = true;
	$("#y40aFormacionGrupoMantenimiento").rup_dialog("destroy");
	$("#y40aFormacionGrupoMantenimiento").rup_dialog({
		modal: true,
		autoOpen: true,
		width: "900",
		height: "auto",
		title: $.rup.i18n.app.y40aTitlesModalesSolicitudes.nuevoRegistro,
		url: "/y40aVistaWar/y40aFormacionGrupo/porFormacionGrupo?R01HNoPortal=true",    
		type:$.rup.dialog.AJAX,
		close: function(event, ui) {
			//alert("close NUEVO2");
			y40aVarNuevaConSolicitante = false;
			y40aFunTabDetalleSolicitanteReloadTablaFormaciones();
		}
	});	
});

//MODIFICACION
$("#y40aTabDetalleSolicitanteModificar").click(function () {
	var selectedRow = $("#y40aTabDetalleSolicitanteTabla").rup_grid("getSelectedRows")[0];
	row = $("#y40aTabDetalleSolicitanteTabla").rup_grid("getRowData", selectedRow);
	var codigo = row.idSol;
	if(codigo == "" || codigo == null)
		{
			$("#y40aTabDetalleSolicitante_feedback").rup_feedback("option", "delay", 800);
			$("#y40aTabDetalleSolicitante_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
		}
	else
		{
			idSolicitudFormacionGrupo = codigo;
			y40aFunTabDetalleSolicitanteShowModalModificar();
		}
});

function y40aFunTabDetalleSolicitanteShowModalModificar(){
	$("#y40aFormacionGrupoMantenimiento").rup_dialog("destroy");
	$("#y40aFormacionGrupoMantenimiento").rup_dialog({
		modal: true,
		autoOpen: true,
		width: "900",
		height: "auto",
		title: $.rup.i18n.app.y40aTitlesModalesSolicitudes.modificarRegistro,
		url: "/y40aVistaWar/y40aFormacionGrupo/porFormacionGrupo?R01HNoPortal=true",    
		type:$.rup.dialog.AJAX,
		close: function(event, ui) {
			//alert("close MODIFICAR");
			y40aFunTabDetalleSolicitanteReloadTablaFormaciones();
		}
	});	
}


//ELIMINAR
$("#y40aTabDetalleSolicitanteEliminar").click(function(){
	var selectedRow = $("#y40aTabDetalleSolicitanteTabla").rup_grid("getSelectedRows")[0];
	row = $("#y40aTabDetalleSolicitanteTabla").rup_grid("getRowData", selectedRow);
	var codigo = row.idSol;
	if(codigo == "" || codigo == null)
		{
			$("#y40aTabDetalleSolicitante_feedback").rup_feedback("option", "delay", 800);
			$("#y40aTabDetalleSolicitante_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
		}
	else
		{
		   $.rup_messages("msgConfirm",{
			   title:$.rup.i18n.app.msg.confirmacion,
			   message: $.rup.i18n.app.msg.confiramacioneliminar,
			   OKFunction : function () {
				   y40aFunEliminarFilaSolicitanteTabla(codigo);
				}
		   });
		}

});

function y40aFunEliminarFilaSolicitanteTabla(idSol){
	var jqxhr = $.ajax({
		type : 'DELETE',
		url : "/y40aVistaWar/y40aFormacionGrupo/eliminarSolicitud/" + idSol +"?R01HNoPortal=true",
		error: function (jqXHR, textStatus, errorThrown){
			switch(jqXHR.status){		
				case 406:
					$("#y40aTabDetalleSolicitante_feedback").rup_feedback("option", "delay",null);
					$("#y40aTabDetalleSolicitante_feedback").rup_feedback("set",jqXHR.responseText, "error");
					break;
				//case 500:	
				default:
					$("#y40aTabDetalleSolicitante_feedback").rup_feedback("option", "delay",null);
					$("#y40aTabDetalleSolicitante_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
					break;
			}
		},
		success : function(data) {
					$("#y40aTabDetalleSolicitante_feedback").rup_feedback("option", "delay",800);
					$("#y40aTabDetalleSolicitante_feedback").rup_feedback("set", $.rup.i18n.app.msg.ok, "ok");
					y40aFunTabDetalleSolicitanteReloadTablaFormaciones();
		}
	});
}


//ARBOL solicitudes
$("#y40aTabDetalleSolicitanteSolicitudesCheckbox").click(function () {
	var y40aVarMostrarSolicitudesCheckeado=$("#y40aTabDetalleSolicitanteSolicitudesCheckbox").attr("checked");
	if(y40aVarMostrarSolicitudesCheckeado!="checked") {
		y40aVarMostrarSolicitudes = "false";
	}
	else{
		y40aVarMostrarSolicitudes = "true";
	}
	$("#y40aTabDetalleSolicitanteArbolListaSolicitudes").dynatree("destroy"); 
	y40aFunTabDetalleSolicitantePintarArbolSolicitudes();
});




function y40aFunTabDetalleSolicitantePintarArbolSolicitudes(){
	$("#y40aTabDetalleSolicitanteArbolListaSolicitudes").dynatree({
		initAjax: {
			url: "/y40aVistaWar/entidad/arbolSolicitudes?R01HNoPortal=true",
			data: {	idEntidad :  $("#y40aTabBusquedaSolicitanteIdEntidad").val(),
					mostrarSolicitudes : y40aVarMostrarSolicitudes}
		},
		activeVisible: true, // Make sure, active nodes are visible (expanded).
		autoCollapse: false,
		autoFocus: false,
		selectMode: 1
	});
}

$("#y40aTabDetalleSolicitanteExpandir").click(function () {
	$("#y40aTabDetalleSolicitanteArbolListaSolicitudes").dynatree("getRoot").visit(function(node){
		 node.expand(true);
	});
	return false;
}); 

$("#y40aTabDetalleSolicitanteContraer").click(function () {
	$("#y40aTabDetalleSolicitanteArbolListaSolicitudes").dynatree("getRoot").visit(function(node){
		 node.expand(false);
	});
	return false;
}); 



//GENERAR EXCEL
function y40aTabDetalleSolicitanteGenerarExcel(){
	var query = $("#y40aFormTabBusquedaSolicitante").serialize();
	var urlBusqueda = "/y40aVistaWar/entidad/excelDetalleSolicitantes?entidadId="+$("#y40aTabBusquedaSolicitanteIdEntidad").val()+ "&" + query + "&R01HNoPortal=true";
	window.open(urlBusqueda);
}

function y40aTabDetalleSolicitanteGenerarExcelCab(){
	
	var sortname = $("#y40aTabDetalleSolicitanteTabla").rup_grid("getGridParam","sortname");
	var sortorder = $("#y40aTabDetalleSolicitanteTabla").rup_grid("getGridParam","sortorder");	
	var query = $("#y40aFormTabBusquedaSolicitante").serialize();
	var urlBusqueda = "/y40aVistaWar/entidad/excelCabDetalleSolicitantes?entidadIdBusquedaSol="+$("#y40aTabBusquedaSolicitanteIdEntidad").val()+ "&" + query + "&R01HNoPortal=true&sortorder="+sortorder+"&sortname="+sortname;
	window.open(urlBusqueda);
}

//FICHA
function y40aTabDetalleSolicitanteVerFicha(){
	$("#y40aCapaSolicitanteFicha").rup_dialog({
		modal: true,
		autoOpen: true,
		width: "960",
		height: "auto",
		position: "top",
		title: $.rup.i18n.app.y40aTitlesModales.solicitanteficha,
		url: "/y40aVistaWar/entidad/y40aSolicitanteFicha?R01HNoPortal=true", 
		type:$.rup.dialog.AJAX,
		close: function(event, ui) {
			//$('#y40aSolicitanteFichaContactosTabla').jqGrid('GridUnload');
			y40aFunTabDetalleSolicitanteReloadTablaFormaciones();
		}
	});
}


//GENERAR LINEA DE FILTRO

function y40aFunTabDetalleSolicitanteGeneraFiltro(){
	
	var y40aVarFiltro = "";
	var planificados = false;
	
	if ($("#y40aTabBusquedaSolicitanteTextCategoria").val()!=""){
		y40aVarFiltro += "<span style='font-weight: bold;'>";
		y40aVarFiltro += $.rup.i18n.app.y40aGeneracionLineaFiltro.categoria;//"Categoría";
		y40aVarFiltro += ": ";
		y40aVarFiltro += "</span>";
		y40aVarFiltro += "<span style='font-style: italic;'>";
		y40aVarFiltro += $("#y40aTabBusquedaSolicitanteTextCategoria").val();
		y40aVarFiltro += "</span>";
		y40aVarFiltro += ". ";
	}
	
	if ($("#y40aTabBusquedaSolicitanteTextEtiquetas").val()!=""){
		y40aVarFiltro += "<span style='font-weight: bold;'>";
		y40aVarFiltro += $.rup.i18n.app.y40aGeneracionLineaFiltro.etiquetas;//"Etiquetas";
		y40aVarFiltro += ": ";
		y40aVarFiltro += "</span>";
		y40aVarFiltro += "<span style='font-style: italic;'>";
		y40aVarFiltro += $("#y40aTabBusquedaSolicitanteTextEtiquetas").val();
		y40aVarFiltro += "</span>";
		y40aVarFiltro += ". ";
	}

	
	
	if (	$("#y40aTabBusquedaSolicitanteSinPlaniCheckbox").attr('checked') 
			&& ($("#y40aTabBusquedaSolicitantePlaniCheckbox").attr('checked') 
				|| $("#y40TabBusquedaSolicitanteFechaDesde").val()!= "" 
				|| $("#y40TabBusquedaSolicitanteFechaHasta").val()!= ""	)){
		y40aVarFiltro += "<span style='font-weight: bold;'>";
		y40aVarFiltro += $.rup.i18n.app.y40aGeneracionLineaFiltro.ambos;//"Sin planificar, planificados";
		y40aVarFiltro += "</span>";	
		planificados = true;
	}else if (   $("#y40aTabBusquedaSolicitanteSinPlaniCheckbox").attr('checked')
			&& !($("#y40aTabBusquedaSolicitantePlaniCheckbox").attr('checked'))
			&& $("#y40TabBusquedaSolicitanteFechaDesde").val()== "" 
			&& $("#y40TabBusquedaSolicitanteFechaHasta").val()== ""	){
			y40aVarFiltro += "<span style='font-weight: bold;'>";
			y40aVarFiltro += $.rup.i18n.app.y40aGeneracionLineaFiltro.sinplan;//"Sin planificar";
			y40aVarFiltro += "</span>";
			y40aVarFiltro += ". ";
	}else if($("#y40aTabBusquedaSolicitantePlaniCheckbox").attr('checked')
			|| $("#y40TabBusquedaSolicitanteFechaDesde").val()!= "" 
			|| $("#y40TabBusquedaSolicitanteFechaHasta").val()!= ""){
			y40aVarFiltro += "<span style='font-weight: bold;'>";
			y40aVarFiltro += $.rup.i18n.app.y40aGeneracionLineaFiltro.conplan;//"Planificados";
			y40aVarFiltro += "</span>";
			planificados = true;
	}
	
	
	
	if ($("#y40TabBusquedaSolicitanteFechaDesde").val()!= "" || $("#y40TabBusquedaSolicitanteFechaHasta").val()!= ""){

		y40aVarFiltro += "<span style='font-weight: bold;'>";
		y40aVarFiltro += ": ";
		y40aVarFiltro += "</span>";
		y40aVarFiltro += "<span style='font-style: italic;'>";
		y40aVarFiltro += $("#y40TabBusquedaSolicitanteFechaDesde").val();
		y40aVarFiltro += " - ";
		y40aVarFiltro += $("#y40TabBusquedaSolicitanteFechaHasta").val();
		y40aVarFiltro += "</span>";
		y40aVarFiltro += ". ";	
	}else if (planificados){
		y40aVarFiltro += ". ";
	}
	
	
	return y40aVarFiltro;
}



//funcion mailto
function y40aFunTabDetalleSolicitanteMailTo(email){
	if (null!=email){
		var html = "<a  href=mailto:"+email+">"+email+"</a>";
		$(html).appendTo($("#y40aTabDetalleSolicitanteEmail"));
	}
}

$("#y40aTabDetalleSolicitanteHistorico").click(function(){
	$("#y40aHistoricoObservModal").rup_dialog("destroy");
	$("#y40aHistoricoObservModal").rup_dialog({
		modal: true,
		autoOpen: true,
		width: "900",
		height: "auto",
		title: $.rup.i18n.app.y40aTitlesModales.historicoObserv,
		url: "/y40aVistaWar/entidad/y40aHistoricoObserv?R01HNoPortal=true",    
		type:$.rup.dialog.AJAX,
		close: function(event, ui) {
			y40aFunTabDetalleSolicitanteReloadTablaFormaciones();
		}
	});	
});