jQuery(function($){
	
	$("#y40aHistorico_feedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});
	
	
	var y40aVarOpcionMenu = 5;
	
	if($("#y40aMenuCategorias").length == 1)
	{
		$("#accordion").accordion('activate', y40aVarOpcionMenu);
	}else
	{
		$("#accordion").accordion('activate', y40aVarOpcionMenu-2);
	}

	
$("#y40aHistoricoBtNuevo").click(function () {
		
	Nuevo();
	});
	
$("#y40aHistoricoBtEliminar").click(function () {
	
	Eliminar();
	
	});

var y40aVarHistoricoTablaWidth = $("#capaPadre").width() -10;

$("#y40aGRID_Historico").rup_grid({

		width: y40aVarHistoricoTablaWidth,
		url: "/y40aVistaWar/historico?R01HNoPortal=true",
		loadOnStartUp: true,
		pagerName: "y40aTablaHistoricoPager",
		rowNum: "10",
		sortorder: "asc",
		sortname: "nombre",
		colNames: [   
		        $.rup.i18n.app.historico_grid.idHist,
		        $.rup.i18n.app.historico_grid.archivo,
		        $.rup.i18n.app.historico_grid.tipo,
		        $.rup.i18n.app.historico_grid.nombre,
		    	$.rup.i18n.app.historico_grid.tamanio,
				$.rup.i18n.app.historico_grid.fecha
				
     
		],
		colModel: [

		           { name: "idHist",
				   	 label: "idHist",
					 index: "idHist",
					 hidden:true
		           },
		           
		           { name: "archivo",
				   	 label: "archivo",
					 index: "archivo",
					 hidden:true
			           },
		           
		           { name: "tipo",
					label: "tipo",
					index: "tipo",
					align:'center',
					width: funcPercentage(10,y40aVarHistoricoTablaWidth),
					sortable:false,
					editable: true,
					formatter:formateadorPonerImagen,
					edittype: "text"
					},
		           { name: "nombre",
					label: "nombre",
		        	 index: "nombre",
		        	 width: funcPercentage(70,y40aVarHistoricoTablaWidth),
		        	 editable: true,
		        	 formatter:formateadorLink,
		        	 edittype: "text"
		           },
		           { name: "tamanio",
					label: "tamanio",
					index: "tamanio",
					hidden:true,
					editable: true,
					edittype: "text"
					},
					{ name: "fecha",
					label: "fecha",
					index: "fecha",
					width: funcPercentage(20,y40aVarHistoricoTablaWidth),
					editable: true,
					edittype: "text",
					align: "center"
					}
        ]
		
	});
	

	
				
});


function Nuevo(){
	
	$("#y40aHistorico_feedback").rup_feedback("close");
	
	$("#capaHistorico").rup_dialog({
		modal: true,
		autoOpen: true,
		width: "650",
		height: "auto",
		title:$.rup.i18n.app.capaHistorico.titulo,
		url: "/y40aVistaWar/historico/capaHistorico?R01HNoPortal=true",  
		type:$.rup.dialog.AJAX
	});		
	
	
}


function Eliminar(){
	var selectedRow = $("#y40aGRID_Historico").rup_grid("getSelectedRows")[0];
	row = $("#y40aGRID_Historico").rup_grid("getRowData", selectedRow);
	var codigo = row.idHist;
	if(codigo == "" || codigo == null)
		{
			$("#y40aHistorico_feedback").rup_feedback("option", "delay", 800);
			$("#y40aHistorico_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
		}
	else
		{
		   $.rup_messages("msgConfirm",{
			   title:$.rup.i18n.app.msg.confirmacion,
			   message: $.rup.i18n.app.msg.confiramacioneliminar,
			   OKFunction : function () {
				   eliminarFilaTablaDocs(codigo);
				}
		   });
		}

}


function eliminarFilaTablaDocs(codigo){
	var jqxhr = $.ajax({
		type : 'DELETE',
		url : "/y40aVistaWar/historico/" + codigo+"?R01HNoPortal=true",
		error: function (jqXHR, textStatus, errorThrown){
			switch(jqXHR.status){		
				case 406:
					$("#y40aHistorico_feedback").rup_feedback("option", "delay",null);
					$("#y40aHistorico_feedback").rup_feedback("set",jqXHR.responseText, "error");
					break;
				//case 500:	
				default:
					$("#y40aHistorico_feedback").rup_feedback("option", "delay",null);
					$("#y40aHistorico_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
					break;
			}
		},
		success : function(data) {
					$("#y40aHistorico_feedback").rup_feedback("option", "delay",800);
					$("#y40aHistorico_feedback").rup_feedback("set", $.rup.i18n.app.msg.ok, "ok");
					reloadTablaDocs();
		}
	});
}

function reloadTablaDocs()
{
	$("#y40aGRID_Historico").rup_grid("clearGridData");
	$("#y40aGRID_Historico").rup_grid("setGridParam", {url : "/y40aVistaWar/historico?R01HNoPortal=true"});
	$("#y40aGRID_Historico").rup_grid("reloadGrid");
}

function formateadorPonerImagen(cellValue){
	
var imagen="";
//str.toLowerCase().indexOf("yes") >= 0
    if (cellValue.indexOf("word")>=0 ){
    	imagen = '<img src="'+$.rup.APP_STATICS+'/images/word.png" width="19" height="18">';
    }else if (cellValue.indexOf("pdf")>=0){
    	imagen = '<img src="'+$.rup.APP_STATICS+'/images/y40a-icono-pdf.png" width="19" height="18">';
    }else if ((cellValue.indexOf("excel")>=0)||(cellValue.indexOf("sheet")>=0)){   
    	imagen = '<img src="'+$.rup.APP_STATICS+'/images/excel.png" width="19" height="18">';
    }else if ((cellValue.indexOf("presentation")>=0)||(cellValue.indexOf("powerpoint")>=0)||(cellValue.indexOf("sheet")>=0)){   
    	imagen = '<img src="'+$.rup.APP_STATICS+'/images/y40a-icono-ppt.png" width="19" height="18">';
    }else if ((cellValue.indexOf("text/plain")>=0)||(cellValue.indexOf("sheet")>=0)){   
    	imagen = '<img src="'+$.rup.APP_STATICS+'/images/y40a-icono-txt.png" width="19" height="18">';
    }else if ((cellValue.indexOf("image/gif")>=0)||(cellValue.indexOf("sheet")>=0)){   
    	imagen = '<img src="'+$.rup.APP_STATICS+'/images/y40a-icono-gif.png" width="19" height="18">';
    }else if ((cellValue.indexOf("image/bmp")>=0)||(cellValue.indexOf("sheet")>=0)){   
    	imagen = '<img src="'+$.rup.APP_STATICS+'/images/y40a-icono-bmp.png" width="19" height="18">';
    }else if ((cellValue.indexOf("application/rar")>=0)||(cellValue.indexOf("application/zip")>=0)||(cellValue.indexOf("sheet")>=0)){   
    	imagen = '<img src="'+$.rup.APP_STATICS+'/images/y40a-icono-rar.png" width="19" height="18">';    	
    	
    }else{
    	imagen = '';
    }
    
    return imagen;	
  
}

function formateadorLink(cellvalue, options, rowObject) {
    return "<a href=/y40aVistaWar/historico/descargafichero/"+ rowObject.idHist +"?R01HNoPortal=true>" + cellvalue + "</a>";
}
