/* INICIO BLOQUE INICIALIZACIONES _____________________________________________________________________________________________________________________________ */
jQuery(function($) {
	$("#y40aFormacionesBusqueda_feedback").rup_feedback({
		gotoTop : true,
		block : false,
		closeLink : true
	});
	

	
	var y40aVarOpcionMenu = 2;
	
	if($("#y40aMenuCategorias").length == 1)
	{
		$("#accordion").accordion('activate', y40aVarOpcionMenu);
	}else
	{
		$("#accordion").accordion('activate', y40aVarOpcionMenu-2);
	}
		


	//tabla
	var y40aVarFormacionesBusquedaTablaWidth = $("#contentMV").width();
	$("#y40aFormacionesBusquedaTabla").rup_grid({
		url:"/y40aVistaWar/formacion/like?R01HNoPortal=true",
		loadOnStartUp: false,
		width: y40aVarFormacionesBusquedaTablaWidth,
		pagerName:"y40aFormacionesBusquedaTablaPager", 
		rowNum: "10",
		sortorder: "asc",
		sortname: "nombre" + recuperarLetraIdiomaMayuscula(),
		colNames:[
		    "",
		    "",
		    $.rup.i18n.app.y40aFormacionesBusquedaTabla.id,
		    $.rup.i18n.app.y40aFormacionesBusquedaTabla.nombre,
		    $.rup.i18n.app.y40aFormacionesBusquedaTabla.nombrecorto,
		    $.rup.i18n.app.y40aFormacionesBusquedaTabla.categoria,
		    $.rup.i18n.app.y40aFormacionesBusquedaTabla.visibleWeb
		    
		],
		colModel: [	
			{
				name: "jerarquiaCategoria", 
				index: "jerarquiaCategoria",
			    hidden: true
			},
		    { 	name: "nueva",
		    	index: "nueva",
		    	width: funcPercentage(5,y40aVarFormacionesBusquedaTablaWidth),
		    	formatter: y40aFormacionesBusquedaTabla_NuevaFormatter,
		    	align: "center"
		    },
		    { 	name: "idFor", 
		    	index: "idFor",
		    	hidden: true
		    },
		    { 	name: "nombre" + recuperarLetraIdiomaMayuscula(),
		    	index: "nombre" + recuperarLetraIdiomaMayuscula(),
		    	width: funcPercentage(40,y40aVarFormacionesBusquedaTablaWidth)
		    },
		    { 	name: "nombreCorto" + recuperarLetraIdiomaMayuscula(),
		    	index: "nombreCorto" + recuperarLetraIdiomaMayuscula(),
		    	width: funcPercentage(15,y40aVarFormacionesBusquedaTablaWidth)
		    },
		    { 	name: "categoriaNombre"+ recuperarLetraIdiomaMayuscula(),
		    	cellattr: function (rowId, val, rawObject, cm, rdata) {
		    		return 'title= "'+  rawObject.jerarquiaCategoria +'"';
                },
		    	index: "categoriaNombre"+ recuperarLetraIdiomaMayuscula(),
		    	width: funcPercentage(40,y40aVarFormacionesBusquedaTablaWidth)
		    	//,sortable:false
		    },
		    {	name: "visibleWeb", 
		    	index: "visibleWeb",
		    	hidden: true
		    }
		    
		],
		altRows:true,
		afterInsertRow : function(rowid, rowdata)
		{
		    if (rowdata.visibleWeb == "N") 
		    {
		        $(this).jqGrid('setRowData', rowid, false, {color:'#E01B32'}); //rojo .y40a-textoRojo
		    }
		}

	});
	
	y40aFormacionesBusquedaFiltrar();
	
});
/* FIN BLOQUE INICIALIZACIONES _____________________________________________________________________________________________________________________________ */
/* INICIO BLOQUE FUNCIONES _________________________________________________________________________________________________________________________________ */

function y40aFormacionesBusquedaTabla_NuevaFormatter(cellvalue, options, rowObject) {
	 if(cellvalue == "S"){
		 return "<label style='color: red;'>"+$.rup.i18n.app.msg.nueva+"</label>";
	 }else{ 
		 return "";
	 }
}


	//On click de la papelera de categoria
	$("#y40aFormacionesBusquedaCategoriaBorrar").click(function(){
		$("#y40aFormacionesBusquedaIdCategoria").val("");	
		$("#y40aFormacionesBusquedaNombreCategoria").val("");
	});
	
	//On click de la lupa de categoria
	$("#y40aFormacionesBusquedaCategoriaLupa").click(function(){
		y40aIdCategoria = "";
		y40aIdCategoriaSelec = $("#y40aFormacionesBusquedaIdCategoria").val();
		$("#y40aCategoriasPadreModal").rup_dialog({
			modal: true,
			autoOpen: true,
			width: "800",
			height: "auto",
			title: $.rup.i18n.app.y40aVistaWar_categorias.busquedaCategoriasPadre,
			url: "/y40aVistaWar/categoria/busquedaCategoriasPadre?R01HNoPortal=true", 
			type:$.rup.dialog.AJAX,
			close:function(event, ui){
				y40ablnMostrarCategorias = "false"; 
				if(y40aIdCategoria != "" && y40aIdCategoria != null)
				{
					//alert("vengo de busqueda"+y40aIdCategoria);
					$("#y40aFormacionesBusquedaIdCategoria").val(y40aIdCategoria);
					y40FuncCategoriasABusqueda();
				
				}
				y40aIdCategoriaSelec="";
			}
		});		
	});	


	function y40FuncCategoriasABusqueda(){
		//alert("categoriaID: "+y40aIdCategoria);
		$.ajax({
			type : "GET",
			url : "/y40aVistaWar/categoria/findCategoriaPadre/" + $("#y40aFormacionesBusquedaIdCategoria").val() + "?R01HNoPortal=true",
			dataType : "json",
			error : function(jqXHR, textStatus, errorThrown) {
				$("#y40aFormacionesBusqueda_feedback").rup_feedback("option", "delay", null);
				$("#y40aFormacionesBusqueda_feedback").rup_feedback("set", textStatus + ": error", "error");
			},
			success : function(data, textStatus, jqXHR) {
				$("#y40aFormacionesBusquedaNombreCategoria").val(data.jerarquiaCategoria);
			}
		});
	
	}
	
	
	/* *********************************************************************************************************************************************************
	 * Boton Limpiar
	 * *********************************************************************************************************************************************************
	 */
	$("#y40aFormacionesBusquedaLimpiar").click(function () {
		y40aFunFormacionesBusquedaLimpiarFiltro();
	});
	
	/* ******************************************************
	 * Funcion que limpia/inicializa los valores del filtro *
	 * ******************************************************
	 */
	function y40aFunFormacionesBusquedaLimpiarFiltro() {
		$("#y40aFormacionesBusquedaIdCategoria").val("");
		$("#y40aFormacionesBusquedaNombreCategoria").val("");
		$("#y40aFormacionesBusquedaNombre").val("");
		$("#y40aFormacionesBusquedaEtiquetasIds").val("");
		$("#y40aFormacionesBusquedaEtiquetasDescs").val("");
		$("#y40aFormacionesBusquedaMFOPWeb").attr('checked', true);
		$("#y40aFormacionesBusquedaTabla").rup_grid("clearGridData");
	}

	
	
	/* papelera de ETIQUETAS *********************************************************************************************************************************	 */
	$("#y40aFormacionesBusquedaEtiquetasBorrar").click(function(){
		$("#y40aFormacionesBusquedaEtiquetasIds").val("");
		$("#y40aFormacionesBusquedaEtiquetasDescs").val("");
	});
	
	/* lupa de ETIQUETAS *************************************************************************************************************************************	 */
	$("#y40aFormacionesBusquedaEtiquetasLupa").click(function () {
		//alert("ONCLICK BUSQUEDA");
		y40aVarOrigenEtiquetas = "formacion"; 
		y40aVarModoEtiquetas = "busqueda";
		y40aVarIdOrigen = "";
		y40aVarEtiquetasKeyList= $("#y40aFormacionesBusquedaEtiquetasIds").val();
		y40aVarEtiquetasKeyListNames= y40aFunEliminarCorchetes($("#y40aFormacionesBusquedaEtiquetasDescs").val());
		//alert("IDs: "+y40aVarEtiquetasKeyList);
		//alert("DESCS: "+y40aVarEtiquetasKeyListNames);
		
		$("#y40aCapaEtiquetas").rup_dialog({
			modal: true,
			autoOpen: true,
			width: "600",
			height: "auto",
			position: "top" ,
			title: $.rup.i18n.app.y40aTitlesModales.etiquetas,
			url: "/y40aVistaWar/etiqueta/y40aSeleccionEtiquetas?R01HNoPortal=true", 
			type:$.rup.dialog.AJAX,
			close:function(event, ui){
				//alert("on close de la busqueda");
				if(y40aVarEtiquetasKeyList != "" && y40aVarEtiquetasKeyList != null)
				{
					y40FuncEtiquetasABusqueda();
					$("#y40aCapaEtiquetas").rup_dialog("destroy");
				}else{
					$("#y40aFormacionesBusquedaEtiquetasIds").val("");
					$("#y40aFormacionesBusquedaEtiquetasDescs").val("");
				}
			}
		});		
	});
	
	function y40FuncEtiquetasABusqueda(){
		
		
		
		
		
		$("#y40aFormacionesBusquedaEtiquetasIds").val(y40aVarEtiquetasKeyList);
		$("#y40aFormacionesBusquedaEtiquetasDescs").val("[" + y40aVarEtiquetasKeyListNames + "]");
	}

	
	/* Boton Buscar *****************************************************************************************************************************************	 */
	$("#y40aFormacionesBusquedaBuscar").click(function () {
		y40aFormacionesBusquedaFiltrar();
	});
	
	// Filtra por los datos del formulario.
	function y40aFormacionesBusquedaFiltrar() {
		$("#y40aFormacionesBusquedaTabla").rup_grid("clearGridData");
		var query = $("#y40aFormacionesBusquedaForm").serialize();
		//alert("/y40aVistaWar/formacion/like?R01HNoPortal=true&"+query);
		$("#y40aFormacionesBusquedaTabla").rup_grid("setGridParam", {url : "/y40aVistaWar/formacion/like?R01HNoPortal=true&" + query});
		$("#y40aFormacionesBusquedaTabla").rup_grid("reloadGrid");
	}
	
	/* Boton Eliminar *****************************************************************************************************************************************	 */
	$("#y40aFormacionesBusquedaEliminar").click(function () {
		var selectedRow = $("#y40aFormacionesBusquedaTabla").rup_grid("getSelectedRows")[0];
		row = $("#y40aFormacionesBusquedaTabla").rup_grid("getRowData", selectedRow);
		var codigo = row.idFor;
		if(codigo == "" || codigo == null)
			{
				$("#y40aFormacionesBusqueda_feedback").rup_feedback("option", "delay", 800);
				$("#y40aFormacionesBusqueda_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
			}
		else
			{
			   $.rup_messages("msgConfirm",{
				   title:$.rup.i18n.app.msg.confirmacion,
				   message: $.rup.i18n.app.msg.confiramacioneliminar,
				   OKFunction : function () {
					   y40aFunEliminarFilaTablaFormaciones(codigo);
					}
			   });
			}
	});


	//Elimina formacion
	function y40aFunEliminarFilaTablaFormaciones(codigo){
		var jqxhr = $.ajax({
			type : 'DELETE',
			url : "/y40aVistaWar/formacion/eliminarFormacion/" + codigo+"?R01HNoPortal=true",
			error: function (jqXHR, textStatus, errorThrown){
				switch(jqXHR.status){		
					case 406:
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("option", "delay",null);
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("set",jqXHR.responseText, "error");
						break;
					case 409:
						controlY40aUDAException(jqXHR, "y40aFormacionesBusqueda_feedback");
						break;
					//case 500:	
					default:
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("option", "delay",null);
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
						break;
				}
			},
			success : function(data) {
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("option", "delay",800);
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("set", "ok", "ok");
						y40aFunReloadTablaFormaciones();
			}
		});
	}
	
	function y40aFunReloadTablaFormaciones(){
		y40aFormacionesBusquedaFiltrar();
	}

	
	/* Boton Ocultar Web ************************************************************************************************************************************	 */
	$("#y40aFormacionesBusquedaOcultarWeb").click(function () {
		var selectedRow = $("#y40aFormacionesBusquedaTabla").rup_grid("getSelectedRows")[0];
		row = $("#y40aFormacionesBusquedaTabla").rup_grid("getRowData", selectedRow);
		var codigo = row.idFor;
		if(codigo == "" || codigo == null)
			{
				$("#y40aFormacionesBusqueda_feedback").rup_feedback("option", "delay", 800);
				$("#y40aFormacionesBusqueda_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
			}
		else
			{
				y40aFunOcultarWebFilaTablaFormaciones(codigo);
			}
	});
	
	//Ocultar formacion
	function y40aFunOcultarWebFilaTablaFormaciones(codigo){
		var jqxhr = $.ajax({
			type : 'PUT',
			url : "/y40aVistaWar/formacion/ocultarWebFormacion/" + codigo+"?R01HNoPortal=true",
			error: function (jqXHR, textStatus, errorThrown){
				switch(jqXHR.status){		
					case 406:
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("option", "delay",null);
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("set",jqXHR.responseText, "error");
						break;
					case 409:
						controlY40aUDAException(jqXHR, "y40aFormacionesBusqueda_feedback");
						break;
						
					//case 500:	
					default:
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("option", "delay",null);
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
						break;
				}
			},
			success : function(data) {
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("option", "delay",800);
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("set", "ok", "ok");
						y40aFunReloadTablaFormaciones();
			}
		});
	}
	
	
	
	
	/* Boton Mostrar Web ************************************************************************************************************************************	 */
	$("#y40aFormacionesBusquedaMostrarWeb").click(function () {
		var selectedRow = $("#y40aFormacionesBusquedaTabla").rup_grid("getSelectedRows")[0];
		row = $("#y40aFormacionesBusquedaTabla").rup_grid("getRowData", selectedRow);
		var codigo = row.idFor;
		if(codigo == "" || codigo == null)
			{
				$("#y40aFormacionesBusqueda_feedback").rup_feedback("option", "delay", 800);
				$("#y40aFormacionesBusqueda_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
			}
		else
			{
				y40aFunMostrarWebFilaTablaFormaciones(codigo);
			}
	});
	
	//Mostrar formacion
	function y40aFunMostrarWebFilaTablaFormaciones(codigo){
		var jqxhr = $.ajax({
			type : 'PUT',
			url : "/y40aVistaWar/formacion/mostrarWebFormacion/" + codigo+"?R01HNoPortal=true",
			error: function (jqXHR, textStatus, errorThrown){
				switch(jqXHR.status){		
					case 406:
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("option", "delay",null);
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("set",jqXHR.responseText, "error");
						break;
					case 409:
						controlY40aUDAException(jqXHR, "y40aFormacionesBusqueda_feedback");
						break;
					//case 500:	
					default:
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("option", "delay",null);
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("set",$.rup.i18n.app.msg.errorModifDatos, "error");
						break;
				}
			},
			success : function(data) {
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("option", "delay",800);
						$("#y40aFormacionesBusqueda_feedback").rup_feedback("set", "ok", "ok");
						y40aFunReloadTablaFormaciones();
			}
		});
	}
	
	
	/* Boton NUEVA formacion *******************************************************************************************************************************    */
	$("#y40aFormacionesBusquedaNueva").click(function(){
		y40aVarFormacionCodigo = "";
		y40aVarEsModal = true;
		$("#y40aCapaFormacionDetalle").rup_dialog({
			modal: true,
			autoOpen: true,
			width: "850",
			height: "auto",
			position: "top",
			title: $.rup.i18n.app.y40aTitlesModales.detalleformacionalta,
			url: "/y40aVistaWar/formacion/y40aFormacionModal?R01HNoPortal=true", 
			type:$.rup.dialog.AJAX,
			close:function(event, ui){
				y40aFormacionesBusquedaFiltrar();
			}
		});		
	});	

	
	/* Boton MODIFICAR formacion *******************************************************************************************************************************    */
	$("#y40aFormacionesBusquedaModificar").click(function(){
		
		var selectedRow = $("#y40aFormacionesBusquedaTabla").rup_grid("getSelectedRows")[0];
		row = $("#y40aFormacionesBusquedaTabla").rup_grid("getRowData", selectedRow);
		var codigo = row.idFor;
		if(codigo == "" || codigo == null)
			{
				$("#y40aFormacionesBusqueda_feedback").rup_feedback("option", "delay", 800);
				$("#y40aFormacionesBusqueda_feedback").rup_feedback("set",$.rup.i18n.app.msg.seleccioneDatos, "alert");
			}
		else
			{
			y40aVarFormacionCodigo = codigo;
			y40aVarEsModal = true;
			$("#y40aCapaFormacionDetalle").rup_dialog({
				modal: true,
				autoOpen: true,
				width: "850",
				height: "auto",
				position: "top",
				title: $.rup.i18n.app.y40aTitlesModales.detalleformacionedicion,
				url: "/y40aVistaWar/formacion/y40aFormacionModal?R01HNoPortal=true", 
				type:$.rup.dialog.AJAX,
				close:function(event, ui){
					y40aFormacionesBusquedaFiltrar();
				}
			});		

		}

		
	});	
	
	//GENERAR EXCEL
	
	function y40aFormacionesBusquedaGenerarExcel(){
		var sortname = $("#y40aFormacionesBusquedaTabla").rup_grid("getGridParam","sortname");
		var sortorder = $("#y40aFormacionesBusquedaTabla").rup_grid("getGridParam","sortorder");
		var query = $("#y40aFormacionesBusquedaForm").serialize();
		var urlBusqueda = "/y40aVistaWar/formacion/excel?R01HNoPortal=true&" + query +"&sortorder="+sortorder+"&sortname="+sortname;
		window.open(urlBusqueda);
	}
	

	
	
/* FIN BLOQUE FUNCIONES _______________________________________________________________________________________________________________________________________ */
