package com.ejie.u74a.resolver;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

/**
 * Captura y resuelve las excepciones no controladas de la aplicación.
 * 
 *  
 */
public class MySimpleMappingExceptionResolver extends SimpleMappingExceptionResolver {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver
	 * #buildLogMessage(java.lang.Exception, javax.servlet.http.HttpServletRequest)
	 */
	@Override()
	public String buildLogMessage(Exception ex, HttpServletRequest request) {
		return "Spring MVC exception: " + ex.getLocalizedMessage();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver#logException(java.lang.Exception,
	 * javax.servlet.http.HttpServletRequest)
	 */
	@Override()
	protected void logException(Exception ex, HttpServletRequest request) {
		super.logException(ex, request);

		// Muestra la excepción en el log de error
		logger.error(this.buildLogMessage(ex, request), ex);
	}

}
