package com.ejie.u74a.filter;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

/**
 * Filtro que obtiene los parámetros adicionales que se le pueden pasar al login cuando lo invocan desde otras
 * aplicaciones.
 * 
 * En este caso se obtiene el parámetro del idioma que nos pasan desde Ibermática (parámetro "locale"). Se almacena en
 * sesión para hacerlo accesible para el interceptor MvcInterceptor que lo utiliza para fijar fialmente el locale de la
 * aplicación
 * 
 *  
 */
public class CustomUsernamePasswordAuthenticationFilter extends UsernamePasswordAuthenticationFilter {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter#successfulAuthentication
	 * (javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, javax.servlet.FilterChain,
	 * org.springframework.security.core.Authentication)
	 */
	@Override()
	protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response,
			FilterChain chain, Authentication authResult) throws IOException, ServletException {
		super.successfulAuthentication(request, response, chain, authResult);

		final String locale = request.getParameter("locale");
		request.getSession().setAttribute("locale", locale);
	}
}
