<%@include file="/WEB-INF/includeTemplate.inc"%>
<div class="container ng-scope">
	<header>
		<h2><spring:message code="app.folletos" /></h2>
	</header>
	<section>
		<header>
			<h3><spring:message code="menu.solicitudesRecibidas" /></h3>
		</header>
		<div class="alertPanel" id="divAlert"></div>
		<div class="panel panel-default">
			<div class="panel-heading tooglePanel" role="button" data-toggle="collapse" href="#divCriteriosBusqueda" aria-expanded="true" aria-controls="divCriteriosBusqueda">
				<a href="#">
					<spring:message code="buscador.criteriosBusqueda" />
				</a>
				<a href="#" class="pull-right">
					<i class="icon material-icons">keyboard_arrow_up</i>
				</a>
		  </div>
		  <div class="panel-body panel-collapse collapse in" id="divCriteriosBusqueda" aria-expanded="true">
			<form class="form-horizontal" id="frmBusqueda">
				<div class="row">
					<div class="col-sm-6 col-xs-12 form-group ">
						<label><spring:message code="buscador.texto" /></label>
						<input type="text" class="form-control" name="texto" />
					</div>
					<div class="col-sm-6 col-xs-12 form-group">
						<label><spring:message code="buscador.tipoMaterial" /></label>
						<form:select class="form-control" path="tipoMaterial" id="tipoMaterial" name="tipoMaterial">
							<form:option value="" label="" />
							<form:options items="${tiposMaterial}" />
						</form:select>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-6 col-xs-12 form-group ">
						<label><spring:message code="buscador.fechaSolicitud" /></label>
						<div class="row">
							<div class="col-sm-5 col-xs-12">
								<div class="input-group date">
									<input type="text" class="form-control campoFecha" id="fecha1" name="fecha1" />
									<div class="input-group-addon calendarioFecha"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></div>
								</div>
							</div>
							<div class="col-sm-2 col-xs-12 text-center">
								<label><spring:message code="buscador.fechaHasta" /></label>
							</div>
							<div class="col-sm-5 col-xs-12">
								<div class="input-group date">
									<input type="text" class="form-control campoFecha" id="fecha2" name="fecha2" />
									<div class="input-group-addon calendarioFecha"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-xs-12 form-group ">
						<label><spring:message code="buscador.idioma" /></label>
						<form:select class="form-control" path="idioma" name="idioma">
							<form:option value="" label="" />
							<form:options items="${idiomas}" />
						</form:select>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-6 col-xs-12 form-group">
						<label class="radio-inline"><input type="radio" name="estado" value="P" checked="checked" id="optPendientes" /><spring:message code="buscador.pendientes" /></label>
						<label class="radio-inline"><input type="radio" name="estado" id="optAceptadas" value="A" /><spring:message code="buscador.aceptados" /></label>
						<label class="radio-inline"><input type="radio" name="estado" value="R" id="optRechazadas" /><spring:message code="buscador.rechazados" /></label>
					</div>
					<div class="col-sm-6 col-xs-12 form-group invisible" id="divFechaAceptacion">
						<label><spring:message code="buscador.fechaAceptacion" /></label>
						<div class="row">
							<div class="col-sm-5 col-xs-12">
								<div class="input-group date">
									<input type="text" class="form-control campoFecha" id="fecha3" name="fecha3" />
									<div class="input-group-addon calendarioFecha"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></div>
								</div>
							</div>
							<div class="col-sm-2 col-xs-12 text-center">
								<label><spring:message code="buscador.fechaHasta" /></label>
							</div>
							<div class="col-sm-5 col-xs-12">
								<div class="input-group date">
									<input type="text" class="form-control campoFecha" id="fecha4" name="fecha4" />
									<div class="input-group-addon calendarioFecha"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></div>
								</div>
							</div>
						</div>
					</div>
				</div>
				
				<div class="row">
					<div class="col-xs-12 form-group ">
						<button class="btn btn-light" type="button" id="btnLimpiar"><spring:message code="buscador.botonLimpiar" /></button>
						<button class="btn btn-green" type="button" id="btnBuscar"><spring:message code="buscador.botonBuscar" /></button>
					</div>
				</div>
			</form>
		  </div>
		</div>

		<div id="divToolbarTabla">
			<button type="button" class="btn btn-light" id="btnInforme" disabled><span class="btn-add material-icons">assignment</span><span><spring:message code="solicitudes.botonGenerarInforme" /></span></button>
			<button type="button" class="btn btn-light" id="btnAceptar"><span class="btn-add material-icons">done</span><span><spring:message code="solicitudes.botonAceptarSolicitudes" /></span></button>
			<button type="button" class="btn btn-light" id="btnRechazar"><span class="btn-add material-icons">clear</span><span><spring:message code="solicitudes.botonRechazarSolicitudes" /></span></button>
		</div>

		<div class="row">
			<div class="col-xs-12">
					<table id="tblBusqueda"></table>
			</div>
		</div>
	</section>
</div>


<div class="modal fade" id="modalAceptarSolicitudes">
	<div class="modal-dialog modal-sm">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title"><spring:message code="solicitudes.aceptarSolicitudes" /></h4>
			</div>
			<div class="modal-body">
				<label><spring:message code="solicitudes.confirmacionAceptarSolicitudes" /></label>
			</div>
			<div class="modal-footer">
				<button class="btn btn-light" type="button" data-dismiss="modal"><spring:message code="formulario.botonCancelar" /></button>
				<button class="btn btn-green" type="button" data-dismiss="modal" id="btnRealizarAceptar"><spring:message code="formulario.botonAceptar" /></button>
			</div>
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div class="modal fade" id="modalRechazarSolicitudes">
	<div class="modal-dialog modal-sm">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title"><spring:message code="solicitudes.rechazarSolicitudes" /></h4>
			</div>
			<div class="modal-body">
				<label><spring:message code="solicitudes.confirmacionRechazarSolicitudes" /></label>
			</div>
			<div class="modal-footer">
				<button class="btn btn-light" type="button" data-dismiss="modal"><spring:message code="formulario.botonCancelar" /></button>
				<button class="btn btn-green" type="button" data-dismiss="modal" id="btnRealizarRechazar"><spring:message code="formulario.botonAceptar" /></button>
			</div>
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div class="modal fade" id="modalInforme">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<h4 class="modal-title"><spring:message code="solicitudes.informeAlmacen" /></h4>
			</div>
			<div class="modal-body" id="bodyInforme"></div>
			<div class="modal-footer">
				<button class="btn btn-light" type="button" data-dismiss="modal"><spring:message code="formulario.botonSalir" /></button>
			</div>
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div class="modal fade" id="modalListaSolicitudes">
	<form id="frmAceptarRechazar">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close btnCerrarListaSolicitudes" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title" id="tituloModalAceptarRechazar"></h4>
				</div>
				<div class="modal-body">
					
					<div class="alertPanel" id="divAlertAceptarRechazar"></div>
					
					<div class="alert alert-info alert-dismissible" role="alert">
						<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
						<span><spring:message code="solicitudes.avisoComentarioSolicitud"></spring:message></span>
					</div>
					
					<div class="row">
						<div class="col-xs-12">
							<table id="tblSolicitudesSel"></table>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button class="btn btn-light btnCerrarListaSolicitudes" type="button"><spring:message code="formulario.botonCancelar" /></button>
					<button class="btn btn-green" type="button" id="btnAceptarRechazar"><spring:message code="formulario.botonAceptar" /></button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
	</form>
</div><!-- /.modal -->

<%@include file="/WEB-INF/views/fichaSolicitud.inc" %>