<%@include file="/WEB-INF/includeTemplate.inc"%>
<div class="container ng-scope">
	<header>
		<h2><spring:message code="app.folletos" /></h2>
	</header>
	<section>
		<header>
			<h3><spring:message code="menu.solicitudFolletos" /></h3>
		</header>
		<div class="alertPanel" id="divAlert"></div>
		<div class="panel panel-default">
			<div class="panel-heading tooglePanel" role="button" data-toggle="collapse" href="#divCriteriosBusqueda" aria-expanded="true" aria-controls="divCriteriosBusqueda">
				<a href="#">
					<spring:message code="buscador.criteriosBusqueda" />
				</a>
				<a href="#" class="pull-right">
					<i class="icon material-icons">keyboard_arrow_up</i>
				</a>
		  </div>
		  <div class="panel-body panel-collapse collapse in" id="divCriteriosBusqueda" aria-expanded="true">
			<form class="form-horizontal" id="frmBusqueda">
				<div class="row">
					<div class="col-sm-6 col-xs-12 form-group ">
						<label><spring:message code="buscador.texto" /></label>
						<input type="text" class="form-control" name="texto" />
					</div>
					<div class="col-sm-6 col-xs-12 form-group">
						<label><spring:message code="buscador.tipoMaterial" /></label>
						<form:select class="form-control" path="tipoMaterial" id="tipoMaterial" name="tipoMaterial">
							<form:option value="" label="" />
							<form:options items="${tiposMaterial}" />
						</form:select>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-6 col-xs-12 form-group ">
						<label><spring:message code="buscador.tema" /></label>
						<select class="form-control" id="tema" name="tema">
							<option>&nbsp;</option>
						</select>
					</div>
					<div class="col-sm-6 col-xs-12 form-group ">
						<label><spring:message code="buscador.idioma" /></label>
						<form:select class="form-control" path="idioma" name="idioma">
							<form:option value="" label="" />
							<form:options items="${idiomas}" />
						</form:select>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12 form-group">
						<button class="btn btn-light" type="button" id="btnLimpiar"><spring:message code="buscador.botonLimpiar" /></button>
						<button class="btn btn-green" type="button" id="btnBuscar"><spring:message code="buscador.botonBuscar" /></button>
					</div>
				</div>
				<input type="hidden" name="descatalogado" value="N" />
				<input type="hidden" name="controlStock" value="S" />
				
			</form>
		  </div>
		</div>
		
		<div id="divToolbarTabla">
			<button type="button" class="btn btn-light" id="btnSolicitar"><span class="btn-add material-icons">input</span><span><spring:message code="solicitud.botonSolicitar" /></span></button>
		</div>
		
		<div class="row">
			<div class="col-xs-12">
				<table id="tblBusqueda"></table>
			</div>
		</div>
	</section>
</div>

<div class="modal fade" id="modalSolicitar">
	<form id="formSolicitar" method="post" class="form-horizontal">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" id="btnCerrarModalSolicitar" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title"><spring:message code="solicitud.fichaSolicitud" /></h4>
				</div>
				<div class="modal-body">	
					<div class="alertPanel" id="divAlertSolicitarModal"></div>				
<!-- 					<form class="form-horizontal" id="formSolicitar" >								 -->
						<div class="row">
							<div class="col-sm-6 col-xs-12 form-group">
								<label><spring:message code="solicitud.fechaSolicitud" /></label>
								<input type="text" class="form-control campoFecha" disabled="disabled" name="fechaSolicitud"/>
							</div>
							<div class="col-sm-6 col-xs-12 form-group">
								<label><spring:message code="solicitud.estadoSolicitud" /></label>
								<input type="text" class="form-control" disabled="disabled" name="estado" />
							</div>
						</div><!-- fin fila -->
						
						<div class="panel panel-default">
							<div class="panel-heading"><label><spring:message code="solicitud.datosSolicitud" /></label></div>
							<div class="panel-body">
								<div class="row">
									<div class="col-xs-12 form-group">
										<table id="tblListaSolicitudes"></table>										
									</div>
								</div>
								
								<div class="row">
									<div class="col-xs-12 form-group">
										<label><spring:message code="solicitud.comentarioSolicitud" /></label>
										<textarea class="form-control" name="observacionesSolicitud" maxlength="1000"></textarea>
									</div>
								</div><!-- fin fila -->
								
							</div>
						</div>
						
						
						<div class="panel panel-default">
							<div class="panel-heading"><label><spring:message code="solicitud.oficinaSolicitud" /></label></div>
							<div class="panel-body">
								<div class="row">
									<div class="col-xs-12 form-group">
										<label><spring:message code="solicitud.oficina" /></label>
										<input type="text" class="form-control" readonly="readonly" name="oficinaSolicitud.nombreOficina" />
										<input type="hidden" class="form-control" readonly="readonly" name="oficinaSolicitud.codigoOficina" />
									</div>
								</div><!-- fin fila -->
								
								<div class="row">
									<div class="col-sm-6 col-xs-12 form-group">
										<label><spring:message code="solicitud.contacto" /></label>
										<input type="text" class="form-control" readonly="readonly" name="oficinaSolicitud.nombreContacto" />
									</div>
									<div class="col-sm-6 col-xs-12 form-group">
										<label><spring:message code="solicitud.telefono" /></label>
										<input type="text" class="form-control" readonly="readonly" name="oficinaSolicitud.numeroTelefono"/>
									</div>
								</div><!-- fin fila -->
							</div>
						</div>
						
						<div class="panel panel-default">
							<div class="panel-heading"><label><spring:message code="solicitud.puntoRecepcion" /></label></div>
							<div class="panel-body">
								<div class="row">
									<div class="col-xs-12 form-group">
										<label><spring:message code="solicitud.recibir" /></label>
										<div class="input-group">
											<select class="form-control" id="ubicacion" name="ubicacion"></select>
											<span class="input-group-btn">
										        <button type="button" class="btn btn-light" id="btnAniadirPuntoRecepcion"><span class="btn-add material-icons">add</span><span><spring:message code="accion.anadir" /></span></button>
										      </span>
										</div>
									</div>
								</div><!-- fin fila -->
								
								<div class="row local">
									<div class="col-xs-12 form-group">
										<label><spring:message code="solicitud.domicilio" /></label>
										<input type="text" class="form-control" readonly="readonly" name="puntoRecepcion.nombreDireccion"/>
										<input type="hidden" class="form-control" readonly="readonly" name="puntoRecepcion.codigoUbicacion" />
									</div>										
								</div><!-- fin fila -->
								
								<div class="row local">
									<div class="col-sm-6 col-xs-12 form-group">
										<label><spring:message code="solicitud.localidad" /></label>
										<input type="text" class="form-control" readonly="readonly" name="puntoRecepcion.nombreLocalidad" />
									</div>
									<div class="col-sm-6 col-xs-12 form-group">
										<label><spring:message code="solicitud.municipio" /></label>
										<input type="text" class="form-control" readonly="readonly" name="puntoRecepcion.nombreMunicipio"/>
									</div>
								</div><!-- fin fila -->
								
								<div class="row local">
									<div class="col-sm-6 col-xs-12 form-group">
										<label><spring:message code="configuracion.puntoRecepcion.provincia" /></label>
										<input type="text" class="form-control" readonly="readonly" name="puntoRecepcion.nombreProvincia" />
									</div>
									<div class="col-sm-6 col-xs-12 form-group">
										<label><spring:message code="solicitud.codigoPostal" /></label>
										<input type="text" class="form-control" readonly="readonly"  name="puntoRecepcion.codigoPostal" />
									</div>
								</div><!-- fin fila -->
								
								<div class="row extranjero ocultar">
									<div class="col-xs-12 form-group">
										<label><spring:message code="solicitud.domicilio" /></label>
										<textarea class="form-control" id="direccionExtranjero" name="puntoRecepcion.direccionExtranjero" maxlength="1000" rows="4" disabled="disabled"></textarea>
									</div>
								</div><!-- fin fila -->
								
								<div class="row">
									<div class="col-xs-12 form-group">
										<label><spring:message code="solicitud.comentarioSolicitud" /></label>
										<textarea class="form-control" id="observacionesRecepcion" name="observacionesRecepcion"  maxlength="1000"></textarea>
									</div>
								</div><!-- fin fila -->
							</div>
						</div>
						
<!-- 					</form> -->
					
				</div>
				<div class="modal-footer">
					<button class="btn btn-light" type="button" id="btnCancelarSolicitud"><spring:message code="formulario.botonCancelar" /></button>
					<button class="btn btn-green" type="button" id="btnGuardarSolicitud"><spring:message code="formulario.botonAceptar" /></button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
	</form>
</div><!-- /.modal -->

<%@include file="/WEB-INF/views/fichaFolleto.inc" %>
<%@include file="/WEB-INF/views/fichaMaterialPromocional.inc" %>
<%@include file="/WEB-INF/views/puntosRecepcionFormulario.inc" %>