<%@include file="/WEB-INF/includeTemplate.inc"%>
<div class="container ng-scope">
	<header>
		<h2><spring:message code="app.folletos" /></h2>
	</header>
	<section>
		<header>
			<h3><spring:message code="menu.gestionStocks" /></h3>
		</header>
		<div class="alertPanel" id="divAlert"></div>
		<div class="panel panel-default">
			<div class="panel-heading tooglePanel" role="button" data-toggle="collapse" href="#divCriteriosBusqueda" aria-expanded="true" aria-controls="divCriteriosBusqueda">
				<a href="#">
					<spring:message code="buscador.criteriosBusqueda" />
				</a>
				<a href="#" class="pull-right">
					<i class="icon material-icons">keyboard_arrow_up</i>
				</a>
		  </div>
		  <div class="panel-body panel-collapse collapse in" id="divCriteriosBusqueda" aria-expanded="true">
			<form class="form-horizontal" id="frmBusqueda">
				<div class="row">
					<div class="col-sm-6 col-xs-12 form-group ">
						<label><spring:message code="buscador.texto" /></label>
						<input type="text" class="form-control" name="texto" />
					</div>
					<div class="col-sm-6 col-xs-12 form-group">
						<label><spring:message code="buscador.tipoMaterial" /></label>
						<form:select class="form-control" path="tipoMaterial" id="tipoMaterial" name="tipoMaterial">
							<form:option value="" label="" />
							<form:options items="${tiposMaterial}" />
						</form:select>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-6 col-xs-12 form-group ">
						<label><spring:message code="buscador.fechaInventario" /></label>
						<div class="row">
							<div class="col-sm-5 col-xs-12">
								<div class="input-group date">
									<input type="text" class="form-control campoFecha" id="fecha1" name="fecha1" data-end-date-field="#fecha2"/>
									<div class="input-group-addon calendarioFecha"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></div>
								</div>
							</div>
							<div class="col-sm-2 col-xs-12 text-center">
								<label><spring:message code="buscador.fechaHasta" /></label>
							</div>
							<div class="col-sm-5 col-xs-12">
								<div class="input-group date">
									<input type="text" class="form-control campoFecha" id="fecha2" name="fecha2" data-start-date-field="#fecha1"/>
									<div class="input-group-addon calendarioFecha"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-xs-12 form-group ">
						<label><spring:message code="buscador.stock" /></label>
						<div class="row">
							<div class="col-sm-5 col-xs-12">
								<input type="text" class="form-control campoNumerico" name="stockMin" />
							</div>
							<div class="col-sm-2 col-xs-12 text-center">
								<label><spring:message code="buscador.stockHasta" /></label>
							</div>
							<div class="col-sm-5 col-xs-12">
								<input type="text" class="form-control campoNumerico" name="stockMax" />
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-6 col-xs-12 form-group ">
						<label><spring:message code="buscador.fechaEntradaSalida" /></label>
						<div class="row">
							<div class="col-sm-5 col-xs-12">
								<div class="input-group date">
									<input type="text" class="form-control campoFecha" id="fecha3" name="fecha3" data-end-date-field="#fecha4" />
									<div class="input-group-addon calendarioFecha"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></div>
								</div>
							</div>
							<div class="col-sm-2 col-xs-12 text-center">
								<label><spring:message code="buscador.fechaHasta" /></label>
							</div>
							<div class="col-sm-5 col-xs-12">
								<div class="input-group date">
									<input type="text" class="form-control campoFecha" id="fecha4" name="fecha4" data-start-date-field="#fecha3" />
									<div class="input-group-addon calendarioFecha"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12 form-group">
						<button class="btn btn-light" type="button" id="btnLimpiar"><spring:message code="buscador.botonLimpiar" /></button>
						<button class="btn btn-green" type="button" id="btnBuscar"><spring:message code="buscador.botonBuscar" /></button>
					</div>
				</div>
			</form>
		  </div>
		</div>

		<div class="row">
			<div class="col-xs-12">
				<table id="tblBusqueda"></table>
			</div>
		</div>
	</section>
</div>


<div class="modal fade" id="modalActualizarStock">
	<form class="form-horizontal" id="formActualizarStock">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" id="btnCerrarActualizar" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title"><spring:message code="stock.actualizarStock" /></h4>
				</div>
				<div class="modal-body">
					<div class="alertPanel" id="divAlertActualizarStock"></div>
				
					<div class="row">
						<div class="col-xs-12 form-group">
							<label><spring:message code="stock.tituloArticulo" /></label>
							<input type="text" class="form-control" readonly="readonly"  name="descripcionTitulo"/>
						</div>
					</div><!-- fin fila -->

					<div class="row">
						<div class="col-xs-12 col-sm-6 form-group">
							<label><spring:message code="stock.idioma" /></label>
							<input type="text" class="form-control" readonly="readonly"  name="descripcionIdioma"/>
						</div>
						<div class="col-xs-12 col-sm-6 form-group">
							<label><spring:message code="stock.tipoMaterial" /></label>
							<input type="text" class="form-control" readonly="readonly" name="descripcionTipoMaterial" />
						</div>
					</div><!-- fin fila -->

					<div class="row">
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="stock.codigoAlmacen" /></label>
							<input type="text" class="form-control" name="codigoAlmacen" maxlength="10"/>
						</div>
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="stock.fechaInventario" /></label>
							<div class="input-group date">
								<input type="text" class="form-control campoFecha" id="fechaInventario" name="fechaInventario"/>
								<div class="input-group-addon calendarioFecha"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></div>
							</div>
						</div>
					</div><!-- fin fila -->

					<div class="row">
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="stock.stock" /></label>
							<input type="text" class="form-control campoNumerico" id="stock"  name="stock" />
						</div>
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="stock.minimo" /></label>
							<input type="text" class="form-control campoNumerico" name="stockMin"  />
						</div>
					</div><!-- fin fila -->


					<div class="panel panel-default">
						<div class="panel-heading"><label><spring:message code="stock.datosNecesarios" /></label></div>
						<div class="panel-body">
							<div class="row">
								<div class="col-xs-12 form-group">
									<label class="radio-inline"><input type="radio" id="modoPeticionE" name="modoPeticion" value="E" ><spring:message code="stock.solicitudEjemplar" /></label>
									<label class="radio-inline"><input type="radio" id="modoPeticionC" name="modoPeticion" value="C"><spring:message code="stock.solicitudCajas" /></label>
								</div>
							</div><!-- fin fila -->

							<div class="panel panel-default" id="divEjemplares">
								<div class="panel-heading"><label><spring:message code="stock.ejemplar" /></label></div>
								<div class="panel-body">
									<div class="row">
										<div class="col-sm-6 col-xs-12 form-group">
											<label><spring:message code="stock.minimoEjemplares" /></label>
											<input type="text" class="form-control campoNumerico" id="numMinimoE" name="numMinimo"/>
										</div>
										<div class="col-sm-6 col-xs-12 form-group">
											<label><spring:message code="stock.formaEnvio" /></label>
												<form:select class="form-control" path="formaEnvio" id="codigoFormaEnvioE" name="codigoFormaEnvio">
														<form:option value="" label="" />
														<form:options items="${formasEnvio}" />
													</form:select>
										</div>
									</div><!-- fin fila -->
								</div>
							</div>

							<div class="panel panel-default ocultar" id="divCajas">
								<div class="panel-heading"><label><spring:message code="catalogo.cajas" /></label></div>
								<div class="panel-body">
									<div class="row">
										<div class="col-sm-6 col-xs-12 form-group">
											<label><spring:message code="stock.ejemplaresCaja" /></label>
											<input type="text" class="form-control campoNumerico" id="numEjemplares" name="numEjemplares"/>
										</div>
										<div class="col-sm-6 col-xs-12 form-group">
											<label><spring:message code="stock.minimoCajas" /></label>
											<input type="text" class="form-control campoNumerico" id="numMinimoC" name="numMinimo"/>
										</div>
									</div>
									<div class="row">
										<div class="col-sm-6 col-xs-12 form-group">
											<label><spring:message code="stock.formaEnvio" /></label>
												<form:select class="form-control" path="formaEnvio" id="codigoFormaEnvioC" name="codigoFormaEnvio">
													<form:option value="" label="" />
													<form:options items="${formasEnvio}" />
												</form:select>
										</div>
									</div><!-- fin fila -->
								</div>
							</div>

						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button class="btn btn-light" type="button" id="btnCancelarActualizar"><spring:message code="formulario.botonCancelar" /></button>
					<button class="btn btn-green" type="submit" id="btnAceptarActualizar"><spring:message code="formulario.botonAceptar" /></button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
		<input type="hidden" class="form-control" readonly="readonly" id="codArticulo" name="codArticulo" />
		<input type="hidden" class="form-control campoNumerico" readonly="readonly" id="stockAnterior" name="stockAnterior" />
	</form>
</div><!-- /.modal -->


<div class="modal fade" id="modalRegistroES">
	<form class="form-horizontal" id="formRegistroES">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title"><spring:message code="stock.registroEntradasSalidas" /></h4>
				</div>
				<div class="modal-body">
					<div class="alertPanel" id="divAlertRegistroES"></div>
					<div class="row">
						<div class="col-xs-12 form-group">
							<label><spring:message code="stock.material" /></label>
							<input type="text" class="form-control" readonly="readonly" name="descripcionTitulo" />
						</div>
					</div><!-- fin fila -->

					<div class="row">
						<div class="col-xs-12 form-group">
							<label><spring:message code="stock.tipo" /></label>
							<input type="text" class="form-control" readonly="readonly" name="descripcionTipoMaterial" />
						</div>
					</div><!-- fin fila -->

					<div class="row">
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="stock.idioma" /></label>
							<input type="text" class="form-control" readonly name="descripcionIdioma" />
						</div>
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="stock.stockActual" /></label>
							<input type="text" class="form-control" readonly name="stock" />
						</div>
					</div>
					<div class="row">
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="stock.fechaInventario" /></label>
							<input type="text" class="form-control campoFecha" disabled="disabled"  name="fechaInventario"/>
						</div>
					</div><!-- fin fila -->

					<div class="panel panel-default">
						<div class="panel-heading"><label><spring:message code="stock.listaEntradasSalidas" /></label></div>
						<div class="panel-body">
							<div class="row">
								<div class="col-xs-12">
									<table id="tblRegistrosES"></table>
								</div>
							</div><!-- fin fila -->

						</div>
					</div>
				</div>
			<div class="modal-footer">
				<button class="btn btn-light" type="button" data-dismiss="modal"><spring:message code="formulario.botonSalir" /></button>
			</div>
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->
		<input type="hidden" class="form-control" readonly="readonly" id="codArticulo" name="codArticulo" />
	</form>
</div><!-- /.modal -->